/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "()V", "resolveImplementationClass", "Ljava/lang/Class;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "Companion", "intellij.platform.extensions"})
public final class InterfaceExtensionImplementationClassResolver
implements ImplementationClassResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final InterfaceExtensionImplementationClassResolver INSTANCE = new InterfaceExtensionImplementationClassResolver();

    private InterfaceExtensionImplementationClassResolver() {
    }

    @Override
    @NotNull
    public Class<?> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Object className = adapter.implementationClassOrName;
        if (!(className instanceof String)) {
            Intrinsics.checkNotNull((Object)className, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            return (Class)className;
        }
        PluginDescriptor pluginDescriptor = adapter.pluginDescriptor;
        Class clazz = componentManager.loadClass((String)className, pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"componentManager.loadCla\u2026ssName, pluginDescriptor)");
        Class result2 = clazz;
        if (!(result2.getClassLoader() == pluginDescriptor.getPluginClassLoader() || pluginDescriptor.getPluginClassLoader() == null || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.webcore.resourceRoots.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.tasks.impl.", (boolean)false, (int)2, null) || result2.isAnnotationPresent(InternalIgnoreDependencyViolation.class))) {
            String string2 = pluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginDescriptor.pluginId.idString");
            String idString = string2;
            if (!(Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java.ide") || Intrinsics.areEqual((Object)idString, (Object)"org.jetbrains.android") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.kotlinNative.platformDeps") || Intrinsics.areEqual((Object)idString, (Object)"com.jetbrains.rider.android"))) {
                ExtensionPointImpl.LOG.error(componentManager.createError("Created extension classloader is not equal to plugin's one.\nSee https://youtrack.jetbrains.com/articles/IDEA-A-65/Plugin-Model#internalignoredependencyviolation\n(\n  className=" + className + ",\n  extensionInstanceClassloader=" + result2.getClassLoader() + ",\n  pluginClassloader=" + pluginDescriptor.getPluginClassLoader() + "\n)", pluginDescriptor.getPluginId()));
            }
        }
        adapter.implementationClassOrName = result2;
        return result2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "intellij.platform.extensions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

