/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class InstructionKey
implements Comparable<InstructionKey> {
    private final int myOffset;
    private final int[] myCallStack;

    private InstructionKey(int offset, int @NotNull [] callStack) {
        if (callStack == null) {
            InstructionKey.$$$reportNull$$$0(0);
        }
        this.myOffset = offset;
        this.myCallStack = callStack;
    }

    @NotNull
    static InstructionKey create(int offset) {
        return new InstructionKey(offset, ArrayUtilRt.EMPTY_INT_ARRAY);
    }

    @NotNull
    InstructionKey next(int nextOffset) {
        return new InstructionKey(nextOffset, this.myCallStack);
    }

    @NotNull
    InstructionKey push(int nextOffset, int returnOffset) {
        if (this.myCallStack.length > 100) {
            throw new OverflowException(this.myOffset);
        }
        int[] nextStack = ArrayUtil.append(this.myCallStack, returnOffset);
        return new InstructionKey(nextOffset, nextStack);
    }

    @NotNull
    InstructionKey pop(int overriddenOffset) {
        int returnOffset = this.myCallStack[this.myCallStack.length - 1];
        int[] nextStack = ArrayUtil.realloc(this.myCallStack, this.myCallStack.length - 1);
        int nextOffset = overriddenOffset != 0 ? overriddenOffset : returnOffset;
        return new InstructionKey(nextOffset, nextStack);
    }

    int getOffset() {
        return this.myOffset;
    }

    int @NotNull [] getCallStack() {
        if (this.myCallStack == null) {
            InstructionKey.$$$reportNull$$$0(1);
        }
        return this.myCallStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionKey key = (InstructionKey)o;
        return this.myOffset == key.myOffset && Arrays.equals(this.myCallStack, key.myCallStack);
    }

    public int hashCode() {
        return 31 * this.myOffset + Arrays.hashCode(this.myCallStack);
    }

    public String toString() {
        if (this.myCallStack.length == 0) {
            return String.valueOf(this.myOffset);
        }
        StringBuilder s = new StringBuilder();
        for (int offset : this.myCallStack) {
            if (s.length() != 0) {
                s.append(',');
            }
            s.append(offset);
        }
        return this.myOffset + "[" + s + "]";
    }

    @Override
    public int compareTo(@NotNull InstructionKey key) {
        int c;
        if (key == null) {
            InstructionKey.$$$reportNull$$$0(2);
        }
        if ((c = this.myOffset - key.myOffset) != 0) {
            return c;
        }
        int len = Math.min(this.myCallStack.length, key.myCallStack.length);
        for (int i2 = 0; i2 < len; ++i2) {
            c = this.myCallStack[i2] - key.myCallStack[i2];
            if (c == 0) continue;
            return c;
        }
        c = this.myCallStack.length - key.myCallStack.length;
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/InstructionKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/InstructionKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class OverflowException
    extends RuntimeException {
        OverflowException(int offset) {
            super("Instruction key overflow at offset " + offset);
        }
    }
}

