/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImpl
extends JavaStubPsiElement<PsiClassStub<?>>
implements PsiExtensibleClass,
Queryable {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);
    private volatile String myCachedName;

    public PsiClassImpl(PsiClassStub<?> stub) {
        this(stub, (IStubElementType<?, ?>)JavaStubElementTypes.CLASS);
    }

    protected PsiClassImpl(PsiClassStub<?> stub, IStubElementType<?, ?> type) {
        super(stub, (IStubElementType)type);
        this.addTrace(null);
    }

    public PsiClassImpl(ASTNode node) {
        super(node);
        this.addTrace(null);
    }

    private void addTrace(@Nullable PsiClassStub<?> stub) {
        if (ourTraceStubAstBinding) {
            String creationTrace = "Creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            if (stub != null) {
                String stubTrace;
                creationTrace = creationTrace + "\nfrom stub " + stub + "@" + System.identityHashCode(stub) + "\n";
                if (stub instanceof UserDataHolder && (stubTrace = (String)((UserDataHolder)((Object)stub)).getUserData(CREATION_TRACE)) != null) {
                    creationTrace = creationTrace + stubTrace;
                }
            }
            this.putUserData(CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public void subtreeChanged() {
        this.dropCaches();
        super.subtreeChanged();
    }

    private void dropCaches() {
        this.myCachedName = null;
    }

    @Override
    protected Object clone() {
        PsiClassImpl clone = (PsiClassImpl)super.clone();
        clone.dropCaches();
        return clone;
    }

    @Override
    public PsiElement getOriginalElement() {
        if (DumbService.isDumb(this.getProject())) {
            return this;
        }
        return (PsiElement)CachedValuesManager.getCachedValue(this, () -> {
            JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
            PsiClassImpl result2 = helper != null ? helper.getOriginalClass(this) : this;
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiClassImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @Override
    public PsiElement getScope() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        CompositeElement treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType)) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    @Override
    public String getName() {
        PsiIdentifier identifier;
        String name2 = this.myCachedName;
        if (name2 != null) {
            return name2;
        }
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        name2 = stub == null ? ((identifier = this.getNameIdentifier()) == null ? null : identifier.getText()) : stub.getName();
        this.myCachedName = name2;
        return name2;
    }

    @Override
    public String getQualifiedName() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiJavaFile) {
            return StringUtil.getQualifiedName(((PsiJavaFile)parent).getPackageName(), StringUtil.notNullize(this.getName()));
        }
        if (parent instanceof PsiClass) {
            String parentQName = ((PsiClass)parent).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return StringUtil.getQualifiedName(parentQName, StringUtil.notNullize(this.getName()));
        }
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modList;
        if (name2 == null) {
            PsiClassImpl.$$$reportNull$$$0(1);
        }
        return (modList = this.getModifierList()) != null && modList.hasModifierProperty(name2);
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.EXTENDS_LIST);
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.IMPLEMENTS_LIST);
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(2);
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClassType @NotNull [] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(3);
        }
        return psiClassTypeArray;
    }

    @Override
    @Nullable
    public PsiReferenceList getPermitsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.PERMITS_LIST);
    }

    @Override
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @Override
    public PsiClass @NotNull [] getInterfaces() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Override
    public PsiClassType @NotNull [] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(6);
        }
        return psiClassTypeArray;
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            StubElement parent = stub.getParentStub();
            return parent instanceof PsiClassStub ? (PsiClass)((PsiClassStub)parent).getPsi() : null;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClassLevelDeclarationStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
        }
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        return this.getContext(null);
    }

    public PsiElement getContext(@Nullable String referenceName) {
        StubElement parent;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            return this.getParent();
        }
        if (referenceName == null) {
            return super.getContext();
        }
        for (parent = stub.getParentStub(); parent != null && !(parent instanceof PsiClassStub) && !(parent instanceof PsiFileStub); parent = parent.getParentStub()) {
            PsiClass[] allLocalClasses = (PsiClass[])parent.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (allLocalClasses.length > 0 && ContainerUtil.exists(allLocalClasses, c -> referenceName.equals(c.getName()))) {
                return this.getParent();
            }
            if (!(parent instanceof PsiMethodStub)) continue;
            return parent.getPsi();
        }
        return parent != null ? parent.getPsi() : this.getParent();
    }

    @Override
    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            PsiClassImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @Override
    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = this.myInnersCache.getRecordComponents();
        if (psiRecordComponentArray == null) {
            PsiClassImpl.$$$reportNull$$$0(12);
        }
        return psiRecordComponentArray;
    }

    @Override
    @Nullable
    public PsiRecordHeader getRecordHeader() {
        return this.getStubOrPsiChild(JavaStubElementTypes.RECORD_HEADER);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = Arrays.asList((PsiField[])this.getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = Arrays.asList((PsiMethod[])this.getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = Arrays.asList((PsiClass[])this.getStubOrPsiChildren(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    public PsiClassInitializer @NotNull [] getInitializers() {
        PsiClassInitializer[] psiClassInitializerArray = (PsiClassInitializer[])this.getStubOrPsiChildren(JavaStubElementTypes.CLASS_INITIALIZER, PsiClassInitializer.ARRAY_FACTORY);
        if (psiClassInitializerArray == null) {
            PsiClassImpl.$$$reportNull$$$0(16);
        }
        return psiClassInitializerArray;
    }

    @Override
    public PsiTypeParameter @NotNull [] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            PsiClassImpl.$$$reportNull$$$0(17);
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiField @NotNull [] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(18);
        }
        return psiFieldArray;
    }

    @Override
    public PsiMethod @NotNull [] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(19);
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass @NotNull [] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(20);
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    @Override
    public PsiMethod findMethodBySignature(@NotNull PsiMethod patternMethod, boolean checkBases) {
        if (patternMethod == null) {
            PsiClassImpl.$$$reportNull$$$0(21);
        }
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @Override
    public PsiMethod @NotNull [] findMethodsBySignature(@NotNull PsiMethod patternMethod, boolean checkBases) {
        if (patternMethod == null) {
            PsiClassImpl.$$$reportNull$$$0(22);
        }
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(23);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(24);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull String name2, boolean checkBases) {
        if (name2 == null) {
            PsiClassImpl.$$$reportNull$$$0(25);
        }
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Override
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    @Override
    public PsiDocComment getDocComment() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    @Override
    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(18);
    }

    @Override
    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(19);
    }

    @Override
    public boolean isInterface() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.INTERFACE_KEYWORD;
    }

    @Override
    public boolean isAnnotationType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnnotationType();
        }
        return this.getNode().findChildByRole(247) != null;
    }

    @Override
    public boolean isEnum() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isEnum();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.ENUM_KEYWORD;
    }

    @Override
    public boolean isRecord() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRecord();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.RECORD_KEYWORD;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiClassImpl.$$$reportNull$$$0(28);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiClassImpl.$$$reportNull$$$0(29);
        }
        if (state == null) {
            PsiClassImpl.$$$reportNull$$$0(30);
        }
        if (place == null) {
            PsiClassImpl.$$$reportNull$$$0(31);
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, level, false);
    }

    @Override
    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            PsiClassImpl.$$$reportNull$$$0(32);
        }
        String oldName = this.getName();
        boolean isRenameFile = this.isRenameFileOnRenaming();
        PsiImplUtil.setName(Objects.requireNonNull(this.getNameIdentifier()), newName);
        if (isRenameFile) {
            PsiFile file2;
            String fileName = (file2 = (PsiFile)this.getParent()).getName();
            int dotIndex = fileName.lastIndexOf(46);
            file2.setName(dotIndex >= 0 ? newName + "." + fileName.substring(dotIndex + 1) : newName);
        }
        for (PsiMethod method : this.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
            method.setName(newName);
        }
        return this;
    }

    private boolean isRenameFileOnRenaming() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            PsiFile file2 = (PsiFile)parent;
            String fileName = file2.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String name2 = dotIndex >= 0 ? fileName.substring(0, dotIndex) : fileName;
            String oldName = this.getName();
            return name2.equals(oldName);
        }
        return false;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            PsiClassImpl.$$$reportNull$$$0(33);
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Override
    public boolean isInheritorDeep(@NotNull PsiClass baseClass, PsiClass classToByPass) {
        if (baseClass == null) {
            PsiClassImpl.$$$reportNull$$$0(34);
        }
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            PsiClassImpl.$$$reportNull$$$0(35);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiClassImpl.$$$reportNull$$$0(36);
        }
        PsiClassImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiClass psiClass, @NotNull Map<? super String, ? super String> info) {
        if (psiClass == null) {
            PsiClassImpl.$$$reportNull$$$0(37);
        }
        if (info == null) {
            PsiClassImpl.$$$reportNull$$$0(38);
        }
        info.put("className", psiClass.getName());
        info.put("qualifiedClassName", psiClass.getQualifiedName());
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 instanceof Queryable) {
            ((Queryable)((Object)file2)).putInfo(info);
        }
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myInnersCache.getValuesMethod();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsBySignature";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isInheritorDeep";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

