/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternGuard;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.AnnotationElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance(JavaSharedImplUtil.class);
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations : allAnnotations) {
            type = type.createArrayType().annotate(TypeAnnotationProvider.Static.create(annotations));
        }
        return type;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        SmartList<PsiAnnotation[]> annotations = new SmartList<PsiAnnotation[]>();
        SmartList<PsiAnnotation> current2 = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current2 == null) {
                    current2 = new SmartList<PsiAnnotation>();
                }
                current2.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations.add(0, current2 == null ? PsiAnnotation.EMPTY_ARRAY : ContainerUtil.toArray(current2, PsiAnnotation.ARRAY_FACTORY));
                current2 = null;
                if (!stop) continue;
                return annotations;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations;
    }

    @NotNull
    public static PsiType createTypeFromStub(@NotNull PsiModifierListOwner owner, @NotNull TypeInfo typeInfo) {
        if (owner == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (typeInfo == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(6);
        }
        String typeText = TypeInfo.createTypeText(typeInfo);
        assert (typeText != null) : owner;
        PsiType type = JavaPsiFacade.getInstance(owner.getProject()).getParserFacade().createTypeFromText(typeText, owner);
        type = JavaSharedImplUtil.applyAnnotations(type, owner.getModifierList());
        PsiType psiType = typeInfo.getTypeAnnotations().applyTo(type, owner);
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(7);
        }
        return psiType;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type, @Nullable PsiModifierList modifierList) {
        PsiAnnotation[] annotations;
        if (type == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(8);
        }
        if (modifierList != null && (annotations = modifierList.getAnnotations()).length > 0) {
            if (type instanceof PsiArrayType) {
                Stack<PsiArrayType> types = new Stack<PsiArrayType>();
                do {
                    types.push((PsiArrayType)type);
                } while ((type = ((PsiArrayType)type).getComponentType()) instanceof PsiArrayType);
                type = JavaSharedImplUtil.annotate(type, modifierList, annotations);
                while (!types.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types.pop();
                    type = t instanceof PsiEllipsisType ? new PsiEllipsisType(type, t.getAnnotations()) : new PsiArrayType(type, t.getAnnotations());
                }
                PsiType psiType = type;
                if (psiType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(9);
                }
                return psiType;
            }
            if (type instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components = new ArrayList<PsiType>(((PsiDisjunctionType)type).getDisjunctions());
                components.set(0, JavaSharedImplUtil.annotate((PsiType)components.get(0), modifierList, annotations));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type).newDisjunctionType(components);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(10);
                }
                return psiDisjunctionType;
            }
            return JavaSharedImplUtil.annotate(type, modifierList, annotations);
        }
        PsiType psiType = type;
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        return psiType;
    }

    @NotNull
    private static PsiType annotate(@NotNull PsiType type, @NotNull PsiModifierList modifierList, PsiAnnotation @NotNull [] annotations) {
        if (type == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(12);
        }
        if (modifierList == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(13);
        }
        if (annotations == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(14);
        }
        TypeAnnotationProvider original = modifierList.getParent() instanceof PsiMethod ? type.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
        FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations, original);
        PsiType psiType = type.annotate(provider);
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(16);
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type = typeElement.getNode();
        ASTNode name2 = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name2;
        MultiMap<Integer, AnnotationElement> annotationElementsToMove = new MultiMap<Integer, AnnotationElement>();
        while (element != null) {
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) instanceof AnnotationElement) {
                annotationElementsToMove.putValue(arrayCount, (AnnotationElement)element);
                continue;
            }
            if (element == null || element.getElementType() != JavaTokenType.LBRACKET) break;
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = PsiImplUtil.skipWhitespaceAndComments(name2.getTreeNext());
            while (element != null) {
                ASTNode next2 = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext());
                CodeEditUtil.removeChild(variableElement, element);
                if (element == lastBracket) break;
                element = next2;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            if (!(typeElement.getType() instanceof PsiArrayType)) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType = newType1;
            }
            for (int i2 = 0; i2 < arrayCount; ++i2) {
                annotationElementsToMove.get(i2).forEach(newType::rawAddChildren);
                newType.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
            }
            newType.acceptTree(new GeneratedMarkerVisitor());
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            CodeEditUtil.replaceChild(variableElement, type, newType);
        }
    }

    @NotNull
    public static PsiElement getPatternVariableDeclarationScope(@NotNull PsiPatternVariable variable) {
        PsiElement parent;
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(17);
        }
        if (!((parent = variable.getPattern().getParent()) instanceof PsiInstanceOfExpression || parent instanceof PsiCaseLabelElementList || parent instanceof PsiPattern || parent instanceof PsiDeconstructionList || parent instanceof PsiPatternGuard)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                JavaSharedImplUtil.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement psiElement = JavaSharedImplUtil.getInstanceOfPartDeclarationScope(parent);
        if (psiElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getPatternVariableDeclarationScope(@NotNull PsiInstanceOfExpression instanceOfExpression) {
        if (instanceOfExpression == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(20);
        }
        return JavaSharedImplUtil.getInstanceOfPartDeclarationScope(instanceOfExpression);
    }

    private static PsiElement getInstanceOfPartDeclarationScope(@NotNull PsiElement parent) {
        if (parent == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(21);
        }
        boolean negated = false;
        PsiElement nextParent = parent.getParent();
        while (true) {
            if (!(nextParent instanceof PsiParenthesizedExpression)) {
                IElementType tokenType;
                if (nextParent instanceof PsiForeachStatementBase || nextParent instanceof PsiConditionalExpression && parent == ((PsiConditionalExpression)nextParent).getCondition()) {
                    return nextParent;
                }
                if (nextParent instanceof PsiPrefixExpression && ((PsiPrefixExpression)nextParent).getOperationTokenType().equals(JavaTokenType.EXCL)) {
                    negated = !negated;
                } else if (!(nextParent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)nextParent).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !negated || tokenType.equals(JavaTokenType.OROR) && negated))) {
                    if (nextParent instanceof PsiIfStatement) {
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (nextParent instanceof PsiConditionalLoopStatement) {
                        if (!negated) {
                            return nextParent;
                        }
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (nextParent instanceof PsiSwitchLabelStatementBase) {
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (!(nextParent instanceof PsiPattern || nextParent instanceof PsiCaseLabelElementList || nextParent instanceof PsiPatternGuard || parent instanceof PsiPattern && nextParent instanceof PsiInstanceOfExpression || parent instanceof PsiPattern && nextParent instanceof PsiDeconstructionList)) {
                        return parent;
                    }
                }
            }
            parent = nextParent;
            nextParent = parent.getParent();
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable, PsiExpression initializer2) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(22);
        }
        if ((oldInitializer = variable.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer2 == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter(initializer2, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromStub";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternVariableDeclarationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromStub";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPatternVariableDeclarationScope";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceOfPartDeclarationScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation @NotNull [] candidates, @NotNull TypeAnnotationProvider originalProvider) {
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (candidates == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        public PsiAnnotation @NotNull [] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation -> !annotation.isValid() || AnnotationTargetUtil.isTypeAnnotation(annotation)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result2;
            }
            if (result2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

