/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public final class PsiMethodUtil {
    public static final Condition<PsiClass> MAIN_CLASS = psiClass -> {
        if (PsiUtil.isLocalOrAnonymousClass(psiClass)) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher(psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(PsiClass aClass) {
        for (JavaMainMethodProvider provider : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider.isApplicable(aClass)) continue;
            return provider.findMainInClass(aClass);
        }
        PsiMethod[] mainMethods = aClass.findMethodsByName("main", true);
        return PsiMethodUtil.findMainMethod(mainMethods, aClass);
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods, PsiClass aClass) {
        for (PsiMethod mainMethod : mainMethods) {
            PsiClass containingClass = mainMethod.getContainingClass();
            if (containingClass != null && containingClass != aClass && containingClass.isInterface() || !PsiMethodUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (!PsiTypes.voidType().equals(method.getReturnType())) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType type = parameters[0].getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        for (JavaMainMethodProvider provider : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider.isApplicable(psiClass)) continue;
            return provider.hasMainMethod(psiClass);
        }
        return PsiMethodUtil.findMainMethod(psiClass.findMethodsByName("main", true), psiClass) != null;
    }

    @Nullable
    public static PsiMethod findMainInClass(PsiClass aClass) {
        if (!MAIN_CLASS.value(aClass)) {
            return null;
        }
        return PsiMethodUtil.findMainMethod(aClass);
    }
}

