/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.HashBiMap;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.MultimapStorageIndex;
import com.intellij.workspaceModel.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020\u001dJ\u001e\u0010#\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'J\u0012\u0010(\u001a\u00020\u001b2\n\u0010)\u001a\u00060*j\u0002`+J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\rJ\u000e\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200J2\u00101\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H$0'2\u0010\u00103\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000104H\u0002J\u0006\u00105\u001a\u00020\u0001J(\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001d2\n\u00108\u001a\u0006\u0012\u0002\b\u0003092\n\u0010:\u001a\u0006\u0012\u0002\b\u000309H\u0002J&\u0010;\u001a\u00020\u001b2\n\u0010<\u001a\u00060*j\u0002`+2\n\u0010=\u001a\u00060*j\u0002`+2\u0006\u0010>\u001a\u00020\u0001J&\u0010?\u001a\u00020\u001b2\n\u0010@\u001a\u00060*j\u0002`+2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u00107\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200JP\u0010D\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\u0006\u00107\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020%2\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u0001092\f\u00102\u001a\b\u0012\u0004\u0012\u0002H$0'2\u0012\b\u0002\u00103\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000104R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006F"}, d2={"Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "softLinks", "Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "symbolicIdIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "externalMappings", "", "", "Lcom/intellij/workspaceModel/storage/impl/external/MutableExternalEntityMappingImpl;", "(Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "getSoftLinks$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;", "getSymbolicIdIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "getVirtualFileIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "applyExternalMappingChanges", "", "diff", "Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "target", "entityAdded", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "entityRemoved", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "removeExternalMapping", "identifier", "removeFromSoftLinksIndex", "softLinkable", "Lcom/intellij/workspaceModel/storage/impl/SoftLinkable;", "simpleUpdateSoftReferences", "copiedData", "modifiableEntity", "Lcom/intellij/workspaceModel/storage/impl/ModifiableWorkspaceEntityBase;", "toImmutable", "updateComposedIds", "builder", "beforeSymbolicId", "Lcom/intellij/workspaceModel/storage/SymbolicEntityId;", "newSymbolicId", "updateExternalMappingForEntityId", "replaceWithEntityId", "targetEntityId", "replaceWithIndexes", "updateIndices", "oldEntityId", "newEntityData", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "updateSoftLinksIndex", "updateSymbolicIdIndexes", "updatedEntity", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/workspaceModel/storage/impl/MutableStorageIndexes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,291:1\n1#2:292\n1855#3,2:293\n1295#4,2:295\n215#5,2:297\n215#5,2:299\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/workspaceModel/storage/impl/MutableStorageIndexes\n*L\n178#1:293,2\n213#1:295,2\n217#1:297,2\n230#1:299,2\n*E\n"})
public final class MutableStorageIndexes
extends StorageIndexes {
    @NotNull
    private final MultimapStorageIndex.MutableMultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex;
    @NotNull
    private final Map<String, MutableExternalEntityMappingImpl<?>> externalMappings;

    public MutableStorageIndexes(@NotNull MultimapStorageIndex.MutableMultimapStorageIndex softLinks, @NotNull VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex, @NotNull Map<String, MutableExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter((Object)symbolicIdIndex, (String)"symbolicIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, (String)"externalMappings");
        super(softLinks, virtualFileIndex, (EntityStorageInternalIndex<EntitySource>)entitySourceIndex, symbolicIdIndex, externalMappings);
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.symbolicIdIndex = symbolicIdIndex;
        this.externalMappings = externalMappings;
    }

    @Override
    @NotNull
    public MultimapStorageIndex.MutableMultimapStorageIndex getSoftLinks$intellij_platform_workspaceModel_storage() {
        return this.softLinks;
    }

    @Override
    @NotNull
    public VirtualFileIndex.MutableVirtualFileIndex getVirtualFileIndex$intellij_platform_workspaceModel_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspaceModel_storage() {
        return this.entitySourceIndex;
    }

    @Override
    @NotNull
    public SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspaceModel_storage() {
        return this.symbolicIdIndex;
    }

    @NotNull
    public Map<String, MutableExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspaceModel_storage() {
        return this.externalMappings;
    }

    public final <T extends WorkspaceEntity> void entityAdded(@NotNull WorkspaceEntityData<T> entityData) {
        block2: {
            Intrinsics.checkNotNullParameter(entityData, (String)"entityData");
            long pid = entityData.createEntityId();
            if (entityData instanceof SoftLinkable) {
                ((SoftLinkable)((Object)entityData)).index(this.getSoftLinks$intellij_platform_workspaceModel_storage());
            }
            EntitySource entitySource = entityData.getEntitySource();
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(pid, entitySource);
            SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(entityData);
            if (symbolicEntityId != null) {
                SymbolicEntityId<?> symbolicId = symbolicEntityId;
                boolean bl = false;
                this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(pid, symbolicId);
            }
            VirtualFileUrl virtualFileUrl = entitySource.getVirtualFileUrl();
            if (virtualFileUrl == null) break block2;
            VirtualFileUrl it = virtualFileUrl;
            boolean bl = false;
            this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(pid, "entitySource", it);
        }
    }

    public final void entityRemoved(long entityId) {
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex.index$intellij_platform_workspaceModel_storage$default((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage(), entityId, null, 2, null);
        SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex.index$intellij_platform_workspaceModel_storage$default(this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage(), entityId, null, 2, null);
        this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().removeRecordsByEntityId$intellij_platform_workspaceModel_storage(entityId);
        Iterable $this$forEach$iv = this.getExternalMappings$intellij_platform_workspaceModel_storage().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableExternalEntityMappingImpl it = (MutableExternalEntityMappingImpl)element$iv;
            boolean bl = false;
            it.remove$intellij_platform_workspaceModel_storage(entityId);
        }
    }

    public final void updateSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter((Object)softLinkable, (String)"softLinkable");
        softLinkable.index(this.getSoftLinks$intellij_platform_workspaceModel_storage());
    }

    public final void removeFromSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter((Object)softLinkable, (String)"softLinkable");
        long pid = ((WorkspaceEntityData)((Object)softLinkable)).createEntityId();
        for (SymbolicEntityId<?> link : softLinkable.getLinks()) {
            this.getSoftLinks$intellij_platform_workspaceModel_storage().remove$intellij_platform_workspaceModel_storage(pid, link);
        }
    }

    public final void updateIndices(long oldEntityId, @NotNull WorkspaceEntityData<?> newEntityData, @NotNull AbstractEntityStorage builder) {
        block0: {
            SymbolicEntityId<?> symbolicEntityId;
            Intrinsics.checkNotNullParameter(newEntityData, (String)"newEntityData");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            long newEntityId = newEntityData.createEntityId();
            this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().updateIndex$intellij_platform_workspaceModel_storage(oldEntityId, newEntityId, builder.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage());
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newEntityId, newEntityData.getEntitySource());
            SymbolicEntityId<?> symbolicEntityId2 = builder.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldEntityId);
            if (symbolicEntityId2 == null) break block0;
            SymbolicEntityId<?> it = symbolicEntityId = symbolicEntityId2;
            boolean bl = false;
            this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(newEntityId, it);
        }
    }

    private final <T extends WorkspaceEntity> void simpleUpdateSoftReferences(WorkspaceEntityData<T> copiedData, ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        long pid = copiedData.createEntityId();
        if (copiedData instanceof SoftLinkable) {
            ((SoftLinkable)((Object)copiedData)).updateLinksIndex(this.getSoftLinks$intellij_platform_workspaceModel_storage().getEntriesById$intellij_platform_workspaceModel_storage(pid), this.getSoftLinks$intellij_platform_workspaceModel_storage());
        }
    }

    public final void applyExternalMappingChanges(@NotNull MutableEntityStorageImpl diff, @NotNull HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, @NotNull MutableEntityStorageImpl target) {
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().keySet()), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ MutableStorageIndexes this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getExternalMappings$intellij_platform_workspaceModel_storage().keySet().contains(it);
            }
        }));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl = false;
            this.getExternalMappings$intellij_platform_workspaceModel_storage().put(it, new MutableExternalEntityMappingImpl());
        }
        $this$forEach$iv = diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = iterator2.next();
            boolean bl = false;
            String identifier = (String)object.getKey();
            MutableExternalEntityMappingImpl index2 = (MutableExternalEntityMappingImpl)object.getValue();
            MutableExternalEntityMappingImpl<?> mapping2 = this.getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
            if (mapping2 == null) continue;
            mapping2.applyChanges(index2, replaceMap, target);
            if (!mapping2.getIndex$intellij_platform_workspaceModel_storage().isEmpty()) continue;
            this.getExternalMappings$intellij_platform_workspaceModel_storage().remove(identifier);
        }
    }

    public final void updateExternalMappingForEntityId(long replaceWithEntityId, long targetEntityId, @NotNull StorageIndexes replaceWithIndexes) {
        Intrinsics.checkNotNullParameter((Object)replaceWithIndexes, (String)"replaceWithIndexes");
        Map<String, ExternalEntityMappingImpl<?>> $this$forEach$iv = replaceWithIndexes.getExternalMappings$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ExternalEntityMappingImpl<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object data;
            Map.Entry<String, ExternalEntityMappingImpl<?>> element$iv;
            Map.Entry<String, ExternalEntityMappingImpl<?>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String mappingId = entry.getKey();
            ExternalEntityMappingImpl<?> mapping2 = entry.getValue();
            if (mapping2.getIndex$intellij_platform_workspaceModel_storage().get(replaceWithEntityId) == null) continue;
            MutableExternalEntityMappingImpl<?> externalMapping = this.getExternalMappings$intellij_platform_workspaceModel_storage().get(mappingId);
            if (externalMapping == null) {
                MutableExternalEntityMappingImpl newMapping = new MutableExternalEntityMappingImpl();
                newMapping.add$intellij_platform_workspaceModel_storage(targetEntityId, data);
                this.getExternalMappings$intellij_platform_workspaceModel_storage().put(mappingId, newMapping);
                continue;
            }
            externalMapping.add$intellij_platform_workspaceModel_storage(targetEntityId, data);
        }
    }

    public final <T extends WorkspaceEntity> void updateSymbolicIdIndexes(@NotNull MutableEntityStorageImpl builder, @NotNull WorkspaceEntity updatedEntity, @Nullable SymbolicEntityId<?> beforeSymbolicId, @NotNull WorkspaceEntityData<T> copiedData, @Nullable ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)updatedEntity, (String)"updatedEntity");
        Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
        long entityId = ((WorkspaceEntityBase)updatedEntity).getId();
        if (updatedEntity instanceof WorkspaceEntityWithSymbolicId) {
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> newSymbolicId = ((WorkspaceEntityWithSymbolicId)updatedEntity).getSymbolicId();
            if (beforeSymbolicId != null && !Intrinsics.areEqual(beforeSymbolicId, newSymbolicId)) {
                this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(entityId, newSymbolicId);
                this.updateComposedIds(builder, beforeSymbolicId, newSymbolicId);
            }
        }
        this.simpleUpdateSoftReferences(copiedData, modifiableEntity);
    }

    public static /* synthetic */ void updateSymbolicIdIndexes$default(MutableStorageIndexes mutableStorageIndexes, MutableEntityStorageImpl mutableEntityStorageImpl, WorkspaceEntity workspaceEntity, SymbolicEntityId symbolicEntityId, WorkspaceEntityData workspaceEntityData, ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase, int n, Object object) {
        if ((n & 0x10) != 0) {
            modifiableWorkspaceEntityBase = null;
        }
        mutableStorageIndexes.updateSymbolicIdIndexes(mutableEntityStorageImpl, workspaceEntity, symbolicEntityId, workspaceEntityData, modifiableWorkspaceEntityBase);
    }

    private final void updateComposedIds(MutableEntityStorageImpl builder, SymbolicEntityId<?> beforeSymbolicId, SymbolicEntityId<?> newSymbolicId) {
        HashSet idsWithSoftRef = new HashSet(this.getSoftLinks$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(beforeSymbolicId));
        for (Long entityId : idsWithSoftRef) {
            WorkspaceEntityData<?> originalEntityData;
            WorkspaceEntityData<?> entity2;
            Intrinsics.checkNotNullExpressionValue((Object)entityId, (String)"entityId");
            Intrinsics.checkNotNull(WorkspaceBuilderChangeLogKt.getOriginalEntityData(builder, entityId), (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            Map<ConnectionId, ParentEntityId> originalParentsData = WorkspaceBuilderChangeLogKt.getOriginalParents(builder, RefsTableKt.asChild(entityId));
            Intrinsics.checkNotNull(builder.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(entityId), (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            SymbolicEntityId<?> editingBeforeSymbolicId = EntitiesKt.symbolicId(entity2);
            ((SoftLinkable)((Object)entity2)).updateLink(beforeSymbolicId, newSymbolicId);
            builder.getChangeLog$intellij_platform_workspaceModel_storage().addReplaceEvent$intellij_platform_workspaceModel_storage(entityId, entity2, originalEntityData, originalParentsData, CollectionsKt.emptyList(), SetsKt.emptySet(), MapsKt.emptyMap());
            MutableStorageIndexes.updateSymbolicIdIndexes$default(builder.getIndexes$intellij_platform_workspaceModel_storage(), builder, entity2.createEntity(builder), editingBeforeSymbolicId, entity2, null, 16, null);
        }
    }

    public final void removeExternalMapping(@NotNull String identifier) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            MutableExternalEntityMappingImpl<?> mutableExternalEntityMappingImpl = this.getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
            if (mutableExternalEntityMappingImpl == null) break block0;
            mutableExternalEntityMappingImpl.clearMapping$intellij_platform_workspaceModel_storage();
        }
    }

    @NotNull
    public final StorageIndexes toImmutable() {
        MultimapStorageIndex copiedLinks = this.getSoftLinks$intellij_platform_workspaceModel_storage().toImmutable();
        VirtualFileIndex newVirtualFileIndex = this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().toImmutable();
        EntityStorageInternalIndex<EntitySource> newEntitySourceIndex = ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).toImmutable();
        SymbolicIdInternalIndex newSymbolicIdIndex = this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().toImmutable();
        Map<String, ExternalEntityMappingImpl<?>> newExternalMappings = MutableExternalEntityMappingImpl.Companion.toImmutable(this.getExternalMappings$intellij_platform_workspaceModel_storage());
        return new StorageIndexes(copiedLinks, newVirtualFileIndex, newEntitySourceIndex, newSymbolicIdIndex, newExternalMappings);
    }
}

