/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.DummyParentEntitySource;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.ReplaceBySourceOperation;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.ReplaceBySourceAsGraph;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.exceptions.ReplaceBySourceException;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J6\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\b\u0002\u0010\u0014\u001a\u00020\u000bH\u0002JX\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\r2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002JX\u0010!\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u0002H#\u0018\u00010\"\"\u0004\b\u0000\u0010#*\"\u0012\u0004\u0012\u00020%\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u0002H#0\"0$2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010'\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0018H\u0002J:\u0010)\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020.H\u0002JZ\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001801*\u00020\u000f2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u001a\u001a\u00020\r2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u001d032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u000204H\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/workspaceModel/storage/impl/ReplaceBySourceAsGraph;", "Lcom/intellij/workspaceModel/storage/ReplaceBySourceOperation;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "entityFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "replaceWithStorage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "thisStorage", "Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "replace", "", "targetStorage", "replaceBySourceAsGraph", "reverseEntities", "replaceOperation", "thisBuilder", "matchedEntityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "replaceWith", "localNode", "matchedEntityId", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "dataDiffersByProperties", "dataDiffersByEntitySource", "originalEntitySource", "find", "Lkotlin/Pair;", "T", "Lcom/google/common/collect/HashMultimap;", "", "entity", "hasSymbolicId", "identificator", "rbsFailedAndReport", "message", "", "sourceFilter", "left", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "right", "removeEntitiesByOneToOneRef", "", "replaceMap", "", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "localEntityId", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nReplaceBySourceAsGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsGraph.kt\ncom/intellij/workspaceModel/storage/impl/ReplaceBySourceAsGraph\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,487:1\n10#2:488\n12#2,5:489\n12#2,5:494\n12#2,5:506\n12#2,5:511\n12#2,5:528\n12#2,5:533\n12#2,5:538\n12#2,5:558\n766#3:499\n857#3,2:500\n1855#3:502\n1855#3,2:503\n1856#3:505\n766#3:516\n857#3,2:517\n1045#3:519\n1620#3,3:520\n1855#3,2:524\n1855#3,2:526\n1855#3:543\n1603#3,9:544\n1855#3:553\n1856#3:555\n1612#3:556\n1856#3:557\n1#4:523\n1#4:554\n515#5:563\n500#5,6:564\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsGraph.kt\ncom/intellij/workspaceModel/storage/impl/ReplaceBySourceAsGraph\n*L\n485#1:488\n61#1:489,5\n74#1:494,5\n82#1:506,5\n117#1:511,5\n216#1:528,5\n235#1:533,5\n320#1:538,5\n383#1:558,5\n75#1:499\n75#1:500,2\n75#1:502\n76#1:503,2\n75#1:505\n123#1:516\n123#1:517,2\n126#1:519\n127#1:520,3\n154#1:524,2\n187#1:526,2\n354#1:543\n358#1:544,9\n358#1:553\n358#1:555\n358#1:556\n354#1:557\n358#1:554\n457#1:563\n457#1:564,6\n*E\n"})
public final class ReplaceBySourceAsGraph
implements ReplaceBySourceOperation {
    private MutableEntityStorageImpl thisStorage;
    private AbstractEntityStorage replaceWithStorage;
    private Function1<? super EntitySource, Boolean> entityFilter;
    @NotNull
    private final Logger LOG;

    public ReplaceBySourceAsGraph() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReplaceBySourceAsGraph.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
    }

    @Override
    public void replace(@NotNull MutableEntityStorageImpl targetStorage, @NotNull AbstractEntityStorage replaceWithStorage, @NotNull Function1<? super EntitySource, Boolean> entityFilter) {
        Intrinsics.checkNotNullParameter((Object)targetStorage, (String)"targetStorage");
        Intrinsics.checkNotNullParameter((Object)replaceWithStorage, (String)"replaceWithStorage");
        Intrinsics.checkNotNullParameter(entityFilter, (String)"entityFilter");
        ReplaceBySourceAsGraph.replaceBySourceAsGraph$default(this, targetStorage, replaceWithStorage, entityFilter, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceBySourceAsGraph(MutableEntityStorageImpl thisStorage, AbstractEntityStorage replaceWithStorage, Function1<? super EntitySource, Boolean> entityFilter, boolean reverseEntities) {
        List<Long> $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv2;
        Object object;
        this.thisStorage = thisStorage;
        this.replaceWithStorage = replaceWithStorage;
        this.entityFilter = entityFilter;
        if (this.LOG.isTraceEnabled()) {
            ConsistencyCheckerKt.assertConsistency(thisStorage);
            ConsistencyCheckerKt.assertConsistency(replaceWithStorage);
            this.LOG.trace("Before starting replaceBySource no consistency issues were found");
        }
        EntityStorageSnapshot initialStore = ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED ? thisStorage.toSnapshot() : null;
        Logger $this$debug_u24default$iv = this.LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            ((Logger)object).debug("Performing replace by source", e$iv);
        }
        HashMultimap localMatchedEntities = HashMultimap.create();
        ArrayList<NotThisEntityId> orderedListOfMatchedEntities = new ArrayList<NotThisEntityId>();
        HashMultimap localUnmatchedReferencedNodes = HashMultimap.create();
        HashBiMap replaceMap = HashBiMap.create();
        Logger $this$debug_u24default$iv2 = this.LOG;
        Throwable e$iv2 = null;
        boolean $i$f$debug232 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            object = $this$debug_u24default$iv2;
            boolean bl = false;
            ((Logger)object).debug("1) Traverse all entities and store matched only", e$iv2);
        }
        Iterable $this$filter$iv = thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter = false;
        Iterable $i$f$debug232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            EntitySource entitySource = (EntitySource)t;
            boolean bl = false;
            if (!((Boolean)entityFilter.invoke((Object)entitySource)).booleanValue()) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            EntitySource entitySource = (EntitySource)element$iv;
            boolean bl = false;
            List<Long> list = thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(entitySource);
            if (list != null) {
                Iterable iterable = list;
                boolean bl2 = false;
                for (Object element$iv2 : iterable) {
                    long it = ((Number)element$iv2).longValue();
                    boolean bl22 = false;
                    WorkspaceEntityData<? extends WorkspaceEntity> entityData = thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it);
                    localMatchedEntities.put(this.identificator(entityData), (Object)TuplesKt.to(entityData, (Object)UtilsKt.asThis(it)));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        Iterator $this$debug_u24default$iv3 = this.LOG;
        Throwable e$iv222 = null;
        boolean $i$f$debug3 = false;
        if (((Logger)((Object)$this$debug_u24default$iv3)).isDebugEnabled()) {
            object = $this$debug_u24default$iv3;
            boolean bl = false;
            ((Logger)object).debug("1.1) Cleanup references", e$iv222);
        }
        $this$debug_u24default$iv3 = localMatchedEntities.values().iterator();
        while ($this$debug_u24default$iv3.hasNext()) {
            ThisEntityId entityId = (ThisEntityId)((Pair)$this$debug_u24default$iv3.next()).component2();
            ChildEntityId childEntityId = RefsTableKt.asChild(entityId.getId());
            for (Map.Entry<ConnectionId, ParentEntityId> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(childEntityId).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                ParentEntityId parentEntityId = entry.getValue();
                WorkspaceEntityData<? extends WorkspaceEntity> parentEntity = thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentEntityId.getId());
                if (((Boolean)entityFilter.invoke((Object)parentEntity.getEntitySource())).booleanValue()) {
                    thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parentEntityId, childEntityId);
                    continue;
                }
                localUnmatchedReferencedNodes.put(this.identificator(parentEntity), (Object)UtilsKt.asThis(parentEntityId.getId()));
            }
            for (Map.Entry<ConnectionId, Object> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                List list = (List)entry.getValue();
                for (ChildEntityId childId : list) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childEntity = thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId.getId());
                    if (((Boolean)entityFilter.invoke((Object)childEntity.getEntitySource())).booleanValue()) {
                        thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, RefsTableKt.asParent(entityId.getId()), childId);
                        continue;
                    }
                    localUnmatchedReferencedNodes.put(this.identificator(childEntity), (Object)UtilsKt.asThis(childId.getId()));
                }
            }
        }
        $this$debug_u24default$iv3 = this.LOG;
        Pair e$iv32 = null;
        boolean $i$f$debug2 = false;
        if (((Logger)((Object)$this$debug_u24default$iv3)).isDebugEnabled()) {
            object = $this$debug_u24default$iv3;
            boolean bl = false;
            ((Logger)object).debug("2) Traverse entities of replaceWith store", (Throwable)e$iv32);
        }
        Iterable $this$filter$iv2 = replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter2 = false;
        Iterable bl = $this$filter$iv2;
        Collection destination$iv$iv222 = new ArrayList();
        boolean bl3 = false;
        for (Object t : $this$filterTo$iv$iv) {
            EntitySource it = (EntitySource)t;
            boolean bl32 = false;
            if (!((Boolean)entityFilter.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv222.add(t);
        }
        for (EntitySource replaceWithEntitySource : (List)destination$iv$iv222) {
            $this$filterTo$iv$iv = replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(replaceWithEntitySource);
            if ($this$filterTo$iv$iv == null) continue;
            Iterable iterable = $this$filterTo$iv$iv;
            boolean bl4 = false;
            destination$iv$iv222 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    long it = ((Number)a).longValue();
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(EntityIdKt.getClazz(it) + EntityIdKt.getArrayId(it));
                    it = ((Number)b).longValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(EntityIdKt.getClazz(it) + EntityIdKt.getArrayId(it)));
                }
            });
            if (destination$iv$iv222 == null) continue;
            Iterable iterable2 = destination$iv$iv222;
            Collection collection = new ArrayList();
            boolean $i$f$mapTo = false;
            for (Object item$iv : iterable2) {
                void it;
                long l = ((Number)item$iv).longValue();
                object = collection;
                boolean bl42 = false;
                object.add(TuplesKt.to(replaceWithStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage((long)it), (Object)UtilsKt.notThis((long)it)));
            }
            ArrayList entityDataList = (ArrayList)collection;
            if (reverseEntities) {
                CollectionsKt.reverse((List)entityDataList);
            }
            for (Collection destination$iv$iv222 : entityDataList) {
                SymbolicEntityId<?> symbolicEntityId;
                EntitySource entitySource;
                Object it;
                boolean entityStillExists;
                boolean bl5;
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)destination$iv$iv222.component1();
                NotThisEntityId notThisEntityId = (NotThisEntityId)destination$iv$iv222.component2();
                orderedListOfMatchedEntities.add(notThisEntityId);
                Intrinsics.checkNotNullExpressionValue((Object)localMatchedEntities, (String)"localMatchedEntities");
                Pair pair = this.find(localMatchedEntities, workspaceEntityData);
                Object object2 = pair;
                if (object2 != null && (object2 = (ThisEntityId)object2.getSecond()) != null) {
                    Object it2 = object2;
                    boolean bl62 = false;
                    bl5 = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(((ThisEntityId)it2).getId()) != null;
                } else {
                    bl5 = entityStillExists = false;
                }
                if (entityStillExists && pair != null) {
                    boolean dataDiffersByEntitySource;
                    WorkspaceEntityData localNode = (WorkspaceEntityData)pair.component1();
                    ThisEntityId localNodeEntityId = (ThisEntityId)pair.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)replaceMap, (String)"replaceMap");
                    ((Map)replaceMap).put(localNodeEntityId, notThisEntityId);
                    boolean dataDiffersByProperties = !localNode.equalsIgnoringEntitySource(workspaceEntityData);
                    boolean bl6 = dataDiffersByEntitySource = !Intrinsics.areEqual((Object)localNode.getEntitySource(), (Object)workspaceEntityData.getEntitySource());
                    if (this.hasSymbolicId(localNode, thisStorage) && (dataDiffersByEntitySource || dataDiffersByProperties) && !(workspaceEntityData.getEntitySource() instanceof DummyParentEntitySource)) {
                        this.replaceOperation(thisStorage, workspaceEntityData, replaceWithStorage, localNode, notThisEntityId, dataDiffersByProperties, dataDiffersByEntitySource, localNode.getEntitySource());
                    }
                    if (!(localNode.getEntitySource() instanceof DummyParentEntitySource) && !(workspaceEntityData.getEntitySource() instanceof DummyParentEntitySource)) {
                        void $this$forEach$iv3;
                        Iterable bl62 = this.removeEntitiesByOneToOneRef(thisStorage, entityFilter, replaceWithStorage, (Map)replaceMap, notThisEntityId, localNodeEntityId);
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv : $this$forEach$iv3) {
                            WorkspaceEntityData removedEntityData = (WorkspaceEntityData)element$iv;
                            boolean bl8 = false;
                            localUnmatchedReferencedNodes.removeAll(this.identificator(removedEntityData));
                        }
                    }
                    if (Intrinsics.areEqual((Object)localNode, (Object)workspaceEntityData)) {
                        thisStorage.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(notThisEntityId.getId(), localNodeEntityId.getId(), replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage());
                    }
                    localMatchedEntities.remove(this.identificator(localNode), pair);
                    continue;
                }
                SymbolicEntityId<?> symbolicId = EntitiesKt.symbolicId(workspaceEntityData);
                if (symbolicId != null) {
                    ThisEntityId existingEntityId;
                    Long l = thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(symbolicId);
                    ThisEntityId thisEntityId = existingEntityId = l != null ? UtilsKt.asThis(l) : null;
                    if (existingEntityId != null) {
                        void $this$forEach$iv4;
                        WorkspaceEntityData<? extends WorkspaceEntity> localNode = thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(existingEntityId.getId());
                        boolean dataDiffersByProperties = !localNode.equalsIgnoringEntitySource(workspaceEntityData);
                        boolean dataDiffersByEntitySource = !Intrinsics.areEqual((Object)localNode.getEntitySource(), (Object)workspaceEntityData.getEntitySource());
                        this.replaceOperation(thisStorage, workspaceEntityData, replaceWithStorage, localNode, notThisEntityId, dataDiffersByProperties, dataDiffersByEntitySource, localNode.getEntitySource());
                        Intrinsics.checkNotNullExpressionValue((Object)replaceMap, (String)"replaceMap");
                        Iterable $i$f$forEach3 = this.removeEntitiesByOneToOneRef(thisStorage, entityFilter, replaceWithStorage, (Map)replaceMap, notThisEntityId, existingEntityId);
                        boolean $i$f$forEach4 = false;
                        for (Object element$iv : $this$forEach$iv4) {
                            WorkspaceEntityData removedEntityData = (WorkspaceEntityData)element$iv;
                            boolean bl9 = false;
                            localUnmatchedReferencedNodes.removeAll(this.identificator(removedEntityData));
                        }
                        ((Map)replaceMap).put(existingEntityId, notThisEntityId);
                        continue;
                    }
                }
                int entityClass = ClassToIntConverterKt.toClassId(workspaceEntityData.getEntityInterface());
                WorkspaceEntityData newEntity = thisStorage.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(workspaceEntityData, entityClass);
                ThisEntityId newEntityId = UtilsKt.asThis(EntityIdKt.copy$default(notThisEntityId.getId(), newEntity.getId(), 0, 2, null));
                Intrinsics.checkNotNullExpressionValue((Object)replaceMap, (String)"replaceMap");
                ((Map)replaceMap).put(newEntityId, notThisEntityId);
                thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().updateIndex$intellij_platform_workspaceModel_storage(notThisEntityId.getId(), newEntityId.getId(), replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage());
                if (replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(notThisEntityId.getId()) != null) {
                    EntitySource $this$forEach$iv4;
                    it = $this$forEach$iv4;
                    boolean bl10 = false;
                    ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newEntityId.getId(), it);
                    entitySource = $this$forEach$iv4;
                } else {
                    entitySource = null;
                }
                if (replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(notThisEntityId.getId()) != null) {
                    SymbolicEntityId<?> $this$forEach$iv4;
                    it = $this$forEach$iv4;
                    boolean bl11 = false;
                    thisStorage.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(newEntityId.getId(), (SymbolicEntityId<?>)it);
                    symbolicEntityId = $this$forEach$iv4;
                } else {
                    symbolicEntityId = null;
                }
                thisStorage.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(notThisEntityId.getId(), newEntityId.getId(), replaceWithStorage.getIndexes$intellij_platform_workspaceModel_storage());
                if (newEntity instanceof SoftLinkable) {
                    thisStorage.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)newEntity));
                }
                thisStorage.createAddEvent$intellij_platform_workspaceModel_storage(newEntity);
            }
        }
        $this$debug_u24default$iv3 = this.LOG;
        e$iv32 = null;
        $i$f$debug = false;
        if (((Logger)((Object)$this$debug_u24default$iv3)).isDebugEnabled()) {
            object = $this$debug_u24default$iv3;
            boolean bl12 = false;
            ((Logger)object).debug("3) Remove old entities", (Throwable)e$iv32);
        }
        for (Pair e$iv32 : localMatchedEntities.values()) {
            WorkspaceEntityData<WorkspaceEntity> original;
            WorkspaceEntityData localEntity = (WorkspaceEntityData)e$iv32.component1();
            ThisEntityId entityId = (ThisEntityId)e$iv32.component2();
            int entityClass = ClassToIntConverterKt.toClassId(localEntity.getEntityInterface());
            long l = EntityIdKt.createEntityId(localEntity.getId(), entityClass);
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(l);
            if (workspaceEntityData == null) continue;
            Intrinsics.checkNotNull(thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(l), (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            Map<ConnectionId, ParentEntityId> originalParents = thisStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(l));
            thisStorage.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(localEntity.getId(), entityClass);
            thisStorage.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(entityId.getId());
            if (localEntity instanceof SoftLinkable) {
                thisStorage.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)localEntity));
            }
            thisStorage.getChangeLog$intellij_platform_workspaceModel_storage().addRemoveEvent$intellij_platform_workspaceModel_storage(entityId.getId(), original, originalParents);
        }
        HashSet lostChildren = new HashSet();
        Iterator $this$debug_u24default$iv32 = this.LOG;
        Throwable e$iv33 = null;
        boolean $i$f$debug4 = false;
        if (((Logger)((Object)$this$debug_u24default$iv32)).isDebugEnabled()) {
            object = $this$debug_u24default$iv32;
            boolean bl13 = false;
            ((Logger)object).debug("4) Restore references between matched and unmatched entities", e$iv33);
        }
        for (ThisEntityId thisUnmatchedId : localUnmatchedReferencedNodes.values()) {
            WorkspaceEntityData<? extends WorkspaceEntity> replaceWithUnmatchedEntity = replaceWithStorage.entityDataById$intellij_platform_workspaceModel_storage(thisUnmatchedId.getId());
            if (replaceWithUnmatchedEntity == null || !Intrinsics.areEqual(replaceWithUnmatchedEntity, thisStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(thisUnmatchedId.getId()))) {
                for (Map.Entry<ConnectionId, ParentEntityId> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId())).entrySet()) {
                    ConnectionId connectionId = entry.getKey();
                    ParentEntityId parentEntityId = entry.getValue();
                    WorkspaceEntityData<? extends WorkspaceEntity> parent = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(parentEntityId.getId());
                    if (parent != null) continue;
                    if (connectionId.canRemoveParent()) {
                        thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parentEntityId, RefsTableKt.asChild(thisUnmatchedId.getId()));
                        continue;
                    }
                    thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parentEntityId, RefsTableKt.asChild(thisUnmatchedId.getId()));
                    ((Collection)lostChildren).add(thisUnmatchedId);
                }
                for (Map.Entry<ConnectionId, Object> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId())).entrySet()) {
                    ConnectionId connectionId = entry.getKey();
                    List list = (List)entry.getValue();
                    for (ChildEntityId childId : list) {
                        WorkspaceEntityData<? extends WorkspaceEntity> child = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(childId.getId());
                        if (child != null) continue;
                        thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, RefsTableKt.asParent(thisUnmatchedId.getId()), childId);
                    }
                }
                continue;
            }
            HashMap removedConnections = new HashMap();
            for (Map.Entry<ConnectionId, ParentEntityId> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                ParentEntityId parentId = entry.getValue();
                WorkspaceEntityData<? extends WorkspaceEntity> parentData = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(parentId.getId());
                if (parentData != null && !((Boolean)entityFilter.invoke((Object)parentData.getEntitySource())).booleanValue()) continue;
                thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parentId, RefsTableKt.asChild(thisUnmatchedId.getId()));
                ((Map)removedConnections).put(connectionId, parentId.getId());
            }
            for (Map.Entry<ConnectionId, ParentEntityId> entry : replaceWithStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                ParentEntityId parentId = entry.getValue();
                if (!((Boolean)entityFilter.invoke((Object)replaceWithStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId.getId()).getEntitySource())).booleanValue()) continue;
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                Iterator<ChildEntityId> localParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)UtilsKt.notThis(parentId.getId()));
                thisStorage.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(thisUnmatchedId.getId()), RefsTableKt.asParent(((ThisEntityId)((Object)localParentId)).getId()));
                removedConnections.remove(connectionId);
            }
            for (Map.Entry entry : ((Map)removedConnections).entrySet()) {
                ConnectionId connectionId = (ConnectionId)entry.getKey();
                long parentId = ((Number)entry.getValue()).longValue();
                if (connectionId.canRemoveParent()) continue;
                this.rbsFailedAndReport(thisStorage, "Cannot restore connection to " + parentId + "; " + connectionId, entityFilter, initialStore, replaceWithStorage);
            }
            for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : thisStorage.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                List<ChildEntityId> childrenId = entry.getValue();
                for (ChildEntityId childId : childrenId) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childData = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(childId.getId());
                    if (childData != null && !((Boolean)entityFilter.invoke((Object)childData.getEntitySource())).booleanValue()) continue;
                    thisStorage.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, RefsTableKt.asParent(thisUnmatchedId.getId()), childId);
                }
            }
            for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : replaceWithStorage.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                List<ChildEntityId> childrenId = entry.getValue();
                for (ChildEntityId childId : childrenId) {
                    if (!((Boolean)entityFilter.invoke((Object)replaceWithStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId.getId()).getEntitySource())).booleanValue()) continue;
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                    ThisEntityId localChildId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)UtilsKt.notThis(childId.getId()));
                    thisStorage.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(localChildId.getId()), RefsTableKt.asParent(thisUnmatchedId.getId()));
                }
            }
        }
        for (ThisEntityId entityId : lostChildren) {
            MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspaceModel_storage$default(thisStorage, entityId.getId(), null, 2, null);
        }
        Logger $this$debug_u24default$iv4 = this.LOG;
        Iterator e$iv4 = null;
        boolean $i$f$debug5 = false;
        if ($this$debug_u24default$iv4.isDebugEnabled()) {
            object = $this$debug_u24default$iv4;
            boolean bl14 = false;
            ((Logger)object).debug("5) Restore references in matching ids", (Throwable)((Object)e$iv4));
        }
        Set parentsWithSortedChildren = new LinkedHashSet();
        for (NotThisEntityId nodeId : orderedListOfMatchedEntities) {
            for (Map.Entry<ConnectionId, ParentEntityId> entry : replaceWithStorage.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(nodeId.getId())).entrySet()) {
                ConnectionId connectionId = entry.getKey();
                ParentEntityId parentEntityId = entry.getValue();
                if (!((Boolean)entityFilter.invoke((Object)replaceWithStorage.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentEntityId.getId()).getEntitySource())).booleanValue()) {
                    if (connectionId.isParentNullable()) continue;
                    WorkspaceEntityData<? extends WorkspaceEntity> localParent = thisStorage.entityDataById$intellij_platform_workspaceModel_storage(parentEntityId.getId());
                    if (localParent == null) {
                        this.rbsFailedAndReport(thisStorage, "Cannot link entities. Child entity doesn't have a parent after operation; " + connectionId, entityFilter, initialStore, replaceWithStorage);
                    }
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                    ThisEntityId localChildId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                    if (connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                        ((Collection)parentsWithSortedChildren).add(TuplesKt.to((Object)UtilsKt.notThis(parentEntityId.getId()), (Object)connectionId));
                    }
                    thisStorage.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(localChildId.getId()), parentEntityId);
                    continue;
                }
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                ThisEntityId localChildId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                BiMap biMap2 = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap2, (String)"replaceMap.inverse()");
                ThisEntityId localParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap2), (Object)UtilsKt.notThis(parentEntityId.getId()));
                if (connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                    ((Collection)parentsWithSortedChildren).add(TuplesKt.to((Object)UtilsKt.notThis(parentEntityId.getId()), (Object)connectionId));
                }
                thisStorage.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(localChildId.getId()), RefsTableKt.asParent(localParentId.getId()));
            }
        }
        Iterable $this$forEach$iv5 = parentsWithSortedChildren;
        boolean $i$f$forEach5 = false;
        for (Object t : $this$forEach$iv5) {
            List<ChildEntityId> savedLocalChildren;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Pair pair = (Pair)t;
            boolean bl7 = false;
            NotThisEntityId notThisParentId = (NotThisEntityId)pair.component1();
            ConnectionId connectionId = (ConnectionId)pair.component2();
            if (!replaceMap.containsValue((Object)notThisParentId)) continue;
            BiMap biMap = replaceMap.inverse();
            Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
            ThisEntityId thisParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)notThisParentId);
            List<ChildEntityId> localChildId = replaceWithStorage.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(notThisParentId.getId()));
            if (localChildId == null) continue;
            Iterable newEntityId = localChildId;
            boolean $i$f$mapNotNull = false;
            void $this$forEach$iv4 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach6 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                ThisEntityId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl16 = false;
                ChildEntityId it = (ChildEntityId)element$iv$iv;
                boolean bl17 = false;
                BiMap biMap3 = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap3, (String)"replaceMap.inverse()");
                if ((ThisEntityId)MapsKt.getValue((Map)((Map)biMap3), (Object)UtilsKt.notThis(it.getId())) == null) continue;
                boolean bl18 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List children2 = (List)destination$iv$iv3;
            Collection<ChildEntityId> collection = thisStorage.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(thisParentId.getId()));
            if (collection == null || (collection = CollectionsKt.toMutableSet((Iterable)collection)) == null) continue;
            Collection<ChildEntityId> localChildren = collection;
            if (thisStorage.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(thisParentId.getId())) == null) continue;
            List newChildren = new ArrayList();
            for (ThisEntityId child : children2) {
                boolean removed = localChildren.remove(RefsTableKt.asChild(child.getId()));
                if (!removed) continue;
                ((Collection)newChildren).add(RefsTableKt.asChild(child.getId()));
            }
            newChildren.addAll((Collection)localChildren);
            if (Intrinsics.areEqual(savedLocalChildren, (Object)newChildren)) continue;
            thisStorage.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asParent(thisParentId.getId()), newChildren);
        }
        if (!thisStorage.getBrokenConsistency$intellij_platform_workspaceModel_storage() && !replaceWithStorage.getBrokenConsistency$intellij_platform_workspaceModel_storage()) {
            thisStorage.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage("Check after replaceBySource", entityFilter, initialStore, replaceWithStorage);
        } else {
            thisStorage.setBrokenConsistency$intellij_platform_workspaceModel_storage(true);
        }
        Logger $this$debug_u24default$iv42 = this.LOG;
        Throwable e$iv42 = null;
        boolean $i$f$debug52 = false;
        if ($this$debug_u24default$iv42.isDebugEnabled()) {
            object = $this$debug_u24default$iv42;
            boolean bl8 = false;
            ((Logger)object).debug("Replace by source finished", e$iv42);
        }
    }

    static /* synthetic */ void replaceBySourceAsGraph$default(ReplaceBySourceAsGraph replaceBySourceAsGraph, MutableEntityStorageImpl mutableEntityStorageImpl, AbstractEntityStorage abstractEntityStorage, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        replaceBySourceAsGraph.replaceBySourceAsGraph(mutableEntityStorageImpl, abstractEntityStorage, (Function1<? super EntitySource, Boolean>)function1, bl);
    }

    private final Object identificator(WorkspaceEntityData<?> $this$identificator) {
        SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId($this$identificator);
        if (symbolicEntityId == null) {
            symbolicEntityId = $this$identificator.hashCode();
        }
        return symbolicEntityId;
    }

    private final <T> Pair<WorkspaceEntityData<? extends WorkspaceEntity>, T> find(HashMultimap<Object, Pair<WorkspaceEntityData<? extends WorkspaceEntity>, T>> $this$find, WorkspaceEntityData<? extends WorkspaceEntity> entity2) {
        Pair pair;
        Set possibleValues = $this$find.get(this.identificator(entity2));
        SymbolicEntityId<?> symbolicId = EntitiesKt.symbolicId(entity2);
        if (symbolicId != null) {
            Intrinsics.checkNotNullExpressionValue((Object)possibleValues, (String)"possibleValues");
            pair = (Pair)CollectionsKt.singleOrNull((Iterable)possibleValues);
        } else {
            Object v1;
            block3: {
                Intrinsics.checkNotNullExpressionValue((Object)possibleValues, (String)"possibleValues");
                Iterable iterable = possibleValues;
                for (Object t : iterable) {
                    Pair it = (Pair)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFirst(), entity2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            pair = v1;
        }
        return pair;
    }

    private final boolean hasSymbolicId(WorkspaceEntityData<?> $this$hasSymbolicId, MutableEntityStorageImpl thisBuilder) {
        Object entity2 = $this$hasSymbolicId.createEntity(thisBuilder);
        return entity2 instanceof WorkspaceEntityWithSymbolicId;
    }

    private final void replaceOperation(MutableEntityStorageImpl thisBuilder, WorkspaceEntityData<? extends WorkspaceEntity> matchedEntityData, AbstractEntityStorage replaceWith, WorkspaceEntityData<? extends WorkspaceEntity> localNode, NotThisEntityId matchedEntityId, boolean dataDiffersByProperties, boolean dataDiffersByEntitySource, EntitySource originalEntitySource) {
        Object object = matchedEntityData.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
        Object clonedEntity = object;
        SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(matchedEntityData);
        if (symbolicEntityId == null) {
            throw new IllegalStateException(("SymbolicId expected for " + matchedEntityData).toString());
        }
        SymbolicEntityId<?> symbolicIdBefore = symbolicEntityId;
        ((WorkspaceEntityData)clonedEntity).setId(localNode.getId());
        long clonedEntityId = EntityIdKt.copy$default(matchedEntityId.getId(), ((WorkspaceEntityData)clonedEntity).getId(), 0, 2, null);
        thisBuilder.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(clonedEntity, EntityIdKt.getClazz(clonedEntityId));
        MutableStorageIndexes.updateSymbolicIdIndexes$default(thisBuilder.getIndexes$intellij_platform_workspaceModel_storage(), thisBuilder, ((WorkspaceEntityData)clonedEntity).createEntity(thisBuilder), symbolicIdBefore, (WorkspaceEntityData)clonedEntity, null, 16, null);
        thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().updateIndex$intellij_platform_workspaceModel_storage(matchedEntityId.getId(), clonedEntityId, replaceWith.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage());
        EntitySource entitySource = replaceWith.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(matchedEntityId.getId());
        if (entitySource != null) {
            EntitySource entitySource2;
            EntitySource it = entitySource2 = entitySource;
            boolean bl = false;
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(clonedEntityId, it);
        }
        thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(matchedEntityId.getId(), clonedEntityId, replaceWith.getIndexes$intellij_platform_workspaceModel_storage());
        if (dataDiffersByProperties) {
            WorkspaceBuilderChangeLog workspaceBuilderChangeLog = thisBuilder.getChangeLog$intellij_platform_workspaceModel_storage();
            Object object2 = localNode.clone();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            workspaceBuilderChangeLog.addReplaceEvent$intellij_platform_workspaceModel_storage(clonedEntityId, (WorkspaceEntityData<? extends WorkspaceEntity>)clonedEntity, (WorkspaceEntityData<? extends WorkspaceEntity>)object2, thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(localNode.createEntityId())), CollectionsKt.emptyList(), SetsKt.emptySet(), MapsKt.emptyMap());
        }
        if (dataDiffersByEntitySource) {
            thisBuilder.getChangeLog$intellij_platform_workspaceModel_storage().addChangeSourceEvent$intellij_platform_workspaceModel_storage(clonedEntityId, clonedEntity, originalEntitySource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<WorkspaceEntityData<? extends WorkspaceEntity>> removeEntitiesByOneToOneRef(MutableEntityStorageImpl $this$removeEntitiesByOneToOneRef, Function1<? super EntitySource, Boolean> sourceFilter, AbstractEntityStorage replaceWith, Map<ThisEntityId, NotThisEntityId> replaceMap, NotThisEntityId matchedEntityId, ThisEntityId localEntityId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Map<ConnectionId, ChildEntityId> map2 = replaceWith.getRefs$intellij_platform_workspaceModel_storage().getChildrenOneToOneRefsOfParentBy(RefsTableKt.asParent(matchedEntityId.getId()));
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((ConnectionId)it.getKey()).isParentNullable())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map replacingChildrenOneToOneConnections = destination$iv$iv;
        Set result2 = SequencesKt.toMutableSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence($this$removeEntitiesByOneToOneRef.getRefs$intellij_platform_workspaceModel_storage().getChildrenOneToOneRefsOfParentBy(RefsTableKt.asParent(localEntityId.getId()))), (Function1)removeEntitiesByOneToOneRef.result.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends ConnectionId, ? extends ChildEntityId>, WorkspaceEntityData<? extends WorkspaceEntity>>((Map<ConnectionId, ChildEntityId>)replacingChildrenOneToOneConnections, replaceWith, sourceFilter, replaceMap, $this$removeEntitiesByOneToOneRef, localEntityId){
            final /* synthetic */ Map<ConnectionId, ChildEntityId> $replacingChildrenOneToOneConnections;
            final /* synthetic */ AbstractEntityStorage $replaceWith;
            final /* synthetic */ Function1<EntitySource, Boolean> $sourceFilter;
            final /* synthetic */ Map<ThisEntityId, NotThisEntityId> $replaceMap;
            final /* synthetic */ MutableEntityStorageImpl $this_removeEntitiesByOneToOneRef;
            final /* synthetic */ ThisEntityId $localEntityId;
            {
                this.$replacingChildrenOneToOneConnections = $replacingChildrenOneToOneConnections;
                this.$replaceWith = $replaceWith;
                this.$sourceFilter = $sourceFilter;
                this.$replaceMap = $replaceMap;
                this.$this_removeEntitiesByOneToOneRef = $receiver;
                this.$localEntityId = $localEntityId;
                super(1);
            }

            @Nullable
            public final WorkspaceEntityData<? extends WorkspaceEntity> invoke(@NotNull Map.Entry<ConnectionId, ChildEntityId> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                ConnectionId connectionId = entry.getKey();
                ChildEntityId entityId = entry.getValue();
                ChildEntityId childEntityId = this.$replacingChildrenOneToOneConnections.get(connectionId);
                if (childEntityId == null) {
                    return null;
                }
                ChildEntityId suggestedNewChildEntityId = childEntityId;
                WorkspaceEntityData<? extends WorkspaceEntity> suggestedNewChildEntityData = this.$replaceWith.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(suggestedNewChildEntityId.getId());
                if (((Boolean)this.$sourceFilter.invoke((Object)suggestedNewChildEntityData.getEntitySource())).booleanValue()) {
                    if (this.$replaceMap.containsKey(UtilsKt.asThis(entityId.getId()))) {
                        return null;
                    }
                    WorkspaceEntityData<? extends WorkspaceEntity> childEntityData = this.$this_removeEntitiesByOneToOneRef.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(entityId.getId());
                    this.$this_removeEntitiesByOneToOneRef.removeEntityByEntityId$intellij_platform_workspaceModel_storage(entityId.getId(), (Function1<? super Long, Boolean>)((Function1)new Function1<Long, Boolean>(this.$localEntityId, this.$replaceMap){
                        final /* synthetic */ ThisEntityId $localEntityId;
                        final /* synthetic */ Map<ThisEntityId, NotThisEntityId> $replaceMap;
                        {
                            this.$localEntityId = $localEntityId;
                            this.$replaceMap = $replaceMap;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(long it) {
                            return it != this.$localEntityId.getId() && !this.$replaceMap.containsKey(UtilsKt.asThis(it));
                        }
                    }));
                    return childEntityData;
                }
                return null;
            }
        })));
        return result2;
    }

    private final void rbsFailedAndReport(MutableEntityStorageImpl $this$rbsFailedAndReport, String message, Function1<? super EntitySource, Boolean> sourceFilter, EntityStorage left, EntityStorage right) {
        ErrorReportingKt.reportConsistencyIssue(message, new ReplaceBySourceException(message), sourceFilter, left, right, $this$rbsFailedAndReport);
    }

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }
}

