/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;

public final class FloatIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private FloatIterators() {
    }

    public static FloatListIterator singleton(float element) {
        return new SingletonIterator(element);
    }

    public static FloatListIterator wrap(float[] array2, int offset, int length) {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        return new ArrayIterator(array2, offset, length);
    }

    public static FloatListIterator wrap(float[] array2) {
        return new ArrayIterator(array2, 0, array2.length);
    }

    public static int unwrap(FloatIterator i2, float[] array2, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array2.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            array2[offset++] = i2.nextFloat();
        }
        return max - j - 1;
    }

    public static int unwrap(FloatIterator i2, float[] array2) {
        return FloatIterators.unwrap(i2, array2, 0, array2.length);
    }

    public static float[] unwrap(FloatIterator i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        float[] array2 = new float[16];
        int j = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j == array2.length) {
                array2 = FloatArrays.grow(array2, j + 1);
            }
            array2[j++] = i2.nextFloat();
        }
        return FloatArrays.trim(array2, j);
    }

    public static float[] unwrap(FloatIterator i2) {
        return FloatIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static long unwrap(FloatIterator i2, float[][] array2, long offset, long max) {
        if (max < 0L) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0L || offset + max > BigArrays.length(array2)) {
            throw new IllegalArgumentException();
        }
        long j = max;
        while (j-- != 0L && i2.hasNext()) {
            BigArrays.set(array2, offset++, i2.nextFloat());
        }
        return max - j - 1L;
    }

    public static long unwrap(FloatIterator i2, float[][] array2) {
        return FloatIterators.unwrap(i2, array2, 0L, BigArrays.length(array2));
    }

    public static int unwrap(FloatIterator i2, FloatCollection c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            c.add(i2.nextFloat());
        }
        return max - j - 1;
    }

    public static float[][] unwrapBig(FloatIterator i2, long max) {
        if (max < 0L) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        float[][] array2 = FloatBigArrays.newBigArray(16L);
        long j = 0L;
        while (max-- != 0L && i2.hasNext()) {
            if (j == BigArrays.length(array2)) {
                array2 = BigArrays.grow(array2, j + 1L);
            }
            BigArrays.set(array2, j++, i2.nextFloat());
        }
        return BigArrays.trim(array2, j);
    }

    public static float[][] unwrapBig(FloatIterator i2) {
        return FloatIterators.unwrapBig(i2, Long.MAX_VALUE);
    }

    public static long unwrap(FloatIterator i2, FloatCollection c) {
        long n = 0L;
        while (i2.hasNext()) {
            c.add(i2.nextFloat());
            ++n;
        }
        return n;
    }

    public static int pour(FloatIterator i2, FloatCollection s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            s.add(i2.nextFloat());
        }
        return max - j - 1;
    }

    public static int pour(FloatIterator i2, FloatCollection s) {
        return FloatIterators.pour(i2, s, Integer.MAX_VALUE);
    }

    public static FloatList pour(FloatIterator i2, int max) {
        FloatArrayList l = new FloatArrayList();
        FloatIterators.pour(i2, l, max);
        l.trim();
        return l;
    }

    public static FloatList pour(FloatIterator i2) {
        return FloatIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static FloatIterator asFloatIterator(Iterator i2) {
        if (i2 instanceof FloatIterator) {
            return (FloatIterator)i2;
        }
        return new IteratorWrapper(i2);
    }

    public static FloatIterator narrow(PrimitiveIterator.OfDouble i2) {
        return new CheckedPrimitiveIteratorWrapper(i2);
    }

    public static FloatIterator uncheckedNarrow(PrimitiveIterator.OfDouble i2) {
        return new PrimitiveIteratorWrapper(i2);
    }

    public static DoubleIterator widen(FloatIterator i2) {
        return DoubleIterators.wrap(i2);
    }

    public static FloatListIterator asFloatIterator(ListIterator i2) {
        if (i2 instanceof FloatListIterator) {
            return (FloatListIterator)i2;
        }
        return new ListIteratorWrapper(i2);
    }

    public static boolean any(FloatIterator iterator2, FloatPredicate predicate) {
        return FloatIterators.indexOf(iterator2, predicate) != -1;
    }

    public static boolean any(FloatIterator iterator2, DoublePredicate predicate) {
        return FloatIterators.any(iterator2, predicate instanceof FloatPredicate ? (FloatPredicate)predicate : predicate::test);
    }

    public static boolean all(FloatIterator iterator2, FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        do {
            if (iterator2.hasNext()) continue;
            return true;
        } while (predicate.test(iterator2.nextFloat()));
        return false;
    }

    public static boolean all(FloatIterator iterator2, DoublePredicate predicate) {
        return FloatIterators.all(iterator2, predicate instanceof FloatPredicate ? (FloatPredicate)predicate : predicate::test);
    }

    public static int indexOf(FloatIterator iterator2, FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        int i2 = 0;
        while (iterator2.hasNext()) {
            if (predicate.test(iterator2.nextFloat())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static int indexOf(FloatIterator iterator2, DoublePredicate predicate) {
        return FloatIterators.indexOf(iterator2, predicate instanceof FloatPredicate ? (FloatPredicate)predicate : predicate::test);
    }

    public static FloatIterator concat(FloatIterator ... a) {
        return FloatIterators.concat(a, 0, a.length);
    }

    public static FloatIterator concat(FloatIterator[] a, int offset, int length) {
        return new IteratorConcatenator(a, offset, length);
    }

    public static FloatIterator unmodifiable(FloatIterator i2) {
        return new UnmodifiableIterator(i2);
    }

    public static FloatBidirectionalIterator unmodifiable(FloatBidirectionalIterator i2) {
        return new UnmodifiableBidirectionalIterator(i2);
    }

    public static FloatListIterator unmodifiable(FloatListIterator i2) {
        return new UnmodifiableListIterator(i2);
    }

    public static FloatIterator wrap(ByteIterator iterator2) {
        return new ByteIteratorWrapper(iterator2);
    }

    public static FloatIterator wrap(ShortIterator iterator2) {
        return new ShortIteratorWrapper(iterator2);
    }

    public static FloatIterator wrap(CharIterator iterator2) {
        return new CharIteratorWrapper(iterator2);
    }

    private static class SingletonIterator
    implements FloatListIterator {
        private final float element;
        private byte curr;

        public SingletonIterator(float element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            Objects.requireNonNull(action2);
            if (this.curr == 0) {
                action2.accept(this.element);
                this.curr = 1;
            }
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }

        @Override
        public int back(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0 || this.curr < 1) {
                return 0;
            }
            this.curr = 1;
            return 1;
        }

        @Override
        public int skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0 || this.curr > 0) {
                return 0;
            }
            this.curr = 0;
            return 1;
        }
    }

    private static class ArrayIterator
    implements FloatListIterator {
        private final float[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(float[] array2, int offset, int length) {
            this.array = array2;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            Objects.requireNonNull(action2);
            while (this.curr < this.length) {
                action2.accept(this.array[this.offset + this.curr]);
                ++this.curr;
            }
        }

        @Override
        public int skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        @Override
        public int back(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class IteratorWrapper
    implements FloatIterator {
        final Iterator<Float> i;

        public IteratorWrapper(Iterator<Float> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public float nextFloat() {
            return this.i.next().floatValue();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            this.i.forEachRemaining(action2);
        }
    }

    private static class CheckedPrimitiveIteratorWrapper
    extends PrimitiveIteratorWrapper {
        public CheckedPrimitiveIteratorWrapper(PrimitiveIterator.OfDouble i2) {
            super(i2);
        }

        @Override
        public float nextFloat() {
            return SafeMath.safeDoubleToFloat(this.i.nextDouble());
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining((double value) -> action2.accept(SafeMath.safeDoubleToFloat(value)));
        }
    }

    private static class PrimitiveIteratorWrapper
    implements FloatIterator {
        final PrimitiveIterator.OfDouble i;

        public PrimitiveIteratorWrapper(PrimitiveIterator.OfDouble i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public float nextFloat() {
            return (float)this.i.nextDouble();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }
    }

    private static class ListIteratorWrapper
    implements FloatListIterator {
        final ListIterator<Float> i;

        public ListIteratorWrapper(ListIterator<Float> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(float k) {
            this.i.set(Float.valueOf(k));
        }

        @Override
        public void add(float k) {
            this.i.add(Float.valueOf(k));
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public float nextFloat() {
            return this.i.next().floatValue();
        }

        @Override
        public float previousFloat() {
            return this.i.previous().floatValue();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            this.i.forEachRemaining(action2);
        }
    }

    private static class IteratorConcatenator
    implements FloatIterator {
        final FloatIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(FloatIterator[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            float next2 = this.a[this.lastOffset].nextFloat();
            this.advance();
            return next2;
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            while (this.length > 0) {
                this.lastOffset = this.offset;
                this.a[this.lastOffset].forEachRemaining(action2);
                this.advance();
            }
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            while (this.length > 0) {
                this.lastOffset = this.offset;
                this.a[this.lastOffset].forEachRemaining(action2);
                this.advance();
            }
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    public static class UnmodifiableIterator
    implements FloatIterator {
        protected final FloatIterator i;

        public UnmodifiableIterator(FloatIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            this.i.forEachRemaining(action2);
        }
    }

    public static class UnmodifiableBidirectionalIterator
    implements FloatBidirectionalIterator {
        protected final FloatBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(FloatBidirectionalIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            this.i.forEachRemaining(action2);
        }
    }

    public static class UnmodifiableListIterator
    implements FloatListIterator {
        protected final FloatListIterator i;

        public UnmodifiableListIterator(FloatListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            this.i.forEachRemaining(action2);
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
            this.i.forEachRemaining(action2);
        }
    }

    private static final class ByteIteratorWrapper
    implements FloatIterator {
        final ByteIterator iterator;

        public ByteIteratorWrapper(ByteIterator iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(this.iterator.nextByte());
        }

        @Override
        public float nextFloat() {
            return this.iterator.nextByte();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            Objects.requireNonNull(action2);
            this.iterator.forEachRemaining(action2::accept);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n) {
            return this.iterator.skip(n);
        }
    }

    private static final class ShortIteratorWrapper
    implements FloatIterator {
        final ShortIterator iterator;

        public ShortIteratorWrapper(ShortIterator iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(this.iterator.nextShort());
        }

        @Override
        public float nextFloat() {
            return this.iterator.nextShort();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            Objects.requireNonNull(action2);
            this.iterator.forEachRemaining(action2::accept);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n) {
            return this.iterator.skip(n);
        }
    }

    private static final class CharIteratorWrapper
    implements FloatIterator {
        final CharIterator iterator;

        public CharIteratorWrapper(CharIterator iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(this.iterator.nextChar());
        }

        @Override
        public float nextFloat() {
            return this.iterator.nextChar();
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            Objects.requireNonNull(action2);
            this.iterator.forEachRemaining(action2::accept);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n) {
            return this.iterator.skip(n);
        }
    }

    public static class EmptyIterator
    implements FloatListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public float previousFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n) {
            return 0;
        }

        @Override
        public int back(int n) {
            return 0;
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> action2) {
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedListIterator
    extends AbstractIndexBasedIterator
    implements FloatListIterator {
        protected AbstractIndexBasedListIterator(int minPos, int initialPos) {
            super(minPos, initialPos);
        }

        protected abstract void add(int var1, float var2);

        protected abstract void set(int var1, float var2);

        @Override
        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void add(float k) {
            this.add(this.pos++, k);
            this.lastReturned = -1;
        }

        @Override
        public void set(float k) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, k);
        }

        @Override
        public int back(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            int remaining = this.pos - this.minPos;
            if (n < remaining) {
                this.pos -= n;
            } else {
                n = remaining;
                this.pos = this.minPos;
            }
            this.lastReturned = this.pos;
            return n;
        }
    }

    public static abstract class AbstractIndexBasedIterator
    extends AbstractFloatIterator {
        protected final int minPos;
        protected int pos;
        protected int lastReturned;

        protected AbstractIndexBasedIterator(int minPos, int initialPos) {
            this.minPos = minPos;
            this.pos = initialPos;
        }

        protected abstract float get(int var1);

        protected abstract void remove(int var1);

        protected abstract int getMaxPos();

        @Override
        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1;
        }

        @Override
        public void forEachRemaining(FloatConsumer action2) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                action2.accept(this.get(this.lastReturned));
            }
        }

        @Override
        public int skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            int max = this.getMaxPos();
            int remaining = max - this.pos;
            if (n < remaining) {
                this.pos += n;
            } else {
                n = remaining;
                this.pos = max;
            }
            this.lastReturned = this.pos - 1;
            return n;
        }
    }
}

