/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0013\u001a\u00020\u000e*\u00020\u0014\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFileClassInfo", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "internalNameWithoutInnerClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getInternalNameWithoutInnerClasses", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "isJvmMultifileClassFile", "", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "javaFileFacadeFqName", "getJavaFileFacadeFqName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/name/FqName;", "isInsideJvmMultifileClassFile", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "frontend.common.jvm"})
public final class JvmFileClassUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull KtFile $this$fileClassInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$fileClassInfo, (String)"<this>");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)$this$fileClassInfo), () -> JvmFileClassUtilKt._get_fileClassInfo_$lambda$0($this$fileClassInfo));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(this) {\n \u2026ve(this), this)\n        }");
        return (JvmFileClassInfo)object;
    }

    @NotNull
    public static final FqName getJavaFileFacadeFqName(@NotNull KtFile $this$javaFileFacadeFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$javaFileFacadeFqName, (String)"<this>");
        FqName fqName2 = $this$javaFileFacadeFqName.isCompiled() ? $this$javaFileFacadeFqName.getPackageFqName().child(Name.identifier($this$javaFileFacadeFqName.getVirtualFile().getNameWithoutExtension())) : JvmFileClassUtilKt.getFileClassInfo($this$javaFileFacadeFqName).getFacadeClassFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"if (isCompiled) packageF\u2026assInfo.facadeClassFqName");
        FqName facadeFqName = fqName2;
        if (!Name.isValidIdentifier(facadeFqName.shortName().getIdentifier())) {
            LOG.error("An invalid fqName `" + facadeFqName + "` with short name `" + facadeFqName.shortName() + "` is created for file `" + $this$javaFileFacadeFqName.getName() + "` (isCompiled = " + $this$javaFileFacadeFqName.isCompiled() + ')');
        }
        return facadeFqName;
    }

    public static final boolean isJvmMultifileClassFile(@NotNull KtFile $this$isJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJvmMultifileClassFile, (String)"<this>");
        return JvmFileClassUtil.findAnnotationEntryOnFileNoResolve($this$isJvmMultifileClassFile, JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
    }

    public static final boolean isInsideJvmMultifileClassFile(@NotNull KtDeclaration $this$isInsideJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideJvmMultifileClassFile, (String)"<this>");
        KtFile ktFile = $this$isInsideJvmMultifileClassFile.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingKtFile");
        return JvmFileClassUtilKt.isJvmMultifileClassFile(ktFile);
    }

    @NotNull
    public static final String getInternalNameWithoutInnerClasses(@NotNull FqName $this$internalNameWithoutInnerClasses) {
        Intrinsics.checkNotNullParameter((Object)$this$internalNameWithoutInnerClasses, (String)"<this>");
        String string2 = JvmClassName.byFqNameWithoutInnerClasses($this$internalNameWithoutInnerClasses).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byFqNameWithoutInnerClasses(this).internalName");
        return string2;
    }

    private static final CachedValueProvider.Result _get_fileClassInfo_$lambda$0(KtFile $this_fileClassInfo) {
        Intrinsics.checkNotNullParameter((Object)$this_fileClassInfo, (String)"$this_fileClassInfo");
        Object[] objectArray = new Object[]{$this_fileClassInfo};
        return new CachedValueProvider.Result((Object)JvmFileClassUtil.getFileClassInfoNoResolve($this_fileClassInfo), objectArray);
    }

    static {
        Logger logger = Logger.getInstance((String)"JvmFileClassUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"JvmFileClassUtil\")");
        LOG = logger;
    }
}

