/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0011J\u0010\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0014J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020/02H\u0086\b\u00f8\u0001\u0000J\u001a\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010;\u001a\u0002042\u0006\u00100\u001a\u00020\u00112\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\u00112\b\u00107\u001a\u0004\u0018\u00010\u0002H&J\u000e\u0010>\u001a\u00020%2\u0006\u0010=\u001a\u00020\u0011J\u001a\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020A2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010D\u001a\u00020/2\u0006\u0010C\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u0002042\u0006\u0010I\u001a\u00020J2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u0002042\u0006\u0010L\u001a\u00020M2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Q\u001a\u0002042\u0006\u0010R\u001a\u00020S2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010T\u001a\u00020%2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020S2\u000e\b\u0002\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00020YH\u0002J\u001a\u0010T\u001a\u0002042\u0006\u0010U\u001a\u00020V2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Z\u001a\u0002042\u0006\u0010)\u001a\u00020*2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010[\u001a\u0002042\u0006\u0010\\\u001a\u00020]2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010^\u001a\u0002042\u0006\u0010_\u001a\u00020`2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010e\u001a\u00020%2\u0006\u0010=\u001a\u00020\u0011J\u001a\u0010f\u001a\u0002042\u0006\u0010g\u001a\u00020h2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010i\u001a\u00020-*\u00020/H$J\f\u0010j\u001a\u00020-*\u00020/H$R\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00118DX\u0084\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006k"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClasses$annotations", "()V", "getClasses", "()Ljava/util/List;", "containingClass", "getContainingClass$annotations", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "forceResolveStatusOfCorrespondingClass", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "forceResolveStatusesOfClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "forceResolveStatusesOfSupertypes", "resolveClassForSuperType", "", "storeClass", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "computeResult", "Lkotlin/Function0;", "transformAnonymousObject", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformClass", "transformClassContent", "firClass", "transformClassStatus", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformDeclaration", "declaration", "transformDeclarationContent", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "containingProperty", "overriddenStatuses", "", "transformRegularClass", "transformSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "transformValueClassRepresentation", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "needResolveMembers", "needResolveNestedClassifiers", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,489:1\n222#1,2:518\n224#1,2:522\n153#2,4:490\n145#2,4:494\n145#2,2:498\n147#2,2:502\n145#2,4:504\n145#2,4:508\n145#2,2:516\n147#2,2:524\n145#2,4:527\n145#2,4:531\n145#2,4:535\n145#2,2:539\n147#2,2:559\n145#2,4:561\n145#2,4:565\n1855#3,2:500\n1855#3,2:512\n1855#3,2:514\n1855#3,2:520\n1549#3:541\n1620#3,3:542\n1603#3,9:545\n1855#3:554\n1856#3:556\n1612#3:557\n40#4:526\n1#5:555\n1#5:558\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n*L\n308#1:518,2\n308#1:522,2\n204#1:490,4\n231#1:494,4\n250#1:498,2\n250#1:502,2\n259#1:504,4\n271#1:508,4\n307#1:516,2\n307#1:524,2\n388#1:527,4\n406#1:531,4\n414#1:535,4\n423#1:539,2\n423#1:559,2\n454#1:561,4\n466#1:565,4\n251#1:500,2\n288#1:512,2\n295#1:514,2\n309#1:520,2\n426#1:541\n426#1:542,3\n428#1:545,9\n428#1:554\n428#1:556\n428#1:557\n315#1:526\n428#1:555\n*E\n"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @Nullable
    private final FirScope scopeForLocalClass;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, (String)"designationMapForLocalClasses");
        super(FirResolvePhase.STATUS);
        this.session = session2;
        this.scopeSession = scopeSession;
        this.statusComputationSession = statusComputationSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.scopeForLocalClass = scopeForLocalClass;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.session, this.scopeSession);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    public final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    @NotNull
    public final List<FirClass> getClasses() {
        return this.classes;
    }

    @PrivateForInline
    public static /* synthetic */ void getClasses$annotations() {
    }

    @NotNull
    public final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    protected final FirClass getContainingClass() {
        return (FirClass)CollectionsKt.lastOrNull(this.classes);
    }

    protected static /* synthetic */ void getContainingClass$annotations() {
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file2, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw null;
        }
        return file2;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)declarationStatus, (String)"declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data2;
        return firResolvedDeclarationStatus != null ? (FirDeclarationStatus)firResolvedDeclarationStatus : declarationStatus;
    }

    @NotNull
    public final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(computeResult, (String)"computeResult");
        boolean $i$f$storeClass = false;
        ((Collection)this.getClasses()).add(klass);
        FirDeclaration result2 = (FirDeclaration)computeResult.invoke();
        this.getClasses().remove(CollectionsKt.getLastIndex(this.getClasses()));
        return result2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl = false;
            if (declaration instanceof FirCallableDeclaration) {
                if (declaration instanceof FirFunction) {
                    for (FirValueParameter valueParameter2 : ((FirFunction)declaration).getValueParameters()) {
                        this.transformValueParameter(valueParameter2, data2);
                    }
                }
                firDeclaration = declaration;
            } else {
                firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration, data2);
            }
            return firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(declaration, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = typeAlias.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameter it = (FirTypeParameter)element$iv;
                boolean bl2 = false;
                this.transformDeclaration((FirDeclaration)it, data2);
            }
            typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            return (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(regularClass, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw null;
        }
        return firStatement;
    }

    @NotNull
    public abstract FirStatement transformClassContent(@NotNull FirClass var1, @Nullable FirResolvedDeclarationStatus var2);

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(anonymousObject, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(anonymousObject, throwable$iv);
            throw null;
        }
        return firStatement;
    }

    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            list2 = ((FirRegularClass)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list2 = ((FirAnonymousObject)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list2 = ((FirFile)declaration).getDeclarations();
        } else {
            throw new IllegalStateException(("Not supported declaration " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getSimpleName()).toString());
        }
        List<FirDeclaration> declarations2 = list2;
        if (this.needResolveMembers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        if (this.needResolveNestedClassifiers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        return declaration;
    }

    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            AbstractFirStatusResolveTransformer this_$iv = this;
            boolean $i$f$storeClass = false;
            ((Collection)this_$iv.getClasses()).add(klass);
            boolean bl2 = false;
            Iterable $this$forEach$iv = klass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
            FirDeclaration result$iv = this.transformDeclarationContent(klass, data2);
            this_$iv.getClasses().remove(CollectionsKt.getLastIndex(this_$iv.getClasses()));
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(klass, throwable$iv);
            throw null;
        }
    }

    public final void transformValueClassRepresentation(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        if (firClass instanceof FirRegularClass) {
            FirMemberDeclaration $this$isInline$iv = firClass;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                FirValueClassRepresentationKt.setValueClassRepresentation((FirRegularClass)firClass, ValueClassesUtilsKt.computeValueClassRepresentation((FirRegularClass)firClass, this.session));
            }
        }
    }

    public final void transformClassStatus(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        firClass.transformStatus(this, this.statusResolver.resolveStatus(firClass, this.getContainingClass(), false));
    }

    public final void forceResolveStatusesOfSupertypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            this.forceResolveStatusOfCorrespondingClass(superTypeRef);
        }
    }

    private final void forceResolveStatusOfCorrespondingClass(FirTypeRef typeRef) {
        FirClassifierSymbol<?> superClassSymbol;
        FirClassifierSymbol<?> firClassifierSymbol = superClassSymbol = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.session);
        if (firClassifierSymbol != null) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)firClassifierSymbol, FirResolvePhase.STATUS.getPrevious());
        }
        FirClassifierSymbol<?> firClassifierSymbol2 = superClassSymbol;
        if (firClassifierSymbol2 instanceof FirRegularClassSymbol) {
            this.forceResolveStatusesOfClass((FirRegularClass)((FirRegularClassSymbol)superClassSymbol).getFir());
        } else if (firClassifierSymbol2 instanceof FirTypeAliasSymbol) {
            this.forceResolveStatusOfCorrespondingClass(((FirTypeAlias)((FirTypeAliasSymbol)superClassSymbol).getFir()).getExpandedTypeRef());
        } else if ((firClassifierSymbol2 instanceof FirTypeParameterSymbol ? true : firClassifierSymbol2 instanceof FirAnonymousObjectSymbol) ? true : firClassifierSymbol2 == null) {
            // empty if block
        }
    }

    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        if (regularClass.getOrigin() instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)regularClass.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE)) {
            StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
            if (!statusComputationStatus.getRequiresComputation()) {
                return;
            }
            this.statusComputationSession.startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        if (!Intrinsics.areEqual((Object)regularClass.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (regularClass.getStatus() instanceof FirResolvedDeclarationStatus && statusComputationStatus == StatusComputationSession.StatusComputationStatus.Computed) {
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        if (!this.resolveClassForSuperType(regularClass)) {
            return;
        }
        this.statusComputationSession.endComputing(regularClass);
    }

    protected boolean resolveClassForSuperType(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        DesignationState designationState = DesignationState.Companion.create(regularClass.getSymbol(), this.designationMapForLocalClasses, false);
        if (designationState == null) {
            return false;
        }
        DesignationState designation2 = designationState;
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(this.session, this.scopeSession, designation2, this.statusComputationSession, this.designationMapForLocalClasses, this.scopeForLocalClass);
        FirTransformerUtilKt.transformSingle((FirElement)designation2.getFirstDeclaration(), transformer2, null);
        return true;
    }

    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty, List<? extends FirResolvedDeclarationStatus> overriddenStatuses) {
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false, overriddenStatuses));
            propertyAccessor.transformValueParameters(this, null);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(propertyAccessor, throwable$iv);
            throw null;
        }
    }

    static /* synthetic */ void transformPropertyAccessor$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirPropertyAccessor firPropertyAccessor, FirProperty firProperty, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformPropertyAccessor");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        abstractFirStatusResolveTransformer.transformPropertyAccessor(firPropertyAccessor, firProperty, list2);
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            constructor2.transformStatus(this, this.statusResolver.resolveStatus(constructor2, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)constructor2, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor2, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirResolvedDeclarationStatus resolvedStatus = this.statusResolver.resolveStatus(simpleFunction, this.getContainingClass(), false);
            simpleFunction.transformStatus(this, resolvedStatus);
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirCallableDeclaration it;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List<FirProperty> overridden = this.statusResolver.getOverriddenProperties(property, this.getContainingClass());
            Iterable $this$map$iv = overridden;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirProperty firProperty = (FirProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirDeclarationStatus firDeclarationStatus = it2.getStatus();
                Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
            }
            List overriddenProperties = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = overridden;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirResolvedDeclarationStatus firResolvedDeclarationStatus;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FirProperty it3 = (FirProperty)element$iv$iv;
                boolean bl4 = false;
                if (it3.getSetter() == null) {
                    firResolvedDeclarationStatus = null;
                } else {
                    FirPropertyAccessor setter2;
                    FirDeclarationStatus firDeclarationStatus = setter2.getStatus();
                    Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                    firResolvedDeclarationStatus = (FirResolvedDeclarationStatus)firDeclarationStatus;
                }
                if (firResolvedDeclarationStatus == null) continue;
                FirResolvedDeclarationStatus it$iv$iv = firResolvedDeclarationStatus;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List overriddenSetters = (List)destination$iv$iv2;
            property.transformStatus(this, this.statusResolver.resolveStatus(property, this.getContainingClass(), false, overriddenProperties));
            FirPropertyAccessor firPropertyAccessor = property.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl6 = false;
                AbstractFirStatusResolveTransformer.transformPropertyAccessor$default(this, (FirPropertyAccessor)it, property, null, 4, null);
            }
            FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl7 = false;
                this.transformPropertyAccessor((FirPropertyAccessor)it, property, overriddenSetters);
            }
            FirBackingField firBackingField = property.getBackingField();
            if (firBackingField != null) {
                it = firBackingField;
                boolean bl8 = false;
                ((FirBackingField)it).transformStatus(this, this.statusResolver.resolveStatus(it, this.getContainingClass(), property, false));
            }
            return property;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            field2.transformStatus(this, this.statusResolver.resolveStatus(field2, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)field2, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirField");
            return (FirField)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field2, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable FirResolvedDeclarationStatus data2) {
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        FirPropertyAccessor it = firPropertyAccessor = propertyAccessor;
        boolean bl = false;
        this.transformProperty((FirProperty)it.getPropertySymbol().getFir(), data2);
        return firPropertyAccessor;
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)enumEntry, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
            return (FirEnumEntry)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)valueParameter2, data2);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration);
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeParameter2, data2);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameter");
        return (FirTypeParameter)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block;
    }
}

