/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.SarifReporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.ActionsXmlDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppCompatCustomViewDetector;
import com.android.tools.lint.checks.AppCompatResourceDetector;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.checks.AssertDetector;
import com.android.tools.lint.checks.AutofillDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.checks.CanvasSizeDetector;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.checks.ChromeOsDetector;
import com.android.tools.lint.checks.ChromeOsSourceDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.DataBindingDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.EllipsizeMaxLinesDetector;
import com.android.tools.lint.checks.ExportedFlagDetector;
import com.android.tools.lint.checks.FontDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IgnoreWithoutReasonDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.InteroperabilityDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.KeyboardNavigationDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.LintDetectorDetector;
import com.android.tools.lint.checks.LocaleDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.MissingPrefixDetector;
import com.android.tools.lint.checks.MotionLayoutDetector;
import com.android.tools.lint.checks.MotionSceneDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ReadParcelableDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.SamDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdkIntDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.StringEscapeDetector;
import com.android.tools.lint.checks.SyntheticAccessorDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TileProviderDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.ToastDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnsafeBroadcastReceiverDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.VectorPathDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WakelockDetector;
import com.android.tools.lint.checks.WatchFaceEditorDetector;
import com.android.tools.lint.checks.WatchFaceForAndroidXDetector;
import com.android.tools.lint.checks.WearStandaloneAppDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.utils.SdkUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0004J&\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H&J\u001e\u0010'\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0#H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/Reporter;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "isDisplayEmpty", "", "()Z", "setDisplayEmpty", "(Z)V", "isWriteToConsole", "getOutput", "()Ljava/io/File;", "stripPrefix", "", "title", "urlMap", "", "getUrlMap", "()Ljava/util/Map;", "setUrlMap", "(Ljava/util/Map;)V", "getUrl", "file", "setStripPrefix", "", "prefix", "stripPath", "path", "write", "stats", "Lcom/android/tools/lint/LintStats;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "writeProjectList", "projects", "Lcom/android/tools/lint/MultiProjectHtmlReporter$ProjectEntry;", "Companion", "lint-cli"})
public abstract class Reporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final LintCliClient client;
    @Nullable
    private final File output;
    @JvmField
    @NotNull
    public String title;
    private boolean isDisplayEmpty;
    @Nullable
    private Map<String, String> urlMap;
    @Nullable
    private String stripPrefix;
    @NotNull
    public static final String STDOUT = "stdout";
    @NotNull
    public static final String STDERR = "stderr";
    @Nullable
    private static Set<Issue> studioFixes;

    protected Reporter(@NotNull LintCliClient client, @Nullable File output) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        this.client = client;
        this.output = output;
        this.title = "Lint Report";
        this.isDisplayEmpty = true;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public final boolean isWriteToConsole() {
        return this.output == null;
    }

    public final boolean isDisplayEmpty() {
        return this.isDisplayEmpty;
    }

    public final void setDisplayEmpty(boolean bl) {
        this.isDisplayEmpty = bl;
    }

    @Nullable
    public final Map<String, String> getUrlMap() {
        return this.urlMap;
    }

    public final void setUrlMap(@Nullable Map<String, String> map) {
        this.urlMap = map;
    }

    public abstract void write(@NotNull LintStats var1, @NotNull List<Incident> var2, @NotNull IssueRegistry var3) throws IOException;

    public void writeProjectList(@NotNull LintStats stats, @NotNull List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final String getUrl(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, String> urlMap = this.urlMap;
        if (urlMap != null) {
            String path = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String pathUrl = Companion.encodeUrl(path);
            for (Map.Entry<String, String> entry : urlMap.entrySet()) {
                String prefix = entry.getKey();
                String value = entry.getValue();
                String prefixUrl = Companion.encodeUrl(prefix);
                if (!StringsKt.startsWith$default((String)pathUrl, (String)prefixUrl, (boolean)false, (int)2, null)) continue;
                String string2 = pathUrl.substring(prefixUrl.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String relative = string2;
                return value + relative;
            }
        }
        if (file.isAbsolute()) {
            File file2 = this.output;
            String relativePath = this.client.getRelativePath(file2 != null ? file2.getParentFile() : null, file);
            if (relativePath != null) {
                relativePath = StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                return Companion.encodeUrl(relativePath);
            }
        }
        try {
            string = SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    protected final String stripPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String stripPrefix = this.stripPrefix;
        if (stripPrefix != null && StringsKt.startsWith$default((String)path, (String)stripPrefix, (boolean)false, (int)2, null) && path.length() > stripPrefix.length()) {
            int index = stripPrefix.length();
            if (path.charAt(index) == File.separatorChar) {
                ++index;
            }
            String string = path.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return string;
        }
        return path;
    }

    public final void setStripPrefix(@Nullable String prefix) {
        this.stripPrefix = prefix;
    }

    @JvmStatic
    @NotNull
    public static final Reporter createHtmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull LintCliFlags flags) throws IOException {
        return Companion.createHtmlReporter(client, output, flags);
    }

    @JvmStatic
    @NotNull
    public static final XmlReporter createXmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType reportType) throws IOException {
        return Companion.createXmlReporter(client, output, reportType);
    }

    @JvmStatic
    @NotNull
    public static final Reporter createSarifReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        return Companion.createSarifReporter(client, output);
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrl(@NotNull String url) {
        return Companion.encodeUrl(url);
    }

    @JvmStatic
    public static final boolean hasAutoFix(@Nullable Issue issue) {
        return Companion.hasAutoFix(issue);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/Reporter$Companion;", "", "()V", "STDERR", "", "STDOUT", "studioFixes", "", "Lcom/android/tools/lint/detector/api/Issue;", "createHtmlReporter", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "createSarifReporter", "createTextReporter", "Lcom/android/tools/lint/TextReporter;", "file", "writer", "Ljava/io/Writer;", "close", "", "createXmlReporter", "Lcom/android/tools/lint/XmlReporter;", "reportType", "Lcom/android/tools/lint/XmlFileType;", "encodeUrl", "url", "hasAutoFix", "issue", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Reporter createHtmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull LintCliFlags flags) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
            return new HtmlReporter(client, output, flags);
        }

        @NotNull
        public final TextReporter createTextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @Nullable File file, @NotNull Writer writer, boolean close) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return new TextReporter(client, flags, file, writer, close);
        }

        @JvmStatic
        @NotNull
        public final XmlReporter createXmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType reportType) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
            return new XmlReporter(client, output, reportType);
        }

        public static /* synthetic */ XmlReporter createXmlReporter$default(Companion companion, LintCliClient lintCliClient, File file, XmlFileType xmlFileType, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                xmlFileType = XmlFileType.REPORT;
            }
            return companion.createXmlReporter(lintCliClient, file, xmlFileType);
        }

        @JvmStatic
        @NotNull
        public final Reporter createSarifReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new SarifReporter(client, output);
        }

        @JvmStatic
        @NotNull
        public final String encodeUrl(@NotNull String url) {
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                String encoded = StringsKt.replace$default((String)url, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                String string2 = URLEncoder.encode(encoded, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(encoded, SdkConstants.UTF_8)");
                string = StringsKt.replace$default((String)string2, (String)"%2F", (String)"/", (boolean)false, (int)4, null);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Invalid string " + e.getLocalizedMessage());
                string = url;
            }
            return string;
        }

        @JvmStatic
        public final boolean hasAutoFix(@Nullable Issue issue) {
            if (studioFixes == null) {
                Object[] objectArray = new Issue[147];
                Intrinsics.checkNotNullExpressionValue((Object)AccessibilityDetector.ISSUE, (String)"ISSUE");
                objectArray[1] = ActionsXmlDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)AlwaysShowActionDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)AndroidAutoDetector.INVALID_USES_TAG_ISSUE, (String)"INVALID_USES_TAG_ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)AndroidTvDetector.MISSING_BANNER, (String)"MISSING_BANNER");
                Intrinsics.checkNotNullExpressionValue((Object)AndroidTvDetector.MISSING_LEANBACK_SUPPORT, (String)"MISSING_LEANBACK_SUPPORT");
                Intrinsics.checkNotNullExpressionValue((Object)AndroidTvDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, (String)"PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE");
                Intrinsics.checkNotNullExpressionValue((Object)AndroidTvDetector.UNSUPPORTED_TV_HARDWARE, (String)"UNSUPPORTED_TV_HARDWARE");
                objectArray[8] = AnnotationDetector.FLAG_STYLE;
                objectArray[9] = AnnotationDetector.SWITCH_TYPE_DEF;
                objectArray[10] = ApiDetector.INLINED;
                objectArray[11] = ApiDetector.OBSOLETE_SDK;
                objectArray[12] = ApiDetector.UNSUPPORTED;
                objectArray[13] = ApiDetector.UNUSED;
                Intrinsics.checkNotNullExpressionValue((Object)AppCompatCallDetector.ISSUE, (String)"ISSUE");
                objectArray[15] = AppCompatCustomViewDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)AppCompatResourceDetector.ISSUE, (String)"ISSUE");
                objectArray[17] = AppLinksValidDetector.INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES;
                objectArray[18] = AppLinksValidDetector.VALIDATION;
                objectArray[19] = AssertDetector.EXPENSIVE;
                Intrinsics.checkNotNullExpressionValue((Object)AutofillDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)ButtonDetector.STYLE, (String)"STYLE");
                objectArray[22] = ByteOrderMarkDetector.BOM;
                objectArray[23] = CallSuperDetector.ISSUE;
                objectArray[24] = CanvasSizeDetector.ISSUE;
                objectArray[25] = CheckResultDetector.CHECK_PERMISSION;
                objectArray[26] = CheckResultDetector.CHECK_RESULT;
                Intrinsics.checkNotNullExpressionValue((Object)ChromeOsDetector.NON_RESIZEABLE_ACTIVITY, (String)"NON_RESIZEABLE_ACTIVITY");
                Intrinsics.checkNotNullExpressionValue((Object)ChromeOsDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, (String)"PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE");
                Intrinsics.checkNotNullExpressionValue((Object)ChromeOsDetector.SETTING_ORIENTATION_ON_ACTIVITY, (String)"SETTING_ORIENTATION_ON_ACTIVITY");
                Intrinsics.checkNotNullExpressionValue((Object)ChromeOsDetector.UNSUPPORTED_CHROME_OS_HARDWARE, (String)"UNSUPPORTED_CHROME_OS_HARDWARE");
                objectArray[31] = ChromeOsSourceDetector.CHROMEOS_ON_CONFIGURATION_CHANGED;
                objectArray[32] = ChromeOsSourceDetector.UNSUPPORTED_CAMERA_FEATURE;
                objectArray[33] = ChromeOsSourceDetector.UNSUPPORTED_LOCKED_ORIENTATION;
                objectArray[34] = CleanupDetector.APPLY_SHARED_PREF;
                objectArray[35] = CleanupDetector.SHARED_PREF;
                Intrinsics.checkNotNullExpressionValue((Object)CommentDetector.STOP_SHIP, (String)"STOP_SHIP");
                objectArray[37] = DataBindingDetector.ESCAPE_XML;
                Intrinsics.checkNotNullExpressionValue((Object)DuplicateResourceDetector.TYPE_MISMATCH, (String)"TYPE_MISMATCH");
                Intrinsics.checkNotNullExpressionValue((Object)EllipsizeMaxLinesDetector.ISSUE, (String)"ISSUE");
                objectArray[40] = ExportedFlagDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)FontDetector.FONT_VALIDATION, (String)"FONT_VALIDATION");
                objectArray[42] = GradleDetector.AGP_DEPENDENCY;
                objectArray[43] = GradleDetector.ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
                objectArray[44] = GradleDetector.CHROMEOS_ABI_SUPPORT;
                objectArray[45] = GradleDetector.COMPATIBILITY;
                objectArray[46] = GradleDetector.DEPENDENCY;
                objectArray[47] = GradleDetector.DEPRECATED;
                objectArray[48] = GradleDetector.DEPRECATED_CONFIGURATION;
                objectArray[49] = GradleDetector.DEPRECATED_LIBRARY;
                objectArray[50] = GradleDetector.DUPLICATE_CLASSES;
                objectArray[51] = GradleDetector.EXPIRED_TARGET_SDK_VERSION;
                objectArray[52] = GradleDetector.EXPIRING_TARGET_SDK_VERSION;
                objectArray[53] = GradleDetector.JAVA_PLUGIN_LANGUAGE_LEVEL;
                objectArray[54] = GradleDetector.JCENTER_REPOSITORY_OBSOLETE;
                objectArray[55] = GradleDetector.KTX_EXTENSION_AVAILABLE;
                objectArray[56] = GradleDetector.MIN_SDK_TOO_LOW;
                objectArray[57] = GradleDetector.NOT_INTERPOLATED;
                objectArray[58] = GradleDetector.PATH;
                objectArray[59] = GradleDetector.PLUS;
                objectArray[60] = GradleDetector.REMOTE_VERSION;
                objectArray[61] = GradleDetector.RISKY_LIBRARY;
                objectArray[62] = GradleDetector.STRING_INTEGER;
                objectArray[63] = GradleDetector.TARGET_NEWER;
                Intrinsics.checkNotNullExpressionValue((Object)GridLayoutDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)IconDetector.WEBP_ELIGIBLE, (String)"WEBP_ELIGIBLE");
                Intrinsics.checkNotNullExpressionValue((Object)IconDetector.WEBP_UNSUPPORTED, (String)"WEBP_UNSUPPORTED");
                objectArray[67] = IgnoreWithoutReasonDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)IncludeDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)InefficientWeightDetector.BASELINE_WEIGHTS, (String)"BASELINE_WEIGHTS");
                Intrinsics.checkNotNullExpressionValue((Object)InefficientWeightDetector.INEFFICIENT_WEIGHT, (String)"INEFFICIENT_WEIGHT");
                Intrinsics.checkNotNullExpressionValue((Object)InefficientWeightDetector.ORIENTATION, (String)"ORIENTATION");
                objectArray[72] = InteroperabilityDetector.PLATFORM_NULLNESS;
                Intrinsics.checkNotNullExpressionValue((Object)JavaPerformanceDetector.USE_VALUE_OF, (String)"USE_VALUE_OF");
                Intrinsics.checkNotNullExpressionValue((Object)KeyboardNavigationDetector.ISSUE, (String)"ISSUE");
                objectArray[75] = LabelForDetector.ISSUE;
                objectArray[76] = LintDetectorDetector.DOLLAR_STRINGS;
                objectArray[77] = LintDetectorDetector.EXISTING_LINT_CONSTANTS;
                objectArray[78] = LintDetectorDetector.TEXT_FORMAT;
                objectArray[79] = LintDetectorDetector.TRIM_INDENT;
                objectArray[80] = LocaleDetector.STRING_LOCALE;
                objectArray[81] = ManifestDetector.APPLICATION_ICON;
                objectArray[82] = ManifestDetector.DATA_EXTRACTION_RULES;
                objectArray[83] = ManifestDetector.MIPMAP;
                objectArray[84] = ManifestDetector.MOCK_LOCATION;
                objectArray[85] = ManifestDetector.SET_VERSION;
                objectArray[86] = MissingClassDetector.INNERCLASS;
                Intrinsics.checkNotNullExpressionValue((Object)MissingIdDetector.ISSUE, (String)"ISSUE");
                objectArray[88] = MissingPrefixDetector.MISSING_NAMESPACE;
                objectArray[89] = MotionLayoutDetector.INVALID_SCENE_FILE_REFERENCE;
                objectArray[90] = MotionSceneDetector.MOTION_SCENE_FILE_VALIDATION_ERROR;
                objectArray[91] = NamespaceDetector.REDUNDANT;
                objectArray[92] = NamespaceDetector.RES_AUTO;
                objectArray[93] = NamespaceDetector.TYPO;
                Intrinsics.checkNotNullExpressionValue((Object)NetworkSecurityConfigDetector.INSECURE_CONFIGURATION, (String)"INSECURE_CONFIGURATION");
                Intrinsics.checkNotNullExpressionValue((Object)NetworkSecurityConfigDetector.ISSUE, (String)"ISSUE");
                objectArray[96] = ObjectAnimatorDetector.MISSING_KEEP;
                Intrinsics.checkNotNullExpressionValue((Object)ObsoleteLayoutParamsDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)ParcelDetector.ISSUE, (String)"ISSUE");
                objectArray[99] = PermissionDetector.MISSING_PERMISSION;
                objectArray[100] = PropertyFileDetector.ESCAPE;
                objectArray[101] = PropertyFileDetector.HTTP;
                Intrinsics.checkNotNullExpressionValue((Object)PxUsageDetector.DP_ISSUE, (String)"DP_ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)PxUsageDetector.PX_ISSUE, (String)"PX_ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)ReadParcelableDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)RtlDetector.COMPAT, (String)"COMPAT");
                Intrinsics.checkNotNullExpressionValue((Object)RtlDetector.USE_START, (String)"USE_START");
                objectArray[107] = SamDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)ScrollViewChildDetector.ISSUE, (String)"ISSUE");
                objectArray[109] = SdkIntDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)SecurityDetector.EXPORTED_PROVIDER, (String)"EXPORTED_PROVIDER");
                Intrinsics.checkNotNullExpressionValue((Object)SecurityDetector.EXPORTED_RECEIVER, (String)"EXPORTED_RECEIVER");
                Intrinsics.checkNotNullExpressionValue((Object)SecurityDetector.EXPORTED_SERVICE, (String)"EXPORTED_SERVICE");
                Intrinsics.checkNotNullExpressionValue((Object)ServiceCastDetector.WIFI_MANAGER, (String)"WIFI_MANAGER");
                Intrinsics.checkNotNullExpressionValue((Object)ServiceCastDetector.WIFI_MANAGER_UNCERTAIN, (String)"WIFI_MANAGER_UNCERTAIN");
                Intrinsics.checkNotNullExpressionValue((Object)SignatureOrSystemDetector.ISSUE, (String)"ISSUE");
                objectArray[116] = StringEscapeDetector.STRING_ESCAPING;
                objectArray[117] = SyntheticAccessorDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)TextFieldDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)TextViewDetector.SELECTABLE, (String)"SELECTABLE");
                objectArray[120] = TileProviderDetector.TILE_PROVIDER_PERMISSIONS;
                Intrinsics.checkNotNullExpressionValue((Object)TitleDetector.ISSUE, (String)"ISSUE");
                objectArray[122] = ToastDetector.ISSUE;
                objectArray[123] = TranslationDetector.EXTRA;
                objectArray[124] = TranslationDetector.MISSING;
                objectArray[125] = TranslationDetector.MISSING_BASE;
                objectArray[126] = TranslationDetector.TRANSLATED_UNTRANSLATABLE;
                objectArray[127] = TypoDetector.ISSUE;
                objectArray[128] = TypographyDetector.DASHES;
                objectArray[129] = TypographyDetector.ELLIPSIS;
                objectArray[130] = TypographyDetector.FRACTIONS;
                objectArray[131] = TypographyDetector.OTHER;
                objectArray[132] = TypographyDetector.QUOTES;
                Intrinsics.checkNotNullExpressionValue((Object)UnsafeBroadcastReceiverDetector.BROADCAST_SMS, (String)"BROADCAST_SMS");
                objectArray[134] = UnusedResourceDetector.ISSUE;
                objectArray[135] = UnusedResourceDetector.ISSUE_IDS;
                Intrinsics.checkNotNullExpressionValue((Object)UselessViewDetector.USELESS_LEAF, (String)"USELESS_LEAF");
                Intrinsics.checkNotNullExpressionValue((Object)Utf8Detector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)VectorPathDetector.PATH_VALID, (String)"PATH_VALID");
                objectArray[139] = ViewTypeDetector.ADD_CAST;
                objectArray[140] = ViewTypeDetector.WRONG_VIEW_CAST;
                Intrinsics.checkNotNullExpressionValue((Object)WakelockDetector.TIMEOUT, (String)"TIMEOUT");
                objectArray[142] = WatchFaceForAndroidXDetector.ISSUE;
                objectArray[143] = WatchFaceEditorDetector.ISSUE;
                Intrinsics.checkNotNullExpressionValue((Object)WearStandaloneAppDetector.WEAR_STANDALONE_APP_ISSUE, (String)"WEAR_STANDALONE_APP_ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)WrongCallDetector.ISSUE, (String)"ISSUE");
                Intrinsics.checkNotNullExpressionValue((Object)WrongCaseDetector.WRONG_CASE, (String)"WRONG_CASE");
                studioFixes = SetsKt.setOf((Object[])objectArray);
            }
            Set set = studioFixes;
            return set != null ? CollectionsKt.contains((Iterable)set, (Object)issue) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

