/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Landroidx/appcompat/view/OnClickXmlDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "appcompat-lint"})
public final class OnClickXmlDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue USING_ON_CLICK_IN_XML = Issue.Companion.create("UsingOnClickInXml", "Using `android:onClick` on older version of the platform is broken", "Old versions of the platform do not properly support resolving `android:onClick`", Category.CORRECTNESS, 1, Severity.WARNING, new Implementation(OnClickXmlDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"onClick");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = attribute.getValue();
        if (string == null) {
            return;
        }
        String onClickValue = string;
        if (StringsKt.startsWith$default((String)onClickValue, (String)"@{", (boolean)false, (int)2, null)) {
            return;
        }
        Incident incident = IncidentKt.Incident((Context)((Context)context)).issue(USING_ON_CLICK_IN_XML).at((Object)attribute).message("Use databinding or explicit wiring of click listener in code");
        context.report(incident, Constraints.minSdkLessThan((int)23));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/appcompat/view/OnClickXmlDetector$Companion;", "", "()V", "USING_ON_CLICK_IN_XML", "Lcom/android/tools/lint/detector/api/Issue;", "getUSING_ON_CLICK_IN_XML$appcompat_lint", "()Lcom/android/tools/lint/detector/api/Issue;", "appcompat-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUSING_ON_CLICK_IN_XML$appcompat_lint() {
            return USING_ON_CLICK_IN_XML;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

