/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Landroidx/appcompat/widget/TextViewCompoundDrawablesXmlDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "appcompat-lint"})
public final class TextViewCompoundDrawablesXmlDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> ATTRS_MAP;
    @NotNull
    private static final Issue NOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"TextView");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (Map.Entry<String, String> entry : ATTRS_MAP.entrySet()) {
            String from = entry.getKey();
            String to = entry.getValue();
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", from)) continue;
            Node node = element;
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", from);
            Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"element.getAttributeNode\u2026stants.ANDROID_URI, from)");
            LintFix[] lintFixArray = new LintFix[]{LintFix.Companion.create().set("http://schemas.android.com/apk/res-auto", to, element.getAttributeNS("http://schemas.android.com/apk/res/android", from)).build(), LintFix.Companion.create().unset("http://schemas.android.com/apk/res/android", from).build()};
            context.report(NOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS, node, context.getLocation((Node)attr), "Use `app:" + to + "` instead of `android:" + from + "`", LintFix.Companion.create().composite(lintFixArray));
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"drawableLeft", (Object)"drawableLeftCompat"), TuplesKt.to((Object)"drawableRight", (Object)"drawableRightCompat"), TuplesKt.to((Object)"drawableTop", (Object)"drawableTopCompat"), TuplesKt.to((Object)"drawableBottom", (Object)"drawableBottomCompat"), TuplesKt.to((Object)"drawableStart", (Object)"drawableStartCompat"), TuplesKt.to((Object)"drawableEnd", (Object)"drawableEndCompat"), TuplesKt.to((Object)"drawableTint", (Object)"drawableTint"), TuplesKt.to((Object)"drawableTintMode", (Object)"drawableTintMode")};
        ATTRS_MAP = MapsKt.mapOf((Pair[])pairArray);
        NOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS = Issue.Companion.create("UseCompatTextViewDrawableXml", "Compat compound drawable attributes should be used on `TextView`", "`TextView` uses `android:` compound drawable attributes instead of `app:` ones", Category.CORRECTNESS, 1, Severity.WARNING, new Implementation(TextViewCompoundDrawablesXmlDetector.class, Scope.RESOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/appcompat/widget/TextViewCompoundDrawablesXmlDetector$Companion;", "", "()V", "ATTRS_MAP", "", "", "getATTRS_MAP$appcompat_lint", "()Ljava/util/Map;", "NOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS", "Lcom/android/tools/lint/detector/api/Issue;", "getNOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS$appcompat_lint", "()Lcom/android/tools/lint/detector/api/Issue;", "appcompat-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getATTRS_MAP$appcompat_lint() {
            return ATTRS_MAP;
        }

        @NotNull
        public final Issue getNOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS$appcompat_lint() {
            return NOT_USING_COMPAT_TEXT_VIEW_DRAWABLE_ATTRS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

