/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.LintUtilsKt;
import androidx.fragment.lint.Method;
import androidx.fragment.lint.UnsafeFragmentLifecycleObserverDetectorKt;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/fragment/lint/RecursiveMethodVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "originFragmentName", "", "lifecycleMethod", "(Lcom/android/tools/lint/detector/api/JavaContext;Ljava/lang/String;Ljava/lang/String;)V", "visitedMethods", "", "Lorg/jetbrains/uast/UCallExpression;", "checkCall", "", "call", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "visitCallExpression", "node", "fragment-lint"})
final class RecursiveMethodVisitor
extends AbstractUastVisitor {
    private final Set<UCallExpression> visitedMethods;
    private final JavaContext context;
    private final String originFragmentName;
    private final String lifecycleMethod;

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.visitedMethods.contains(node)) {
            return super.visitCallExpression(node);
        }
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return super.visitCallExpression(node);
        }
        PsiMethod psiMethod2 = psiMethod;
        if (!this.checkCall(node, psiMethod2) && UnsafeFragmentLifecycleObserverDetectorKt.isInteresting(node, this.context)) {
            UMethod uastNode = this.context.getUastContext().getMethod(psiMethod2);
            this.visitedMethods.add(node);
            UExpression uExpression = uastNode.getUastBody();
            if (uExpression != null) {
                uExpression.accept((UastVisitor)this);
            }
            this.visitedMethods.remove(node);
        }
        return super.visitCallExpression(node);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkCall(UCallExpression call, PsiMethod psiMethod) {
        Map argMap;
        PsiClass psiClass = psiMethod.getContainingClass();
        String string = psiClass != null ? psiClass.getQualifiedName() : null;
        String string2 = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiMethod.name");
        Method method = new Method(string, string2);
        Issue issue = UnsafeFragmentLifecycleObserverDetectorKt.getUNSAFE_METHODS().get(method);
        if (issue == null) {
            return false;
        }
        Issue issue2 = issue;
        Map $this$forEach$iv = argMap = this.context.getEvaluator().computeArgumentMapping(call, psiMethod);
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void arg;
            Map.Entry element$iv;
            Map.Entry $dstr$arg$param = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$arg$param;
            boolean bl3 = false;
            UExpression uExpression = (UExpression)entry.getKey();
            entry = $dstr$arg$param;
            bl3 = false;
            PsiParameter param = (PsiParameter)entry.getValue();
            if (!LintUtilsKt.extends$default(arg.getExpressionType(), this.context, "androidx.fragment.app.Fragment", false, 4, null) || LintUtilsKt.extends$default(arg.getExpressionType(), this.context, "androidx.fragment.app.DialogFragment", false, 4, null) || !LintUtilsKt.extends$default(param.getType(), this.context, "androidx.lifecycle.LifecycleOwner", false, 4, null)) continue;
            PsiClass argType = PsiTypesUtil.getPsiClass((PsiType)arg.getExpressionType());
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)call));
            if (Intrinsics.areEqual((Object)argType, (Object)(uClass != null ? uClass.getJavaPsi() : null))) {
                String methodFix = Lint.isKotlin((PsiElement)((PsiElement)this.context.getPsiFile())) ? "viewLifecycleOwner" : "getViewLifecycleOwner()";
                this.context.report(issue2, this.context.getLocation((UElement)arg), "Use " + methodFix + " as the LifecycleOwner.", LintFix.create().replace().with(methodFix).build());
            } else {
                Context.report$default((Context)((Context)this.context), (Issue)issue2, (Location)this.context.getLocation((UElement)call), (String)("Unsafe call to " + call.getMethodName() + " with Fragment instance as " + "LifecycleOwner from " + this.originFragmentName + '.' + this.lifecycleMethod + '.'), null, (int)8, null);
            }
            return true;
        }
        return false;
    }

    public RecursiveMethodVisitor(@NotNull JavaContext context, @Nullable String originFragmentName, @NotNull String lifecycleMethod) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lifecycleMethod, (String)"lifecycleMethod");
        this.context = context;
        this.originFragmentName = originFragmentName;
        this.lifecycleMethod = lifecycleMethod;
        boolean bl = false;
        this.visitedMethods = new LinkedHashSet();
    }
}

