/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.RecursiveMethodVisitor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "lifecycleMethods", "", "", "applicableSuperClasses", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Issues", "fragment-lint"})
public final class UnsafeFragmentLifecycleObserverDetector
extends Detector
implements SourceCodeScanner {
    private final Set<String> lifecycleMethods = SetsKt.setOf((Object[])new String[]{"onCreateView", "onViewCreated", "onActivityCreated", "onViewStateRestored"});
    @NotNull
    private static final Issue LIVEDATA_ISSUE;
    @NotNull
    private static final Issue BACK_PRESSED_ISSUE;
    @NotNull
    public static final Issues Issues;

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"androidx.fragment.app.Fragment");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        UMethod[] uMethodArray = $this$forEach$iv;
        int n = uMethodArray.length;
        for (int i = 0; i < n; ++i) {
            UMethod element$iv;
            UMethod it = element$iv = uMethodArray[i];
            boolean bl = false;
            if (!this.lifecycleMethods.contains(it.getName())) continue;
            RecursiveMethodVisitor visitor = new RecursiveMethodVisitor(context, declaration.getName(), it.getName());
            UExpression uExpression = it.getUastBody();
            if (uExpression == null) continue;
            uExpression.accept((UastVisitor)visitor);
        }
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = true;
        boolean bl2 = false;
        Implementation implementation = new Implementation(UnsafeFragmentLifecycleObserverDetector.class, Scope.JAVA_FILE_SCOPE);
        int n = 0;
        Severity severity = Severity.ERROR;
        String string = null;
        Category category = Category.CORRECTNESS;
        LIVEDATA_ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"FragmentLiveDataObserve", (String)"Use getViewLifecycleOwner() as the LifecycleOwner instead of a Fragment instance when observing a LiveData object.", (String)"When observing a LiveData object from a fragment's onCreateView, \\\n                onViewCreated, onActivityCreated, or onViewStateRestored method \\\n                getViewLifecycleOwner() should be used as the LifecycleOwner rather than the \\\n                Fragment instance. The Fragment lifecycle can result in the Fragment being \\\n                active longer than its view. This can lead to unexpected behavior from \\\n                LiveData objects being observed longer than the Fragment's view is active.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, (Boolean)bl, enumSet, collection, (int)3408, null);
        collection = null;
        enumSet = null;
        bl = true;
        bl2 = false;
        implementation = new Implementation(UnsafeFragmentLifecycleObserverDetector.class, Scope.JAVA_FILE_SCOPE);
        n = 0;
        severity = Severity.ERROR;
        string = null;
        category = Category.CORRECTNESS;
        BACK_PRESSED_ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"FragmentBackPressedCallback", (String)"Use getViewLifecycleOwner() as the LifecycleOwner instead of a Fragment instance.", (String)"The Fragment lifecycle can result in a Fragment being active \\\n                longer than its view. This can lead to unexpected behavior from lifecycle aware \\\n                objects remaining active longer than the Fragment's view. To solve this issue, \\\n                getViewLifecycleOwner() should be used as a LifecycleOwner rather than the \\\n                Fragment instance once it is safe to access the view lifecycle in a \\\n                Fragment's onCreateView, onViewCreated, onActivityCreated, or \\\n                onViewStateRestored methods.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, (Boolean)bl, enumSet, collection, (int)3408, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector$Issues;", "", "()V", "BACK_PRESSED_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getBACK_PRESSED_ISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "LIVEDATA_ISSUE", "getLIVEDATA_ISSUE", "fragment-lint"})
    public static final class Issues {
        @NotNull
        public final Issue getLIVEDATA_ISSUE() {
            return LIVEDATA_ISSUE;
        }

        @NotNull
        public final Issue getBACK_PRESSED_ISSUE() {
            return BACK_PRESSED_ISSUE;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

