/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.LintUtilsKt;
import androidx.fragment.lint.UseRequireInsteadOfGet;
import androidx.fragment.lint.UseRequireInsteadOfGetKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Landroidx/fragment/lint/UseRequireInsteadOfGet;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "fragment-lint"})
public final class UseRequireInsteadOfGet
extends Detector
implements SourceCodeScanner {
    @NotNull
    private static final Issue ISSUE;
    private static final String FRAGMENT_FQCN = "androidx.fragment.app.Fragment";
    @NotNull
    private static final Set<String> REQUIRABLE_METHODS;
    @NotNull
    private static final List<String> REQUIRABLE_REFERENCES;
    @NotNull
    private static final Set<String> KNOWN_NULLCHECKS;
    @NotNull
    public static final Companion Companion;

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        super.visitMethodCall(context, node, method);
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UCallExpression.class, USimpleNameReferenceExpression.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isKotlin = Lint.isKotlin((PsiElement)((PsiElement)context.getPsiFile()));
        return new UElementHandler(context, isKotlin){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ boolean $isKotlin;

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement parent = node.getUastParent();
                if (parent instanceof UQualifiedReferenceExpression) {
                    this.checkReferenceExpression((UExpression)parent, node.getIdentifier(), (Function0<? extends PsiClass>)((Function0)new Function0<PsiClass>(this, parent){
                        final /* synthetic */ createUastHandler.1 this$0;
                        final /* synthetic */ UElement $parent;

                        @Nullable
                        public final PsiClass invoke() {
                            PsiClass psiClass;
                            PsiType psiType = ((UQualifiedReferenceExpression)this.$parent).getReceiver().getExpressionType();
                            if (psiType != null) {
                                PsiType psiType2 = psiType;
                                boolean bl = false;
                                boolean bl2 = false;
                                PsiType it = psiType2;
                                boolean bl3 = false;
                                JavaEvaluator javaEvaluator = this.this$0.$context.getEvaluator();
                                String string = it.getCanonicalText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.canonicalText");
                                psiClass = javaEvaluator.findClass(string);
                            } else {
                                psiClass = null;
                            }
                            return psiClass;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$parent = uElement;
                            super(0);
                        }
                    }));
                } else {
                    this.checkReferenceExpression((UExpression)node, node.getIdentifier(), (Function0<? extends PsiClass>)((Function0)new Function0<PsiClass>(node){
                        final /* synthetic */ USimpleNameReferenceExpression $node;

                        @Nullable
                        public final PsiClass invoke() {
                            return (PsiClass)UastUtils.getContainingUClass((UElement)((UElement)this.$node));
                        }
                        {
                            this.$node = uSimpleNameReferenceExpression;
                            super(0);
                        }
                    }));
                }
            }

            private final void checkReferenceExpression(UExpression node, String identifier, Function0<? extends PsiClass> resolveEnclosingClass) {
                if (UseRequireInsteadOfGet.Companion.getREQUIRABLE_REFERENCES$fragment_lint().contains(identifier)) {
                    PsiElement element = UastUtils.tryResolve((UElement)((UElement)node));
                    if (element != null && UastContextKt.toUElement((PsiElement)element) instanceof ULocalVariable) {
                        return;
                    }
                    PsiClass psiClass = (PsiClass)resolveEnclosingClass.invoke();
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass enclosingClass = psiClass;
                    if (this.$context.getEvaluator().extendsClass(enclosingClass, "androidx.fragment.app.Fragment", false)) {
                        createUastHandler.1.checkForIssue$default(this, node, identifier, null, 4, null);
                    }
                }
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod targetMethod = psiMethod;
                PsiClass psiClass = targetMethod.getContainingClass();
                if (psiClass == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"targetMethod.containingClass ?: return");
                PsiClass containingClass = psiClass;
                if (UseRequireInsteadOfGet.Companion.getREQUIRABLE_METHODS$fragment_lint().contains(targetMethod.getName()) && this.$context.getEvaluator().extendsClass(containingClass, "androidx.fragment.app.Fragment", false)) {
                    UExpression uExpression = (UExpression)node;
                    String string = targetMethod.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetMethod.name");
                    this.checkForIssue(uExpression, string, targetMethod.getName() + "()");
                }
            }

            private final void checkForIssue(UExpression node, String targetMethodName, String targetExpression) {
                UElement uElement = LintUtilsKt.getNearestNonQualifiedReferenceParent((UElement)node);
                if (uElement == null) {
                    return;
                }
                UElement nearestNonQualifiedReferenceParent = uElement;
                if (this.$isKotlin && UseRequireInsteadOfGetKt.isNullCheckBlock(nearestNonQualifiedReferenceParent)) {
                    String parentSourceToReplace = nearestNonQualifiedReferenceParent.asSourceString();
                    String correctMethod = this.correctMethod(parentSourceToReplace, targetExpression + "!!", targetMethodName);
                    if (Intrinsics.areEqual((Object)correctMethod, (Object)parentSourceToReplace)) {
                        correctMethod = this.replaceFirstOccurrenceAfter(StringsKt.replace$default((String)parentSourceToReplace, (String)(targetExpression + '?'), (String)(targetExpression + "!!"), (boolean)false, (int)4, null), "!!", "", targetExpression + "!!");
                    }
                    this.report(nearestNonQualifiedReferenceParent, parentSourceToReplace, correctMethod);
                } else if (nearestNonQualifiedReferenceParent instanceof UCallExpression) {
                    boolean singleParameterSpecified;
                    PsiMethod psiMethod = ((UCallExpression)nearestNonQualifiedReferenceParent).resolve();
                    if (psiMethod == null) {
                        return;
                    }
                    PsiMethod enclosingMethodCall = psiMethod;
                    if (UseRequireInsteadOfGet.Companion.getKNOWN_NULLCHECKS$fragment_lint().contains(enclosingMethodCall.getName()) && (singleParameterSpecified = this.isSingleParameterSpecified(enclosingMethodCall, (UCallExpression)nearestNonQualifiedReferenceParent))) {
                        String source = ((UExpression)((UCallExpression)nearestNonQualifiedReferenceParent).getValueArguments().get(0)).asSourceString();
                        String parentToReplace = LintUtilsKt.fullyQualifiedNearestParent$default(nearestNonQualifiedReferenceParent, false, 1, null).asSourceString();
                        String correctMethod = this.correctMethod(source, targetExpression, targetMethodName);
                        this.report(nearestNonQualifiedReferenceParent, parentToReplace, correctMethod);
                    }
                }
            }

            static /* synthetic */ void checkForIssue$default(createUastHandler.1 var0, UExpression uExpression, String string, String string2, int n, Object object) {
                if ((n & 4) != 0) {
                    string2 = string;
                }
                var0.checkForIssue(uExpression, string, string2);
            }

            private final boolean isSingleParameterSpecified(PsiMethod enclosingMethodCall, UCallExpression nearestNonQualifiedRefParent) {
                PsiParameterList psiParameterList = enclosingMethodCall.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"enclosingMethodCall.parameterList");
                return psiParameterList.getParametersCount() == 1 || this.$isKotlin && nearestNonQualifiedRefParent instanceof KotlinUFunctionCallExpression && ((KotlinUFunctionCallExpression)nearestNonQualifiedRefParent).getArgumentForParameter(1) == null;
            }

            private final String correctMethod(String source, String targetExpression, String targetMethodName) {
                StringBuilder stringBuilder = new StringBuilder().append("require");
                String string = StringsKt.removePrefix((String)targetMethodName, (CharSequence)"get");
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
                return StringsKt.replace$default((String)source, (String)targetExpression, (String)stringBuilder.append(UseRequireInsteadOfGetKt.capitalize(string, locale)).append("()").toString(), (boolean)false, (int)4, null);
            }

            private final String replaceFirstOccurrenceAfter(String $this$replaceFirstOccurrenceAfter, String oldValue, String newValue, String prefix) {
                return prefix + StringsKt.replaceFirst$default((String)StringsKt.substringAfter$default((String)$this$replaceFirstOccurrenceAfter, (String)prefix, null, (int)2, null), (String)oldValue, (String)newValue, (boolean)false, (int)4, null);
            }

            private final void report(UElement node, String targetExpression, String correctMethod) {
                this.$context.report(UseRequireInsteadOfGet.Companion.getISSUE(), this.$context.getLocation(node), "Use " + correctMethod + " instead of " + targetExpression, LintFix.create().replace().name("Replace with " + correctMethod).text(targetExpression).with(correctMethod).autoFix().build());
            }
            {
                this.$context = $captured_local_variable$0;
                this.$isKotlin = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        ISSUE = Issue.Companion.create("UseRequireInsteadOfGet", "Use the 'require_____()' API rather than 'get____()' API for more descriptive error messages when it's null.", "\n            AndroidX added new \"require____()\" versions of common \"get___()\" APIs, such as \\\n            getContext/getActivity/getArguments/etc. Rather than wrap these in something like \\\n            requireNotNull(), using these APIs will allow the underlying component to try \\\n            to tell you _why_ it was null, and thus yield a better error message.\n            ", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(UseRequireInsteadOfGet.class, Scope.JAVA_FILE_SCOPE));
        REQUIRABLE_METHODS = SetsKt.setOf((Object[])new String[]{"getArguments", "getContext", "getActivity", "getFragmentManager", "getHost", "getParentFragment", "getView"});
        Iterable $this$map$iv = REQUIRABLE_METHODS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removePrefix((String)it, (CharSequence)"get");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            String string3 = UseRequireInsteadOfGetKt.decapitalize(string2, locale);
            collection.add(string3);
        }
        REQUIRABLE_REFERENCES = (List)var3_3;
        KNOWN_NULLCHECKS = SetsKt.setOf((Object[])new String[]{"checkNotNull", "requireNonNull"});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/fragment/lint/UseRequireInsteadOfGet$Companion;", "", "()V", "FRAGMENT_FQCN", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "KNOWN_NULLCHECKS", "", "getKNOWN_NULLCHECKS$fragment_lint", "()Ljava/util/Set;", "REQUIRABLE_METHODS", "getREQUIRABLE_METHODS$fragment_lint", "REQUIRABLE_REFERENCES", "", "getREQUIRABLE_REFERENCES$fragment_lint", "()Ljava/util/List;", "fragment-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        @NotNull
        public final Set<String> getREQUIRABLE_METHODS$fragment_lint() {
            return REQUIRABLE_METHODS;
        }

        @NotNull
        public final List<String> getREQUIRABLE_REFERENCES$fragment_lint() {
            return REQUIRABLE_REFERENCES;
        }

        @NotNull
        public final Set<String> getKNOWN_NULLCHECKS$fragment_lint() {
            return KNOWN_NULLCHECKS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

