/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class BundleCompat {
    private BundleCompat() {
    }

    @Nullable
    public static IBinder getBinder(@NonNull Bundle bundle, @Nullable String key) {
        if (Build.VERSION.SDK_INT >= 18) {
            return Api18Impl.getBinder(bundle, key);
        }
        return BeforeApi18Impl.getBinder(bundle, key);
    }

    public static void putBinder(@NonNull Bundle bundle, @Nullable String key, @Nullable IBinder binder) {
        if (Build.VERSION.SDK_INT >= 18) {
            Api18Impl.putBinder(bundle, key, binder);
        } else {
            BeforeApi18Impl.putBinder(bundle, key, binder);
        }
    }

    @RequiresApi(value=18)
    static class Api18Impl {
        private Api18Impl() {
        }

        @DoNotInline
        static IBinder getBinder(Bundle bundle, String key) {
            return bundle.getBinder(key);
        }

        @DoNotInline
        static void putBinder(Bundle bundle, String key, IBinder value) {
            bundle.putBinder(key, value);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    static class BeforeApi18Impl {
        private static final String TAG = "BundleCompatBaseImpl";
        private static Method sGetIBinderMethod;
        private static boolean sGetIBinderMethodFetched;
        private static Method sPutIBinderMethod;
        private static boolean sPutIBinderMethodFetched;

        private BeforeApi18Impl() {
        }

        public static IBinder getBinder(Bundle bundle, String key) {
            if (!sGetIBinderMethodFetched) {
                try {
                    sGetIBinderMethod = Bundle.class.getMethod("getIBinder", String.class);
                    sGetIBinderMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    Log.i((String)TAG, (String)"Failed to retrieve getIBinder method", (Throwable)e);
                }
                sGetIBinderMethodFetched = true;
            }
            if (sGetIBinderMethod != null) {
                try {
                    return (IBinder)sGetIBinderMethod.invoke((Object)bundle, key);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Log.i((String)TAG, (String)"Failed to invoke getIBinder via reflection", (Throwable)e);
                    sGetIBinderMethod = null;
                }
            }
            return null;
        }

        public static void putBinder(Bundle bundle, String key, IBinder binder) {
            if (!sPutIBinderMethodFetched) {
                try {
                    sPutIBinderMethod = Bundle.class.getMethod("putIBinder", String.class, IBinder.class);
                    sPutIBinderMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    Log.i((String)TAG, (String)"Failed to retrieve putIBinder method", (Throwable)e);
                }
                sPutIBinderMethodFetched = true;
            }
            if (sPutIBinderMethod != null) {
                try {
                    sPutIBinderMethod.invoke((Object)bundle, key, binder);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Log.i((String)TAG, (String)"Failed to invoke putIBinder via reflection", (Throwable)e);
                    sPutIBinderMethod = null;
                }
            }
        }
    }
}

