/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import java.lang.reflect.Method;

public final class DisplayCompat {
    private static final int DISPLAY_SIZE_4K_WIDTH = 3840;
    private static final int DISPLAY_SIZE_4K_HEIGHT = 2160;

    private DisplayCompat() {
    }

    @NonNull
    public static ModeCompat getMode(@NonNull Context context, @NonNull Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getMode(context, display);
        }
        return new ModeCompat(DisplayCompat.getDisplaySize(context, display));
    }

    @NonNull
    private static Point getDisplaySize(@NonNull Context context, @NonNull Display display) {
        Point displaySize = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(context, display);
        if (displaySize != null) {
            return displaySize;
        }
        displaySize = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.getRealSize(display, displaySize);
        } else {
            display.getSize(displaySize);
        }
        return displaySize;
    }

    @NonNull
    @SuppressLint(value={"ArrayReturn"})
    public static ModeCompat[] getSupportedModes(@NonNull Context context, @NonNull Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getSupportedModes(context, display);
        }
        return new ModeCompat[]{DisplayCompat.getMode(context, display)};
    }

    private static Point parseDisplaySize(@NonNull String displaySize) throws NumberFormatException {
        String[] displaySizeParts = displaySize.trim().split("x", -1);
        if (displaySizeParts.length == 2) {
            int width = Integer.parseInt(displaySizeParts[0]);
            int height = Integer.parseInt(displaySizeParts[1]);
            if (width > 0 && height > 0) {
                return new Point(width, height);
            }
        }
        throw new NumberFormatException();
    }

    @Nullable
    private static String getSystemProperty(String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("get", String.class);
            return (String)getMethod.invoke(systemProperties, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isTv(@NonNull Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        return uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
    }

    @Nullable
    private static Point parsePhysicalDisplaySizeFromSystemProperties(@NonNull String property, @NonNull Display display) {
        if (display.getDisplayId() != 0) {
            return null;
        }
        String displaySize = DisplayCompat.getSystemProperty(property);
        if (TextUtils.isEmpty((CharSequence)displaySize) || displaySize == null) {
            return null;
        }
        try {
            return DisplayCompat.parseDisplaySize(displaySize);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Point getCurrentDisplaySizeFromWorkarounds(@NonNull Context context, @NonNull Display display) {
        Point displaySize;
        Point point = displaySize = Build.VERSION.SDK_INT < 28 ? DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("sys.display-size", display) : DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("vendor.display-size", display);
        if (displaySize != null) {
            return displaySize;
        }
        if (DisplayCompat.isSonyBravia4kTv(context)) {
            return DisplayCompat.isCurrentModeTheLargestMode(display) ? new Point(3840, 2160) : null;
        }
        return null;
    }

    private static boolean isSonyBravia4kTv(@NonNull Context context) {
        return DisplayCompat.isTv(context) && "Sony".equals(Build.MANUFACTURER) && Build.MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd");
    }

    static boolean isCurrentModeTheLargestMode(@NonNull Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.isCurrentModeTheLargestMode(display);
        }
        return true;
    }

    public static final class ModeCompat {
        private final Display.Mode mMode;
        private final Point mPhysicalSize;
        private final boolean mIsNative;

        ModeCompat(@NonNull Point physicalSize) {
            Preconditions.checkNotNull(physicalSize, "physicalSize == null");
            this.mPhysicalSize = physicalSize;
            this.mMode = null;
            this.mIsNative = true;
        }

        @RequiresApi(value=23)
        ModeCompat(@NonNull Display.Mode mode, boolean isNative) {
            Preconditions.checkNotNull(mode, "mode == null, can't wrap a null reference");
            this.mPhysicalSize = new Point(Api23Impl.getPhysicalWidth(mode), Api23Impl.getPhysicalHeight(mode));
            this.mMode = mode;
            this.mIsNative = isNative;
        }

        @RequiresApi(value=23)
        ModeCompat(@NonNull Display.Mode mode, @NonNull Point physicalSize) {
            Preconditions.checkNotNull(mode, "mode == null, can't wrap a null reference");
            Preconditions.checkNotNull(physicalSize, "physicalSize == null");
            this.mPhysicalSize = physicalSize;
            this.mMode = mode;
            this.mIsNative = true;
        }

        public int getPhysicalWidth() {
            return this.mPhysicalSize.x;
        }

        public int getPhysicalHeight() {
            return this.mPhysicalSize.y;
        }

        @Deprecated
        public boolean isNative() {
            return this.mIsNative;
        }

        @RequiresApi(value=23)
        @Nullable
        public Display.Mode toMode() {
            return this.mMode;
        }

        @RequiresApi(value=23)
        static class Api23Impl {
            private Api23Impl() {
            }

            @DoNotInline
            static int getPhysicalWidth(Display.Mode mode) {
                return mode.getPhysicalWidth();
            }

            @DoNotInline
            static int getPhysicalHeight(Display.Mode mode) {
                return mode.getPhysicalHeight();
            }
        }
    }

    @RequiresApi(value=17)
    static class Api17Impl {
        private Api17Impl() {
        }

        static void getRealSize(Display display, Point displaySize) {
            display.getRealSize(displaySize);
        }
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @NonNull
        static ModeCompat getMode(@NonNull Context context, @NonNull Display display) {
            Display.Mode currentMode = display.getMode();
            Point workaroundSize = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(context, display);
            return workaroundSize == null || Api23Impl.physicalSizeEquals(currentMode, workaroundSize) ? new ModeCompat(currentMode, true) : new ModeCompat(currentMode, workaroundSize);
        }

        @NonNull
        @SuppressLint(value={"ArrayReturn"})
        public static ModeCompat[] getSupportedModes(@NonNull Context context, @NonNull Display display) {
            Display.Mode[] supportedModes = display.getSupportedModes();
            ModeCompat[] supportedModesCompat = new ModeCompat[supportedModes.length];
            Display.Mode currentMode = display.getMode();
            Point workaroundSize = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(context, display);
            if (workaroundSize == null || Api23Impl.physicalSizeEquals(currentMode, workaroundSize)) {
                for (int i = 0; i < supportedModes.length; ++i) {
                    boolean isNative = Api23Impl.physicalSizeEquals(supportedModes[i], currentMode);
                    supportedModesCompat[i] = new ModeCompat(supportedModes[i], isNative);
                }
            } else {
                for (int i = 0; i < supportedModes.length; ++i) {
                    supportedModesCompat[i] = Api23Impl.physicalSizeEquals(supportedModes[i], currentMode) ? new ModeCompat(supportedModes[i], workaroundSize) : new ModeCompat(supportedModes[i], false);
                }
            }
            return supportedModesCompat;
        }

        static boolean isCurrentModeTheLargestMode(@NonNull Display display) {
            Display.Mode[] supportedModes;
            Display.Mode currentMode = display.getMode();
            for (Display.Mode supportedMode : supportedModes = display.getSupportedModes()) {
                if (currentMode.getPhysicalHeight() >= supportedMode.getPhysicalHeight() && currentMode.getPhysicalWidth() >= supportedMode.getPhysicalWidth()) continue;
                return false;
            }
            return true;
        }

        static boolean physicalSizeEquals(Display.Mode mode, Point size) {
            return mode.getPhysicalWidth() == size.x && mode.getPhysicalHeight() == size.y || mode.getPhysicalWidth() == size.y && mode.getPhysicalHeight() == size.x;
        }

        static boolean physicalSizeEquals(Display.Mode mode, Display.Mode otherMode) {
            return mode.getPhysicalWidth() == otherMode.getPhysicalWidth() && mode.getPhysicalHeight() == otherMode.getPhysicalHeight();
        }
    }
}

