/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.os.Build;
import android.view.View;
import android.widget.ListView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

public final class ListViewCompat {
    public static void scrollListBy(@NonNull ListView listView, int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            Api19Impl.scrollListBy(listView, y);
        } else {
            int firstPosition = listView.getFirstVisiblePosition();
            if (firstPosition == -1) {
                return;
            }
            View firstView = listView.getChildAt(0);
            if (firstView == null) {
                return;
            }
            int newTop = firstView.getTop() - y;
            listView.setSelectionFromTop(firstPosition, newTop);
        }
    }

    public static boolean canScrollList(@NonNull ListView listView, int direction) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Api19Impl.canScrollList(listView, direction);
        }
        int childCount = listView.getChildCount();
        if (childCount == 0) {
            return false;
        }
        int firstPosition = listView.getFirstVisiblePosition();
        if (direction > 0) {
            int lastBottom = listView.getChildAt(childCount - 1).getBottom();
            int lastPosition = firstPosition + childCount;
            return lastPosition < listView.getCount() || lastBottom > listView.getHeight() - listView.getListPaddingBottom();
        }
        int firstTop = listView.getChildAt(0).getTop();
        return firstPosition > 0 || firstTop < listView.getListPaddingTop();
    }

    private ListViewCompat() {
    }

    @RequiresApi(value=19)
    static class Api19Impl {
        private Api19Impl() {
        }

        @DoNotInline
        static void scrollListBy(ListView absListView, int y) {
            absListView.scrollListBy(y);
        }

        @DoNotInline
        static boolean canScrollList(ListView absListView, int direction) {
            return absListView.canScrollList(direction);
        }
    }
}

