/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentStateManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class FragmentStore {
    private static final String TAG = "FragmentManager";
    private final ArrayList<Fragment> mAdded = new ArrayList();
    private final HashMap<String, FragmentStateManager> mActive = new HashMap();
    private final HashMap<String, Bundle> mSavedState = new HashMap();
    private FragmentManagerViewModel mNonConfig;

    FragmentStore() {
    }

    void setNonConfig(@NonNull FragmentManagerViewModel nonConfig) {
        this.mNonConfig = nonConfig;
    }

    FragmentManagerViewModel getNonConfig() {
        return this.mNonConfig;
    }

    void resetActiveFragments() {
        this.mActive.clear();
    }

    void restoreAddedFragments(@Nullable List<String> added) {
        this.mAdded.clear();
        if (added != null) {
            for (String who : added) {
                Fragment f = this.findActiveFragment(who);
                if (f == null) {
                    throw new IllegalStateException("No instantiated fragment for (" + who + ")");
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreSaveState: added (" + who + "): " + f));
                }
                this.addFragment(f);
            }
        }
    }

    void makeActive(@NonNull FragmentStateManager newlyActive) {
        Fragment f = newlyActive.getFragment();
        if (this.containsActiveFragment(f.mWho)) {
            return;
        }
        this.mActive.put(f.mWho, newlyActive);
        if (f.mRetainInstanceChangedWhileDetached) {
            if (f.mRetainInstance) {
                this.mNonConfig.addRetainedFragment(f);
            } else {
                this.mNonConfig.removeRetainedFragment(f);
            }
            f.mRetainInstanceChangedWhileDetached = false;
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Added fragment to active set " + f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFragment(@NonNull Fragment fragment) {
        if (this.mAdded.contains(fragment)) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
    }

    void dispatchStateChange(int state) {
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            fragmentStateManager.setFragmentManagerState(state);
        }
    }

    void moveToExpectedState() {
        for (Fragment f : this.mAdded) {
            FragmentStateManager fragmentStateManager = this.mActive.get(f.mWho);
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
            Fragment f = fragmentStateManager.getFragment();
            boolean beingRemoved = f.mRemoving && !f.isInBackStack();
            if (!beingRemoved) continue;
            if (f.mBeingSaved && !this.mSavedState.containsKey(f.mWho)) {
                this.setSavedState(f.mWho, fragmentStateManager.saveState());
            }
            this.makeInactive(fragmentStateManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFragment(@NonNull Fragment fragment) {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.remove(fragment);
        }
        fragment.mAdded = false;
    }

    void makeInactive(@NonNull FragmentStateManager newlyInactive) {
        Fragment f = newlyInactive.getFragment();
        if (f.mRetainInstance) {
            this.mNonConfig.removeRetainedFragment(f);
        }
        if (this.mActive.get(f.mWho) != newlyInactive) {
            return;
        }
        FragmentStateManager removedStateManager = this.mActive.put(f.mWho, null);
        if (removedStateManager == null) {
            return;
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Removed fragment from active set " + f));
        }
    }

    void burpActive() {
        Collection<FragmentStateManager> values = this.mActive.values();
        values.removeAll(Collections.singleton(null));
    }

    @Nullable
    Bundle getSavedState(@NonNull String who) {
        return this.mSavedState.get(who);
    }

    @Nullable
    Bundle setSavedState(@NonNull String who, @Nullable Bundle bundle) {
        if (bundle != null) {
            return this.mSavedState.put(who, bundle);
        }
        return this.mSavedState.remove(who);
    }

    void restoreSaveState(@NonNull HashMap<String, Bundle> allSavedStates) {
        this.mSavedState.clear();
        this.mSavedState.putAll(allSavedStates);
    }

    @NonNull
    HashMap<String, Bundle> getAllSavedState() {
        return this.mSavedState;
    }

    @NonNull
    ArrayList<String> saveActiveFragments() {
        ArrayList<String> active = new ArrayList<String>(this.mActive.size());
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            this.setSavedState(f.mWho, fragmentStateManager.saveState());
            active.add(f.mWho);
            if (!FragmentManager.isLoggingEnabled(2)) continue;
            Log.v((String)TAG, (String)("Saved state of " + f + ": " + f.mSavedFragmentState));
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<String> saveAddedFragments() {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            if (this.mAdded.isEmpty()) {
                return null;
            }
            ArrayList<String> added = new ArrayList<String>(this.mAdded.size());
            for (Fragment f : this.mAdded) {
                added.add(f.mWho);
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)TAG, (String)("saveAllState: adding fragment (" + f.mWho + "): " + f));
            }
            return added;
        }
    }

    @NonNull
    List<FragmentStateManager> getActiveFragmentStateManagers() {
        ArrayList<FragmentStateManager> activeFragmentStateManagers = new ArrayList<FragmentStateManager>();
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            activeFragmentStateManagers.add(fragmentStateManager);
        }
        return activeFragmentStateManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return new ArrayList<Fragment>(this.mAdded);
        }
    }

    @NonNull
    List<Fragment> getActiveFragments() {
        ArrayList<Fragment> activeFragments = new ArrayList<Fragment>();
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager != null) {
                activeFragments.add(fragmentStateManager.getFragment());
                continue;
            }
            activeFragments.add(null);
        }
        return activeFragments;
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    @Nullable
    Fragment findFragmentById(@IdRes int id2) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || f.mFragmentId != id2) continue;
            return f;
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            if (f.mFragmentId != id2) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findFragmentByTag(@Nullable String tag) {
        if (tag != null) {
            for (int i = this.mAdded.size() - 1; i >= 0; --i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        if (tag != null) {
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                if (fragmentStateManager == null) continue;
                Fragment f = fragmentStateManager.getFragment();
                if (!tag.equals(f.mTag)) continue;
                return f;
            }
        }
        return null;
    }

    boolean containsActiveFragment(@NonNull String who) {
        return this.mActive.get(who) != null;
    }

    @Nullable
    FragmentStateManager getFragmentStateManager(@NonNull String who) {
        return this.mActive.get(who);
    }

    @Nullable
    Fragment findFragmentByWho(@NonNull String who) {
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            if ((f = f.findFragmentByWho(who)) == null) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findActiveFragment(@NonNull String who) {
        FragmentStateManager fragmentStateManager = this.mActive.get(who);
        if (fragmentStateManager != null) {
            return fragmentStateManager.getFragment();
        }
        return null;
    }

    int findFragmentIndexInContainer(@NonNull Fragment f) {
        int i;
        ViewGroup container = f.mContainer;
        if (container == null) {
            return -1;
        }
        int fragmentIndex = this.mAdded.indexOf(f);
        for (i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            int underIndex = container.indexOfChild(underFragment.mView);
            return underIndex + 1;
        }
        for (i = fragmentIndex + 1; i < this.mAdded.size(); ++i) {
            Fragment overFragment = this.mAdded.get(i);
            if (overFragment.mContainer != container || overFragment.mView == null) continue;
            return container.indexOfChild(overFragment.mView);
        }
        return -1;
    }

    void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        int count;
        Fragment f;
        String innerPrefix = prefix + "    ";
        if (!this.mActive.isEmpty()) {
            writer.print(prefix);
            writer.println("Active Fragments:");
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                writer.print(prefix);
                if (fragmentStateManager != null) {
                    f = fragmentStateManager.getFragment();
                    writer.println(f);
                    f.dump(innerPrefix, fd, writer, args);
                    continue;
                }
                writer.println("null");
            }
        }
        if ((count = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (int i = 0; i < count; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
    }
}

