/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NavUtils;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Iterator;

public final class TaskStackBuilder
implements Iterable<Intent> {
    private static final String TAG = "TaskStackBuilder";
    private final ArrayList<Intent> mIntents = new ArrayList();
    private final Context mSourceContext;

    private TaskStackBuilder(Context a) {
        this.mSourceContext = a;
    }

    @NonNull
    public static TaskStackBuilder create(@NonNull Context context) {
        return new TaskStackBuilder(context);
    }

    @Deprecated
    public static TaskStackBuilder from(Context context) {
        return TaskStackBuilder.create(context);
    }

    @NonNull
    public TaskStackBuilder addNextIntent(@NonNull Intent nextIntent) {
        this.mIntents.add(nextIntent);
        return this;
    }

    @NonNull
    public TaskStackBuilder addNextIntentWithParentStack(@NonNull Intent nextIntent) {
        ComponentName target = nextIntent.getComponent();
        if (target == null) {
            target = nextIntent.resolveActivity(this.mSourceContext.getPackageManager());
        }
        if (target != null) {
            this.addParentStack(target);
        }
        this.addNextIntent(nextIntent);
        return this;
    }

    @NonNull
    public TaskStackBuilder addParentStack(@NonNull Activity sourceActivity) {
        Intent parent = null;
        if (sourceActivity instanceof SupportParentable) {
            parent = ((SupportParentable)sourceActivity).getSupportParentActivityIntent();
        }
        if (parent == null) {
            parent = NavUtils.getParentActivityIntent(sourceActivity);
        }
        if (parent != null) {
            ComponentName target = parent.getComponent();
            if (target == null) {
                target = parent.resolveActivity(this.mSourceContext.getPackageManager());
            }
            this.addParentStack(target);
            this.addNextIntent(parent);
        }
        return this;
    }

    @NonNull
    public TaskStackBuilder addParentStack(@NonNull Class<?> sourceActivityClass) {
        return this.addParentStack(new ComponentName(this.mSourceContext, sourceActivityClass));
    }

    @NonNull
    public TaskStackBuilder addParentStack(@NonNull ComponentName sourceActivityName) {
        int insertAt = this.mIntents.size();
        try {
            Intent parent = NavUtils.getParentActivityIntent(this.mSourceContext, sourceActivityName);
            while (parent != null) {
                this.mIntents.add(insertAt, parent);
                parent = NavUtils.getParentActivityIntent(this.mSourceContext, parent.getComponent());
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public int getIntentCount() {
        return this.mIntents.size();
    }

    @Deprecated
    public Intent getIntent(int index) {
        return this.editIntentAt(index);
    }

    @Nullable
    public Intent editIntentAt(int index) {
        return this.mIntents.get(index);
    }

    @Override
    @Deprecated
    @NonNull
    public Iterator<Intent> iterator() {
        return this.mIntents.iterator();
    }

    public void startActivities() {
        this.startActivities(null);
    }

    public void startActivities(@Nullable Bundle options) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        Intent[] intents = this.mIntents.toArray(new Intent[0]);
        intents[0] = new Intent(intents[0]).addFlags(0x1000C000);
        if (!ContextCompat.startActivities(this.mSourceContext, intents, options)) {
            Intent topIntent = new Intent(intents[intents.length - 1]);
            topIntent.addFlags(0x10000000);
            this.mSourceContext.startActivity(topIntent);
        }
    }

    @Nullable
    public PendingIntent getPendingIntent(int requestCode, int flags) {
        return this.getPendingIntent(requestCode, flags, null);
    }

    @Nullable
    public PendingIntent getPendingIntent(int requestCode, int flags, @Nullable Bundle options) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        Intent[] intents = this.mIntents.toArray(new Intent[0]);
        intents[0] = new Intent(intents[0]).addFlags(0x1000C000);
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.getActivities(this.mSourceContext, requestCode, intents, flags, options);
        }
        return PendingIntent.getActivities((Context)this.mSourceContext, (int)requestCode, (Intent[])intents, (int)flags);
    }

    @NonNull
    public Intent[] getIntents() {
        Intent[] intents = new Intent[this.mIntents.size()];
        if (intents.length == 0) {
            return intents;
        }
        intents[0] = new Intent(this.mIntents.get(0)).addFlags(0x1000C000);
        for (int i = 1; i < intents.length; ++i) {
            intents[i] = new Intent(this.mIntents.get(i));
        }
        return intents;
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags, Bundle options) {
            return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)flags, (Bundle)options);
        }
    }

    public static interface SupportParentable {
        @Nullable
        public Intent getSupportParentActivityIntent();
    }
}

