/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.location.GnssMeasurementsEvent;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.collection.SimpleArrayMap;
import androidx.core.location.GnssStatusCompat;
import androidx.core.location.LocationCompat;
import androidx.core.location.LocationListenerCompat;
import androidx.core.location.LocationRequestCompat;
import androidx.core.os.CancellationSignal;
import androidx.core.os.ExecutorCompat;
import androidx.core.util.Consumer;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class LocationManagerCompat {
    private static final long GET_CURRENT_LOCATION_TIMEOUT_MS = 30000L;
    private static final long MAX_CURRENT_LOCATION_AGE_MS = 10000L;
    private static final long PRE_N_LOOPER_TIMEOUT_S = 5L;
    private static Field sContextField;
    private static Class<?> sGnssRequestBuilderClass;
    private static Method sGnssRequestBuilderBuildMethod;
    private static Method sRegisterGnssMeasurementsCallbackMethod;
    @GuardedBy(value="sLocationListeners")
    static final WeakHashMap<LocationListenerKey, WeakReference<LocationListenerTransport>> sLocationListeners;

    public static boolean isLocationEnabled(@NonNull LocationManager locationManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.isLocationEnabled(locationManager);
        }
        if (Build.VERSION.SDK_INT <= 19) {
            try {
                Context context;
                if (sContextField == null) {
                    sContextField = LocationManager.class.getDeclaredField("mContext");
                    sContextField.setAccessible(true);
                }
                if ((context = (Context)sContextField.get(locationManager)) != null) {
                    if (Build.VERSION.SDK_INT == 19) {
                        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode", (int)0) != 0;
                    }
                    return !TextUtils.isEmpty((CharSequence)Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed"));
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return locationManager.isProviderEnabled("network") || locationManager.isProviderEnabled("gps");
    }

    public static boolean hasProvider(@NonNull LocationManager locationManager, @NonNull String provider) {
        if (Build.VERSION.SDK_INT >= 31) {
            return Api31Impl.hasProvider(locationManager, provider);
        }
        if (locationManager.getAllProviders().contains(provider)) {
            return true;
        }
        try {
            return locationManager.getProvider(provider) != null;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public static void getCurrentLocation(@NonNull LocationManager locationManager, @NonNull String provider, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull Consumer<Location> consumer) {
        long locationAgeMs;
        Location location;
        if (Build.VERSION.SDK_INT >= 30) {
            Api30Impl.getCurrentLocation(locationManager, provider, cancellationSignal, executor, consumer);
            return;
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if ((location = locationManager.getLastKnownLocation(provider)) != null && (locationAgeMs = SystemClock.elapsedRealtime() - LocationCompat.getElapsedRealtimeMillis(location)) < 10000L) {
            executor.execute(() -> consumer.accept(location));
            return;
        }
        CancellableLocationListener listener = new CancellableLocationListener(locationManager, executor, consumer);
        locationManager.requestLocationUpdates(provider, 0L, 0.0f, (LocationListener)listener, Looper.getMainLooper());
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(listener::cancel);
        }
        listener.startTimeout(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public static void requestLocationUpdates(@NonNull LocationManager locationManager, @NonNull String provider, @NonNull LocationRequestCompat locationRequest, @NonNull Executor executor, @NonNull LocationListenerCompat listener) {
        if (Build.VERSION.SDK_INT >= 31) {
            Api31Impl.requestLocationUpdates(locationManager, provider, locationRequest.toLocationRequest(), executor, listener);
            return;
        }
        if (Build.VERSION.SDK_INT >= 30 && Api30Impl.tryRequestLocationUpdates(locationManager, provider, locationRequest, executor, listener)) {
            return;
        }
        LocationListenerTransport transport = new LocationListenerTransport(new LocationListenerKey(provider, listener), executor);
        if (Build.VERSION.SDK_INT >= 19 && Api19Impl.tryRequestLocationUpdates(locationManager, provider, locationRequest, transport)) {
            return;
        }
        WeakHashMap<LocationListenerKey, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
        synchronized (weakHashMap) {
            locationManager.requestLocationUpdates(provider, locationRequest.getIntervalMillis(), locationRequest.getMinUpdateDistanceMeters(), (LocationListener)transport, Looper.getMainLooper());
            LocationManagerCompat.registerLocationListenerTransport(locationManager, transport);
        }
    }

    @GuardedBy(value="sLocationListeners")
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    static void registerLocationListenerTransport(LocationManager locationManager, LocationListenerTransport transport) {
        LocationListenerTransport oldTransport;
        WeakReference<LocationListenerTransport> oldRef = sLocationListeners.put(transport.getKey(), new WeakReference<LocationListenerTransport>(transport));
        LocationListenerTransport locationListenerTransport = oldTransport = oldRef != null ? (LocationListenerTransport)oldRef.get() : null;
        if (oldTransport != null) {
            oldTransport.unregister();
            locationManager.removeUpdates((LocationListener)oldTransport);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public static void requestLocationUpdates(@NonNull LocationManager locationManager, @NonNull String provider, @NonNull LocationRequestCompat locationRequest, @NonNull LocationListenerCompat listener, @NonNull Looper looper) {
        if (Build.VERSION.SDK_INT >= 31) {
            Api31Impl.requestLocationUpdates(locationManager, provider, locationRequest.toLocationRequest(), ExecutorCompat.create(new Handler(looper)), listener);
            return;
        }
        if (Build.VERSION.SDK_INT >= 19 && Api19Impl.tryRequestLocationUpdates(locationManager, provider, locationRequest, listener, looper)) {
            return;
        }
        locationManager.requestLocationUpdates(provider, locationRequest.getIntervalMillis(), locationRequest.getMinUpdateDistanceMeters(), (LocationListener)listener, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public static void removeUpdates(@NonNull LocationManager locationManager, @NonNull LocationListenerCompat listener) {
        WeakHashMap<LocationListenerKey, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
        synchronized (weakHashMap) {
            ArrayList<LocationListenerKey> cleanup = null;
            for (WeakReference<LocationListenerTransport> transportRef : sLocationListeners.values()) {
                LocationListenerTransport transport = (LocationListenerTransport)transportRef.get();
                if (transport == null) continue;
                LocationListenerKey key = transport.getKey();
                if (key.mListener != listener) continue;
                if (cleanup == null) {
                    cleanup = new ArrayList<LocationListenerKey>();
                }
                cleanup.add(key);
                transport.unregister();
                locationManager.removeUpdates((LocationListener)transport);
            }
            if (cleanup != null) {
                for (LocationListenerKey key : cleanup) {
                    sLocationListeners.remove(key);
                }
            }
        }
        locationManager.removeUpdates((LocationListener)listener);
    }

    @Nullable
    public static String getGnssHardwareModelName(@NonNull LocationManager locationManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getGnssHardwareModelName(locationManager);
        }
        return null;
    }

    public static int getGnssYearOfHardware(@NonNull LocationManager locationManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getGnssYearOfHardware(locationManager);
        }
        return 0;
    }

    @RequiresApi(value=24)
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public static boolean registerGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull GnssMeasurementsEvent.Callback callback, @NonNull Handler handler) {
        if (Build.VERSION.SDK_INT != 30) {
            return Api24Impl.registerGnssMeasurementsCallback(locationManager, callback, handler);
        }
        return LocationManagerCompat.registerGnssMeasurementsCallbackOnR(locationManager, ExecutorCompat.create(handler), callback);
    }

    @RequiresApi(value=30)
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public static boolean registerGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull Executor executor, @NonNull GnssMeasurementsEvent.Callback callback) {
        if (Build.VERSION.SDK_INT > 30) {
            return Api31Impl.registerGnssMeasurementsCallback(locationManager, executor, callback);
        }
        return LocationManagerCompat.registerGnssMeasurementsCallbackOnR(locationManager, executor, callback);
    }

    @RequiresApi(value=24)
    public static void unregisterGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull GnssMeasurementsEvent.Callback callback) {
        Api24Impl.unregisterGnssMeasurementsCallback(locationManager, callback);
    }

    @RequiresApi(value=30)
    private static boolean registerGnssMeasurementsCallbackOnR(@NonNull LocationManager locationManager, @NonNull Executor executor, @NonNull GnssMeasurementsEvent.Callback callback) {
        if (Build.VERSION.SDK_INT == 30) {
            try {
                Object success;
                if (sGnssRequestBuilderClass == null) {
                    sGnssRequestBuilderClass = Class.forName("android.location.GnssRequest$Builder");
                }
                if (sGnssRequestBuilderBuildMethod == null) {
                    sGnssRequestBuilderBuildMethod = sGnssRequestBuilderClass.getDeclaredMethod("build", new Class[0]);
                    sGnssRequestBuilderBuildMethod.setAccessible(true);
                }
                if (sRegisterGnssMeasurementsCallbackMethod == null) {
                    sRegisterGnssMeasurementsCallbackMethod = LocationManager.class.getDeclaredMethod("registerGnssMeasurementsCallback", Class.forName("android.location.GnssRequest"), Executor.class, GnssMeasurementsEvent.Callback.class);
                    sRegisterGnssMeasurementsCallbackMethod.setAccessible(true);
                }
                return (success = sRegisterGnssMeasurementsCallbackMethod.invoke((Object)locationManager, sGnssRequestBuilderBuildMethod.invoke(sGnssRequestBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]), executor, callback)) != null && (Boolean)success != false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public static boolean registerGnssStatusCallback(@NonNull LocationManager locationManager, @NonNull GnssStatusCompat.Callback callback, @NonNull Handler handler) {
        if (Build.VERSION.SDK_INT >= 30) {
            return LocationManagerCompat.registerGnssStatusCallback(locationManager, ExecutorCompat.create(handler), callback);
        }
        return LocationManagerCompat.registerGnssStatusCallback(locationManager, new InlineHandlerExecutor(handler), callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public static boolean registerGnssStatusCallback(@NonNull LocationManager locationManager, @NonNull Executor executor, @NonNull GnssStatusCompat.Callback callback) {
        if (Build.VERSION.SDK_INT >= 30) {
            return LocationManagerCompat.registerGnssStatusCallback(locationManager, null, executor, callback);
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        return LocationManagerCompat.registerGnssStatusCallback(locationManager, new Handler(looper), executor, callback);
    }

    /*
     * Exception decompiling
     */
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    private static boolean registerGnssStatusCallback(LocationManager locationManager, Handler baseHandler, Executor executor, GnssStatusCompat.Callback callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGnssStatusCallback(@NonNull LocationManager locationManager, @NonNull GnssStatusCompat.Callback callback) {
        if (Build.VERSION.SDK_INT >= 24) {
            SimpleArrayMap<Object, Object> simpleArrayMap = GnssListenersHolder.sGnssStatusListeners;
            synchronized (simpleArrayMap) {
                Object transport = GnssListenersHolder.sGnssStatusListeners.remove((Object)callback);
                if (transport != null) {
                    Api24Impl.unregisterGnssStatusCallback(locationManager, transport);
                }
            }
        }
        SimpleArrayMap<Object, Object> simpleArrayMap = GnssListenersHolder.sGnssStatusListeners;
        synchronized (simpleArrayMap) {
            GpsStatusTransport transport = (GpsStatusTransport)GnssListenersHolder.sGnssStatusListeners.remove((Object)callback);
            if (transport != null) {
                transport.unregister();
                locationManager.removeGpsStatusListener((GpsStatus.Listener)transport);
            }
        }
    }

    private LocationManagerCompat() {
    }

    private static /* synthetic */ Boolean lambda$registerGnssStatusCallback$1(LocationManager locationManager, GpsStatusTransport myTransport) throws Exception {
        return locationManager.addGpsStatusListener((GpsStatus.Listener)myTransport);
    }

    static {
        sLocationListeners = new WeakHashMap();
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
        @DoNotInline
        static boolean registerGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull GnssMeasurementsEvent.Callback callback, @NonNull Handler handler) {
            return locationManager.registerGnssMeasurementsCallback(callback, handler);
        }

        @DoNotInline
        static void unregisterGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull GnssMeasurementsEvent.Callback callback) {
            locationManager.unregisterGnssMeasurementsCallback(callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        @DoNotInline
        static boolean registerGnssStatusCallback(LocationManager locationManager, Handler baseHandler, Executor executor, GnssStatusCompat.Callback callback) {
            Preconditions.checkArgument(baseHandler != null);
            SimpleArrayMap<Object, Object> simpleArrayMap = GnssListenersHolder.sGnssStatusListeners;
            synchronized (simpleArrayMap) {
                PreRGnssStatusTransport transport = (PreRGnssStatusTransport)((Object)GnssListenersHolder.sGnssStatusListeners.get((Object)callback));
                if (transport == null) {
                    transport = new PreRGnssStatusTransport(callback);
                } else {
                    transport.unregister();
                }
                transport.register(executor);
                if (locationManager.registerGnssStatusCallback((GnssStatus.Callback)transport, baseHandler)) {
                    GnssListenersHolder.sGnssStatusListeners.put((Object)callback, (Object)transport);
                    return true;
                }
                return false;
            }
        }

        @DoNotInline
        static void unregisterGnssStatusCallback(LocationManager locationManager, Object callback) {
            if (callback instanceof PreRGnssStatusTransport) {
                ((PreRGnssStatusTransport)((Object)callback)).unregister();
            }
            locationManager.unregisterGnssStatusCallback((GnssStatus.Callback)callback);
        }
    }

    @RequiresApi(value=19)
    static class Api19Impl {
        private static Class<?> sLocationRequestClass;
        private static Method sRequestLocationUpdatesLooperMethod;

        private Api19Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        @DoNotInline
        static boolean tryRequestLocationUpdates(LocationManager locationManager, String provider, LocationRequestCompat locationRequest, LocationListenerTransport transport) {
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    LocationRequest request;
                    if (sLocationRequestClass == null) {
                        sLocationRequestClass = Class.forName("android.location.LocationRequest");
                    }
                    if (sRequestLocationUpdatesLooperMethod == null) {
                        sRequestLocationUpdatesLooperMethod = LocationManager.class.getDeclaredMethod("requestLocationUpdates", sLocationRequestClass, LocationListener.class, Looper.class);
                        sRequestLocationUpdatesLooperMethod.setAccessible(true);
                    }
                    if ((request = locationRequest.toLocationRequest(provider)) != null) {
                        WeakHashMap<LocationListenerKey, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
                        synchronized (weakHashMap) {
                            sRequestLocationUpdatesLooperMethod.invoke((Object)locationManager, request, transport, Looper.getMainLooper());
                            LocationManagerCompat.registerLocationListenerTransport(locationManager, transport);
                            return true;
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @DoNotInline
        static boolean tryRequestLocationUpdates(LocationManager locationManager, String provider, LocationRequestCompat locationRequest, LocationListenerCompat listener, Looper looper) {
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    LocationRequest request;
                    if (sLocationRequestClass == null) {
                        sLocationRequestClass = Class.forName("android.location.LocationRequest");
                    }
                    if (sRequestLocationUpdatesLooperMethod == null) {
                        sRequestLocationUpdatesLooperMethod = LocationManager.class.getDeclaredMethod("requestLocationUpdates", sLocationRequestClass, LocationListener.class, Looper.class);
                        sRequestLocationUpdatesLooperMethod.setAccessible(true);
                    }
                    if ((request = locationRequest.toLocationRequest(provider)) != null) {
                        sRequestLocationUpdatesLooperMethod.invoke((Object)locationManager, request, listener, looper);
                        return true;
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @RequiresApi(value=28)
    private static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static boolean isLocationEnabled(LocationManager locationManager) {
            return locationManager.isLocationEnabled();
        }

        @DoNotInline
        static String getGnssHardwareModelName(LocationManager locationManager) {
            return locationManager.getGnssHardwareModelName();
        }

        @DoNotInline
        static int getGnssYearOfHardware(LocationManager locationManager) {
            return locationManager.getGnssYearOfHardware();
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private static Class<?> sLocationRequestClass;
        private static Method sRequestLocationUpdatesExecutorMethod;

        private Api30Impl() {
        }

        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        @DoNotInline
        static void getCurrentLocation(LocationManager locationManager, @NonNull String provider, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull Consumer<Location> consumer) {
            locationManager.getCurrentLocation(provider, cancellationSignal != null ? (android.os.CancellationSignal)cancellationSignal.getCancellationSignalObject() : null, executor, consumer::accept);
        }

        @DoNotInline
        public static boolean tryRequestLocationUpdates(LocationManager locationManager, String provider, LocationRequestCompat locationRequest, Executor executor, LocationListenerCompat listener) {
            if (Build.VERSION.SDK_INT >= 30) {
                try {
                    LocationRequest request;
                    if (sLocationRequestClass == null) {
                        sLocationRequestClass = Class.forName("android.location.LocationRequest");
                    }
                    if (sRequestLocationUpdatesExecutorMethod == null) {
                        sRequestLocationUpdatesExecutorMethod = LocationManager.class.getDeclaredMethod("requestLocationUpdates", sLocationRequestClass, Executor.class, LocationListener.class);
                        sRequestLocationUpdatesExecutorMethod.setAccessible(true);
                    }
                    if ((request = locationRequest.toLocationRequest(provider)) != null) {
                        sRequestLocationUpdatesExecutorMethod.invoke((Object)locationManager, request, executor, listener);
                        return true;
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        @DoNotInline
        public static boolean registerGnssStatusCallback(LocationManager locationManager, Handler baseHandler, Executor executor, GnssStatusCompat.Callback callback) {
            SimpleArrayMap<Object, Object> simpleArrayMap = GnssListenersHolder.sGnssStatusListeners;
            synchronized (simpleArrayMap) {
                GnssStatusTransport transport = (GnssStatusTransport)((Object)GnssListenersHolder.sGnssStatusListeners.get((Object)callback));
                if (transport == null) {
                    transport = new GnssStatusTransport(callback);
                }
                if (locationManager.registerGnssStatusCallback(executor, (GnssStatus.Callback)transport)) {
                    GnssListenersHolder.sGnssStatusListeners.put((Object)callback, (Object)transport);
                    return true;
                }
                return false;
            }
        }
    }

    @RequiresApi(value=31)
    private static class Api31Impl {
        private Api31Impl() {
        }

        @DoNotInline
        static boolean hasProvider(LocationManager locationManager, @NonNull String provider) {
            return locationManager.hasProvider(provider);
        }

        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        @DoNotInline
        static void requestLocationUpdates(LocationManager locationManager, @NonNull String provider, @NonNull LocationRequest locationRequest, @NonNull Executor executor, @NonNull LocationListener listener) {
            locationManager.requestLocationUpdates(provider, locationRequest, executor, listener);
        }

        @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
        @DoNotInline
        static boolean registerGnssMeasurementsCallback(@NonNull LocationManager locationManager, @NonNull Executor executor, @NonNull GnssMeasurementsEvent.Callback callback) {
            return locationManager.registerGnssMeasurementsCallback(executor, callback);
        }
    }

    private static final class InlineHandlerExecutor
    implements Executor {
        private final Handler mHandler;

        InlineHandlerExecutor(@NonNull Handler handler) {
            this.mHandler = Preconditions.checkNotNull(handler);
        }

        @Override
        public void execute(@NonNull Runnable command) {
            if (Looper.myLooper() == this.mHandler.getLooper()) {
                command.run();
            } else if (!this.mHandler.post(Preconditions.checkNotNull(command))) {
                throw new RejectedExecutionException(this.mHandler + " is shutting down");
            }
        }
    }

    private static final class CancellableLocationListener
    implements LocationListener {
        private final LocationManager mLocationManager;
        private final Executor mExecutor;
        private final Handler mTimeoutHandler;
        private Consumer<Location> mConsumer;
        @GuardedBy(value="this")
        private boolean mTriggered;
        @Nullable
        Runnable mTimeoutRunnable;

        CancellableLocationListener(LocationManager locationManager, Executor executor, Consumer<Location> consumer) {
            this.mLocationManager = locationManager;
            this.mExecutor = executor;
            this.mTimeoutHandler = new Handler(Looper.getMainLooper());
            this.mConsumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        public void cancel() {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.mTriggered) {
                    return;
                }
                this.mTriggered = true;
            }
            this.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"MissingPermission"})
        public void startTimeout(long timeoutMs) {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.mTriggered) {
                    return;
                }
                this.mTimeoutRunnable = () -> {
                    this.mTimeoutRunnable = null;
                    this.onLocationChanged(null);
                };
                this.mTimeoutHandler.postDelayed(this.mTimeoutRunnable, timeoutMs);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(@NonNull String provider) {
        }

        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        public void onProviderDisabled(@NonNull String p) {
            this.onLocationChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        public void onLocationChanged(@Nullable Location location) {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.mTriggered) {
                    return;
                }
                this.mTriggered = true;
            }
            Consumer<Location> consumer = this.mConsumer;
            this.mExecutor.execute(() -> consumer.accept(location));
            this.cleanup();
        }

        @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
        private void cleanup() {
            this.mConsumer = null;
            this.mLocationManager.removeUpdates((LocationListener)this);
            if (this.mTimeoutRunnable != null) {
                this.mTimeoutHandler.removeCallbacks(this.mTimeoutRunnable);
                this.mTimeoutRunnable = null;
            }
        }
    }

    private static class GpsStatusTransport
    implements GpsStatus.Listener {
        private final LocationManager mLocationManager;
        final GnssStatusCompat.Callback mCallback;
        @Nullable
        volatile Executor mExecutor;

        GpsStatusTransport(LocationManager locationManager, GnssStatusCompat.Callback callback) {
            Preconditions.checkArgument(callback != null, "invalid null callback");
            this.mLocationManager = locationManager;
            this.mCallback = callback;
        }

        public void register(Executor executor) {
            Preconditions.checkState(this.mExecutor == null);
            this.mExecutor = executor;
        }

        public void unregister() {
            this.mExecutor = null;
        }

        @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
        public void onGpsStatusChanged(int event) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            switch (event) {
                case 1: {
                    executor.execute(() -> {
                        if (this.mExecutor != executor) {
                            return;
                        }
                        this.mCallback.onStarted();
                    });
                    break;
                }
                case 2: {
                    executor.execute(() -> {
                        if (this.mExecutor != executor) {
                            return;
                        }
                        this.mCallback.onStopped();
                    });
                    break;
                }
                case 3: {
                    GpsStatus gpsStatus = this.mLocationManager.getGpsStatus(null);
                    if (gpsStatus == null) break;
                    int ttff = gpsStatus.getTimeToFirstFix();
                    executor.execute(() -> {
                        if (this.mExecutor != executor) {
                            return;
                        }
                        this.mCallback.onFirstFix(ttff);
                    });
                    break;
                }
                case 4: {
                    GpsStatus gpsStatus = this.mLocationManager.getGpsStatus(null);
                    if (gpsStatus == null) break;
                    GnssStatusCompat gnssStatus = GnssStatusCompat.wrap(gpsStatus);
                    executor.execute(() -> {
                        if (this.mExecutor != executor) {
                            return;
                        }
                        this.mCallback.onSatelliteStatusChanged(gnssStatus);
                    });
                }
            }
        }
    }

    @RequiresApi(value=24)
    private static class PreRGnssStatusTransport
    extends GnssStatus.Callback {
        final GnssStatusCompat.Callback mCallback;
        @Nullable
        volatile Executor mExecutor;

        PreRGnssStatusTransport(GnssStatusCompat.Callback callback) {
            Preconditions.checkArgument(callback != null, "invalid null callback");
            this.mCallback = callback;
        }

        public void register(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkState(this.mExecutor == null);
            this.mExecutor = executor;
        }

        public void unregister() {
            this.mExecutor = null;
        }

        public void onStarted() {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(() -> {
                if (this.mExecutor != executor) {
                    return;
                }
                this.mCallback.onStarted();
            });
        }

        public void onStopped() {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(() -> {
                if (this.mExecutor != executor) {
                    return;
                }
                this.mCallback.onStopped();
            });
        }

        public void onFirstFix(int ttffMillis) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(() -> {
                if (this.mExecutor != executor) {
                    return;
                }
                this.mCallback.onFirstFix(ttffMillis);
            });
        }

        public void onSatelliteStatusChanged(GnssStatus status) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(() -> {
                if (this.mExecutor != executor) {
                    return;
                }
                this.mCallback.onSatelliteStatusChanged(GnssStatusCompat.wrap(status));
            });
        }
    }

    @RequiresApi(value=30)
    private static class GnssStatusTransport
    extends GnssStatus.Callback {
        final GnssStatusCompat.Callback mCallback;

        GnssStatusTransport(GnssStatusCompat.Callback callback) {
            Preconditions.checkArgument(callback != null, "invalid null callback");
            this.mCallback = callback;
        }

        public void onStarted() {
            this.mCallback.onStarted();
        }

        public void onStopped() {
            this.mCallback.onStopped();
        }

        public void onFirstFix(int ttffMillis) {
            this.mCallback.onFirstFix(ttffMillis);
        }

        public void onSatelliteStatusChanged(GnssStatus status) {
            this.mCallback.onSatelliteStatusChanged(GnssStatusCompat.wrap(status));
        }
    }

    private static class LocationListenerTransport
    implements LocationListener {
        @Nullable
        volatile LocationListenerKey mKey;
        final Executor mExecutor;

        LocationListenerTransport(@Nullable LocationListenerKey key, Executor executor) {
            this.mKey = key;
            this.mExecutor = executor;
        }

        public LocationListenerKey getKey() {
            return ObjectsCompat.requireNonNull(this.mKey);
        }

        public void unregister() {
            this.mKey = null;
        }

        public void onLocationChanged(@NonNull Location location) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onLocationChanged(location);
            });
        }

        public void onLocationChanged(@NonNull List<Location> locations) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onLocationChanged(locations);
            });
        }

        public void onFlushComplete(int requestCode) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onFlushComplete(requestCode);
            });
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onStatusChanged(provider, status, extras);
            });
        }

        public void onProviderEnabled(@NonNull String provider) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onProviderEnabled(provider);
            });
        }

        public void onProviderDisabled(@NonNull String provider) {
            if (this.mKey == null) {
                return;
            }
            this.mExecutor.execute(() -> {
                LocationListenerKey key = this.mKey;
                if (key == null) {
                    return;
                }
                key.mListener.onProviderDisabled(provider);
            });
        }
    }

    private static class LocationListenerKey {
        final String mProvider;
        final LocationListenerCompat mListener;

        LocationListenerKey(String provider, LocationListenerCompat listener) {
            this.mProvider = ObjectsCompat.requireNonNull(provider, "invalid null provider");
            this.mListener = ObjectsCompat.requireNonNull(listener, "invalid null listener");
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationListenerKey)) {
                return false;
            }
            LocationListenerKey that = (LocationListenerKey)o;
            return this.mProvider.equals(that.mProvider) && this.mListener.equals(that.mListener);
        }

        public int hashCode() {
            return ObjectsCompat.hash(this.mProvider, this.mListener);
        }
    }

    private static class GnssListenersHolder {
        @GuardedBy(value="sGnssStatusListeners")
        static final SimpleArrayMap<Object, Object> sGnssStatusListeners = new SimpleArrayMap();

        private GnssListenersHolder() {
        }
    }
}

