/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresOptIn;
import androidx.annotation.RestrictTo;
import java.util.Locale;

public class BuildCompat {
    private BuildCompat() {
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    protected static boolean isAtLeastPreReleaseCodename(@NonNull String codename, @NonNull String buildCodename) {
        String codenameUpper;
        if ("REL".equals(buildCodename)) {
            return false;
        }
        String buildCodenameUpper = buildCodename.toUpperCase(Locale.ROOT);
        return buildCodenameUpper.compareTo(codenameUpper = codename.toUpperCase(Locale.ROOT)) >= 0;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=24)
    public static boolean isAtLeastN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=25)
    public static boolean isAtLeastNMR1() {
        return Build.VERSION.SDK_INT >= 25;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=26)
    public static boolean isAtLeastO() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=27)
    public static boolean isAtLeastOMR1() {
        return Build.VERSION.SDK_INT >= 27;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=28)
    public static boolean isAtLeastP() {
        return Build.VERSION.SDK_INT >= 28;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=29)
    public static boolean isAtLeastQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @Deprecated
    @ChecksSdkIntAtLeast(api=30)
    public static boolean isAtLeastR() {
        return Build.VERSION.SDK_INT >= 30;
    }

    @Deprecated
    @SuppressLint(value={"RestrictedApi"})
    @ChecksSdkIntAtLeast(api=31, codename="S")
    public static boolean isAtLeastS() {
        return Build.VERSION.SDK_INT >= 31 || Build.VERSION.SDK_INT >= 30 && BuildCompat.isAtLeastPreReleaseCodename("S", Build.VERSION.CODENAME);
    }

    @Deprecated
    @PrereleaseSdkCheck
    @ChecksSdkIntAtLeast(api=32, codename="Sv2")
    public static boolean isAtLeastSv2() {
        return Build.VERSION.SDK_INT >= 32 || Build.VERSION.SDK_INT >= 31 && BuildCompat.isAtLeastPreReleaseCodename("Sv2", Build.VERSION.CODENAME);
    }

    @PrereleaseSdkCheck
    @ChecksSdkIntAtLeast(api=33, codename="Tiramisu")
    public static boolean isAtLeastT() {
        return Build.VERSION.SDK_INT >= 33 || Build.VERSION.SDK_INT >= 32 && BuildCompat.isAtLeastPreReleaseCodename("Tiramisu", Build.VERSION.CODENAME);
    }

    @PrereleaseSdkCheck
    @ChecksSdkIntAtLeast(codename="UpsideDownCake")
    public static boolean isAtLeastU() {
        return Build.VERSION.SDK_INT >= 33 && BuildCompat.isAtLeastPreReleaseCodename("UpsideDownCake", Build.VERSION.CODENAME);
    }

    @RequiresOptIn
    public static @interface PrereleaseSdkCheck {
    }
}

