/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.TooltipPopup;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewConfigurationCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
class TooltipCompatHandler
implements View.OnLongClickListener,
View.OnHoverListener,
View.OnAttachStateChangeListener {
    private static final String TAG = "TooltipCompatHandler";
    private static final long LONG_CLICK_HIDE_TIMEOUT_MS = 2500L;
    private static final long HOVER_HIDE_TIMEOUT_MS = 15000L;
    private static final long HOVER_HIDE_TIMEOUT_SHORT_MS = 3000L;
    private final View mAnchor;
    private final CharSequence mTooltipText;
    private final int mHoverSlop;
    private final Runnable mShowRunnable = () -> this.show(false);
    private final Runnable mHideRunnable = this::hide;
    private int mAnchorX;
    private int mAnchorY;
    private TooltipPopup mPopup;
    private boolean mFromTouch;
    private boolean mForceNextChangeSignificant;
    private static TooltipCompatHandler sPendingHandler;
    private static TooltipCompatHandler sActiveHandler;

    public static void setTooltipText(View view, CharSequence tooltipText) {
        if (sPendingHandler != null && TooltipCompatHandler.sPendingHandler.mAnchor == view) {
            TooltipCompatHandler.setPendingHandler(null);
        }
        if (TextUtils.isEmpty((CharSequence)tooltipText)) {
            if (sActiveHandler != null && TooltipCompatHandler.sActiveHandler.mAnchor == view) {
                sActiveHandler.hide();
            }
            view.setOnLongClickListener(null);
            view.setLongClickable(false);
            view.setOnHoverListener(null);
        } else {
            new TooltipCompatHandler(view, tooltipText);
        }
    }

    private TooltipCompatHandler(View anchor, CharSequence tooltipText) {
        this.mAnchor = anchor;
        this.mTooltipText = tooltipText;
        this.mHoverSlop = ViewConfigurationCompat.getScaledHoverSlop((ViewConfiguration)ViewConfiguration.get((Context)this.mAnchor.getContext()));
        this.forceNextChangeSignificant();
        this.mAnchor.setOnLongClickListener((View.OnLongClickListener)this);
        this.mAnchor.setOnHoverListener((View.OnHoverListener)this);
    }

    public boolean onLongClick(View v) {
        this.mAnchorX = v.getWidth() / 2;
        this.mAnchorY = v.getHeight() / 2;
        this.show(true);
        return true;
    }

    public boolean onHover(View v, MotionEvent event) {
        if (this.mPopup != null && this.mFromTouch) {
            return false;
        }
        AccessibilityManager manager = (AccessibilityManager)this.mAnchor.getContext().getSystemService("accessibility");
        if (manager.isEnabled() && manager.isTouchExplorationEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 7: {
                if (!this.mAnchor.isEnabled() || this.mPopup != null || !this.updateAnchorPos(event)) break;
                TooltipCompatHandler.setPendingHandler(this);
                break;
            }
            case 10: {
                this.forceNextChangeSignificant();
                this.hide();
            }
        }
        return false;
    }

    public void onViewAttachedToWindow(View v) {
    }

    public void onViewDetachedFromWindow(View v) {
        this.hide();
    }

    void show(boolean fromTouch) {
        if (!ViewCompat.isAttachedToWindow((View)this.mAnchor)) {
            return;
        }
        TooltipCompatHandler.setPendingHandler(null);
        if (sActiveHandler != null) {
            sActiveHandler.hide();
        }
        sActiveHandler = this;
        this.mFromTouch = fromTouch;
        this.mPopup = new TooltipPopup(this.mAnchor.getContext());
        this.mPopup.show(this.mAnchor, this.mAnchorX, this.mAnchorY, this.mFromTouch, this.mTooltipText);
        this.mAnchor.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        long timeout = this.mFromTouch ? 2500L : ((ViewCompat.getWindowSystemUiVisibility((View)this.mAnchor) & 1) == 1 ? 3000L - (long)ViewConfiguration.getLongPressTimeout() : 15000L - (long)ViewConfiguration.getLongPressTimeout());
        this.mAnchor.removeCallbacks(this.mHideRunnable);
        this.mAnchor.postDelayed(this.mHideRunnable, timeout);
    }

    void hide() {
        if (sActiveHandler == this) {
            sActiveHandler = null;
            if (this.mPopup != null) {
                this.mPopup.hide();
                this.mPopup = null;
                this.forceNextChangeSignificant();
                this.mAnchor.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            } else {
                Log.e((String)TAG, (String)"sActiveHandler.mPopup == null");
            }
        }
        if (sPendingHandler == this) {
            TooltipCompatHandler.setPendingHandler(null);
        }
        this.mAnchor.removeCallbacks(this.mHideRunnable);
    }

    private static void setPendingHandler(TooltipCompatHandler handler) {
        if (sPendingHandler != null) {
            sPendingHandler.cancelPendingShow();
        }
        if ((sPendingHandler = handler) != null) {
            sPendingHandler.scheduleShow();
        }
    }

    private void scheduleShow() {
        this.mAnchor.postDelayed(this.mShowRunnable, (long)ViewConfiguration.getLongPressTimeout());
    }

    private void cancelPendingShow() {
        this.mAnchor.removeCallbacks(this.mShowRunnable);
    }

    private boolean updateAnchorPos(MotionEvent event) {
        int newAnchorX = (int)event.getX();
        int newAnchorY = (int)event.getY();
        if (this.mForceNextChangeSignificant || Math.abs(newAnchorX - this.mAnchorX) > this.mHoverSlop || Math.abs(newAnchorY - this.mAnchorY) > this.mHoverSlop) {
            this.mAnchorX = newAnchorX;
            this.mAnchorY = newAnchorY;
            this.mForceNextChangeSignificant = false;
            return true;
        }
        return false;
    }

    private void forceNextChangeSignificant() {
        this.mForceNextChangeSignificant = true;
    }
}

