/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;

@SuppressLint(value={"PrivateConstructorForUtilityClass"})
public class AppLaunchChecker {
    private static final String SHARED_PREFS_NAME = "android.support.AppLaunchChecker";
    private static final String KEY_STARTED_FROM_LAUNCHER = "startedFromLauncher";

    public static boolean hasStartedFromLauncher(@NonNull Context context) {
        return context.getSharedPreferences(SHARED_PREFS_NAME, 0).getBoolean(KEY_STARTED_FROM_LAUNCHER, false);
    }

    public static void onActivityCreate(@NonNull Activity activity) {
        SharedPreferences sp = activity.getSharedPreferences(SHARED_PREFS_NAME, 0);
        if (sp.getBoolean(KEY_STARTED_FROM_LAUNCHER, false)) {
            return;
        }
        Intent launchIntent = activity.getIntent();
        if (launchIntent == null) {
            return;
        }
        if ("android.intent.action.MAIN".equals(launchIntent.getAction()) && (launchIntent.hasCategory("android.intent.category.LAUNCHER") || launchIntent.hasCategory("android.intent.category.LEANBACK_LAUNCHER"))) {
            sp.edit().putBoolean(KEY_STARTED_FROM_LAUNCHER, true).apply();
        }
    }

    @Deprecated
    public AppLaunchChecker() {
    }
}

