/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.view.VelocityTracker;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VelocityTrackerCompat {
    @Deprecated
    public static float getXVelocity(VelocityTracker tracker, int pointerId) {
        return tracker.getXVelocity(pointerId);
    }

    @Deprecated
    public static float getYVelocity(VelocityTracker tracker, int pointerId) {
        return tracker.getYVelocity(pointerId);
    }

    public static boolean isAxisSupported(@NonNull VelocityTracker tracker, int axis) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.isAxisSupported(tracker, axis);
        }
        return axis == 0 || axis == 1;
    }

    public static float getAxisVelocity(@NonNull VelocityTracker tracker, int axis) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.getAxisVelocity(tracker, axis);
        }
        if (axis == 0) {
            return tracker.getXVelocity();
        }
        if (axis == 1) {
            return tracker.getYVelocity();
        }
        return 0.0f;
    }

    public static float getAxisVelocity(@NonNull VelocityTracker tracker, int axis, int pointerId) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.getAxisVelocity(tracker, axis, pointerId);
        }
        if (axis == 0) {
            return tracker.getXVelocity(pointerId);
        }
        if (axis == 1) {
            return tracker.getYVelocity(pointerId);
        }
        return 0.0f;
    }

    private VelocityTrackerCompat() {
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static boolean isAxisSupported(VelocityTracker velocityTracker, int axis) {
            return velocityTracker.isAxisSupported(axis);
        }

        @DoNotInline
        static float getAxisVelocity(VelocityTracker velocityTracker, int axis, int id2) {
            return velocityTracker.getAxisVelocity(axis, id2);
        }

        @DoNotInline
        static float getAxisVelocity(VelocityTracker velocityTracker, int axis) {
            return velocityTracker.getAxisVelocity(axis);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface VelocityTrackableMotionEventAxis {
    }
}

