/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "UastHandler", "UastMethodsVisitor", "fragment-lint"})
public final class OnCreateDialogIncorrectCallbackDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Issue ISSUE;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UClass.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UastHandler(context);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(OnCreateDialogIncorrectCallbackDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"DialogFragmentCallbacksDetector", (String)"Use onCancel() and onDismiss() instead of calling setOnCancelListener() and setOnDismissListener() from onCreateDialog()", (String)"When using a `DialogFragment`, the `setOnCancelListener` and \\\n                `setOnDismissListener` callback functions within the `onCreateDialog` function \\\n                 __must not be used__ because the `DialogFragment` owns these callbacks. \\\n                 Instead the respective `onCancel` and `onDismiss` functions can be used to \\\n                 achieve the desired effect.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "fragment-lint"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector$UastHandler;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Landroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "visitClass", "", "node", "Lorg/jetbrains/uast/UClass;", "fragment-lint"})
    @SourceDebugExtension(value={"SMAP\nOnCreateDialogIncorrectCallbackDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnCreateDialogIncorrectCallbackDetector.kt\nandroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector$UastHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n13579#2,2:159\n*S KotlinDebug\n*F\n+ 1 OnCreateDialogIncorrectCallbackDetector.kt\nandroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector$UastHandler\n*L\n91#1:159,2\n*E\n"})
    private final class UastHandler
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public UastHandler(JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public void visitClass(@NotNull UClass node) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Lint.isKotlin((PsiElement)((PsiElement)this.context.getPsiFile())) && !Intrinsics.areEqual((object2 = (object = node.getSourcePsi()) instanceof KtClassOrObject ? (KtClassOrObject)object : null) != null && (object2 = KtPsiUtilKt.getSuperNames((StubBasedPsiElementBase)((StubBasedPsiElementBase)object2))) != null ? (String)CollectionsKt.firstOrNull((List)object2) : null, (Object)"DialogFragment")) {
                return;
            }
            if (!Lint.isKotlin((PsiElement)((PsiElement)this.context.getPsiFile()))) {
                UTypeReferenceExpression uTypeReferenceExpression = (UTypeReferenceExpression)CollectionsKt.firstOrNull((List)node.getUastSuperTypes());
                object = uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null;
                PsiClassReferenceType psiClassReferenceType = object instanceof PsiClassReferenceType ? (PsiClassReferenceType)object : null;
                if (!Intrinsics.areEqual((Object)(psiClassReferenceType != null ? psiClassReferenceType.getClassName() : null), (Object)"DialogFragment")) {
                    return;
                }
            }
            UMethod[] $this$forEach$iv = node.getMethods();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                UMethod element$iv;
                UMethod it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"onCreateDialog")) continue;
                UastMethodsVisitor visitor2 = new UastMethodsVisitor(this.context, it.getName());
                UExpression uExpression = it.getUastBody();
                if (uExpression == null) continue;
                uExpression.accept((UastVisitor)visitor2);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/fragment/lint/OnCreateDialogIncorrectCallbackDetector$UastMethodsVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "containingMethodName", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Ljava/lang/String;)V", "visitedMethods", "", "Lorg/jetbrains/uast/UCallExpression;", "report", "", "node", "message", "visitCallExpression", "", "fragment-lint"})
    private static final class UastMethodsVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final JavaContext context;
        @NotNull
        private final String containingMethodName;
        @NotNull
        private final Set<UCallExpression> visitedMethods;

        public UastMethodsVisitor(@NotNull JavaContext context, @NotNull String containingMethodName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)containingMethodName, (String)"containingMethodName");
            this.context = context;
            this.containingMethodName = containingMethodName;
            this.visitedMethods = new LinkedHashSet();
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.visitedMethods.contains(node)) {
                return super.visitCallExpression(node);
            }
            Object object = node.getMethodIdentifier();
            if (object == null || (object = object.getName()) == null) {
                return super.visitCallExpression(node);
            }
            Object methodName = object;
            Object object2 = methodName;
            if (Intrinsics.areEqual((Object)object2, (Object)"setOnCancelListener")) {
                this.report(this.context, node, "Use onCancel() instead of calling setOnCancelListener() from onCreateDialog()");
                this.visitedMethods.add(node);
            } else if (Intrinsics.areEqual((Object)object2, (Object)"setOnDismissListener")) {
                this.report(this.context, node, "Use onDismiss() instead of calling setOnDismissListener() from onCreateDialog()");
                this.visitedMethods.add(node);
            }
            return super.visitCallExpression(node);
        }

        private final void report(JavaContext context, UCallExpression node, String message) {
            context.report(Issues.getISSUE(), context.getLocation((UElement)node), message, null);
        }
    }
}

