/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.RecursiveMethodVisitor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "lifecycleMethods", "", "", "applicableSuperClasses", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Issues", "fragment-lint"})
@SourceDebugExtension(value={"SMAP\nUnsafeFragmentLifecycleObserverDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeFragmentLifecycleObserverDetector.kt\nandroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,260:1\n13579#2,2:261\n*S KotlinDebug\n*F\n+ 1 UnsafeFragmentLifecycleObserverDetector.kt\nandroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector\n*L\n119#1:261,2\n*E\n"})
public final class UnsafeFragmentLifecycleObserverDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private final Set<String> lifecycleMethods;
    @NotNull
    private static final Issue LIVEDATA_ISSUE;
    @NotNull
    private static final Issue BACK_PRESSED_ISSUE;
    @NotNull
    private static final Issue ADD_MENU_PROVIDER_ISSUE;

    public UnsafeFragmentLifecycleObserverDetector() {
        Object[] objectArray = new String[]{"onCreateView", "onViewCreated", "onActivityCreated", "onViewStateRestored"};
        this.lifecycleMethods = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"androidx.fragment.app.Fragment");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UMethod element$iv;
            UMethod it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!this.lifecycleMethods.contains(it.getName())) continue;
            RecursiveMethodVisitor visitor2 = new RecursiveMethodVisitor(context, declaration.getName(), it.getName());
            UExpression uExpression = it.getUastBody();
            if (uExpression == null) continue;
            uExpression.accept((UastVisitor)visitor2);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(UnsafeFragmentLifecycleObserverDetector.class, Scope.JAVA_FILE_SCOPE);
        LIVEDATA_ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FragmentLiveDataObserve", (String)"Use getViewLifecycleOwner() as the LifecycleOwner instead of a Fragment instance when observing a LiveData object.", (String)"When observing a LiveData object from a fragment's onCreateView, \\\n                onViewCreated, onActivityCreated, or onViewStateRestored method \\\n                getViewLifecycleOwner() should be used as the LifecycleOwner rather than the \\\n                Fragment instance. The Fragment lifecycle can result in the Fragment being \\\n                active longer than its view. This can lead to unexpected behavior from \\\n                LiveData objects being observed longer than the Fragment's view is active.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = new Implementation(UnsafeFragmentLifecycleObserverDetector.class, Scope.JAVA_FILE_SCOPE);
        BACK_PRESSED_ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FragmentBackPressedCallback", (String)"Use getViewLifecycleOwner() as the LifecycleOwner instead of a Fragment instance.", (String)"The Fragment lifecycle can result in a Fragment being active \\\n                longer than its view. This can lead to unexpected behavior from lifecycle aware \\\n                objects remaining active longer than the Fragment's view. To solve this issue, \\\n                getViewLifecycleOwner() should be used as a LifecycleOwner rather than the \\\n                Fragment instance once it is safe to access the view lifecycle in a \\\n                Fragment's onCreateView, onViewCreated, onActivityCreated, or \\\n                onViewStateRestored methods.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = new Implementation(UnsafeFragmentLifecycleObserverDetector.class, Scope.JAVA_FILE_SCOPE);
        ADD_MENU_PROVIDER_ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FragmentAddMenuProvider", (String)"Use getViewLifecycleOwner() as the LifecycleOwner instead of a Fragment instance.", (String)"The Fragment lifecycle can result in a Fragment being active \\\n                longer than its view. This can lead to unexpected behavior from lifecycle aware \\\n                objects remaining active longer than the Fragment's view. To solve this issue, \\\n                getViewLifecycleOwner() should be used as a LifecycleOwner rather than the \\\n                Fragment instance once it is safe to access the view lifecycle in a \\\n                Fragment's onCreateView, onViewCreated, onActivityCreated, or \\\n                onViewStateRestored methods.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/fragment/lint/UnsafeFragmentLifecycleObserverDetector$Issues;", "", "()V", "ADD_MENU_PROVIDER_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getADD_MENU_PROVIDER_ISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "BACK_PRESSED_ISSUE", "getBACK_PRESSED_ISSUE", "LIVEDATA_ISSUE", "getLIVEDATA_ISSUE", "fragment-lint"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Issue getLIVEDATA_ISSUE() {
            return LIVEDATA_ISSUE;
        }

        @NotNull
        public final Issue getBACK_PRESSED_ISSUE() {
            return BACK_PRESSED_ISSUE;
        }

        @NotNull
        public final Issue getADD_MENU_PROVIDER_ISSUE() {
            return ADD_MENU_PROVIDER_ISSUE;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

