/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001b\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/fragment/lint/UnsafeRepeatOnLifecycleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "lifecycleMethods", "", "", "containsViewLifecycleOwnerCall", "", "sourceText", "getApplicableMethodNames", "", "hasFragmentAsAncestorType", "uClass", "Lorg/jetbrains/uast/UClass;", "hasFragmentAsSuperType", "superTypes", "", "Lcom/intellij/psi/PsiType;", "([Lcom/intellij/psi/PsiType;)Z", "isCalledInViewLifecycleFunction", "uMethod", "Lorg/jetbrains/uast/UMethod;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "fragment-lint"})
@SourceDebugExtension(value={"SMAP\nUnsafeRepeatOnLifecycleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeRepeatOnLifecycleDetector.kt\nandroidx/fragment/lint/UnsafeRepeatOnLifecycleDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,126:1\n30#2:127\n30#2:128\n30#2:129\n30#2:130\n*S KotlinDebug\n*F\n+ 1 UnsafeRepeatOnLifecycleDetector.kt\nandroidx/fragment/lint/UnsafeRepeatOnLifecycleDetector\n*L\n70#1:127\n73#1:128\n76#1:129\n80#1:130\n*E\n"})
public final class UnsafeRepeatOnLifecycleDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> lifecycleMethods;
    @NotNull
    private static final Issue ISSUE;

    public UnsafeRepeatOnLifecycleDetector() {
        Object[] objectArray = new String[]{"onCreateView", "onViewCreated", "onActivityCreated", "onViewStateRestored"};
        this.lifecycleMethods = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"repeatOnLifecycle");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        UExpression uExpression;
        UExpression launchScope;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        UElement $this$getParentOfType$iv = (UElement)node;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        if (!this.hasFragmentAsAncestorType((UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UClass.class, (boolean)strict$iv))) {
            return;
        }
        $this$getParentOfType$iv = (UElement)node;
        strict$iv = true;
        $i$f$getParentOfType = false;
        if (!this.isCalledInViewLifecycleFunction((UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UMethod.class, (boolean)strict$iv))) {
            return;
        }
        UElement $this$getParentOfType$iv2 = (UElement)node;
        boolean strict$iv2 = true;
        boolean $i$f$getParentOfType2 = false;
        KotlinUFunctionCallExpression kotlinUFunctionCallExpression = (KotlinUFunctionCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv2, KotlinUFunctionCallExpression.class, (boolean)strict$iv2);
        Object object = launchScope = kotlinUFunctionCallExpression != null ? kotlinUFunctionCallExpression.getReceiver() : null;
        while (launchScope != null) {
            PsiElement psiElement = launchScope.getSourcePsi();
            if (this.containsViewLifecycleOwnerCall(psiElement != null ? psiElement.getText() : null)) break;
            UElement $this$getParentOfType$iv3 = (UElement)launchScope;
            boolean strict$iv3 = true;
            boolean $i$f$getParentOfType3 = false;
            launchScope = (UExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv3, UExpression.class, (boolean)strict$iv3);
        }
        if (!this.containsViewLifecycleOwnerCall((uExpression = launchScope) != null && (uExpression = uExpression.getSourcePsi()) != null ? uExpression.getText() : null)) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)"The repeatOnLifecycle API should be used with viewLifecycleOwner", null, (int)8, null);
        }
    }

    private final boolean containsViewLifecycleOwnerCall(String sourceText) {
        if (sourceText == null) {
            return false;
        }
        return StringsKt.contains((CharSequence)sourceText, (CharSequence)"viewLifecycleOwner", (boolean)true) || StringsKt.contains((CharSequence)sourceText, (CharSequence)"getViewLifecycleOwner", (boolean)true);
    }

    private final boolean isCalledInViewLifecycleFunction(UMethod uMethod) {
        if (uMethod == null) {
            return false;
        }
        return this.lifecycleMethods.contains(uMethod.getName());
    }

    private final boolean hasFragmentAsAncestorType(UClass uClass) {
        if (uClass == null) {
            return false;
        }
        return this.hasFragmentAsSuperType((PsiType[])uClass.getSuperTypes());
    }

    private final boolean hasFragmentAsSuperType(PsiType[] superTypes) {
        for (PsiType superType : superTypes) {
            if (Intrinsics.areEqual((Object)superType.getCanonicalText(), (Object)"androidx.fragment.app.DialogFragment")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)superType.getCanonicalText(), (Object)"androidx.fragment.app.Fragment")) {
                return true;
            }
            PsiType[] psiTypeArray = superType.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"superType.superTypes");
            if (!this.hasFragmentAsSuperType(psiTypeArray)) continue;
            return true;
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(UnsafeRepeatOnLifecycleDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnsafeRepeatOnLifecycleDetector", (String)"RepeatOnLifecycle should be used with viewLifecycleOwner in Fragments.", (String)"The repeatOnLifecycle APIs should be used with the viewLifecycleOwner \\\n                in Fragments as opposed to lifecycleOwner.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/fragment/lint/UnsafeRepeatOnLifecycleDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "fragment-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

