/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.BasePendingResult;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public final class OptionalPendingResultImpl<R extends Result>
extends OptionalPendingResult<R> {
    private final BasePendingResult zaa;

    @Override
    @NonNull
    public final R await() {
        return this.zaa.await();
    }

    @Override
    @NonNull
    public final R await(long l, @NonNull TimeUnit timeUnit) {
        return this.zaa.await(l, timeUnit);
    }

    @Override
    @NonNull
    public final R get() {
        if (!((OptionalPendingResultImpl)object).zaa.isReady()) {
            Object object = new IllegalStateException("Result is not available. Check that isDone() returns true before calling get().");
            throw object;
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        return ((OptionalPendingResultImpl)object).zaa.await(0L, timeUnit);
    }

    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        return ((PendingResult)this.zaa).then(resultTransform);
    }

    public OptionalPendingResultImpl(@NonNull PendingResult pendingResult) {
        this.zaa = (BasePendingResult)pendingResult;
    }

    @Override
    public final void addStatusListener(@NonNull PendingResult.StatusListener statusListener) {
        ((PendingResult)this.zaa).addStatusListener(statusListener);
    }

    @Override
    public final void cancel() {
        this.zaa.cancel();
    }

    @Override
    public final void setResultCallback(@NonNull ResultCallback<? super R> resultCallback) {
        this.zaa.setResultCallback(resultCallback);
    }

    @Override
    public final void setResultCallback(@NonNull ResultCallback<? super R> resultCallback, long l, @NonNull TimeUnit timeUnit) {
        this.zaa.setResultCallback(resultCallback, l, timeUnit);
    }

    @Override
    public final boolean isCanceled() {
        return this.zaa.isCanceled();
    }

    @Override
    public final boolean isDone() {
        return this.zaa.isReady();
    }
}

