/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.app.SharedElementCallback;
import androidx.core.os.CancellationSignal;
import androidx.core.util.Preconditions;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentAnim;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.FragmentTransitionImpl;
import androidx.fragment.app.SpecialEffectsController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DefaultSpecialEffectsController
extends SpecialEffectsController {
    DefaultSpecialEffectsController(@NonNull ViewGroup container) {
        super(container);
    }

    @Override
    void executeOperations(@NonNull List<SpecialEffectsController.Operation> operations, boolean isPop) {
        SpecialEffectsController.Operation firstOut = null;
        SpecialEffectsController.Operation lastIn = null;
        for (SpecialEffectsController.Operation operation : operations) {
            SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.from(operation.getFragment().mView);
            switch (operation.getFinalState()) {
                case GONE: 
                case INVISIBLE: 
                case REMOVED: {
                    if (currentState != SpecialEffectsController.Operation.State.VISIBLE || firstOut != null) break;
                    firstOut = operation;
                    break;
                }
                case VISIBLE: {
                    if (currentState == SpecialEffectsController.Operation.State.VISIBLE) break;
                    lastIn = operation;
                }
            }
        }
        ArrayList<AnimationInfo> animations = new ArrayList<AnimationInfo>();
        ArrayList<TransitionInfo> transitions = new ArrayList<TransitionInfo>();
        final ArrayList<SpecialEffectsController.Operation> awaitingContainerChanges = new ArrayList<SpecialEffectsController.Operation>(operations);
        for (final SpecialEffectsController.Operation operation : operations) {
            CancellationSignal animCancellationSignal = new CancellationSignal();
            operation.markStartedSpecialEffect(animCancellationSignal);
            animations.add(new AnimationInfo(operation, animCancellationSignal, isPop));
            CancellationSignal transitionCancellationSignal = new CancellationSignal();
            operation.markStartedSpecialEffect(transitionCancellationSignal);
            transitions.add(new TransitionInfo(operation, transitionCancellationSignal, isPop, isPop ? operation == firstOut : operation == lastIn));
            operation.addCompletionListener(new Runnable(){

                @Override
                public void run() {
                    if (awaitingContainerChanges.contains(operation)) {
                        awaitingContainerChanges.remove(operation);
                        DefaultSpecialEffectsController.this.applyContainerChanges(operation);
                    }
                }
            });
        }
        Map<SpecialEffectsController.Operation, Boolean> startedTransitions = this.startTransitions(transitions, awaitingContainerChanges, isPop, firstOut, lastIn);
        boolean startedAnyTransition = startedTransitions.containsValue(true);
        this.startAnimations(animations, awaitingContainerChanges, startedAnyTransition, startedTransitions);
        for (SpecialEffectsController.Operation operation : awaitingContainerChanges) {
            this.applyContainerChanges(operation);
        }
        awaitingContainerChanges.clear();
    }

    private void startAnimations(@NonNull List<AnimationInfo> animationInfos, @NonNull List<SpecialEffectsController.Operation> awaitingContainerChanges, boolean startedAnyTransition, @NonNull Map<SpecialEffectsController.Operation, Boolean> startedTransitions) {
        final ViewGroup container = this.getContainer();
        Context context = container.getContext();
        ArrayList<AnimationInfo> animationsToRun = new ArrayList<AnimationInfo>();
        boolean startedAnyAnimator = false;
        for (final AnimationInfo animationInfo : animationInfos) {
            boolean isHideOperation;
            if (animationInfo.isVisibilityUnchanged()) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            FragmentAnim.AnimationOrAnimator anim2 = animationInfo.getAnimation(context);
            if (anim2 == null) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            final Animator animator2 = anim2.animator;
            if (animator2 == null) {
                animationsToRun.add(animationInfo);
                continue;
            }
            final SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            boolean startedTransition = Boolean.TRUE.equals(startedTransitions.get(operation));
            if (startedTransition) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animator set on " + fragment + " as this Fragment was involved in a Transition."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            startedAnyAnimator = true;
            boolean bl = isHideOperation = operation.getFinalState() == SpecialEffectsController.Operation.State.GONE;
            if (isHideOperation) {
                awaitingContainerChanges.remove(operation);
            }
            final View viewToAnimate = fragment.mView;
            container.startViewTransition(viewToAnimate);
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator anim2) {
                    container.endViewTransition(viewToAnimate);
                    if (isHideOperation) {
                        operation.getFinalState().applyState(viewToAnimate);
                    }
                    animationInfo.completeSpecialEffect();
                }
            });
            animator2.setTarget((Object)viewToAnimate);
            animator2.start();
            CancellationSignal signal = animationInfo.getSignal();
            signal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                public void onCancel() {
                    animator2.end();
                }
            });
        }
        for (final AnimationInfo animationInfo : animationsToRun) {
            SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            if (startedAnyTransition) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Transitions."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            if (startedAnyAnimator) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Animators."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            final View viewToAnimate = fragment.mView;
            Animation anim3 = (Animation)Preconditions.checkNotNull((Object)((FragmentAnim.AnimationOrAnimator)Preconditions.checkNotNull((Object)animationInfo.getAnimation((Context)context))).animation);
            SpecialEffectsController.Operation.State finalState = operation.getFinalState();
            if (finalState != SpecialEffectsController.Operation.State.REMOVED) {
                viewToAnimate.startAnimation(anim3);
                animationInfo.completeSpecialEffect();
            } else {
                container.startViewTransition(viewToAnimate);
                FragmentAnim.EndViewTransitionAnimation animation = new FragmentAnim.EndViewTransitionAnimation(anim3, container, viewToAnimate);
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        container.post(new Runnable(){

                            @Override
                            public void run() {
                                container.endViewTransition(viewToAnimate);
                                animationInfo.completeSpecialEffect();
                            }
                        });
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                viewToAnimate.startAnimation((Animation)animation);
            }
            CancellationSignal signal = animationInfo.getSignal();
            signal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                public void onCancel() {
                    viewToAnimate.clearAnimation();
                    container.endViewTransition(viewToAnimate);
                    animationInfo.completeSpecialEffect();
                }
            });
        }
    }

    @NonNull
    private Map<SpecialEffectsController.Operation, Boolean> startTransitions(@NonNull List<TransitionInfo> transitionInfos, @NonNull List<SpecialEffectsController.Operation> awaitingContainerChanges, final boolean isPop, final @Nullable SpecialEffectsController.Operation firstOut, final @Nullable SpecialEffectsController.Operation lastIn) {
        SpecialEffectsController.Operation operation;
        Object transition;
        HashMap<SpecialEffectsController.Operation, Boolean> startedTransitions = new HashMap<SpecialEffectsController.Operation, Boolean>();
        FragmentTransitionImpl transitionImpl = null;
        for (TransitionInfo transitionInfo : transitionInfos) {
            if (transitionInfo.isVisibilityUnchanged()) continue;
            FragmentTransitionImpl handlingImpl = transitionInfo.getHandlingImpl();
            if (transitionImpl == null) {
                transitionImpl = handlingImpl;
                continue;
            }
            if (handlingImpl == null || transitionImpl == handlingImpl) continue;
            throw new IllegalArgumentException("Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + transitionInfo.getOperation().getFragment() + " returned Transition " + transitionInfo.getTransition() + " which uses a different Transition  type than other Fragments.");
        }
        if (transitionImpl == null) {
            for (TransitionInfo transitionInfo : transitionInfos) {
                startedTransitions.put(transitionInfo.getOperation(), false);
                transitionInfo.completeSpecialEffect();
            }
            return startedTransitions;
        }
        View nonExistentView = new View(this.getContainer().getContext());
        Object sharedElementTransition = null;
        View firstOutEpicenterView = null;
        boolean hasLastInEpicenter = false;
        final Rect lastInEpicenterRect = new Rect();
        ArrayList<View> sharedElementFirstOutViews = new ArrayList<View>();
        ArrayList<View> sharedElementLastInViews = new ArrayList<View>();
        ArrayMap sharedElementNameMapping = new ArrayMap();
        for (TransitionInfo transitionInfo : transitionInfos) {
            String epicenterViewName;
            View lastInEpicenterView;
            SharedElementCallback enteringCallback;
            SharedElementCallback exitingCallback;
            boolean hasSharedElementTransition = transitionInfo.hasSharedElementTransition();
            if (!hasSharedElementTransition || firstOut == null || lastIn == null) continue;
            sharedElementTransition = transitionImpl.wrapTransitionInSet(transitionImpl.cloneTransition(transitionInfo.getSharedElementTransition()));
            ArrayList<String> exitingNames = lastIn.getFragment().getSharedElementSourceNames();
            ArrayList<String> firstOutSourceNames = firstOut.getFragment().getSharedElementSourceNames();
            ArrayList<String> firstOutTargetNames = firstOut.getFragment().getSharedElementTargetNames();
            for (int index = 0; index < firstOutTargetNames.size(); ++index) {
                int nameIndex = exitingNames.indexOf(firstOutTargetNames.get(index));
                if (nameIndex == -1) continue;
                exitingNames.set(nameIndex, firstOutSourceNames.get(index));
            }
            ArrayList<String> enteringNames = lastIn.getFragment().getSharedElementTargetNames();
            if (!isPop) {
                exitingCallback = firstOut.getFragment().getExitTransitionCallback();
                enteringCallback = lastIn.getFragment().getEnterTransitionCallback();
            } else {
                exitingCallback = firstOut.getFragment().getEnterTransitionCallback();
                enteringCallback = lastIn.getFragment().getExitTransitionCallback();
            }
            int numSharedElements = exitingNames.size();
            for (int i = 0; i < numSharedElements; ++i) {
                String exitingName = (String)exitingNames.get(i);
                String enteringName = enteringNames.get(i);
                sharedElementNameMapping.put((Object)exitingName, (Object)enteringName);
            }
            ArrayMap firstOutViews = new ArrayMap();
            this.findNamedViews((Map<String, View>)firstOutViews, firstOut.getFragment().mView);
            firstOutViews.retainAll((Collection)exitingNames);
            if (exitingCallback != null) {
                exitingCallback.onMapSharedElements((List)exitingNames, (Map)firstOutViews);
                for (int i = exitingNames.size() - 1; i >= 0; --i) {
                    String name = (String)exitingNames.get(i);
                    View view = (View)firstOutViews.get((Object)name);
                    if (view == null) {
                        sharedElementNameMapping.remove((Object)name);
                        continue;
                    }
                    if (name.equals(ViewCompat.getTransitionName((View)view))) continue;
                    String targetValue = (String)sharedElementNameMapping.remove((Object)name);
                    sharedElementNameMapping.put((Object)ViewCompat.getTransitionName((View)view), (Object)targetValue);
                }
            } else {
                sharedElementNameMapping.retainAll((Collection)firstOutViews.keySet());
            }
            final ArrayMap lastInViews = new ArrayMap();
            this.findNamedViews((Map<String, View>)lastInViews, lastIn.getFragment().mView);
            lastInViews.retainAll(enteringNames);
            lastInViews.retainAll(sharedElementNameMapping.values());
            if (enteringCallback != null) {
                enteringCallback.onMapSharedElements(enteringNames, (Map)lastInViews);
                for (int i = enteringNames.size() - 1; i >= 0; --i) {
                    String key;
                    String name = enteringNames.get(i);
                    View view = (View)lastInViews.get((Object)name);
                    if (view == null) {
                        key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name);
                        if (key == null) continue;
                        sharedElementNameMapping.remove((Object)key);
                        continue;
                    }
                    if (name.equals(ViewCompat.getTransitionName((View)view)) || (key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name)) == null) continue;
                    sharedElementNameMapping.put((Object)key, (Object)ViewCompat.getTransitionName((View)view));
                }
            } else {
                FragmentTransition.retainValues((ArrayMap<String, String>)sharedElementNameMapping, (ArrayMap<String, View>)lastInViews);
            }
            this.retainMatchingViews((ArrayMap<String, View>)firstOutViews, sharedElementNameMapping.keySet());
            this.retainMatchingViews((ArrayMap<String, View>)lastInViews, sharedElementNameMapping.values());
            if (sharedElementNameMapping.isEmpty()) {
                sharedElementTransition = null;
                sharedElementFirstOutViews.clear();
                sharedElementLastInViews.clear();
                continue;
            }
            FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), isPop, (ArrayMap<String, View>)firstOutViews, true);
            OneShotPreDrawListener.add((View)this.getContainer(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), isPop, (ArrayMap<String, View>)lastInViews, false);
                }
            });
            sharedElementFirstOutViews.addAll(firstOutViews.values());
            if (!exitingNames.isEmpty()) {
                String epicenterViewName2 = (String)exitingNames.get(0);
                firstOutEpicenterView = (View)firstOutViews.get((Object)epicenterViewName2);
                transitionImpl.setEpicenter(sharedElementTransition, firstOutEpicenterView);
            }
            sharedElementLastInViews.addAll(lastInViews.values());
            if (!enteringNames.isEmpty() && (lastInEpicenterView = (View)lastInViews.get((Object)(epicenterViewName = enteringNames.get(0)))) != null) {
                hasLastInEpicenter = true;
                final FragmentTransitionImpl impl = transitionImpl;
                OneShotPreDrawListener.add((View)this.getContainer(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        impl.getBoundsOnScreen(lastInEpicenterView, lastInEpicenterRect);
                    }
                });
            }
            transitionImpl.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementFirstOutViews);
            transitionImpl.scheduleRemoveTargets(sharedElementTransition, null, null, null, null, sharedElementTransition, sharedElementLastInViews);
            startedTransitions.put(firstOut, true);
            startedTransitions.put(lastIn, true);
        }
        ArrayList<View> enteringViews = new ArrayList<View>();
        Object mergedTransition = null;
        Object mergedNonOverlappingTransition = null;
        for (final TransitionInfo transitionInfo : transitionInfos) {
            boolean involvedInSharedElementTransition;
            if (transitionInfo.isVisibilityUnchanged()) {
                startedTransitions.put(transitionInfo.getOperation(), false);
                transitionInfo.completeSpecialEffect();
                continue;
            }
            transition = transitionImpl.cloneTransition(transitionInfo.getTransition());
            operation = transitionInfo.getOperation();
            boolean bl = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition == null) {
                if (involvedInSharedElementTransition) continue;
                startedTransitions.put(operation, false);
                transitionInfo.completeSpecialEffect();
                continue;
            }
            final ArrayList<View> transitioningViews = new ArrayList<View>();
            this.captureTransitioningViews(transitioningViews, operation.getFragment().mView);
            if (involvedInSharedElementTransition) {
                if (operation == firstOut) {
                    transitioningViews.removeAll(sharedElementFirstOutViews);
                } else {
                    transitioningViews.removeAll(sharedElementLastInViews);
                }
            }
            if (transitioningViews.isEmpty()) {
                transitionImpl.addTarget(transition, nonExistentView);
            } else {
                transitionImpl.addTargets(transition, transitioningViews);
                transitionImpl.scheduleRemoveTargets(transition, transition, transitioningViews, null, null, null, null);
                if (operation.getFinalState() == SpecialEffectsController.Operation.State.GONE) {
                    awaitingContainerChanges.remove(operation);
                    ArrayList<View> transitioningViewsToHide = new ArrayList<View>(transitioningViews);
                    transitioningViewsToHide.remove(operation.getFragment().mView);
                    transitionImpl.scheduleHideFragmentView(transition, operation.getFragment().mView, transitioningViewsToHide);
                    OneShotPreDrawListener.add((View)this.getContainer(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FragmentTransition.setViewVisibility(transitioningViews, 4);
                        }
                    });
                }
            }
            if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                enteringViews.addAll(transitioningViews);
                if (hasLastInEpicenter) {
                    transitionImpl.setEpicenter(transition, lastInEpicenterRect);
                }
            } else {
                transitionImpl.setEpicenter(transition, firstOutEpicenterView);
            }
            startedTransitions.put(operation, true);
            if (transitionInfo.isOverlapAllowed()) {
                mergedTransition = transitionImpl.mergeTransitionsTogether(mergedTransition, transition, null);
                continue;
            }
            mergedNonOverlappingTransition = transitionImpl.mergeTransitionsTogether(mergedNonOverlappingTransition, transition, null);
        }
        mergedTransition = transitionImpl.mergeTransitionsInSequence(mergedTransition, mergedNonOverlappingTransition, sharedElementTransition);
        for (final TransitionInfo transitionInfo : transitionInfos) {
            boolean involvedInSharedElementTransition;
            if (transitionInfo.isVisibilityUnchanged()) continue;
            transition = transitionInfo.getTransition();
            operation = transitionInfo.getOperation();
            boolean bl = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition == null && !involvedInSharedElementTransition) continue;
            if (!ViewCompat.isLaidOut((View)this.getContainer())) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Container " + this.getContainer() + " has not been laid out. Completing operation " + operation));
                }
                transitionInfo.completeSpecialEffect();
                continue;
            }
            transitionImpl.setListenerForTransitionEnd(transitionInfo.getOperation().getFragment(), mergedTransition, transitionInfo.getSignal(), new Runnable(){

                @Override
                public void run() {
                    transitionInfo.completeSpecialEffect();
                }
            });
        }
        if (!ViewCompat.isLaidOut((View)this.getContainer())) {
            return startedTransitions;
        }
        FragmentTransition.setViewVisibility(enteringViews, 4);
        ArrayList<String> inNames = transitionImpl.prepareSetNameOverridesReordered(sharedElementLastInViews);
        transitionImpl.beginDelayedTransition(this.getContainer(), mergedTransition);
        transitionImpl.setNameOverridesReordered((View)this.getContainer(), sharedElementFirstOutViews, sharedElementLastInViews, inNames, (Map<String, String>)sharedElementNameMapping);
        FragmentTransition.setViewVisibility(enteringViews, 0);
        transitionImpl.swapSharedElementTargets(sharedElementTransition, sharedElementFirstOutViews, sharedElementLastInViews);
        return startedTransitions;
    }

    void retainMatchingViews(@NonNull ArrayMap<String, View> sharedElementViews, @NonNull Collection<String> transitionNames) {
        Iterator iterator = sharedElementViews.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (transitionNames.contains(ViewCompat.getTransitionName((View)((View)entry.getValue())))) continue;
            iterator.remove();
        }
    }

    void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (ViewGroupCompat.isTransitionGroup((ViewGroup)viewGroup)) {
                if (!transitioningViews.contains(view)) {
                    transitioningViews.add((View)viewGroup);
                }
            } else {
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = viewGroup.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    this.captureTransitioningViews(transitioningViews, child);
                }
            }
        } else if (!transitioningViews.contains(view)) {
            transitioningViews.add(view);
        }
    }

    void findNamedViews(Map<String, View> namedViews, @NonNull View view) {
        String transitionName = ViewCompat.getTransitionName((View)view);
        if (transitionName != null) {
            namedViews.put(transitionName, view);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                this.findNamedViews(namedViews, child);
            }
        }
    }

    void applyContainerChanges(@NonNull SpecialEffectsController.Operation operation) {
        View view = operation.getFragment().mView;
        operation.getFinalState().applyState(view);
    }

    private static class TransitionInfo
    extends SpecialEffectsInfo {
        @Nullable
        private final Object mTransition;
        private final boolean mOverlapAllowed;
        @Nullable
        private final Object mSharedElementTransition;

        TransitionInfo(@NonNull SpecialEffectsController.Operation operation, @NonNull CancellationSignal signal, boolean isPop, boolean providesSharedElementTransition) {
            super(operation, signal);
            if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                this.mTransition = isPop ? operation.getFragment().getReenterTransition() : operation.getFragment().getEnterTransition();
                this.mOverlapAllowed = isPop ? operation.getFragment().getAllowReturnTransitionOverlap() : operation.getFragment().getAllowEnterTransitionOverlap();
            } else {
                this.mTransition = isPop ? operation.getFragment().getReturnTransition() : operation.getFragment().getExitTransition();
                this.mOverlapAllowed = true;
            }
            this.mSharedElementTransition = providesSharedElementTransition ? (isPop ? operation.getFragment().getSharedElementReturnTransition() : operation.getFragment().getSharedElementEnterTransition()) : null;
        }

        @Nullable
        Object getTransition() {
            return this.mTransition;
        }

        boolean isOverlapAllowed() {
            return this.mOverlapAllowed;
        }

        public boolean hasSharedElementTransition() {
            return this.mSharedElementTransition != null;
        }

        @Nullable
        public Object getSharedElementTransition() {
            return this.mSharedElementTransition;
        }

        @Nullable
        FragmentTransitionImpl getHandlingImpl() {
            FragmentTransitionImpl transitionImpl = this.getHandlingImpl(this.mTransition);
            FragmentTransitionImpl sharedElementTransitionImpl = this.getHandlingImpl(this.mSharedElementTransition);
            if (transitionImpl != null && sharedElementTransitionImpl != null && transitionImpl != sharedElementTransitionImpl) {
                throw new IllegalArgumentException("Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + this.getOperation().getFragment() + " returned Transition " + this.mTransition + " which uses a different Transition  type than its shared element transition " + this.mSharedElementTransition);
            }
            return transitionImpl != null ? transitionImpl : sharedElementTransitionImpl;
        }

        @Nullable
        private FragmentTransitionImpl getHandlingImpl(Object transition) {
            if (transition == null) {
                return null;
            }
            if (FragmentTransition.PLATFORM_IMPL != null && FragmentTransition.PLATFORM_IMPL.canHandle(transition)) {
                return FragmentTransition.PLATFORM_IMPL;
            }
            if (FragmentTransition.SUPPORT_IMPL != null && FragmentTransition.SUPPORT_IMPL.canHandle(transition)) {
                return FragmentTransition.SUPPORT_IMPL;
            }
            throw new IllegalArgumentException("Transition " + transition + " for fragment " + this.getOperation().getFragment() + " is not a valid framework Transition or AndroidX Transition");
        }
    }

    private static class AnimationInfo
    extends SpecialEffectsInfo {
        private boolean mIsPop;
        private boolean mLoadedAnim = false;
        @Nullable
        private FragmentAnim.AnimationOrAnimator mAnimation;

        AnimationInfo(@NonNull SpecialEffectsController.Operation operation, @NonNull CancellationSignal signal, boolean isPop) {
            super(operation, signal);
            this.mIsPop = isPop;
        }

        @Nullable
        FragmentAnim.AnimationOrAnimator getAnimation(@NonNull Context context) {
            if (this.mLoadedAnim) {
                return this.mAnimation;
            }
            this.mAnimation = FragmentAnim.loadAnimation(context, this.getOperation().getFragment(), this.getOperation().getFinalState() == SpecialEffectsController.Operation.State.VISIBLE, this.mIsPop);
            this.mLoadedAnim = true;
            return this.mAnimation;
        }
    }

    private static class SpecialEffectsInfo {
        @NonNull
        private final SpecialEffectsController.Operation mOperation;
        @NonNull
        private final CancellationSignal mSignal;

        SpecialEffectsInfo(@NonNull SpecialEffectsController.Operation operation, @NonNull CancellationSignal signal) {
            this.mOperation = operation;
            this.mSignal = signal;
        }

        @NonNull
        SpecialEffectsController.Operation getOperation() {
            return this.mOperation;
        }

        @NonNull
        CancellationSignal getSignal() {
            return this.mSignal;
        }

        boolean isVisibilityUnchanged() {
            SpecialEffectsController.Operation.State finalState;
            SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.from(this.mOperation.getFragment().mView);
            return currentState == (finalState = this.mOperation.getFinalState()) || currentState != SpecialEffectsController.Operation.State.VISIBLE && finalState != SpecialEffectsController.Operation.State.VISIBLE;
        }

        void completeSpecialEffect() {
            this.mOperation.completeSpecialEffect(this.mSignal);
        }
    }
}

