/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.IdRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.collection.ArraySet;
import androidx.core.os.CancellationSignal;
import androidx.fragment.R;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.DefaultSpecialEffectsController;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentAnim;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentLayoutInflaterFactory;
import androidx.fragment.app.FragmentLifecycleCallbacksDispatcher;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentOnAttachListener;
import androidx.fragment.app.FragmentResultListener;
import androidx.fragment.app.FragmentResultOwner;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.FragmentStateManagerControl;
import androidx.fragment.app.FragmentStore;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.LogWriter;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FragmentManager
implements FragmentResultOwner {
    private static boolean DEBUG = false;
    static final String TAG = "FragmentManager";
    static boolean USE_STATE_MANAGER = true;
    public static final int POP_BACK_STACK_INCLUSIVE = 1;
    private final ArrayList<OpGenerator> mPendingActions = new ArrayList();
    private boolean mExecutingActions;
    private final FragmentStore mFragmentStore = new FragmentStore();
    ArrayList<BackStackRecord> mBackStack;
    private ArrayList<Fragment> mCreatedMenus;
    private final FragmentLayoutInflaterFactory mLayoutInflaterFactory = new FragmentLayoutInflaterFactory(this);
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    private final OnBackPressedCallback mOnBackPressedCallback = new OnBackPressedCallback(false){

        public void handleOnBackPressed() {
            FragmentManager.this.handleOnBackPressed();
        }
    };
    private final AtomicInteger mBackStackIndex = new AtomicInteger();
    private final Map<String, Bundle> mResults = Collections.synchronizedMap(new HashMap());
    private final Map<String, LifecycleAwareResultListener> mResultListeners = Collections.synchronizedMap(new HashMap());
    private ArrayList<OnBackStackChangedListener> mBackStackChangeListeners;
    private Map<Fragment, HashSet<CancellationSignal>> mExitAnimationCancellationSignals = Collections.synchronizedMap(new HashMap());
    private final FragmentTransition.Callback mFragmentTransitionCallback = new FragmentTransition.Callback(){

        @Override
        public void onStart(@NonNull Fragment fragment, @NonNull CancellationSignal signal) {
            FragmentManager.this.addCancellationSignal(fragment, signal);
        }

        @Override
        public void onComplete(@NonNull Fragment f, @NonNull CancellationSignal signal) {
            if (!signal.isCanceled()) {
                FragmentManager.this.removeCancellationSignal(f, signal);
            }
        }
    };
    private final FragmentLifecycleCallbacksDispatcher mLifecycleCallbacksDispatcher = new FragmentLifecycleCallbacksDispatcher(this);
    private final CopyOnWriteArrayList<FragmentOnAttachListener> mOnAttachListeners = new CopyOnWriteArrayList();
    int mCurState = -1;
    private FragmentHostCallback<?> mHost;
    private FragmentContainer mContainer;
    private Fragment mParent;
    @Nullable
    Fragment mPrimaryNav;
    private FragmentFactory mFragmentFactory = null;
    private FragmentFactory mHostFragmentFactory = new FragmentFactory(){

        @Override
        @NonNull
        public Fragment instantiate(@NonNull ClassLoader classLoader, @NonNull String className) {
            return FragmentManager.this.getHost().instantiate(FragmentManager.this.getHost().getContext(), className, null);
        }
    };
    private SpecialEffectsControllerFactory mSpecialEffectsControllerFactory = null;
    private SpecialEffectsControllerFactory mDefaultSpecialEffectsControllerFactory = new SpecialEffectsControllerFactory(){

        @Override
        @NonNull
        public SpecialEffectsController createController(@NonNull ViewGroup container) {
            return new DefaultSpecialEffectsController(container);
        }
    };
    private ActivityResultLauncher<Intent> mStartActivityForResult;
    private ActivityResultLauncher<IntentSenderRequest> mStartIntentSenderForResult;
    private ActivityResultLauncher<String[]> mRequestPermissions;
    ArrayDeque<LaunchedFragmentInfo> mLaunchedFragments = new ArrayDeque();
    private static final String EXTRA_CREATED_FILLIN_INTENT = "androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE";
    private boolean mNeedMenuInvalidate;
    private boolean mStateSaved;
    private boolean mStopped;
    private boolean mDestroyed;
    private boolean mHavePendingDeferredStart;
    private ArrayList<BackStackRecord> mTmpRecords;
    private ArrayList<Boolean> mTmpIsPop;
    private ArrayList<Fragment> mTmpAddedFragments;
    private ArrayList<StartEnterTransitionListener> mPostponedTransactions;
    private FragmentManagerViewModel mNonConfig;
    private Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManager.this.execPendingActions(true);
        }
    };

    @FragmentStateManagerControl
    public static void enableNewStateManager(boolean enabled) {
        USE_STATE_MANAGER = enabled;
    }

    @Deprecated
    public static void enableDebugLogging(boolean enabled) {
        DEBUG = enabled;
    }

    static boolean isLoggingEnabled(int level) {
        return DEBUG || Log.isLoggable((String)TAG, (int)level);
    }

    private void throwException(RuntimeException ex) {
        Log.e((String)TAG, (String)ex.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        LogWriter logw = new LogWriter(TAG);
        PrintWriter pw = new PrintWriter(logw);
        if (this.mHost != null) {
            try {
                this.mHost.onDump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        } else {
            try {
                this.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        }
        throw ex;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    public FragmentTransaction openTransaction() {
        return this.beginTransaction();
    }

    @NonNull
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public boolean executePendingTransactions() {
        boolean updates = this.execPendingActions(true);
        this.forcePostponedTransactions();
        return updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnBackPressedCallbackEnabled() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (!this.mPendingActions.isEmpty()) {
                this.mOnBackPressedCallback.setEnabled(true);
                return;
            }
        }
        this.mOnBackPressedCallback.setEnabled(this.getBackStackEntryCount() > 0 && this.isPrimaryNavigation(this.mParent));
    }

    boolean isPrimaryNavigation(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        FragmentManager parentFragmentManager = parent.mFragmentManager;
        Fragment primaryNavigationFragment = parentFragmentManager.getPrimaryNavigationFragment();
        return parent.equals(primaryNavigationFragment) && this.isPrimaryNavigation(parentFragmentManager.mParent);
    }

    boolean isParentMenuVisible(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        return parent.isMenuVisible();
    }

    void handleOnBackPressed() {
        this.execPendingActions(true);
        if (this.mOnBackPressedCallback.isEnabled()) {
            this.popBackStackImmediate();
        } else {
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    public boolean popBackStackImmediate() {
        return this.popBackStackImmediate(null, -1, 0);
    }

    public void popBackStack(@Nullable String name, int flags) {
        this.enqueueAction(new PopBackStackState(name, -1, flags), false);
    }

    public boolean popBackStackImmediate(@Nullable String name, int flags) {
        return this.popBackStackImmediate(name, -1, flags);
    }

    public void popBackStack(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        this.enqueueAction(new PopBackStackState(null, id2, flags), false);
    }

    public boolean popBackStackImmediate(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        return this.popBackStackImmediate(null, id2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popBackStackImmediate(@Nullable String name, int id2, int flags) {
        FragmentManager childManager;
        this.execPendingActions(false);
        this.ensureExecReady(true);
        if (this.mPrimaryNav != null && id2 < 0 && name == null && (childManager = this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
            return true;
        }
        boolean executePop = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, name, id2, flags);
        if (executePop) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return executePop;
    }

    public int getBackStackEntryCount() {
        return this.mBackStack != null ? this.mBackStack.size() : 0;
    }

    @NonNull
    public BackStackEntry getBackStackEntryAt(int index) {
        return this.mBackStack.get(index);
    }

    public void addOnBackStackChangedListener(@NonNull OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(listener);
    }

    public void removeOnBackStackChangedListener(@NonNull OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener);
        }
    }

    void addCancellationSignal(@NonNull Fragment f, @NonNull CancellationSignal signal) {
        if (this.mExitAnimationCancellationSignals.get(f) == null) {
            this.mExitAnimationCancellationSignals.put(f, new HashSet());
        }
        this.mExitAnimationCancellationSignals.get(f).add(signal);
    }

    void removeCancellationSignal(@NonNull Fragment f, @NonNull CancellationSignal signal) {
        HashSet<CancellationSignal> signals = this.mExitAnimationCancellationSignals.get(f);
        if (signals != null && signals.remove(signal) && signals.isEmpty()) {
            this.mExitAnimationCancellationSignals.remove(f);
            if (f.mState < 5) {
                this.destroyFragmentView(f);
                this.moveToState(f);
            }
        }
    }

    @Override
    public final void setFragmentResult(@NonNull String requestKey, @NonNull Bundle result) {
        LifecycleAwareResultListener resultListener = this.mResultListeners.get(requestKey);
        if (resultListener != null && resultListener.isAtLeast(Lifecycle.State.STARTED)) {
            resultListener.onFragmentResult(requestKey, result);
        } else {
            this.mResults.put(requestKey, result);
        }
    }

    @Override
    public final void clearFragmentResult(@NonNull String requestKey) {
        this.mResults.remove(requestKey);
    }

    @Override
    @SuppressLint(value={"SyntheticAccessor"})
    public final void setFragmentResultListener(final @NonNull String requestKey, @NonNull LifecycleOwner lifecycleOwner, final @NonNull FragmentResultListener listener) {
        final Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleEventObserver observer = new LifecycleEventObserver(){

            public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                Bundle storedResult;
                if (event == Lifecycle.Event.ON_START && (storedResult = (Bundle)FragmentManager.this.mResults.get(requestKey)) != null) {
                    listener.onFragmentResult(requestKey, storedResult);
                    FragmentManager.this.clearFragmentResult(requestKey);
                }
                if (event == Lifecycle.Event.ON_DESTROY) {
                    lifecycle.removeObserver((LifecycleObserver)this);
                    FragmentManager.this.mResultListeners.remove(requestKey);
                }
            }
        };
        lifecycle.addObserver((LifecycleObserver)observer);
        LifecycleAwareResultListener storedListener = this.mResultListeners.put(requestKey, new LifecycleAwareResultListener(lifecycle, listener, observer));
        if (storedListener != null) {
            storedListener.removeObserver();
        }
    }

    @Override
    public final void clearFragmentResultListener(@NonNull String requestKey) {
        LifecycleAwareResultListener listener = this.mResultListeners.remove(requestKey);
        if (listener != null) {
            listener.removeObserver();
        }
    }

    public void putFragment(@NonNull Bundle bundle, @NonNull String key, @NonNull Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putString(key, fragment.mWho);
    }

    @Nullable
    public Fragment getFragment(@NonNull Bundle bundle, @NonNull String key) {
        String who = bundle.getString(key);
        if (who == null) {
            return null;
        }
        Fragment f = this.findActiveFragment(who);
        if (f == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": unique id " + who));
        }
        return f;
    }

    @NonNull
    public static <F extends Fragment> F findFragment(@NonNull View view) {
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment == null) {
            throw new IllegalStateException("View " + view + " does not have a Fragment set");
        }
        return (F)fragment;
    }

    @Nullable
    private static Fragment findViewFragment(@NonNull View view) {
        while (view != null) {
            Fragment fragment = FragmentManager.getViewFragment(view);
            if (fragment != null) {
                return fragment;
            }
            ViewParent parent = view.getParent();
            view = parent instanceof View ? (View)parent : null;
        }
        return null;
    }

    @Nullable
    static Fragment getViewFragment(@NonNull View view) {
        Object tag = view.getTag(R.id.fragment_container_view_tag);
        if (tag instanceof Fragment) {
            return (Fragment)tag;
        }
        return null;
    }

    void onContainerAvailable(@NonNull FragmentContainerView container) {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            Fragment fragment = fragmentStateManager.getFragment();
            if (fragment.mContainerId != container.getId() || fragment.mView == null || fragment.mView.getParent() != null) continue;
            fragment.mContainer = container;
            fragmentStateManager.addViewToContainer();
        }
    }

    @NonNull
    static FragmentManager findFragmentManager(@NonNull View view) {
        FragmentManager fm;
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment != null) {
            if (!fragment.isAdded()) {
                throw new IllegalStateException("The Fragment " + fragment + " that owns View " + view + " has already been destroyed. Nested fragments should always use the child FragmentManager.");
            }
            fm = fragment.getChildFragmentManager();
        } else {
            Context context = view.getContext();
            FragmentActivity fragmentActivity = null;
            while (context instanceof ContextWrapper) {
                if (context instanceof FragmentActivity) {
                    fragmentActivity = (FragmentActivity)context;
                    break;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            if (fragmentActivity != null) {
                fm = fragmentActivity.getSupportFragmentManager();
            } else {
                throw new IllegalStateException("View " + view + " is not within a subclass of FragmentActivity.");
            }
        }
        return fm;
    }

    @NonNull
    public List<Fragment> getFragments() {
        return this.mFragmentStore.getFragments();
    }

    @NonNull
    ViewModelStore getViewModelStore(@NonNull Fragment f) {
        return this.mNonConfig.getViewModelStore(f);
    }

    @NonNull
    private FragmentManagerViewModel getChildNonConfig(@NonNull Fragment f) {
        return this.mNonConfig.getChildNonConfig(f);
    }

    void addRetainedFragment(@NonNull Fragment f) {
        this.mNonConfig.addRetainedFragment(f);
    }

    void removeRetainedFragment(@NonNull Fragment f) {
        this.mNonConfig.removeRetainedFragment(f);
    }

    @NonNull
    List<Fragment> getActiveFragments() {
        return this.mFragmentStore.getActiveFragments();
    }

    int getActiveFragmentCount() {
        return this.mFragmentStore.getActiveFragmentCount();
    }

    @Nullable
    public Fragment.SavedState saveFragmentInstanceState(@NonNull Fragment fragment) {
        FragmentStateManager fragmentStateManager = this.mFragmentStore.getFragmentStateManager(fragment.mWho);
        if (fragmentStateManager == null || !fragmentStateManager.getFragment().equals(fragment)) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        return fragmentStateManager.saveInstanceState();
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            Class<?> cls = this.mParent.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mParent)));
            sb.append("}");
        } else if (this.mHost != null) {
            Class<?> cls = this.mHost.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mHost)));
            sb.append("}");
        } else {
            sb.append("null");
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        int i;
        int count;
        String innerPrefix = prefix + "    ";
        this.mFragmentStore.dump(prefix, fd, writer, args);
        if (this.mCreatedMenus != null && (count = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (i = 0; i < count; ++i) {
                Fragment f = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mBackStack != null && (count = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (i = 0; i < count; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, writer);
            }
        }
        writer.print(prefix);
        writer.println("Back Stack Index: " + this.mBackStackIndex.get());
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            count = this.mPendingActions.size();
            if (count > 0) {
                writer.print(prefix);
                writer.println("Pending Actions:");
                for (int i2 = 0; i2 < count; ++i2) {
                    OpGenerator r = this.mPendingActions.get(i2);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i2);
                    writer.print(": ");
                    writer.println(r);
                }
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mHost=");
        writer.println(this.mHost);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
    }

    void performPendingDeferredStart(@NonNull FragmentStateManager fragmentStateManager) {
        Fragment f = fragmentStateManager.getFragment();
        if (f.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f.mDeferStart = false;
            if (USE_STATE_MANAGER) {
                fragmentStateManager.moveToExpectedState();
            } else {
                this.moveToState(f);
            }
        }
    }

    boolean isStateAtLeast(int state) {
        return this.mCurState >= state;
    }

    void moveToState(@NonNull Fragment f, int newState) {
        FragmentStateManager fragmentStateManager = this.mFragmentStore.getFragmentStateManager(f.mWho);
        if (fragmentStateManager == null) {
            fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f);
            fragmentStateManager.setFragmentManagerState(1);
        }
        if (f.mFromLayout && f.mInLayout && f.mState == 2) {
            newState = Math.max(newState, 2);
        }
        if (f.mState <= (newState = Math.min(newState, fragmentStateManager.computeExpectedState()))) {
            if (f.mState < newState && !this.mExitAnimationCancellationSignals.isEmpty()) {
                this.cancelExitAnimation(f);
            }
            switch (f.mState) {
                case -1: {
                    if (newState > -1) {
                        fragmentStateManager.attach();
                    }
                }
                case 0: {
                    if (newState > 0) {
                        fragmentStateManager.create();
                    }
                }
                case 1: {
                    if (newState > -1) {
                        fragmentStateManager.ensureInflatedView();
                    }
                    if (newState > 1) {
                        fragmentStateManager.createView();
                    }
                }
                case 2: {
                    if (newState > 2) {
                        fragmentStateManager.activityCreated();
                    }
                }
                case 4: {
                    if (newState > 4) {
                        fragmentStateManager.start();
                    }
                }
                case 5: {
                    if (newState <= 5) break;
                    fragmentStateManager.resume();
                }
            }
        } else if (f.mState > newState) {
            switch (f.mState) {
                case 7: {
                    if (newState < 7) {
                        fragmentStateManager.pause();
                    }
                }
                case 5: {
                    if (newState < 5) {
                        fragmentStateManager.stop();
                    }
                }
                case 4: {
                    if (newState < 4) {
                        if (FragmentManager.isLoggingEnabled(3)) {
                            Log.d((String)TAG, (String)("movefrom ACTIVITY_CREATED: " + f));
                        }
                        if (f.mView != null && this.mHost.onShouldSaveFragmentState(f) && f.mSavedViewState == null) {
                            fragmentStateManager.saveViewState();
                        }
                    }
                }
                case 2: {
                    if (newState < 2) {
                        FragmentAnim.AnimationOrAnimator anim2 = null;
                        if (f.mView != null && f.mContainer != null) {
                            f.mContainer.endViewTransition(f.mView);
                            f.mView.clearAnimation();
                            if (!f.isRemovingParent()) {
                                if (this.mCurState > -1 && !this.mDestroyed && f.mView.getVisibility() == 0 && f.mPostponedAlpha >= 0.0f) {
                                    anim2 = FragmentAnim.loadAnimation(this.mHost.getContext(), f, false, f.getPopDirection());
                                }
                                f.mPostponedAlpha = 0.0f;
                                ViewGroup container = f.mContainer;
                                View view = f.mView;
                                if (anim2 != null) {
                                    FragmentAnim.animateRemoveFragment(f, anim2, this.mFragmentTransitionCallback);
                                }
                                container.removeView(view);
                                if (FragmentManager.isLoggingEnabled(2)) {
                                    Log.v((String)TAG, (String)("Removing view " + view + " for fragment " + f + " from container " + container));
                                }
                                if (container != f.mContainer) {
                                    return;
                                }
                            }
                        }
                        if (this.mExitAnimationCancellationSignals.get(f) == null) {
                            fragmentStateManager.destroyFragmentView();
                        }
                    }
                }
                case 1: {
                    if (newState < 1) {
                        if (this.mExitAnimationCancellationSignals.get(f) != null) {
                            newState = 1;
                        } else {
                            fragmentStateManager.destroy();
                        }
                    }
                }
                case 0: {
                    if (newState >= 0) break;
                    fragmentStateManager.detach();
                }
            }
        }
        if (f.mState != newState) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)("moveToState: Fragment state for " + f + " not updated inline; expected state " + newState + " found " + f.mState));
            }
            f.mState = newState;
        }
    }

    private void cancelExitAnimation(@NonNull Fragment f) {
        HashSet<CancellationSignal> signals = this.mExitAnimationCancellationSignals.get(f);
        if (signals != null) {
            for (CancellationSignal signal : signals) {
                signal.cancel();
            }
            signals.clear();
            this.destroyFragmentView(f);
            this.mExitAnimationCancellationSignals.remove(f);
        }
    }

    void setExitAnimationOrder(@NonNull Fragment f, boolean isPop) {
        ViewGroup container = this.getFragmentContainer(f);
        if (container != null && container instanceof FragmentContainerView) {
            ((FragmentContainerView)container).setDrawDisappearingViewsLast(!isPop);
        }
    }

    private void destroyFragmentView(@NonNull Fragment fragment) {
        fragment.performDestroyView();
        this.mLifecycleCallbacksDispatcher.dispatchOnFragmentViewDestroyed(fragment, false);
        fragment.mContainer = null;
        fragment.mView = null;
        fragment.mViewLifecycleOwner = null;
        fragment.mViewLifecycleOwnerLiveData.setValue(null);
        fragment.mInLayout = false;
    }

    void moveToState(@NonNull Fragment f) {
        this.moveToState(f, this.mCurState);
    }

    private void completeShowHideFragment(final @NonNull Fragment fragment) {
        if (fragment.mView != null) {
            FragmentAnim.AnimationOrAnimator anim2 = FragmentAnim.loadAnimation(this.mHost.getContext(), fragment, !fragment.mHidden, fragment.getPopDirection());
            if (anim2 != null && anim2.animator != null) {
                anim2.animator.setTarget((Object)fragment.mView);
                if (fragment.mHidden) {
                    if (fragment.isHideReplaced()) {
                        fragment.setHideReplaced(false);
                    } else {
                        final ViewGroup container = fragment.mContainer;
                        final View animatingView = fragment.mView;
                        container.startViewTransition(animatingView);
                        anim2.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                container.endViewTransition(animatingView);
                                animation.removeListener((Animator.AnimatorListener)this);
                                if (fragment.mView != null && fragment.mHidden) {
                                    fragment.mView.setVisibility(8);
                                }
                            }
                        });
                    }
                } else {
                    fragment.mView.setVisibility(0);
                }
                anim2.animator.start();
            } else {
                if (anim2 != null) {
                    fragment.mView.startAnimation(anim2.animation);
                    anim2.animation.start();
                }
                int visibility = fragment.mHidden && !fragment.isHideReplaced() ? 8 : 0;
                fragment.mView.setVisibility(visibility);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            }
        }
        this.invalidateMenuForFragment(fragment);
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    void moveFragmentToExpectedState(@NonNull Fragment f) {
        if (!this.mFragmentStore.containsActiveFragment(f.mWho)) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)("Ignoring moving " + f + " to state " + this.mCurState + "since it is not added to " + this));
            }
            return;
        }
        this.moveToState(f);
        if (f.mView != null && f.mIsNewlyAdded && f.mContainer != null) {
            if (f.mPostponedAlpha > 0.0f) {
                f.mView.setAlpha(f.mPostponedAlpha);
            }
            f.mPostponedAlpha = 0.0f;
            f.mIsNewlyAdded = false;
            FragmentAnim.AnimationOrAnimator anim2 = FragmentAnim.loadAnimation(this.mHost.getContext(), f, true, f.getPopDirection());
            if (anim2 != null) {
                if (anim2.animation != null) {
                    f.mView.startAnimation(anim2.animation);
                } else {
                    anim2.animator.setTarget((Object)f.mView);
                    anim2.animator.start();
                }
            }
        }
        if (f.mHiddenChanged) {
            this.completeShowHideFragment(f);
        }
    }

    void moveToState(int newState, boolean always) {
        if (this.mHost == null && newState != -1) {
            throw new IllegalStateException("No activity");
        }
        if (!always && newState == this.mCurState) {
            return;
        }
        this.mCurState = newState;
        if (USE_STATE_MANAGER) {
            this.mFragmentStore.moveToExpectedState();
        } else {
            for (Fragment f : this.mFragmentStore.getFragments()) {
                this.moveFragmentToExpectedState(f);
            }
            for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
                boolean beingRemoved;
                Fragment f = fragmentStateManager.getFragment();
                if (!f.mIsNewlyAdded) {
                    this.moveFragmentToExpectedState(f);
                }
                if (!(beingRemoved = f.mRemoving && !f.isInBackStack())) continue;
                this.mFragmentStore.makeInactive(fragmentStateManager);
            }
        }
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && this.mHost != null && this.mCurState == 7) {
            this.mHost.onSupportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
        }
    }

    private void startPendingDeferredFragments() {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            this.performPendingDeferredStart(fragmentStateManager);
        }
    }

    @NonNull
    FragmentStateManager createOrGetFragmentStateManager(@NonNull Fragment f) {
        FragmentStateManager existing = this.mFragmentStore.getFragmentStateManager(f.mWho);
        if (existing != null) {
            return existing;
        }
        FragmentStateManager fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f);
        fragmentStateManager.restoreState(this.mHost.getContext().getClassLoader());
        fragmentStateManager.setFragmentManagerState(this.mCurState);
        return fragmentStateManager;
    }

    FragmentStateManager addFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
        fragment.mFragmentManager = this;
        this.mFragmentStore.makeActive(fragmentStateManager);
        if (!fragment.mDetached) {
            this.mFragmentStore.addFragment(fragment);
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
        }
        return fragmentStateManager;
    }

    void removeFragment(@NonNull Fragment fragment) {
        boolean inactive;
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            this.mFragmentStore.removeFragment(fragment);
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mRemoving = true;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void hideFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void showFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    void detachFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("remove from detach: " + fragment));
                }
                this.mFragmentStore.removeFragment(fragment);
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
                this.setVisibleRemovingFragment(fragment);
            }
        }
    }

    void attachFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                this.mFragmentStore.addFragment(fragment);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    @Nullable
    public Fragment findFragmentById(@IdRes int id2) {
        return this.mFragmentStore.findFragmentById(id2);
    }

    @Nullable
    public Fragment findFragmentByTag(@Nullable String tag) {
        return this.mFragmentStore.findFragmentByTag(tag);
    }

    Fragment findFragmentByWho(@NonNull String who) {
        return this.mFragmentStore.findFragmentByWho(who);
    }

    @Nullable
    Fragment findActiveFragment(@NonNull String who) {
        return this.mFragmentStore.findActiveFragment(who);
    }

    private void checkStateLoss() {
        if (this.isStateSaved()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
    }

    public boolean isStateSaved() {
        return this.mStateSaved || this.mStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAction(@NonNull OpGenerator action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            if (this.mHost == null) {
                if (this.mDestroyed) {
                    throw new IllegalStateException("FragmentManager has been destroyed");
                }
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            this.checkStateLoss();
        }
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mHost == null) {
                if (allowStateLoss) {
                    return;
                }
                throw new IllegalStateException("Activity has been destroyed");
            }
            this.mPendingActions.add(action);
            this.scheduleCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCommit() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            boolean pendingReady;
            boolean postponeReady = this.mPostponedTransactions != null && !this.mPostponedTransactions.isEmpty();
            boolean bl = pendingReady = this.mPendingActions.size() == 1;
            if (postponeReady || pendingReady) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
        }
    }

    int allocBackStackIndex() {
        return this.mBackStackIndex.getAndIncrement();
    }

    private void ensureExecReady(boolean allowStateLoss) {
        if (this.mExecutingActions) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.mHost == null) {
            if (this.mDestroyed) {
                throw new IllegalStateException("FragmentManager has been destroyed");
            }
            throw new IllegalStateException("FragmentManager has not been attached to a host.");
        }
        if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        if (this.mTmpRecords == null) {
            this.mTmpRecords = new ArrayList();
            this.mTmpIsPop = new ArrayList();
        }
        this.mExecutingActions = true;
        try {
            this.executePostponedTransaction(null, null);
        }
        finally {
            this.mExecutingActions = false;
        }
    }

    void execSingleAction(@NonNull OpGenerator action, boolean allowStateLoss) {
        if (allowStateLoss && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(allowStateLoss);
        if (action.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    boolean execPendingActions(boolean allowStateLoss) {
        this.ensureExecReady(allowStateLoss);
        boolean didSomething = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
            didSomething = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return didSomething;
    }

    private void executePostponedTransaction(@Nullable ArrayList<BackStackRecord> records, @Nullable ArrayList<Boolean> isRecordPop) {
        int numPostponed = this.mPostponedTransactions == null ? 0 : this.mPostponedTransactions.size();
        for (int i = 0; i < numPostponed; ++i) {
            int index;
            StartEnterTransitionListener listener = this.mPostponedTransactions.get(i);
            if (records != null && !listener.mIsBack && (index = records.indexOf(listener.mRecord)) != -1 && isRecordPop != null && isRecordPop.get(index).booleanValue()) {
                this.mPostponedTransactions.remove(i);
                --i;
                --numPostponed;
                listener.cancelTransaction();
                continue;
            }
            if (!listener.isReady() && (records == null || !listener.mRecord.interactsWith(records, 0, records.size()))) continue;
            this.mPostponedTransactions.remove(i);
            --i;
            --numPostponed;
            if (records != null && !listener.mIsBack && (index = records.indexOf(listener.mRecord)) != -1 && isRecordPop != null && isRecordPop.get(index).booleanValue()) {
                listener.cancelTransaction();
                continue;
            }
            listener.completeTransaction();
        }
    }

    private void removeRedundantOperationsAndExecute(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
        if (records.isEmpty()) {
            return;
        }
        if (records.size() != isRecordPop.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        this.executePostponedTransaction(records, isRecordPop);
        int numRecords = records.size();
        int startIndex = 0;
        for (int recordNum = 0; recordNum < numRecords; ++recordNum) {
            int reorderingEnd;
            boolean canReorder = records.get((int)recordNum).mReorderingAllowed;
            if (canReorder) continue;
            if (startIndex != recordNum) {
                this.executeOpsTogether(records, isRecordPop, startIndex, recordNum);
            }
            if (isRecordPop.get(recordNum).booleanValue()) {
                for (reorderingEnd = recordNum + 1; reorderingEnd < numRecords && isRecordPop.get(reorderingEnd).booleanValue() && !records.get((int)reorderingEnd).mReorderingAllowed; ++reorderingEnd) {
                }
            }
            this.executeOpsTogether(records, isRecordPop, recordNum, reorderingEnd);
            startIndex = reorderingEnd;
            recordNum = reorderingEnd - 1;
        }
        if (startIndex != numRecords) {
            this.executeOpsTogether(records, isRecordPop, startIndex, numRecords);
        }
    }

    private void executeOpsTogether(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        BackStackRecord record;
        int recordNum;
        boolean allowReordering = records.get((int)startIndex).mReorderingAllowed;
        boolean addToBackStack = false;
        if (this.mTmpAddedFragments == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            this.mTmpAddedFragments.clear();
        }
        this.mTmpAddedFragments.addAll(this.mFragmentStore.getFragments());
        Fragment oldPrimaryNav = this.getPrimaryNavigationFragment();
        for (recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            oldPrimaryNav = !isPop ? record.expandOps(this.mTmpAddedFragments, oldPrimaryNav) : record.trackAddedFragmentsInPop(this.mTmpAddedFragments, oldPrimaryNav);
            addToBackStack = addToBackStack || record.mAddToBackStack;
        }
        this.mTmpAddedFragments.clear();
        if (!allowReordering && this.mCurState >= 1) {
            if (USE_STATE_MANAGER) {
                for (int index = startIndex; index < endIndex; ++index) {
                    record = records.get(index);
                    for (FragmentTransaction.Op op : record.mOps) {
                        Fragment fragment = op.mFragment;
                        if (fragment == null || fragment.mFragmentManager == null) continue;
                        FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                        this.mFragmentStore.makeActive(fragmentStateManager);
                    }
                }
            } else {
                FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, records, isRecordPop, startIndex, endIndex, false, this.mFragmentTransitionCallback);
            }
        }
        FragmentManager.executeOps(records, isRecordPop, startIndex, endIndex);
        if (USE_STATE_MANAGER) {
            boolean isPop = isRecordPop.get(endIndex - 1);
            for (int index = startIndex; index < endIndex; ++index) {
                FragmentStateManager fragmentStateManager;
                Fragment fragment;
                BackStackRecord record2 = records.get(index);
                if (isPop) {
                    for (int opIndex = record2.mOps.size() - 1; opIndex >= 0; --opIndex) {
                        FragmentTransaction.Op op = (FragmentTransaction.Op)record2.mOps.get(opIndex);
                        fragment = op.mFragment;
                        if (fragment == null) continue;
                        fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                        fragmentStateManager.moveToExpectedState();
                    }
                    continue;
                }
                for (FragmentTransaction.Op op : record2.mOps) {
                    fragment = op.mFragment;
                    if (fragment == null) continue;
                    fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                    fragmentStateManager.moveToExpectedState();
                }
            }
            this.moveToState(this.mCurState, true);
            Set<SpecialEffectsController> changedControllers = this.collectChangedControllers(records, startIndex, endIndex);
            for (SpecialEffectsController controller : changedControllers) {
                controller.updateOperationDirection(isPop);
                controller.markPostponedState();
                controller.executePendingOperations();
            }
        } else {
            int postponeIndex = endIndex;
            if (allowReordering) {
                ArraySet addedFragments = new ArraySet();
                this.addAddedFragments((ArraySet<Fragment>)addedFragments);
                postponeIndex = this.postponePostponableTransactions(records, isRecordPop, startIndex, endIndex, (ArraySet<Fragment>)addedFragments);
                this.makeRemovedFragmentsInvisible((ArraySet<Fragment>)addedFragments);
            }
            if (postponeIndex != startIndex && allowReordering) {
                if (this.mCurState >= 1) {
                    FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, records, isRecordPop, startIndex, postponeIndex, true, this.mFragmentTransitionCallback);
                }
                this.moveToState(this.mCurState, true);
            }
        }
        for (recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            if (isPop && record.mIndex >= 0) {
                record.mIndex = -1;
            }
            record.runOnCommitRunnables();
        }
        if (addToBackStack) {
            this.reportBackStackChanged();
        }
    }

    private Set<SpecialEffectsController> collectChangedControllers(@NonNull ArrayList<BackStackRecord> records, int startIndex, int endIndex) {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (int index = startIndex; index < endIndex; ++index) {
            BackStackRecord record = records.get(index);
            for (FragmentTransaction.Op op : record.mOps) {
                ViewGroup container;
                Fragment fragment = op.mFragment;
                if (fragment == null || (container = fragment.mContainer) == null) continue;
                controllers.add(SpecialEffectsController.getOrCreateController(container, this));
            }
        }
        return controllers;
    }

    private void makeRemovedFragmentsInvisible(@NonNull ArraySet<Fragment> fragments) {
        int numAdded = fragments.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment fragment = (Fragment)fragments.valueAt(i);
            if (fragment.mAdded) continue;
            View view = fragment.requireView();
            fragment.mPostponedAlpha = view.getAlpha();
            view.setAlpha(0.0f);
        }
    }

    private int postponePostponableTransactions(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, @NonNull ArraySet<Fragment> added) {
        int postponeIndex = endIndex;
        for (int i = endIndex - 1; i >= startIndex; --i) {
            boolean isPostponed;
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            boolean bl = isPostponed = record.isPostponed() && !record.interactsWith(records, i + 1, endIndex);
            if (!isPostponed) continue;
            if (this.mPostponedTransactions == null) {
                this.mPostponedTransactions = new ArrayList();
            }
            StartEnterTransitionListener listener = new StartEnterTransitionListener(record, isPop);
            this.mPostponedTransactions.add(listener);
            record.setOnStartPostponedListener(listener);
            if (isPop) {
                record.executeOps();
            } else {
                record.executePopOps(false);
            }
            if (i != --postponeIndex) {
                records.remove(i);
                records.add(postponeIndex, record);
            }
            this.addAddedFragments(added);
        }
        return postponeIndex;
    }

    void completeExecute(@NonNull BackStackRecord record, boolean isPop, boolean runTransitions, boolean moveToState) {
        if (isPop) {
            record.executePopOps(moveToState);
        } else {
            record.executeOps();
        }
        ArrayList<BackStackRecord> records = new ArrayList<BackStackRecord>(1);
        ArrayList<Boolean> isRecordPop = new ArrayList<Boolean>(1);
        records.add(record);
        isRecordPop.add(isPop);
        if (runTransitions && this.mCurState >= 1) {
            FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, records, isRecordPop, 0, 1, true, this.mFragmentTransitionCallback);
        }
        if (moveToState) {
            this.moveToState(this.mCurState, true);
        }
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment == null || fragment.mView == null || !fragment.mIsNewlyAdded || !record.interactsWith(fragment.mContainerId)) continue;
            if (fragment.mPostponedAlpha > 0.0f) {
                fragment.mView.setAlpha(fragment.mPostponedAlpha);
            }
            if (moveToState) {
                fragment.mPostponedAlpha = 0.0f;
                continue;
            }
            fragment.mPostponedAlpha = -1.0f;
            fragment.mIsNewlyAdded = false;
        }
    }

    private static void executeOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                record.bumpBackStackNesting(-1);
                boolean moveToState = i == endIndex - 1;
                record.executePopOps(moveToState);
                continue;
            }
            record.bumpBackStackNesting(1);
            record.executeOps();
        }
    }

    private void setVisibleRemovingFragment(@NonNull Fragment f) {
        ViewGroup container = this.getFragmentContainer(f);
        if (container != null && f.getEnterAnim() + f.getExitAnim() + f.getPopEnterAnim() + f.getPopExitAnim() > 0) {
            if (container.getTag(R.id.visible_removing_fragment_view_tag) == null) {
                container.setTag(R.id.visible_removing_fragment_view_tag, (Object)f);
            }
            ((Fragment)container.getTag(R.id.visible_removing_fragment_view_tag)).setPopDirection(f.getPopDirection());
        }
    }

    private ViewGroup getFragmentContainer(@NonNull Fragment f) {
        View view;
        if (f.mContainer != null) {
            return f.mContainer;
        }
        if (f.mContainerId <= 0) {
            return null;
        }
        if (this.mContainer.onHasView() && (view = this.mContainer.onFindViewById(f.mContainerId)) instanceof ViewGroup) {
            return (ViewGroup)view;
        }
        return null;
    }

    private void addAddedFragments(@NonNull ArraySet<Fragment> added) {
        if (this.mCurState < 1) {
            return;
        }
        int state = Math.min(this.mCurState, 5);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment.mState >= state) continue;
            this.moveToState(fragment, state);
            if (fragment.mView == null || fragment.mHidden || !fragment.mIsNewlyAdded) continue;
            added.add((Object)fragment);
        }
    }

    private void forcePostponedTransactions() {
        block3: {
            block2: {
                if (!USE_STATE_MANAGER) break block2;
                Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
                for (SpecialEffectsController controller : controllers) {
                    controller.forcePostponedExecutePendingOperations();
                }
                break block3;
            }
            if (this.mPostponedTransactions == null) break block3;
            while (!this.mPostponedTransactions.isEmpty()) {
                this.mPostponedTransactions.remove(0).completeTransaction();
            }
        }
    }

    private void endAnimatingAwayFragments() {
        block3: {
            block2: {
                if (!USE_STATE_MANAGER) break block2;
                Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
                for (SpecialEffectsController controller : controllers) {
                    controller.forceCompleteAllOperations();
                }
                break block3;
            }
            if (this.mExitAnimationCancellationSignals.isEmpty()) break block3;
            for (Fragment fragment : this.mExitAnimationCancellationSignals.keySet()) {
                this.cancelExitAnimation(fragment);
                this.moveToState(fragment);
            }
        }
    }

    private Set<SpecialEffectsController> collectAllSpecialEffectsController() {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            ViewGroup container = fragmentStateManager.getFragment().mContainer;
            if (container == null) continue;
            controllers.add(SpecialEffectsController.getOrCreateController(container, this.getSpecialEffectsControllerFactory()));
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateOpsForPendingActions(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isPop) {
        boolean didSomething = false;
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mPendingActions.isEmpty()) {
                return false;
            }
            int numActions = this.mPendingActions.size();
            for (int i = 0; i < numActions; ++i) {
                didSomething |= this.mPendingActions.get(i).generateOps(records, isPop);
            }
            this.mPendingActions.clear();
            this.mHost.getHandler().removeCallbacks(this.mExecCommit);
        }
        return didSomething;
    }

    private void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    private void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    void addBackStackState(BackStackRecord state) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(state);
    }

    boolean popBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, @Nullable String name, int id2, int flags) {
        if (this.mBackStack == null) {
            return false;
        }
        if (name == null && id2 < 0 && (flags & 1) == 0) {
            int last = this.mBackStack.size() - 1;
            if (last < 0) {
                return false;
            }
            records.add(this.mBackStack.remove(last));
            isRecordPop.add(true);
        } else {
            int index = -1;
            if (name != null || id2 >= 0) {
                BackStackRecord bss;
                for (index = this.mBackStack.size() - 1; index >= 0; --index) {
                    bss = this.mBackStack.get(index);
                    if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) break;
                }
                if (index < 0) {
                    return false;
                }
                if ((flags & 1) != 0) {
                    --index;
                    while (index >= 0) {
                        bss = this.mBackStack.get(index);
                        if ((name == null || !name.equals(bss.getName())) && (id2 < 0 || id2 != bss.mIndex)) break;
                        --index;
                    }
                }
            }
            if (index == this.mBackStack.size() - 1) {
                return false;
            }
            for (int i = this.mBackStack.size() - 1; i > index; --i) {
                records.add(this.mBackStack.remove(i));
                isRecordPop.add(true);
            }
        }
        return true;
    }

    @Deprecated
    FragmentManagerNonConfig retainNonConfig() {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You cannot use retainNonConfig when your FragmentHostCallback implements ViewModelStoreOwner."));
        }
        return this.mNonConfig.getSnapshot();
    }

    Parcelable saveAllState() {
        int size;
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions(true);
        this.mStateSaved = true;
        this.mNonConfig.setIsStateSaved(true);
        ArrayList<FragmentState> active = this.mFragmentStore.saveActiveFragments();
        if (active.isEmpty()) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)"saveAllState: no fragments!");
            }
            return null;
        }
        ArrayList<String> added = this.mFragmentStore.saveAddedFragments();
        BackStackState[] backStack = null;
        if (this.mBackStack != null && (size = this.mBackStack.size()) > 0) {
            backStack = new BackStackState[size];
            for (int i = 0; i < size; ++i) {
                backStack[i] = new BackStackState(this.mBackStack.get(i));
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)TAG, (String)("saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i)));
            }
        }
        FragmentManagerState fms = new FragmentManagerState();
        fms.mActive = active;
        fms.mAdded = added;
        fms.mBackStack = backStack;
        fms.mBackStackIndex = this.mBackStackIndex.get();
        if (this.mPrimaryNav != null) {
            fms.mPrimaryNavActiveWho = this.mPrimaryNav.mWho;
        }
        fms.mResultKeys.addAll(this.mResults.keySet());
        fms.mResults.addAll(this.mResults.values());
        fms.mLaunchedFragments = new ArrayList<LaunchedFragmentInfo>(this.mLaunchedFragments);
        return fms;
    }

    void restoreAllState(@Nullable Parcelable state, @Nullable FragmentManagerNonConfig nonConfig) {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You must use restoreSaveState when your FragmentHostCallback implements ViewModelStoreOwner"));
        }
        this.mNonConfig.restoreFromSnapshot(nonConfig);
        this.restoreSaveState(state);
    }

    void restoreSaveState(@Nullable Parcelable state) {
        ArrayList<String> savedResultKeys;
        FragmentStateManager fragmentStateManager;
        if (state == null) {
            return;
        }
        FragmentManagerState fms = (FragmentManagerState)state;
        if (fms.mActive == null) {
            return;
        }
        this.mFragmentStore.resetActiveFragments();
        for (FragmentState fs : fms.mActive) {
            if (fs == null) continue;
            Fragment retainedFragment = this.mNonConfig.findRetainedFragmentByWho(fs.mWho);
            if (retainedFragment != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreSaveState: re-attaching retained " + retainedFragment));
                }
                fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, retainedFragment, fs);
            } else {
                fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, this.mHost.getContext().getClassLoader(), this.getFragmentFactory(), fs);
            }
            Fragment f = fragmentStateManager.getFragment();
            f.mFragmentManager = this;
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("restoreSaveState: active (" + f.mWho + "): " + f));
            }
            fragmentStateManager.restoreState(this.mHost.getContext().getClassLoader());
            this.mFragmentStore.makeActive(fragmentStateManager);
            fragmentStateManager.setFragmentManagerState(this.mCurState);
        }
        for (Fragment f : this.mNonConfig.getRetainedFragments()) {
            if (this.mFragmentStore.containsActiveFragment(f.mWho)) continue;
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Discarding retained Fragment " + f + " that was not found in the set of active Fragments " + fms.mActive));
            }
            this.mNonConfig.removeRetainedFragment(f);
            f.mFragmentManager = this;
            fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f);
            fragmentStateManager.setFragmentManagerState(1);
            fragmentStateManager.moveToExpectedState();
            f.mRemoving = true;
            fragmentStateManager.moveToExpectedState();
        }
        this.mFragmentStore.restoreAddedFragments(fms.mAdded);
        if (fms.mBackStack != null) {
            this.mBackStack = new ArrayList(fms.mBackStack.length);
            for (int i = 0; i < fms.mBackStack.length; ++i) {
                BackStackRecord bse = fms.mBackStack[i].instantiate(this);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreAllState: back stack #" + i + " (index " + bse.mIndex + "): " + bse));
                    LogWriter logw = new LogWriter(TAG);
                    PrintWriter pw = new PrintWriter(logw);
                    bse.dump("  ", pw, false);
                    pw.close();
                }
                this.mBackStack.add(bse);
            }
        } else {
            this.mBackStack = null;
        }
        this.mBackStackIndex.set(fms.mBackStackIndex);
        if (fms.mPrimaryNavActiveWho != null) {
            this.mPrimaryNav = this.findActiveFragment(fms.mPrimaryNavActiveWho);
            this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
        }
        if ((savedResultKeys = fms.mResultKeys) != null) {
            for (int i = 0; i < savedResultKeys.size(); ++i) {
                Bundle savedResult = fms.mResults.get(i);
                savedResult.setClassLoader(this.mHost.getContext().getClassLoader());
                this.mResults.put(savedResultKeys.get(i), savedResult);
            }
        }
        this.mLaunchedFragments = new ArrayDeque<LaunchedFragmentInfo>(fms.mLaunchedFragments);
    }

    @NonNull
    FragmentHostCallback<?> getHost() {
        return this.mHost;
    }

    @Nullable
    Fragment getParent() {
        return this.mParent;
    }

    @NonNull
    FragmentContainer getContainer() {
        return this.mContainer;
    }

    @NonNull
    FragmentStore getFragmentStore() {
        return this.mFragmentStore;
    }

    @SuppressLint(value={"SyntheticAccessor"})
    void attachController(@NonNull FragmentHostCallback<?> host, @NonNull FragmentContainer container, final @Nullable Fragment parent) {
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = host;
        this.mContainer = container;
        this.mParent = parent;
        if (this.mParent != null) {
            this.addFragmentOnAttachListener(new FragmentOnAttachListener(){

                @Override
                public void onAttachFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment) {
                    parent.onAttachFragment(fragment);
                }
            });
        } else if (host instanceof FragmentOnAttachListener) {
            this.addFragmentOnAttachListener((FragmentOnAttachListener)((Object)host));
        }
        if (this.mParent != null) {
            this.updateOnBackPressedCallbackEnabled();
        }
        if (host instanceof OnBackPressedDispatcherOwner) {
            OnBackPressedDispatcherOwner dispatcherOwner = (OnBackPressedDispatcherOwner)host;
            this.mOnBackPressedDispatcher = dispatcherOwner.getOnBackPressedDispatcher();
            Fragment owner = parent != null ? parent : dispatcherOwner;
            this.mOnBackPressedDispatcher.addCallback((LifecycleOwner)owner, this.mOnBackPressedCallback);
        }
        if (parent != null) {
            this.mNonConfig = parent.mFragmentManager.getChildNonConfig(parent);
        } else if (host instanceof ViewModelStoreOwner) {
            ViewModelStore viewModelStore = ((ViewModelStoreOwner)host).getViewModelStore();
            this.mNonConfig = FragmentManagerViewModel.getInstance(viewModelStore);
        } else {
            this.mNonConfig = new FragmentManagerViewModel(false);
        }
        this.mNonConfig.setIsStateSaved(this.isStateSaved());
        this.mFragmentStore.setNonConfig(this.mNonConfig);
        if (this.mHost instanceof ActivityResultRegistryOwner) {
            ActivityResultRegistry registry = ((ActivityResultRegistryOwner)this.mHost).getActivityResultRegistry();
            String parentId = parent != null ? parent.mWho + ":" : "";
            String keyPrefix = "FragmentManager:" + parentId;
            this.mStartActivityForResult = registry.register(keyPrefix + "StartActivityForResult", (ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(){

                public void onActivityResult(ActivityResult result) {
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollFirst();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No Activities were started for result for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Activity result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onActivityResult(requestCode, result.getResultCode(), result.getData());
                }
            });
            this.mStartIntentSenderForResult = registry.register(keyPrefix + "StartIntentSenderForResult", (ActivityResultContract)new FragmentIntentSenderContract(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(){

                public void onActivityResult(ActivityResult result) {
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollFirst();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No IntentSenders were started for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Intent Sender result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onActivityResult(requestCode, result.getResultCode(), result.getData());
                }
            });
            this.mRequestPermissions = registry.register(keyPrefix + "RequestPermissions", (ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), (ActivityResultCallback)new ActivityResultCallback<Map<String, Boolean>>(){

                @SuppressLint(value={"SyntheticAccessor"})
                public void onActivityResult(Map<String, Boolean> result) {
                    String[] permissions = result.keySet().toArray(new String[0]);
                    ArrayList<Boolean> resultValues = new ArrayList<Boolean>(result.values());
                    int[] grantResults = new int[resultValues.size()];
                    for (int i = 0; i < resultValues.size(); ++i) {
                        grantResults[i] = resultValues.get(i) != false ? 0 : -1;
                    }
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollFirst();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No permissions were requested for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Permission request result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    void noteStateNotSaved() {
        if (this.mHost == null) {
            return;
        }
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    void launchStartActivityForResult(@NonNull Fragment f, @SuppressLint(value={"UnknownNullness"}) Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.mStartActivityForResult != null) {
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            if (intent != null && options != null) {
                intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", options);
            }
            this.mStartActivityForResult.launch((Object)intent);
        } else {
            this.mHost.onStartActivityFromFragment(f, intent, requestCode, options);
        }
    }

    void launchStartIntentSenderForResult(@NonNull Fragment f, @SuppressLint(value={"UnknownNullness"}) IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (this.mStartIntentSenderForResult != null) {
            if (options != null) {
                if (fillInIntent == null) {
                    fillInIntent = new Intent();
                    fillInIntent.putExtra(EXTRA_CREATED_FILLIN_INTENT, true);
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("ActivityOptions " + options + " were added to fillInIntent " + fillInIntent + " for fragment " + f));
                }
                fillInIntent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", options);
            }
            IntentSenderRequest request = new IntentSenderRequest.Builder(intent).setFillInIntent(fillInIntent).setFlags(flagsValues, flagsMask).build();
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Fragment " + f + "is launching an IntentSender for result "));
            }
            this.mStartIntentSenderForResult.launch((Object)request);
        } else {
            this.mHost.onStartIntentSenderFromFragment(f, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        }
    }

    void launchRequestPermissions(@NonNull Fragment f, @NonNull String[] permissions, int requestCode) {
        if (this.mRequestPermissions != null) {
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            this.mRequestPermissions.launch((Object)permissions);
        } else {
            this.mHost.onRequestPermissionsFromFragment(f, permissions, requestCode);
        }
    }

    void dispatchAttach() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(0);
    }

    void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(1);
    }

    void dispatchViewCreated() {
        this.dispatchStateChange(2);
    }

    void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(4);
    }

    void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(5);
    }

    void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(7);
    }

    void dispatchPause() {
        this.dispatchStateChange(5);
    }

    void dispatchStop() {
        this.mStopped = true;
        this.mNonConfig.setIsStateSaved(true);
        this.dispatchStateChange(4);
    }

    void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions(true);
        this.endAnimatingAwayFragments();
        this.dispatchStateChange(-1);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
        if (this.mStartActivityForResult != null) {
            this.mStartActivityForResult.unregister();
            this.mStartIntentSenderForResult.unregister();
            this.mRequestPermissions.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchStateChange(int nextState) {
        try {
            this.mExecutingActions = true;
            this.mFragmentStore.dispatchStateChange(nextState);
            this.moveToState(nextState, false);
            if (USE_STATE_MANAGER) {
                Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
                for (SpecialEffectsController controller : controllers) {
                    controller.forceCompleteAllOperations();
                }
            }
        }
        finally {
            this.mExecutingActions = false;
        }
        this.execPendingActions(true);
    }

    void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode) {
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performMultiWindowModeChanged(isInMultiWindowMode);
        }
    }

    void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performPictureInPictureModeChanged(isInPictureInPictureMode);
        }
    }

    void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performConfigurationChanged(newConfig);
        }
    }

    void dispatchLowMemory() {
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performLowMemory();
        }
    }

    boolean dispatchCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        ArrayList<Fragment> newMenus = null;
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !this.isParentMenuVisible(f) || !f.performCreateOptionsMenu(menu, inflater)) continue;
            show = true;
            if (newMenus == null) {
                newMenus = new ArrayList<Fragment>();
            }
            newMenus.add(f);
        }
        if (this.mCreatedMenus != null) {
            for (int i = 0; i < this.mCreatedMenus.size(); ++i) {
                Fragment f;
                f = this.mCreatedMenus.get(i);
                if (newMenus != null && newMenus.contains(f)) continue;
                f.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = newMenus;
        return show;
    }

    boolean dispatchPrepareOptionsMenu(@NonNull Menu menu) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !this.isParentMenuVisible(f) || !f.performPrepareOptionsMenu(menu)) continue;
            show = true;
        }
        return show;
    }

    boolean dispatchOptionsItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !f.performOptionsItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    boolean dispatchContextItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !f.performContextItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    void dispatchOptionsMenuClosed(@NonNull Menu menu) {
        if (this.mCurState < 1) {
            return;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performOptionsMenuClosed(menu);
        }
    }

    void setPrimaryNavigationFragment(@Nullable Fragment f) {
        if (f != null && (!f.equals(this.findActiveFragment(f.mWho)) || f.mHost != null && f.mFragmentManager != this)) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        Fragment previousPrimaryNav = this.mPrimaryNav;
        this.mPrimaryNav = f;
        this.dispatchParentPrimaryNavigationFragmentChanged(previousPrimaryNav);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(@Nullable Fragment f) {
        if (f != null && f.equals(this.findActiveFragment(f.mWho))) {
            f.performPrimaryNavigationFragmentChanged();
        }
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    @Nullable
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    void setMaxLifecycle(@NonNull Fragment f, @NonNull Lifecycle.State state) {
        if (!f.equals(this.findActiveFragment(f.mWho)) || f.mHost != null && f.mFragmentManager != this) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        f.mMaxState = state;
    }

    public void setFragmentFactory(@NonNull FragmentFactory fragmentFactory) {
        this.mFragmentFactory = fragmentFactory;
    }

    @NonNull
    public FragmentFactory getFragmentFactory() {
        if (this.mFragmentFactory != null) {
            return this.mFragmentFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getFragmentFactory();
        }
        return this.mHostFragmentFactory;
    }

    void setSpecialEffectsControllerFactory(@NonNull SpecialEffectsControllerFactory specialEffectsControllerFactory) {
        this.mSpecialEffectsControllerFactory = specialEffectsControllerFactory;
    }

    @NonNull
    SpecialEffectsControllerFactory getSpecialEffectsControllerFactory() {
        if (this.mSpecialEffectsControllerFactory != null) {
            return this.mSpecialEffectsControllerFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getSpecialEffectsControllerFactory();
        }
        return this.mDefaultSpecialEffectsControllerFactory;
    }

    @NonNull
    FragmentLifecycleCallbacksDispatcher getLifecycleCallbacksDispatcher() {
        return this.mLifecycleCallbacksDispatcher;
    }

    public void registerFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacksDispatcher.registerFragmentLifecycleCallbacks(cb, recursive);
    }

    public void unregisterFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks cb) {
        this.mLifecycleCallbacksDispatcher.unregisterFragmentLifecycleCallbacks(cb);
    }

    public void addFragmentOnAttachListener(@NonNull FragmentOnAttachListener listener) {
        this.mOnAttachListeners.add(listener);
    }

    void dispatchOnAttachFragment(@NonNull Fragment fragment) {
        for (FragmentOnAttachListener listener : this.mOnAttachListeners) {
            listener.onAttachFragment(this, fragment);
        }
    }

    public void removeFragmentOnAttachListener(@NonNull FragmentOnAttachListener listener) {
        this.mOnAttachListeners.remove(listener);
    }

    boolean checkForMenus() {
        boolean hasMenu = false;
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment != null) {
                hasMenu = this.isMenuAvailable(fragment);
            }
            if (!hasMenu) continue;
            return true;
        }
        return false;
    }

    private boolean isMenuAvailable(@NonNull Fragment f) {
        return f.mHasMenu && f.mMenuVisible || f.mChildFragmentManager.checkForMenus();
    }

    void invalidateMenuForFragment(@NonNull Fragment f) {
        if (f.mAdded && this.isMenuAvailable(f)) {
            this.mNeedMenuInvalidate = true;
        }
    }

    static int reverseTransit(int transit) {
        int rev = 0;
        switch (transit) {
            case 4097: {
                rev = 8194;
                break;
            }
            case 8194: {
                rev = 4097;
                break;
            }
            case 4099: {
                rev = 4099;
            }
        }
        return rev;
    }

    @NonNull
    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this.mLayoutInflaterFactory;
    }

    static class FragmentIntentSenderContract
    extends ActivityResultContract<IntentSenderRequest, ActivityResult> {
        FragmentIntentSenderContract() {
        }

        @NonNull
        public Intent createIntent(@NonNull Context context, IntentSenderRequest input) {
            Bundle activityOptions;
            Intent result = new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST");
            Intent fillInIntent = input.getFillInIntent();
            if (fillInIntent != null && (activityOptions = fillInIntent.getBundleExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE")) != null) {
                result.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", activityOptions);
                fillInIntent.removeExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                if (fillInIntent.getBooleanExtra(FragmentManager.EXTRA_CREATED_FILLIN_INTENT, false)) {
                    input = new IntentSenderRequest.Builder(input.getIntentSender()).setFillInIntent(null).setFlags(input.getFlagsValues(), input.getFlagsMask()).build();
                }
            }
            result.putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", (Parcelable)input);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)FragmentManager.TAG, (String)("CreateIntent created the following intent: " + result));
            }
            return result;
        }

        @NonNull
        public ActivityResult parseResult(int resultCode, @Nullable Intent intent) {
            return new ActivityResult(resultCode, intent);
        }
    }

    @SuppressLint(value={"BanParcelableUsage"})
    static class LaunchedFragmentInfo
    implements Parcelable {
        String mWho;
        int mRequestCode;
        public static final Parcelable.Creator<LaunchedFragmentInfo> CREATOR = new Parcelable.Creator<LaunchedFragmentInfo>(){

            public LaunchedFragmentInfo createFromParcel(Parcel in) {
                return new LaunchedFragmentInfo(in);
            }

            public LaunchedFragmentInfo[] newArray(int size) {
                return new LaunchedFragmentInfo[size];
            }
        };

        LaunchedFragmentInfo(@NonNull String who, int requestCode) {
            this.mWho = who;
            this.mRequestCode = requestCode;
        }

        LaunchedFragmentInfo(@NonNull Parcel in) {
            this.mWho = in.readString();
            this.mRequestCode = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mWho);
            dest.writeInt(this.mRequestCode);
        }
    }

    static class StartEnterTransitionListener
    implements Fragment.OnStartEnterTransitionListener {
        final boolean mIsBack;
        final BackStackRecord mRecord;
        private int mNumPostponed;

        StartEnterTransitionListener(@NonNull BackStackRecord record, boolean isBack) {
            this.mIsBack = isBack;
            this.mRecord = record;
        }

        @Override
        public void onStartEnterTransition() {
            --this.mNumPostponed;
            if (this.mNumPostponed != 0) {
                return;
            }
            this.mRecord.mManager.scheduleCommit();
        }

        @Override
        public void startListening() {
            ++this.mNumPostponed;
        }

        public boolean isReady() {
            return this.mNumPostponed == 0;
        }

        void completeTransaction() {
            boolean canceled = this.mNumPostponed > 0;
            FragmentManager manager = this.mRecord.mManager;
            for (Fragment fragment : manager.getFragments()) {
                fragment.setOnStartEnterTransitionListener(null);
                if (!canceled || !fragment.isPostponed()) continue;
                fragment.startPostponedEnterTransition();
            }
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, !canceled, true);
        }

        void cancelTransaction() {
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, false, false);
        }
    }

    private class PopBackStackState
    implements OpGenerator {
        final String mName;
        final int mId;
        final int mFlags;

        PopBackStackState(String name, int id2, int flags) {
            this.mName = name;
            this.mId = id2;
            this.mFlags = flags;
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            FragmentManager childManager;
            if (FragmentManager.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && (childManager = FragmentManager.this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
                return false;
            }
            return FragmentManager.this.popBackStackState(records, isRecordPop, this.mName, this.mId, this.mFlags);
        }
    }

    static interface OpGenerator {
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> var1, @NonNull ArrayList<Boolean> var2);
    }

    public static abstract class FragmentLifecycleCallbacks {
        public void onFragmentPreAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentPreCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        @Deprecated
        public void onFragmentActivityCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentSaveInstanceState(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Bundle outState) {
        }

        public void onFragmentViewDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }
    }

    private static class LifecycleAwareResultListener
    implements FragmentResultListener {
        private final Lifecycle mLifecycle;
        private final FragmentResultListener mListener;
        private final LifecycleEventObserver mObserver;

        LifecycleAwareResultListener(@NonNull Lifecycle lifecycle, @NonNull FragmentResultListener listener, @NonNull LifecycleEventObserver observer) {
            this.mLifecycle = lifecycle;
            this.mListener = listener;
            this.mObserver = observer;
        }

        public boolean isAtLeast(Lifecycle.State state) {
            return this.mLifecycle.getCurrentState().isAtLeast(state);
        }

        @Override
        public void onFragmentResult(@NonNull String requestKey, @NonNull Bundle result) {
            this.mListener.onFragmentResult(requestKey, result);
        }

        public void removeObserver() {
            this.mLifecycle.removeObserver((LifecycleObserver)this.mObserver);
        }
    }

    public static interface OnBackStackChangedListener {
        @MainThread
        public void onBackStackChanged();
    }

    public static interface BackStackEntry {
        public int getId();

        @Nullable
        public String getName();

        @Deprecated
        @StringRes
        public int getBreadCrumbTitleRes();

        @Deprecated
        @StringRes
        public int getBreadCrumbShortTitleRes();

        @Deprecated
        @Nullable
        public CharSequence getBreadCrumbTitle();

        @Deprecated
        @Nullable
        public CharSequence getBreadCrumbShortTitle();
    }
}

