/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.os.CancellationSignal;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SuppressLint(value={"UnknownNullness"})
public abstract class FragmentTransitionImpl {
    public abstract boolean canHandle(Object var1);

    public abstract Object cloneTransition(Object var1);

    public abstract Object wrapTransitionInSet(Object var1);

    public abstract void setSharedElementTargets(Object var1, View var2, ArrayList<View> var3);

    public abstract void setEpicenter(Object var1, View var2);

    protected void getBoundsOnScreen(View view, Rect epicenter) {
        if (!ViewCompat.isAttachedToWindow((View)view)) {
            return;
        }
        RectF rect = new RectF();
        rect.set(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        view.getMatrix().mapRect(rect);
        rect.offset((float)view.getLeft(), (float)view.getTop());
        ViewParent parent = view.getParent();
        while (parent instanceof View) {
            View parentView = (View)parent;
            rect.offset((float)(-parentView.getScrollX()), (float)(-parentView.getScrollY()));
            parentView.getMatrix().mapRect(rect);
            rect.offset((float)parentView.getLeft(), (float)parentView.getTop());
            parent = parentView.getParent();
        }
        int[] loc = new int[2];
        view.getRootView().getLocationOnScreen(loc);
        rect.offset((float)loc[0], (float)loc[1]);
        epicenter.set(Math.round(rect.left), Math.round(rect.top), Math.round(rect.right), Math.round(rect.bottom));
    }

    public abstract void addTargets(Object var1, ArrayList<View> var2);

    public abstract Object mergeTransitionsTogether(Object var1, Object var2, Object var3);

    public abstract void scheduleHideFragmentView(Object var1, View var2, ArrayList<View> var3);

    public abstract Object mergeTransitionsInSequence(Object var1, Object var2, Object var3);

    public abstract void beginDelayedTransition(ViewGroup var1, Object var2);

    ArrayList<String> prepareSetNameOverridesReordered(ArrayList<View> sharedElementsIn) {
        ArrayList<String> names = new ArrayList<String>();
        int numSharedElements = sharedElementsIn.size();
        for (int i = 0; i < numSharedElements; ++i) {
            View view = sharedElementsIn.get(i);
            names.add(ViewCompat.getTransitionName((View)view));
            ViewCompat.setTransitionName((View)view, null);
        }
        return names;
    }

    void setNameOverridesReordered(View sceneRoot, final ArrayList<View> sharedElementsOut, final ArrayList<View> sharedElementsIn, final ArrayList<String> inNames, Map<String, String> nameOverrides) {
        final int numSharedElements = sharedElementsIn.size();
        final ArrayList<String> outNames = new ArrayList<String>();
        block0: for (int i = 0; i < numSharedElements; ++i) {
            View view = sharedElementsOut.get(i);
            String name = ViewCompat.getTransitionName((View)view);
            outNames.add(name);
            if (name == null) continue;
            ViewCompat.setTransitionName((View)view, null);
            String inName = nameOverrides.get(name);
            for (int j = 0; j < numSharedElements; ++j) {
                if (!inName.equals(inNames.get(j))) continue;
                ViewCompat.setTransitionName((View)sharedElementsIn.get(j), (String)name);
                continue block0;
            }
        }
        OneShotPreDrawListener.add((View)sceneRoot, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < numSharedElements; ++i) {
                    ViewCompat.setTransitionName((View)((View)sharedElementsIn.get(i)), (String)((String)inNames.get(i)));
                    ViewCompat.setTransitionName((View)((View)sharedElementsOut.get(i)), (String)((String)outNames.get(i)));
                }
            }
        });
    }

    void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
        if (view.getVisibility() == 0) {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                if (ViewGroupCompat.isTransitionGroup((ViewGroup)viewGroup)) {
                    transitioningViews.add((View)viewGroup);
                } else {
                    int count = viewGroup.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        View child = viewGroup.getChildAt(i);
                        this.captureTransitioningViews(transitioningViews, child);
                    }
                }
            } else {
                transitioningViews.add(view);
            }
        }
    }

    void findNamedViews(Map<String, View> namedViews, @NonNull View view) {
        if (view.getVisibility() == 0) {
            String transitionName = ViewCompat.getTransitionName((View)view);
            if (transitionName != null) {
                namedViews.put(transitionName, view);
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = viewGroup.getChildAt(i);
                    this.findNamedViews(namedViews, child);
                }
            }
        }
    }

    void setNameOverridesOrdered(View sceneRoot, final ArrayList<View> sharedElementsIn, final Map<String, String> nameOverrides) {
        OneShotPreDrawListener.add((View)sceneRoot, (Runnable)new Runnable(){

            @Override
            public void run() {
                int numSharedElements = sharedElementsIn.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)sharedElementsIn.get(i);
                    String name = ViewCompat.getTransitionName((View)view);
                    if (name == null) continue;
                    String inName = FragmentTransitionImpl.findKeyForValue(nameOverrides, name);
                    ViewCompat.setTransitionName((View)view, (String)inName);
                }
            }
        });
    }

    public abstract void scheduleRemoveTargets(Object var1, Object var2, ArrayList<View> var3, Object var4, ArrayList<View> var5, Object var6, ArrayList<View> var7);

    public void setListenerForTransitionEnd(@NonNull Fragment outFragment, @NonNull Object transition, @NonNull CancellationSignal signal, @NonNull Runnable transitionCompleteRunnable) {
        transitionCompleteRunnable.run();
    }

    public abstract void swapSharedElementTargets(Object var1, ArrayList<View> var2, ArrayList<View> var3);

    public abstract void replaceTargets(Object var1, ArrayList<View> var2, ArrayList<View> var3);

    public abstract void addTarget(Object var1, View var2);

    public abstract void removeTarget(Object var1, View var2);

    public abstract void setEpicenter(Object var1, Rect var2);

    void scheduleNameReset(ViewGroup sceneRoot, final ArrayList<View> sharedElementsIn, final Map<String, String> nameOverrides) {
        OneShotPreDrawListener.add((View)sceneRoot, (Runnable)new Runnable(){

            @Override
            public void run() {
                int numSharedElements = sharedElementsIn.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)sharedElementsIn.get(i);
                    String name = ViewCompat.getTransitionName((View)view);
                    String inName = (String)nameOverrides.get(name);
                    ViewCompat.setTransitionName((View)view, (String)inName);
                }
            }
        });
    }

    protected static void bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (FragmentTransitionImpl.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        if (ViewCompat.getTransitionName((View)startView) != null) {
            views.add(startView);
        }
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransitionImpl.containedBeforeIndex(views, child, startIndex) || ViewCompat.getTransitionName((View)child) == null) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    protected static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    static String findKeyForValue(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

