/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.os.Build;
import android.text.PrecomputedText;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.text.PrecomputedTextCompat;
import java.util.stream.IntStream;

class UnprecomputeTextOnModificationSpannable
implements Spannable {
    private boolean mSafeToWrite = false;
    @NonNull
    private Spannable mDelegate;

    UnprecomputeTextOnModificationSpannable(@NonNull Spannable delegate) {
        this.mDelegate = delegate;
    }

    UnprecomputeTextOnModificationSpannable(@NonNull Spanned delegate) {
        this.mDelegate = new SpannableString((CharSequence)delegate);
    }

    UnprecomputeTextOnModificationSpannable(@NonNull CharSequence delegate) {
        this.mDelegate = new SpannableString(delegate);
    }

    private void ensureSafeWrites() {
        Spannable old = this.mDelegate;
        if (!this.mSafeToWrite && UnprecomputeTextOnModificationSpannable.precomputedTextDetector().isPrecomputedText((CharSequence)old)) {
            this.mDelegate = new SpannableString((CharSequence)old);
        }
        this.mSafeToWrite = true;
    }

    Spannable getUnwrappedSpannable() {
        return this.mDelegate;
    }

    public void setSpan(Object o, int i, int i1, int i2) {
        this.ensureSafeWrites();
        this.mDelegate.setSpan(o, i, i1, i2);
    }

    public void removeSpan(Object o) {
        this.ensureSafeWrites();
        this.mDelegate.removeSpan(o);
    }

    public <T> T[] getSpans(int i, int i1, Class<T> aClass) {
        return this.mDelegate.getSpans(i, i1, aClass);
    }

    public int getSpanStart(Object o) {
        return this.mDelegate.getSpanStart(o);
    }

    public int getSpanEnd(Object o) {
        return this.mDelegate.getSpanEnd(o);
    }

    public int getSpanFlags(Object o) {
        return this.mDelegate.getSpanFlags(o);
    }

    public int nextSpanTransition(int i, int i1, Class aClass) {
        return this.mDelegate.nextSpanTransition(i, i1, aClass);
    }

    public int length() {
        return this.mDelegate.length();
    }

    public char charAt(int i) {
        return this.mDelegate.charAt(i);
    }

    @NonNull
    public CharSequence subSequence(int i, int i1) {
        return this.mDelegate.subSequence(i, i1);
    }

    @NonNull
    public String toString() {
        return this.mDelegate.toString();
    }

    @RequiresApi(api=24)
    @NonNull
    public IntStream chars() {
        return CharSequenceHelper_API24.chars((CharSequence)this.mDelegate);
    }

    @RequiresApi(api=24)
    @NonNull
    public IntStream codePoints() {
        return CharSequenceHelper_API24.codePoints((CharSequence)this.mDelegate);
    }

    static PrecomputedTextDetector precomputedTextDetector() {
        return Build.VERSION.SDK_INT < 28 ? new PrecomputedTextDetector() : new PrecomputedTextDetector_28();
    }

    @RequiresApi(value=28)
    static class PrecomputedTextDetector_28
    extends PrecomputedTextDetector {
        PrecomputedTextDetector_28() {
        }

        @Override
        boolean isPrecomputedText(CharSequence text) {
            return text instanceof PrecomputedText || text instanceof PrecomputedTextCompat;
        }
    }

    static class PrecomputedTextDetector {
        PrecomputedTextDetector() {
        }

        boolean isPrecomputedText(CharSequence text) {
            return text instanceof PrecomputedTextCompat;
        }
    }

    @RequiresApi(value=24)
    private static class CharSequenceHelper_API24 {
        private CharSequenceHelper_API24() {
        }

        static IntStream codePoints(CharSequence charSequence) {
            return charSequence.codePoints();
        }

        static IntStream chars(CharSequence charSequence) {
            return charSequence.chars();
        }
    }
}

