/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicInteger;

@RequiresApi(value=21)
public abstract class DeferrableSurface {
    public static final Size SIZE_UNDEFINED = new Size(0, 0);
    private static final String TAG = "DeferrableSurface";
    private static final boolean DEBUG = Logger.isDebugEnabled("DeferrableSurface");
    private static final AtomicInteger USED_COUNT = new AtomicInteger(0);
    private static final AtomicInteger TOTAL_COUNT = new AtomicInteger(0);
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private int mUseCount = 0;
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private CallbackToFutureAdapter.Completer<Void> mTerminationCompleter;
    private final ListenableFuture<Void> mTerminationFuture;
    @NonNull
    private final Size mPrescribedSize;
    private final int mPrescribedStreamFormat;
    @Nullable
    Class<?> mContainerClass;

    public DeferrableSurface() {
        this(SIZE_UNDEFINED, 0);
    }

    public DeferrableSurface(@NonNull Size size, int format) {
        this.mPrescribedSize = size;
        this.mPrescribedStreamFormat = format;
        this.mTerminationFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Object object = this.mLock;
            synchronized (object) {
                this.mTerminationCompleter = completer;
            }
            return "DeferrableSurface-termination(" + this + ")";
        });
        if (Logger.isDebugEnabled(TAG)) {
            this.printGlobalDebugCounts("Surface created", TOTAL_COUNT.incrementAndGet(), USED_COUNT.get());
            String creationStackTrace = Log.getStackTraceString((Throwable)new Exception());
            this.mTerminationFuture.addListener(() -> {
                try {
                    this.mTerminationFuture.get();
                    this.printGlobalDebugCounts("Surface terminated", TOTAL_COUNT.decrementAndGet(), USED_COUNT.get());
                }
                catch (Exception e) {
                    Logger.e(TAG, "Unexpected surface termination for " + this + "\nStack Trace:\n" + creationStackTrace);
                    Object object = this.mLock;
                    synchronized (object) {
                        throw new IllegalArgumentException(String.format("DeferrableSurface %s [closed: %b, use_count: %s] terminated with unexpected exception.", this, this.mClosed, this.mUseCount), e);
                    }
                }
            }, CameraXExecutors.directExecutor());
        }
    }

    private void printGlobalDebugCounts(@NonNull String prefix, int totalCount, int useCount) {
        if (!DEBUG && Logger.isDebugEnabled(TAG)) {
            Logger.d(TAG, "DeferrableSurface usage statistics may be inaccurate since debug logging was not enabled at static initialization time. App restart may be required to enable accurate usage statistics.");
        }
        Logger.d(TAG, prefix + "[total_surfaces=" + totalCount + ", used_surfaces=" + useCount + "](" + this + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final ListenableFuture<Surface> getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return Futures.immediateFailedFuture(new SurfaceClosedException("DeferrableSurface already closed.", this));
            }
            return this.provideSurface();
        }
    }

    @NonNull
    protected abstract ListenableFuture<Surface> provideSurface();

    @NonNull
    public ListenableFuture<Void> getTerminationFuture() {
        return Futures.nonCancellationPropagating(this.mTerminationFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUseCount() throws SurfaceClosedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUseCount == 0 && this.mClosed) {
                throw new SurfaceClosedException("Cannot begin use on a closed surface.", this);
            }
            ++this.mUseCount;
            if (Logger.isDebugEnabled(TAG)) {
                if (this.mUseCount == 1) {
                    this.printGlobalDebugCounts("New surface in use", TOTAL_COUNT.get(), USED_COUNT.incrementAndGet());
                }
                Logger.d(TAG, "use count+1, useCount=" + this.mUseCount + " " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        CallbackToFutureAdapter.Completer<Void> terminationCompleter = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mClosed) {
                this.mClosed = true;
                if (this.mUseCount == 0) {
                    terminationCompleter = this.mTerminationCompleter;
                    this.mTerminationCompleter = null;
                }
                if (Logger.isDebugEnabled(TAG)) {
                    Logger.d(TAG, "surface closed,  useCount=" + this.mUseCount + " closed=true " + this);
                }
            }
        }
        if (terminationCompleter != null) {
            terminationCompleter.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUseCount() {
        CallbackToFutureAdapter.Completer<Void> terminationCompleter = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUseCount == 0) {
                throw new IllegalStateException("Decrementing use count occurs more times than incrementing");
            }
            --this.mUseCount;
            if (this.mUseCount == 0 && this.mClosed) {
                terminationCompleter = this.mTerminationCompleter;
                this.mTerminationCompleter = null;
            }
            if (Logger.isDebugEnabled(TAG)) {
                Logger.d(TAG, "use count-1,  useCount=" + this.mUseCount + " closed=" + this.mClosed + " " + this);
                if (this.mUseCount == 0) {
                    this.printGlobalDebugCounts("Surface no longer in use", TOTAL_COUNT.get(), USED_COUNT.decrementAndGet());
                }
            }
        }
        if (terminationCompleter != null) {
            terminationCompleter.set(null);
        }
    }

    @NonNull
    public Size getPrescribedSize() {
        return this.mPrescribedSize;
    }

    public int getPrescribedStreamFormat() {
        return this.mPrescribedStreamFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public int getUseCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUseCount;
        }
    }

    @Nullable
    public Class<?> getContainerClass() {
        return this.mContainerClass;
    }

    public void setContainerClass(@NonNull Class<?> containerClass) {
        this.mContainerClass = containerClass;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SurfaceClosedException
    extends Exception {
        DeferrableSurface mDeferrableSurface;

        public SurfaceClosedException(@NonNull String s, @NonNull DeferrableSurface surface) {
            super(s);
            this.mDeferrableSurface = surface;
        }

        @NonNull
        public DeferrableSurface getDeferrableSurface() {
            return this.mDeferrableSurface;
        }
    }

    public static final class SurfaceUnavailableException
    extends Exception {
        public SurfaceUnavailableException(@NonNull String message) {
            super(message);
        }
    }
}

