/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.ByteOrderedDataOutputStream;
import androidx.camera.core.impl.utils.ExifAttribute;
import androidx.camera.core.impl.utils.ExifData;
import androidx.camera.core.impl.utils.ExifTag;
import androidx.core.util.Preconditions;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

@RequiresApi(value=21)
public final class ExifOutputStream
extends FilterOutputStream {
    private static final String TAG = "ExifOutputStream";
    private static final boolean DEBUG = false;
    private static final int STREAMBUFFER_SIZE = 65536;
    private static final int STATE_SOI = 0;
    private static final int STATE_FRAME_HEADER = 1;
    private static final int STATE_JPEG_DATA = 2;
    private static final byte[] IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes(ExifAttribute.ASCII);
    private static final short BYTE_ALIGN_II = 18761;
    private static final short BYTE_ALIGN_MM = 19789;
    private static final byte START_CODE = 42;
    private static final int IFD_OFFSET = 8;
    private final ExifData mExifData;
    private final byte[] mSingleByteArray = new byte[1];
    private final ByteBuffer mBuffer = ByteBuffer.allocate(4);
    private int mState = 0;
    private int mByteToSkip;
    private int mByteToCopy;

    public ExifOutputStream(@NonNull OutputStream ou, @NonNull ExifData exifData) {
        super(new BufferedOutputStream(ou, 65536));
        this.mExifData = exifData;
    }

    private int requestByteToBuffer(int requestByteCount, byte[] buffer, int offset, int length) {
        int byteNeeded = requestByteCount - this.mBuffer.position();
        int byteToRead = Math.min(length, byteNeeded);
        this.mBuffer.put(buffer, offset, byteToRead);
        return byteToRead;
    }

    @Override
    public void write(@NonNull byte[] buffer, int offset, int length) throws IOException {
        while ((this.mByteToSkip > 0 || this.mByteToCopy > 0 || this.mState != 2) && length > 0) {
            int byteToProcess;
            if (this.mByteToSkip > 0) {
                byteToProcess = Math.min(length, this.mByteToSkip);
                length -= byteToProcess;
                this.mByteToSkip -= byteToProcess;
                offset += byteToProcess;
            }
            if (this.mByteToCopy > 0) {
                byteToProcess = Math.min(length, this.mByteToCopy);
                this.out.write(buffer, offset, byteToProcess);
                length -= byteToProcess;
                this.mByteToCopy -= byteToProcess;
                offset += byteToProcess;
            }
            if (length == 0) {
                return;
            }
            switch (this.mState) {
                case 0: {
                    int byteRead = this.requestByteToBuffer(2, buffer, offset, length);
                    offset += byteRead;
                    length -= byteRead;
                    if (this.mBuffer.position() < 2) {
                        return;
                    }
                    this.mBuffer.rewind();
                    if (this.mBuffer.getShort() != -40) {
                        throw new IOException("Not a valid jpeg image, cannot write exif");
                    }
                    this.out.write(this.mBuffer.array(), 0, 2);
                    this.mState = 1;
                    this.mBuffer.rewind();
                    ByteOrderedDataOutputStream dataOutputStream = new ByteOrderedDataOutputStream(this.out, ByteOrder.BIG_ENDIAN);
                    dataOutputStream.writeShort((short)-31);
                    this.writeExifSegment(dataOutputStream);
                    break;
                }
                case 1: {
                    short tag;
                    int byteRead = this.requestByteToBuffer(4, buffer, offset, length);
                    offset += byteRead;
                    length -= byteRead;
                    if (this.mBuffer.position() == 2 && (tag = this.mBuffer.getShort()) == -39) {
                        this.out.write(this.mBuffer.array(), 0, 2);
                        this.mBuffer.rewind();
                    }
                    if (this.mBuffer.position() < 4) {
                        return;
                    }
                    this.mBuffer.rewind();
                    short marker = this.mBuffer.getShort();
                    if (marker == -31) {
                        this.mByteToSkip = (this.mBuffer.getShort() & 0xFFFF) - 2;
                        this.mState = 2;
                    } else if (!JpegHeader.isSofMarker(marker)) {
                        this.out.write(this.mBuffer.array(), 0, 4);
                        this.mByteToCopy = (this.mBuffer.getShort() & 0xFFFF) - 2;
                    } else {
                        this.out.write(this.mBuffer.array(), 0, 4);
                        this.mState = 2;
                    }
                    this.mBuffer.rewind();
                }
            }
        }
        if (length > 0) {
            this.out.write(buffer, offset, length);
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.mSingleByteArray[0] = (byte)(0xFF & oneByte);
        this.write(this.mSingleByteArray);
    }

    @Override
    public void write(@NonNull byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    private void writeExifSegment(@NonNull ByteOrderedDataOutputStream dataOutputStream) throws IOException {
        int[] ifdOffsets = new int[ExifData.EXIF_TAGS.length];
        int[] ifdDataSizes = new int[ExifData.EXIF_TAGS.length];
        for (ExifTag tag : ExifData.EXIF_POINTER_TAGS) {
            for (int ifdIndex = 0; ifdIndex < ExifData.EXIF_TAGS.length; ++ifdIndex) {
                this.mExifData.getAttributes(ifdIndex).remove(tag.name);
            }
        }
        if (!this.mExifData.getAttributes(1).isEmpty()) {
            this.mExifData.getAttributes(0).put(ExifData.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifData.getByteOrder()));
        }
        if (!this.mExifData.getAttributes(2).isEmpty()) {
            this.mExifData.getAttributes(0).put(ExifData.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifData.getByteOrder()));
        }
        if (!this.mExifData.getAttributes(3).isEmpty()) {
            this.mExifData.getAttributes(1).put(ExifData.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(0L, this.mExifData.getByteOrder()));
        }
        int i = 0;
        while (i < ExifData.EXIF_TAGS.length) {
            int sum = 0;
            for (Map.Entry<String, ExifAttribute> entry : this.mExifData.getAttributes(i).entrySet()) {
                ExifAttribute exifAttribute = entry.getValue();
                int size = exifAttribute.size();
                if (size <= 4) continue;
                sum += size;
            }
            int n = i++;
            ifdDataSizes[n] = ifdDataSizes[n] + sum;
        }
        int position = 8;
        for (int ifdType = 0; ifdType < ExifData.EXIF_TAGS.length; ++ifdType) {
            if (this.mExifData.getAttributes(ifdType).isEmpty()) continue;
            ifdOffsets[ifdType] = position;
            position += 2 + this.mExifData.getAttributes(ifdType).size() * 12 + 4 + ifdDataSizes[ifdType];
        }
        int totalSize = position;
        totalSize += 8;
        if (!this.mExifData.getAttributes(1).isEmpty()) {
            this.mExifData.getAttributes(0).put(ExifData.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(ifdOffsets[1], this.mExifData.getByteOrder()));
        }
        if (!this.mExifData.getAttributes(2).isEmpty()) {
            this.mExifData.getAttributes(0).put(ExifData.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(ifdOffsets[2], this.mExifData.getByteOrder()));
        }
        if (!this.mExifData.getAttributes(3).isEmpty()) {
            this.mExifData.getAttributes(1).put(ExifData.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(ifdOffsets[3], this.mExifData.getByteOrder()));
        }
        dataOutputStream.writeUnsignedShort(totalSize);
        dataOutputStream.write(IDENTIFIER_EXIF_APP1);
        dataOutputStream.writeShort(this.mExifData.getByteOrder() == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
        dataOutputStream.setByteOrder(this.mExifData.getByteOrder());
        dataOutputStream.writeUnsignedShort(42);
        dataOutputStream.writeUnsignedInt(8L);
        for (int ifdType = 0; ifdType < ExifData.EXIF_TAGS.length; ++ifdType) {
            if (this.mExifData.getAttributes(ifdType).isEmpty()) continue;
            dataOutputStream.writeUnsignedShort(this.mExifData.getAttributes(ifdType).size());
            int dataOffset = ifdOffsets[ifdType] + 2 + this.mExifData.getAttributes(ifdType).size() * 12 + 4;
            for (Map.Entry<String, ExifAttribute> entry : this.mExifData.getAttributes(ifdType).entrySet()) {
                ExifTag tag = ExifData.Builder.sExifTagMapsForWriting.get(ifdType).get(entry.getKey());
                int tagNumber = ((ExifTag)Preconditions.checkNotNull((Object)tag, (Object)new StringBuilder().append((String)"Tag not supported: ").append((String)entry.getKey()).append((String)". Tag needs to be ported from ExifInterface to ExifData.").toString())).number;
                ExifAttribute attribute = entry.getValue();
                int size = attribute.size();
                dataOutputStream.writeUnsignedShort(tagNumber);
                dataOutputStream.writeUnsignedShort(attribute.format);
                dataOutputStream.writeInt(attribute.numberOfComponents);
                if (size > 4) {
                    dataOutputStream.writeUnsignedInt(dataOffset);
                    dataOffset += size;
                    continue;
                }
                dataOutputStream.write(attribute.bytes);
                if (size >= 4) continue;
                for (int i2 = size; i2 < 4; ++i2) {
                    dataOutputStream.writeByte(0);
                }
            }
            dataOutputStream.writeUnsignedInt(0L);
            for (Map.Entry<String, ExifAttribute> entry : this.mExifData.getAttributes(ifdType).entrySet()) {
                ExifAttribute attribute = entry.getValue();
                if (attribute.bytes.length <= 4) continue;
                dataOutputStream.write(attribute.bytes, 0, attribute.bytes.length);
            }
        }
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    static final class JpegHeader {
        public static final short SOI = -40;
        public static final short APP1 = -31;
        public static final short EOI = -39;
        public static final short SOF0 = -64;
        public static final short SOF15 = -49;
        public static final short DHT = -60;
        public static final short JPG = -56;
        public static final short DAC = -52;

        public static boolean isSofMarker(short marker) {
            return marker >= -64 && marker <= -49 && marker != -60 && marker != -56 && marker != -52;
        }

        private JpegHeader() {
        }
    }
}

