/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity;

import androidx.activity.Cancellable;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.core.os.BuildCompat;
import androidx.core.util.Consumer;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class OnBackPressedCallback {
    private boolean mEnabled;
    private CopyOnWriteArrayList<Cancellable> mCancellables = new CopyOnWriteArrayList();
    private Consumer<Boolean> mEnabledConsumer;

    public OnBackPressedCallback(boolean enabled) {
        this.mEnabled = enabled;
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    @MainThread
    public final void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        if (this.mEnabledConsumer != null) {
            this.mEnabledConsumer.accept((Object)this.mEnabled);
        }
    }

    @MainThread
    public final boolean isEnabled() {
        return this.mEnabled;
    }

    @MainThread
    public final void remove() {
        for (Cancellable cancellable : this.mCancellables) {
            cancellable.cancel();
        }
    }

    @MainThread
    public abstract void handleOnBackPressed();

    void addCancellable(@NonNull Cancellable cancellable) {
        this.mCancellables.add(cancellable);
    }

    void removeCancellable(@NonNull Cancellable cancellable) {
        this.mCancellables.remove(cancellable);
    }

    void setIsEnabledConsumer(@Nullable Consumer<Boolean> isEnabled) {
        this.mEnabledConsumer = isEnabled;
    }
}

