/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.content.Context;
import android.util.Log;
import android.util.Xml;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class AppLocalesStorageHelper {
    static final String APPLICATION_LOCALES_RECORD_FILE = "androidx.appcompat.app.AppCompatDelegate.application_locales_record_file";
    static final String LOCALE_RECORD_ATTRIBUTE_TAG = "application_locales";
    static final String LOCALE_RECORD_FILE_TAG = "locales";
    static final String TAG = "AppLocalesStorageHelper";
    static final boolean DEBUG = false;
    private static final Object sAppLocaleStorageSync = new Object();

    private AppLocalesStorageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String readLocales(@NonNull Context context) {
        Object object = sAppLocaleStorageSync;
        synchronized (object) {
            FileInputStream fis;
            String appLocales = "";
            try {
                fis = context.openFileInput(APPLICATION_LOCALES_RECORD_FILE);
            }
            catch (FileNotFoundException fnfe) {
                return appLocales;
            }
            try {
                int type;
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)fis, "UTF-8");
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    String tagName;
                    if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(LOCALE_RECORD_FILE_TAG)) continue;
                    appLocales = parser.getAttributeValue(null, LOCALE_RECORD_ATTRIBUTE_TAG);
                    break;
                }
            }
            catch (IOException | XmlPullParserException e) {
                Log.w((String)TAG, (String)"Reading app Locales : Unable to parse through file :androidx.appcompat.app.AppCompatDelegate.application_locales_record_file");
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (appLocales.isEmpty()) {
                context.deleteFile(APPLICATION_LOCALES_RECORD_FILE);
            }
            return appLocales;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistLocales(@NonNull Context context, @NonNull String locales) {
        Object object = sAppLocaleStorageSync;
        synchronized (object) {
            FileOutputStream fos;
            if (locales.equals("")) {
                context.deleteFile(APPLICATION_LOCALES_RECORD_FILE);
                return;
            }
            try {
                fos = context.openFileOutput(APPLICATION_LOCALES_RECORD_FILE, 0);
            }
            catch (FileNotFoundException fnfe) {
                Log.w((String)TAG, (String)String.format("Storing App Locales : FileNotFoundException: Cannot open file %s for writing ", APPLICATION_LOCALES_RECORD_FILE));
                return;
            }
            XmlSerializer serializer = Xml.newSerializer();
            try {
                serializer.setOutput((OutputStream)fos, null);
                serializer.startDocument("UTF-8", Boolean.valueOf(true));
                serializer.startTag(null, LOCALE_RECORD_FILE_TAG);
                serializer.attribute(null, LOCALE_RECORD_ATTRIBUTE_TAG, locales);
                serializer.endTag(null, LOCALE_RECORD_FILE_TAG);
                serializer.endDocument();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Storing App Locales : Failed to persist app-locales in storage ", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

