/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.annotation.SuppressLint;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class FileProvider
extends ContentProvider {
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_ROOT_PATH = "root-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_EXTERNAL_FILES = "external-files-path";
    private static final String TAG_EXTERNAL_CACHE = "external-cache-path";
    private static final String TAG_EXTERNAL_MEDIA = "external-media-path";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String DISPLAYNAME_FIELD = "displayName";
    private static final File DEVICE_ROOT = new File("/");
    @GuardedBy(value="sCache")
    private static final HashMap<String, PathStrategy> sCache = new HashMap();
    @GuardedBy(value="this")
    @Nullable
    private PathStrategy mLocalPathStrategy;
    private int mResourceId;
    private String mAuthority;

    public FileProvider() {
        this.mResourceId = 0;
    }

    protected FileProvider(@XmlRes int resourceId) {
        this.mResourceId = resourceId;
    }

    public boolean onCreate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachInfo(@NonNull Context context, @NonNull ProviderInfo info) {
        super.attachInfo(context, info);
        if (info.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mAuthority = info.authority.split(";")[0];
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            sCache.remove(this.mAuthority);
        }
    }

    public static Uri getUriForFile(@NonNull Context context, @NonNull String authority, @NonNull File file) {
        PathStrategy strategy = FileProvider.getPathStrategy(context, authority, 0);
        return strategy.getUriForFile(file);
    }

    @SuppressLint(value={"StreamFiles"})
    @NonNull
    public static Uri getUriForFile(@NonNull Context context, @NonNull String authority, @NonNull File file, @NonNull String displayName) {
        Uri uri = FileProvider.getUriForFile(context, authority, file);
        return uri.buildUpon().appendQueryParameter(DISPLAYNAME_FIELD, displayName).build();
    }

    @NonNull
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        File file = this.getLocalPathStrategy().getFileForUri(uri);
        String displayName = uri.getQueryParameter(DISPLAYNAME_FIELD);
        if (projection == null) {
            projection = COLUMNS;
        }
        String[] cols = new String[projection.length];
        Object[] values = new Object[projection.length];
        int i = 0;
        for (String col : projection) {
            if ("_display_name".equals(col)) {
                cols[i] = "_display_name";
                values[i++] = displayName == null ? file.getName() : displayName;
                continue;
            }
            if (!"_size".equals(col)) continue;
            cols[i] = "_size";
            values[i++] = file.length();
        }
        cols = FileProvider.copyOf(cols, i);
        values = FileProvider.copyOf(values, i);
        MatrixCursor cursor = new MatrixCursor(cols, 1);
        cursor.addRow(values);
        return cursor;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        File file = this.getLocalPathStrategy().getFileForUri(uri);
        int lastDot = file.getName().lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = file.getName().substring(lastDot + 1);
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    @Nullable
    public String getTypeAnonymous(@NonNull Uri uri) {
        return "application/octet-stream";
    }

    public Uri insert(@NonNull Uri uri, @NonNull ContentValues values) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public int update(@NonNull Uri uri, @NonNull ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException("No external updates");
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        File file = this.getLocalPathStrategy().getFileForUri(uri);
        return file.delete() ? 1 : 0;
    }

    @SuppressLint(value={"UnknownNullness"})
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode) throws FileNotFoundException {
        File file = this.getLocalPathStrategy().getFileForUri(uri);
        int fileMode = FileProvider.modeToMode(mode);
        return ParcelFileDescriptor.open((File)file, (int)fileMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathStrategy getLocalPathStrategy() {
        FileProvider fileProvider = this;
        synchronized (fileProvider) {
            if (this.mLocalPathStrategy == null) {
                this.mLocalPathStrategy = FileProvider.getPathStrategy(this.getContext(), this.mAuthority, this.mResourceId);
            }
            return this.mLocalPathStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PathStrategy getPathStrategy(Context context, String authority, int resourceId) {
        PathStrategy strat;
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            strat = sCache.get(authority);
            if (strat == null) {
                try {
                    strat = FileProvider.parsePathStrategy(context, authority, resourceId);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", e);
                }
                catch (XmlPullParserException e) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", e);
                }
                sCache.put(authority, strat);
            }
        }
        return strat;
    }

    @VisibleForTesting
    static XmlResourceParser getFileProviderPathsMetaData(Context context, String authority, @Nullable ProviderInfo info, int resourceId) {
        XmlResourceParser in;
        if (info == null) {
            throw new IllegalArgumentException("Couldn't find meta-data for provider with authority " + authority);
        }
        if (info.metaData == null && resourceId != 0) {
            info.metaData = new Bundle(1);
            info.metaData.putInt(META_DATA_FILE_PROVIDER_PATHS, resourceId);
        }
        if ((in = info.loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS)) == null) {
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        return in;
    }

    private static PathStrategy parsePathStrategy(Context context, String authority, int resourceId) throws IOException, XmlPullParserException {
        int type;
        SimplePathStrategy strat = new SimplePathStrategy(authority);
        ProviderInfo info = context.getPackageManager().resolveContentProvider(authority, 128);
        XmlResourceParser in = FileProvider.getFileProviderPathsMetaData(context, authority, info, resourceId);
        while ((type = in.next()) != 1) {
            File[] externalMediaDirs;
            if (type != 2) continue;
            String tag = in.getName();
            String name = in.getAttributeValue(null, ATTR_NAME);
            String path = in.getAttributeValue(null, ATTR_PATH);
            File target = null;
            if (TAG_ROOT_PATH.equals(tag)) {
                target = DEVICE_ROOT;
            } else if (TAG_FILES_PATH.equals(tag)) {
                target = context.getFilesDir();
            } else if (TAG_CACHE_PATH.equals(tag)) {
                target = context.getCacheDir();
            } else if (TAG_EXTERNAL.equals(tag)) {
                target = Environment.getExternalStorageDirectory();
            } else if (TAG_EXTERNAL_FILES.equals(tag)) {
                File[] externalFilesDirs = ContextCompat.getExternalFilesDirs(context, null);
                if (externalFilesDirs.length > 0) {
                    target = externalFilesDirs[0];
                }
            } else if (TAG_EXTERNAL_CACHE.equals(tag)) {
                File[] externalCacheDirs = ContextCompat.getExternalCacheDirs(context);
                if (externalCacheDirs.length > 0) {
                    target = externalCacheDirs[0];
                }
            } else if (Build.VERSION.SDK_INT >= 21 && TAG_EXTERNAL_MEDIA.equals(tag) && (externalMediaDirs = Api21Impl.getExternalMediaDirs(context)).length > 0) {
                target = externalMediaDirs[0];
            }
            if (target == null) continue;
            strat.addRoot(name, FileProvider.buildPath(target, path));
        }
        return strat;
    }

    private static int modeToMode(String mode) {
        int modeBits;
        if ("r".equals(mode)) {
            modeBits = 0x10000000;
        } else if ("w".equals(mode) || "wt".equals(mode)) {
            modeBits = 0x2C000000;
        } else if ("wa".equals(mode)) {
            modeBits = 0x2A000000;
        } else if ("rw".equals(mode)) {
            modeBits = 0x38000000;
        } else if ("rwt".equals(mode)) {
            modeBits = 0x3C000000;
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        return modeBits;
    }

    private static File buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            if (segment == null) continue;
            cur = new File(cur, segment);
        }
        return cur;
    }

    private static String[] copyOf(String[] original, int newLength) {
        String[] result = new String[newLength];
        System.arraycopy(original, 0, result, 0, newLength);
        return result;
    }

    private static Object[] copyOf(Object[] original, int newLength) {
        Object[] result = new Object[newLength];
        System.arraycopy(original, 0, result, 0, newLength);
        return result;
    }

    static interface PathStrategy {
        public Uri getUriForFile(File var1);

        public File getFileForUri(Uri var1);
    }

    static class SimplePathStrategy
    implements PathStrategy {
        private final String mAuthority;
        private final HashMap<String, File> mRoots = new HashMap();

        SimplePathStrategy(String authority) {
            this.mAuthority = authority;
        }

        void addRoot(String name, File root) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                throw new IllegalArgumentException("Name must not be empty");
            }
            try {
                root = root.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + root, e);
            }
            this.mRoots.put(name, root);
        }

        @Override
        public Uri getUriForFile(File file) {
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
            Map.Entry<String, File> mostSpecific = null;
            for (Map.Entry<String, File> root : this.mRoots.entrySet()) {
                String rootPath = root.getValue().getPath();
                if (!path.startsWith(rootPath) || mostSpecific != null && rootPath.length() <= mostSpecific.getValue().getPath().length()) continue;
                mostSpecific = root;
            }
            if (mostSpecific == null) {
                throw new IllegalArgumentException("Failed to find configured root that contains " + path);
            }
            String rootPath = ((File)mostSpecific.getValue()).getPath();
            path = rootPath.endsWith("/") ? path.substring(rootPath.length()) : path.substring(rootPath.length() + 1);
            path = Uri.encode((String)mostSpecific.getKey()) + '/' + Uri.encode((String)path, (String)"/");
            return new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath(path).build();
        }

        @Override
        public File getFileForUri(Uri uri) {
            String path = uri.getEncodedPath();
            int splitIndex = path.indexOf(47, 1);
            String tag = Uri.decode((String)path.substring(1, splitIndex));
            path = Uri.decode((String)path.substring(splitIndex + 1));
            File root = this.mRoots.get(tag);
            if (root == null) {
                throw new IllegalArgumentException("Unable to find configured root for " + uri);
            }
            File file = new File(root, path);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
            if (!file.getPath().startsWith(root.getPath())) {
                throw new SecurityException("Resolved path jumped beyond configured root");
            }
            return file;
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static File[] getExternalMediaDirs(Context context) {
            return context.getExternalMediaDirs();
        }
    }
}

