/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.service.quicksettings;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.PendingIntentCompat;

public class PendingIntentActivityWrapper {
    private final Context mContext;
    private final int mRequestCode;
    @NonNull
    private final Intent mIntent;
    private final int mFlags;
    @Nullable
    private final Bundle mOptions;
    @Nullable
    private final PendingIntent mPendingIntent;
    private final boolean mIsMutable;

    public PendingIntentActivityWrapper(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        this(context, requestCode, intent, flags, null, isMutable);
    }

    public PendingIntentActivityWrapper(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, @Nullable Bundle options, boolean isMutable) {
        this.mContext = context;
        this.mRequestCode = requestCode;
        this.mIntent = intent;
        this.mFlags = flags;
        this.mOptions = options;
        this.mIsMutable = isMutable;
        this.mPendingIntent = this.createPendingIntent();
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    @NonNull
    public Intent getIntent() {
        return this.mIntent;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @NonNull
    public Bundle getOptions() {
        return this.mOptions;
    }

    public boolean isMutable() {
        return this.mIsMutable;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    private PendingIntent createPendingIntent() {
        if (this.mOptions == null) {
            return PendingIntentCompat.getActivity(this.mContext, this.mRequestCode, this.mIntent, this.mFlags, this.mIsMutable);
        }
        return PendingIntentCompat.getActivity(this.mContext, this.mRequestCode, this.mIntent, this.mFlags, this.mOptions, this.mIsMutable);
    }
}

