/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.splashscreen;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.ImageView;
import android.window.SplashScreenView;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.core.splashscreen.MaskedDrawable;
import androidx.core.splashscreen.R;
import androidx.core.splashscreen.SplashScreenViewProvider;
import androidx.core.splashscreen.ThemeUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/core/splashscreen/SplashScreen;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "impl", "Landroidx/core/splashscreen/SplashScreen$Impl;", "install", "", "setKeepOnScreenCondition", "condition", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setOnExitAnimationListener", "listener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "Companion", "Impl", "Impl31", "KeepOnScreenCondition", "OnExitAnimationListener", "core-splashscreen_release"})
@SuppressLint(value={"CustomSplashScreen"})
public final class SplashScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Impl impl;
    private static final float MASK_FACTOR = 0.6666667f;

    private SplashScreen(Activity activity) {
        this.impl = Build.VERSION.SDK_INT >= 31 ? (Impl)new Impl31(activity) : new Impl(activity);
    }

    public final void setKeepOnScreenCondition(@NotNull KeepOnScreenCondition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.impl.setKeepOnScreenCondition(condition);
    }

    public final void setOnExitAnimationListener(@NotNull OnExitAnimationListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.impl.setOnExitAnimationListener(listener);
    }

    private final void install() {
        this.impl.install();
    }

    @JvmStatic
    @NotNull
    public static final SplashScreen installSplashScreen(@NotNull Activity $this$installSplashScreen) {
        return Companion.installSplashScreen($this$installSplashScreen);
    }

    public /* synthetic */ SplashScreen(Activity activity, DefaultConstructorMarker $constructor_marker) {
        this(activity);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/core/splashscreen/SplashScreen$Companion;", "", "()V", "MASK_FACTOR", "", "installSplashScreen", "Landroidx/core/splashscreen/SplashScreen;", "Landroid/app/Activity;", "core-splashscreen_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SplashScreen installSplashScreen(@NotNull Activity $this$installSplashScreen) {
            Intrinsics.checkNotNullParameter((Object)$this$installSplashScreen, (String)"<this>");
            SplashScreen splashScreen = new SplashScreen($this$installSplashScreen, null);
            splashScreen.install();
            return splashScreen;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0006"}, d2={"Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "", "onSplashScreenExit", "", "splashScreenViewProvider", "Landroidx/core/splashscreen/SplashScreenViewProvider;", "core-splashscreen_release"})
    public static interface OnExitAnimationListener {
        @MainThread
        public void onSplashScreenExit(@NotNull SplashScreenViewProvider var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "", "shouldKeepOnScreen", "", "core-splashscreen_release"})
    public static interface KeepOnScreenCondition {
        @MainThread
        public boolean shouldKeepOnScreen();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020%J\u0018\u0010/\u001a\u00020-2\u0006\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u00102\u001a\u00020-H\u0016J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020'H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\bH\u0016J\u001c\u00107\u001a\u00020-2\n\u00108\u001a\u000609R\u00020:2\u0006\u0010;\u001a\u00020<H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006="}, d2={"Landroidx/core/splashscreen/SplashScreen$Impl;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "animationListener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "backgroundColor", "", "getBackgroundColor", "()Ljava/lang/Integer;", "setBackgroundColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "backgroundResId", "getBackgroundResId", "setBackgroundResId", "finalThemeId", "getFinalThemeId", "()I", "setFinalThemeId", "(I)V", "hasBackground", "", "getHasBackground", "()Z", "setHasBackground", "(Z)V", "icon", "Landroid/graphics/drawable/Drawable;", "getIcon", "()Landroid/graphics/drawable/Drawable;", "setIcon", "(Landroid/graphics/drawable/Drawable;)V", "mSplashScreenViewProvider", "Landroidx/core/splashscreen/SplashScreenViewProvider;", "splashScreenWaitPredicate", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "getSplashScreenWaitPredicate", "()Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setSplashScreenWaitPredicate", "(Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;)V", "dispatchOnExitAnimation", "", "splashScreenViewProvider", "displaySplashScreenIcon", "splashScreenView", "Landroid/view/View;", "install", "setKeepOnScreenCondition", "keepOnScreenCondition", "setOnExitAnimationListener", "exitAnimationListener", "setPostSplashScreenTheme", "currentTheme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "typedValue", "Landroid/util/TypedValue;", "core-splashscreen_release"})
    private static class Impl {
        @NotNull
        private final Activity activity;
        private int finalThemeId;
        @Nullable
        private Integer backgroundResId;
        @Nullable
        private Integer backgroundColor;
        @Nullable
        private Drawable icon;
        private boolean hasBackground;
        @NotNull
        private KeepOnScreenCondition splashScreenWaitPredicate;
        @Nullable
        private OnExitAnimationListener animationListener;
        @Nullable
        private SplashScreenViewProvider mSplashScreenViewProvider;

        public Impl(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.splashScreenWaitPredicate = Impl::splashScreenWaitPredicate$lambda-0;
        }

        @NotNull
        public final Activity getActivity() {
            return this.activity;
        }

        public final int getFinalThemeId() {
            return this.finalThemeId;
        }

        public final void setFinalThemeId(int n) {
            this.finalThemeId = n;
        }

        @Nullable
        public final Integer getBackgroundResId() {
            return this.backgroundResId;
        }

        public final void setBackgroundResId(@Nullable Integer n) {
            this.backgroundResId = n;
        }

        @Nullable
        public final Integer getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(@Nullable Integer n) {
            this.backgroundColor = n;
        }

        @Nullable
        public final Drawable getIcon() {
            return this.icon;
        }

        public final void setIcon(@Nullable Drawable drawable2) {
            this.icon = drawable2;
        }

        public final boolean getHasBackground() {
            return this.hasBackground;
        }

        public final void setHasBackground(boolean bl) {
            this.hasBackground = bl;
        }

        @NotNull
        public final KeepOnScreenCondition getSplashScreenWaitPredicate() {
            return this.splashScreenWaitPredicate;
        }

        public final void setSplashScreenWaitPredicate(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"<set-?>");
            this.splashScreenWaitPredicate = keepOnScreenCondition;
        }

        public void install() {
            TypedValue typedValue = new TypedValue();
            Resources.Theme currentTheme = this.activity.getTheme();
            if (currentTheme.resolveAttribute(R.attr.windowSplashScreenBackground, typedValue, true)) {
                this.backgroundResId = typedValue.resourceId;
                this.backgroundColor = typedValue.data;
            }
            if (currentTheme.resolveAttribute(R.attr.windowSplashScreenAnimatedIcon, typedValue, true)) {
                this.icon = currentTheme.getDrawable(typedValue.resourceId);
            }
            if (currentTheme.resolveAttribute(R.attr.splashScreenIconSize, typedValue, true)) {
                this.hasBackground = typedValue.resourceId == R.dimen.splashscreen_icon_size_with_background;
            }
            Intrinsics.checkNotNullExpressionValue((Object)currentTheme, (String)"currentTheme");
            this.setPostSplashScreenTheme(currentTheme, typedValue);
        }

        protected final void setPostSplashScreenTheme(@NotNull Resources.Theme currentTheme, @NotNull TypedValue typedValue) {
            Intrinsics.checkNotNullParameter((Object)currentTheme, (String)"currentTheme");
            Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
            if (currentTheme.resolveAttribute(R.attr.postSplashScreenTheme, typedValue, true)) {
                this.finalThemeId = typedValue.resourceId;
                if (this.finalThemeId != 0) {
                    this.activity.setTheme(this.finalThemeId);
                }
            }
        }

        public void setKeepOnScreenCondition(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"keepOnScreenCondition");
            this.splashScreenWaitPredicate = keepOnScreenCondition;
            View contentView = this.activity.findViewById(0x1020002);
            ViewTreeObserver observer = contentView.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, contentView){
                final /* synthetic */ Impl this$0;
                final /* synthetic */ View $contentView;
                {
                    this.this$0 = $receiver;
                    this.$contentView = $contentView;
                }

                public boolean onPreDraw() {
                    block1: {
                        if (this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                            return false;
                        }
                        this.$contentView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        SplashScreenViewProvider splashScreenViewProvider = Impl.access$getMSplashScreenViewProvider$p(this.this$0);
                        if (splashScreenViewProvider == null) break block1;
                        SplashScreenViewProvider splashScreenViewProvider2 = splashScreenViewProvider;
                        Impl impl = this.this$0;
                        SplashScreenViewProvider p0 = splashScreenViewProvider2;
                        boolean bl = false;
                        impl.dispatchOnExitAnimation(p0);
                    }
                    return true;
                }
            });
        }

        public void setOnExitAnimationListener(@NotNull OnExitAnimationListener exitAnimationListener) {
            Intrinsics.checkNotNullParameter((Object)exitAnimationListener, (String)"exitAnimationListener");
            this.animationListener = exitAnimationListener;
            SplashScreenViewProvider splashScreenViewProvider = new SplashScreenViewProvider(this.activity);
            Integer finalBackgroundResId = this.backgroundResId;
            Integer finalBackgroundColor = this.backgroundColor;
            View splashScreenView = splashScreenViewProvider.getView();
            if (finalBackgroundResId != null && finalBackgroundResId != 0) {
                splashScreenView.setBackgroundResource(finalBackgroundResId.intValue());
            } else if (finalBackgroundColor != null) {
                splashScreenView.setBackgroundColor(finalBackgroundColor.intValue());
            } else {
                splashScreenView.setBackground(this.activity.getWindow().getDecorView().getBackground());
            }
            Drawable drawable2 = this.icon;
            if (drawable2 != null) {
                Drawable it = drawable2;
                boolean bl = false;
                this.displaySplashScreenIcon(splashScreenView, it);
            }
            splashScreenView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, splashScreenViewProvider){
                final /* synthetic */ Impl this$0;
                final /* synthetic */ SplashScreenViewProvider $splashScreenViewProvider;
                {
                    this.this$0 = $receiver;
                    this.$splashScreenViewProvider = $splashScreenViewProvider;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    if (!view.isAttachedToWindow()) {
                        return;
                    }
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    if (!this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                        this.this$0.dispatchOnExitAnimation(this.$splashScreenViewProvider);
                    } else {
                        Impl.access$setMSplashScreenViewProvider$p(this.this$0, this.$splashScreenViewProvider);
                    }
                }
            });
        }

        private final void displaySplashScreenIcon(View splashScreenView, Drawable icon) {
            ImageView iconView;
            ImageView imageView;
            ImageView $this$displaySplashScreenIcon_u24lambda_u2d2 = imageView = (iconView = (ImageView)splashScreenView.findViewById(R.id.splashscreen_icon_view));
            boolean bl = false;
            float maskSize = 0.0f;
            if (this.hasBackground) {
                Drawable iconBackgroundDrawable = $this$displaySplashScreenIcon_u24lambda_u2d2.getContext().getDrawable(R.drawable.icon_background);
                float iconSize = $this$displaySplashScreenIcon_u24lambda_u2d2.getResources().getDimension(R.dimen.splashscreen_icon_size_with_background);
                maskSize = iconSize * 0.6666667f;
                if (iconBackgroundDrawable != null) {
                    $this$displaySplashScreenIcon_u24lambda_u2d2.setBackground((Drawable)new MaskedDrawable(iconBackgroundDrawable, maskSize));
                }
            } else {
                float iconSize = $this$displaySplashScreenIcon_u24lambda_u2d2.getResources().getDimension(R.dimen.splashscreen_icon_size_no_background);
                maskSize = iconSize * 0.6666667f;
            }
            $this$displaySplashScreenIcon_u24lambda_u2d2.setImageDrawable((Drawable)new MaskedDrawable(icon, maskSize));
        }

        public final void dispatchOnExitAnimation(@NotNull SplashScreenViewProvider splashScreenViewProvider) {
            Intrinsics.checkNotNullParameter((Object)splashScreenViewProvider, (String)"splashScreenViewProvider");
            OnExitAnimationListener onExitAnimationListener = this.animationListener;
            if (onExitAnimationListener == null) {
                return;
            }
            OnExitAnimationListener finalListener = onExitAnimationListener;
            this.animationListener = null;
            splashScreenViewProvider.getView().postOnAnimation(() -> Impl.dispatchOnExitAnimation$lambda-3(splashScreenViewProvider, finalListener));
        }

        private static final boolean splashScreenWaitPredicate$lambda-0() {
            return false;
        }

        private static final void dispatchOnExitAnimation$lambda-3(SplashScreenViewProvider $splashScreenViewProvider, OnExitAnimationListener $finalListener) {
            Intrinsics.checkNotNullParameter((Object)$splashScreenViewProvider, (String)"$splashScreenViewProvider");
            Intrinsics.checkNotNullParameter((Object)$finalListener, (String)"$finalListener");
            $splashScreenViewProvider.getView().bringToFront();
            $finalListener.onSplashScreenExit($splashScreenViewProvider);
        }

        public static final /* synthetic */ SplashScreenViewProvider access$getMSplashScreenViewProvider$p(Impl $this) {
            return $this.mSplashScreenViewProvider;
        }

        public static final /* synthetic */ void access$setMSplashScreenViewProvider$p(Impl $this, SplashScreenViewProvider splashScreenViewProvider) {
            $this.mSplashScreenViewProvider = splashScreenViewProvider;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Landroidx/core/splashscreen/SplashScreen$Impl31;", "Landroidx/core/splashscreen/SplashScreen$Impl;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "hierarchyListener", "Landroid/view/ViewGroup$OnHierarchyChangeListener;", "getHierarchyListener", "()Landroid/view/ViewGroup$OnHierarchyChangeListener;", "mDecorFitWindowInsets", "", "getMDecorFitWindowInsets", "()Z", "setMDecorFitWindowInsets", "(Z)V", "preDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "getPreDrawListener", "()Landroid/view/ViewTreeObserver$OnPreDrawListener;", "setPreDrawListener", "(Landroid/view/ViewTreeObserver$OnPreDrawListener;)V", "applyAppSystemUiTheme", "", "computeDecorFitsWindow", "child", "Landroid/window/SplashScreenView;", "install", "setKeepOnScreenCondition", "keepOnScreenCondition", "Landroidx/core/splashscreen/SplashScreen$KeepOnScreenCondition;", "setOnExitAnimationListener", "exitAnimationListener", "Landroidx/core/splashscreen/SplashScreen$OnExitAnimationListener;", "core-splashscreen_release"})
    @RequiresApi(value=31)
    private static final class Impl31
    extends Impl {
        @Nullable
        private ViewTreeObserver.OnPreDrawListener preDrawListener;
        private boolean mDecorFitWindowInsets;
        @NotNull
        private final ViewGroup.OnHierarchyChangeListener hierarchyListener;

        public Impl31(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            super(activity);
            this.mDecorFitWindowInsets = true;
            this.hierarchyListener = new ViewGroup.OnHierarchyChangeListener(this, activity){
                final /* synthetic */ Impl31 this$0;
                final /* synthetic */ Activity $activity;
                {
                    this.this$0 = $receiver;
                    this.$activity = $activity;
                }

                public void onChildViewAdded(@Nullable View parent, @Nullable View child) {
                    if (child instanceof SplashScreenView) {
                        this.this$0.setMDecorFitWindowInsets(this.this$0.computeDecorFitsWindow((SplashScreenView)child));
                        ((ViewGroup)this.$activity.getWindow().getDecorView()).setOnHierarchyChangeListener(null);
                    }
                }

                public void onChildViewRemoved(@Nullable View parent, @Nullable View child) {
                }
            };
        }

        @Nullable
        public final ViewTreeObserver.OnPreDrawListener getPreDrawListener() {
            return this.preDrawListener;
        }

        public final void setPreDrawListener(@Nullable ViewTreeObserver.OnPreDrawListener onPreDrawListener) {
            this.preDrawListener = onPreDrawListener;
        }

        public final boolean getMDecorFitWindowInsets() {
            return this.mDecorFitWindowInsets;
        }

        public final void setMDecorFitWindowInsets(boolean bl) {
            this.mDecorFitWindowInsets = bl;
        }

        @NotNull
        public final ViewGroup.OnHierarchyChangeListener getHierarchyListener() {
            return this.hierarchyListener;
        }

        public final boolean computeDecorFitsWindow(@NotNull SplashScreenView child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            WindowInsets windowInsets = new WindowInsets.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"Builder().build()");
            WindowInsets inWindowInsets = windowInsets;
            Rect outLocalInsets = new Rect(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return inWindowInsets != child.getRootView().computeSystemWindowInsets(inWindowInsets, outLocalInsets) || !outLocalInsets.isEmpty();
        }

        @Override
        public void install() {
            Resources.Theme theme = this.getActivity().getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"activity.theme");
            this.setPostSplashScreenTheme(theme, new TypedValue());
            ((ViewGroup)this.getActivity().getWindow().getDecorView()).setOnHierarchyChangeListener(this.hierarchyListener);
        }

        @Override
        public void setKeepOnScreenCondition(@NotNull KeepOnScreenCondition keepOnScreenCondition) {
            Intrinsics.checkNotNullParameter((Object)keepOnScreenCondition, (String)"keepOnScreenCondition");
            this.setSplashScreenWaitPredicate(keepOnScreenCondition);
            View contentView = this.getActivity().findViewById(0x1020002);
            ViewTreeObserver observer = contentView.getViewTreeObserver();
            if (this.preDrawListener != null && observer.isAlive()) {
                observer.removeOnPreDrawListener(this.preDrawListener);
            }
            this.preDrawListener = new ViewTreeObserver.OnPreDrawListener(this, contentView){
                final /* synthetic */ Impl31 this$0;
                final /* synthetic */ View $contentView;
                {
                    this.this$0 = $receiver;
                    this.$contentView = $contentView;
                }

                public boolean onPreDraw() {
                    if (this.this$0.getSplashScreenWaitPredicate().shouldKeepOnScreen()) {
                        return false;
                    }
                    this.$contentView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            observer.addOnPreDrawListener(this.preDrawListener);
        }

        @Override
        public void setOnExitAnimationListener(@NotNull OnExitAnimationListener exitAnimationListener) {
            Intrinsics.checkNotNullParameter((Object)exitAnimationListener, (String)"exitAnimationListener");
            this.getActivity().getSplashScreen().setOnExitAnimationListener(arg_0 -> Impl31.setOnExitAnimationListener$lambda-0(this, exitAnimationListener, arg_0));
        }

        private final void applyAppSystemUiTheme() {
            TypedValue tv = new TypedValue();
            Resources.Theme theme = this.getActivity().getTheme();
            Window window = this.getActivity().getWindow();
            if (theme.resolveAttribute(16843857, tv, true)) {
                window.setStatusBarColor(tv.data);
            }
            if (theme.resolveAttribute(16843858, tv, true)) {
                window.setNavigationBarColor(tv.data);
            }
            if (theme.resolveAttribute(16843856, tv, true)) {
                if (tv.data != 0) {
                    window.addFlags(Integer.MIN_VALUE);
                } else {
                    window.clearFlags(Integer.MIN_VALUE);
                }
            }
            if (theme.resolveAttribute(16844293, tv, true)) {
                window.setNavigationBarContrastEnforced(tv.data != 0);
            }
            if (theme.resolveAttribute(16844292, tv, true)) {
                window.setStatusBarContrastEnforced(tv.data != 0);
            }
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"theme");
            ThemeUtils.Api31.applyThemesSystemBarAppearance(theme, (View)decorView, tv);
            decorView.setOnHierarchyChangeListener(null);
            window.setDecorFitsSystemWindows(this.mDecorFitWindowInsets);
        }

        private static final void setOnExitAnimationListener$lambda-0(Impl31 this$0, OnExitAnimationListener $exitAnimationListener, SplashScreenView splashScreenView) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$exitAnimationListener, (String)"$exitAnimationListener");
            Intrinsics.checkNotNullParameter((Object)splashScreenView, (String)"splashScreenView");
            this$0.applyAppSystemUiTheme();
            SplashScreenViewProvider splashScreenViewProvider = new SplashScreenViewProvider(splashScreenView, this$0.getActivity());
            $exitAnimationListener.onSplashScreenExit(splashScreenViewProvider);
        }
    }
}

