/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.InputConfiguration;
import android.media.Image;
import android.media.ImageWriter;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.ZslControl;
import androidx.camera.camera2.internal.ZslUtil;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.ImageWriterCompat;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Executor;

@RequiresApi(value=23)
final class ZslControlImpl
implements ZslControl {
    private static final int MAX_IMAGES = 2;
    @NonNull
    final Queue<ImageProxy> mImageRingBuffer = new LinkedList<ImageProxy>();
    @NonNull
    final Queue<TotalCaptureResult> mTotalCaptureResultRingBuffer = new LinkedList<TotalCaptureResult>();
    private boolean mIsZslDisabled = false;
    private boolean mIsYuvReprocessingSupported = false;
    private boolean mIsPrivateReprocessingSupported = false;
    SafeCloseImageReaderProxy mReprocessingImageReader;
    private DeferrableSurface mReprocessingImageDeferrableSurface;
    @Nullable
    ImageWriter mReprocessingImageWriter;

    ZslControlImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        this.mIsYuvReprocessingSupported = ZslUtil.isCapabilitySupported(cameraCharacteristicsCompat, 7);
        this.mIsPrivateReprocessingSupported = ZslUtil.isCapabilitySupported(cameraCharacteristicsCompat, 4);
    }

    @Override
    public void setZslDisabled(boolean disabled) {
        this.mIsZslDisabled = disabled;
    }

    @Override
    public void addZslConfig(@NonNull Size resolution, @NonNull SessionConfig.Builder sessionConfigBuilder) {
        if (this.mIsZslDisabled) {
            return;
        }
        if (!this.mIsYuvReprocessingSupported && !this.mIsPrivateReprocessingSupported) {
            return;
        }
        this.cleanup();
        int reprocessingImageFormat = this.mIsYuvReprocessingSupported ? 35 : 34;
        this.mReprocessingImageReader = new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader((int)resolution.getWidth(), (int)resolution.getHeight(), (int)reprocessingImageFormat, (int)2));
        this.mReprocessingImageReader.setOnImageAvailableListener(imageReader -> {
            ImageProxy imageProxy = imageReader.acquireLatestImage();
            if (imageProxy != null) {
                this.mImageRingBuffer.add(imageProxy);
            }
        }, CameraXExecutors.ioExecutor());
        this.mReprocessingImageDeferrableSurface = new ImmediateSurface(this.mReprocessingImageReader.getSurface(), new Size(this.mReprocessingImageReader.getWidth(), this.mReprocessingImageReader.getHeight()), reprocessingImageFormat);
        SafeCloseImageReaderProxy reprocessingImageReaderProxy = this.mReprocessingImageReader;
        this.mReprocessingImageDeferrableSurface.getTerminationFuture().addListener(() -> ((SafeCloseImageReaderProxy)reprocessingImageReaderProxy).safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addSurface(this.mReprocessingImageDeferrableSurface);
        sessionConfigBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                super.onCaptureCompleted(cameraCaptureResult);
                CaptureResult captureResult = cameraCaptureResult.getCaptureResult();
                if (captureResult != null && captureResult instanceof TotalCaptureResult) {
                    ZslControlImpl.this.mTotalCaptureResultRingBuffer.add((TotalCaptureResult)captureResult);
                }
            }
        });
        sessionConfigBuilder.addSessionStateCallback(new CameraCaptureSession.StateCallback(){

            public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                Surface surface = cameraCaptureSession.getInputSurface();
                if (surface != null) {
                    ZslControlImpl.this.mReprocessingImageWriter = ImageWriterCompat.newInstance((Surface)surface, (int)1);
                }
            }

            public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
            }
        });
        sessionConfigBuilder.setInputConfiguration(new InputConfiguration(this.mReprocessingImageReader.getWidth(), this.mReprocessingImageReader.getHeight(), this.mReprocessingImageReader.getImageFormat()));
    }

    @Override
    @Nullable
    public ImageProxy dequeueImageFromBuffer() {
        ImageProxy imageProxy = null;
        try {
            imageProxy = this.mImageRingBuffer.remove();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return imageProxy;
    }

    @Override
    public boolean enqueueImageToImageWriter(@NonNull ImageProxy imageProxy) {
        Image image = imageProxy.getImage();
        if (Build.VERSION.SDK_INT >= 23 && this.mReprocessingImageWriter != null && image != null) {
            ImageWriterCompat.queueInputImage((ImageWriter)this.mReprocessingImageWriter, (Image)image);
            return true;
        }
        return false;
    }

    private void cleanup() {
        ImageWriter reprocessingImageWriter;
        Queue<ImageProxy> imageRingBuffer = this.mImageRingBuffer;
        while (!imageRingBuffer.isEmpty()) {
            ImageProxy imageProxy = imageRingBuffer.remove();
            imageProxy.close();
        }
        Queue<TotalCaptureResult> totalCaptureResultRingBuffer = this.mTotalCaptureResultRingBuffer;
        totalCaptureResultRingBuffer.clear();
        DeferrableSurface reprocessingImageDeferrableSurface = this.mReprocessingImageDeferrableSurface;
        if (reprocessingImageDeferrableSurface != null) {
            SafeCloseImageReaderProxy reprocessingImageReaderProxy = this.mReprocessingImageReader;
            if (reprocessingImageReaderProxy != null) {
                reprocessingImageDeferrableSurface.getTerminationFuture().addListener(() -> ((SafeCloseImageReaderProxy)reprocessingImageReaderProxy).safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
            }
            reprocessingImageDeferrableSurface.close();
        }
        if ((reprocessingImageWriter = this.mReprocessingImageWriter) != null) {
            reprocessingImageWriter.close();
            this.mReprocessingImageWriter = null;
        }
    }
}

