/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProxyConfig {
    public static final String MATCH_HTTP = "http";
    public static final String MATCH_HTTPS = "https";
    public static final String MATCH_ALL_SCHEMES = "*";
    private static final String DIRECT = "direct://";
    private static final String BYPASS_RULE_SIMPLE_NAMES = "<local>";
    private static final String BYPASS_RULE_REMOVE_IMPLICIT = "<-loopback>";
    private List<ProxyRule> mProxyRules;
    private List<String> mBypassRules;
    private boolean mReverseBypass;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProxyConfig(@NonNull List<ProxyRule> proxyRules, @NonNull List<String> bypassRules, boolean reverseBypass) {
        this.mProxyRules = proxyRules;
        this.mBypassRules = bypassRules;
        this.mReverseBypass = reverseBypass;
    }

    @NonNull
    public List<ProxyRule> getProxyRules() {
        return Collections.unmodifiableList(this.mProxyRules);
    }

    @NonNull
    public List<String> getBypassRules() {
        return Collections.unmodifiableList(this.mBypassRules);
    }

    public boolean isReverseBypassEnabled() {
        return this.mReverseBypass;
    }

    public static final class Builder {
        private List<ProxyRule> mProxyRules;
        private List<String> mBypassRules;
        private boolean mReverseBypass = false;

        public Builder() {
            this.mProxyRules = new ArrayList<ProxyRule>();
            this.mBypassRules = new ArrayList<String>();
        }

        public Builder(@NonNull ProxyConfig proxyConfig) {
            this.mProxyRules = proxyConfig.getProxyRules();
            this.mBypassRules = proxyConfig.getBypassRules();
            this.mReverseBypass = proxyConfig.isReverseBypassEnabled();
        }

        @NonNull
        public ProxyConfig build() {
            return new ProxyConfig(this.proxyRules(), this.bypassRules(), this.reverseBypass());
        }

        @NonNull
        public Builder addProxyRule(@NonNull String proxyUrl) {
            this.mProxyRules.add(new ProxyRule(proxyUrl));
            return this;
        }

        @NonNull
        public Builder addProxyRule(@NonNull String proxyUrl, @NonNull String schemeFilter) {
            this.mProxyRules.add(new ProxyRule(schemeFilter, proxyUrl));
            return this;
        }

        @NonNull
        public Builder addBypassRule(@NonNull String bypassRule) {
            this.mBypassRules.add(bypassRule);
            return this;
        }

        @NonNull
        public Builder addDirect(@NonNull String schemeFilter) {
            this.mProxyRules.add(new ProxyRule(schemeFilter, ProxyConfig.DIRECT));
            return this;
        }

        @NonNull
        public Builder addDirect() {
            return this.addDirect(ProxyConfig.MATCH_ALL_SCHEMES);
        }

        @NonNull
        public Builder bypassSimpleHostnames() {
            return this.addBypassRule(ProxyConfig.BYPASS_RULE_SIMPLE_NAMES);
        }

        @NonNull
        public Builder removeImplicitRules() {
            return this.addBypassRule(ProxyConfig.BYPASS_RULE_REMOVE_IMPLICIT);
        }

        @NonNull
        public Builder setReverseBypassEnabled(boolean reverseBypass) {
            this.mReverseBypass = reverseBypass;
            return this;
        }

        @NonNull
        private List<ProxyRule> proxyRules() {
            return this.mProxyRules;
        }

        @NonNull
        private List<String> bypassRules() {
            return this.mBypassRules;
        }

        private boolean reverseBypass() {
            return this.mReverseBypass;
        }
    }

    public static final class ProxyRule {
        private String mSchemeFilter;
        private String mUrl;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public ProxyRule(@NonNull String schemeFilter, @NonNull String url) {
            this.mSchemeFilter = schemeFilter;
            this.mUrl = url;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public ProxyRule(@NonNull String url) {
            this(ProxyConfig.MATCH_ALL_SCHEMES, url);
        }

        @NonNull
        public String getSchemeFilter() {
            return this.mSchemeFilter;
        }

        @NonNull
        public String getUrl() {
            return this.mUrl;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ProxyScheme {
    }
}

