/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class UserAgentMetadata {
    public static final int BITNESS_DEFAULT = 0;
    private final List<BrandVersion> mBrandVersionList;
    private final String mFullVersion;
    private final String mPlatform;
    private final String mPlatformVersion;
    private final String mArchitecture;
    private final String mModel;
    private boolean mMobile = true;
    private int mBitness = 0;
    private boolean mWow64 = false;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    private UserAgentMetadata(@NonNull List<BrandVersion> brandVersionList, @Nullable String fullVersion, @Nullable String platform, @Nullable String platformVersion, @Nullable String architecture, @Nullable String model, boolean mobile, int bitness, boolean wow64) {
        this.mBrandVersionList = brandVersionList;
        this.mFullVersion = fullVersion;
        this.mPlatform = platform;
        this.mPlatformVersion = platformVersion;
        this.mArchitecture = architecture;
        this.mModel = model;
        this.mMobile = mobile;
        this.mBitness = bitness;
        this.mWow64 = wow64;
    }

    @NonNull
    public List<BrandVersion> getBrandVersionList() {
        return this.mBrandVersionList;
    }

    @Nullable
    public String getFullVersion() {
        return this.mFullVersion;
    }

    @Nullable
    public String getPlatform() {
        return this.mPlatform;
    }

    @Nullable
    public String getPlatformVersion() {
        return this.mPlatformVersion;
    }

    @Nullable
    public String getArchitecture() {
        return this.mArchitecture;
    }

    @Nullable
    public String getModel() {
        return this.mModel;
    }

    public boolean isMobile() {
        return this.mMobile;
    }

    public int getBitness() {
        return this.mBitness;
    }

    public boolean isWow64() {
        return this.mWow64;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAgentMetadata)) {
            return false;
        }
        UserAgentMetadata that = (UserAgentMetadata)o;
        return this.mMobile == that.mMobile && this.mBitness == that.mBitness && this.mWow64 == that.mWow64 && Objects.equals(this.mBrandVersionList, that.mBrandVersionList) && Objects.equals(this.mFullVersion, that.mFullVersion) && Objects.equals(this.mPlatform, that.mPlatform) && Objects.equals(this.mPlatformVersion, that.mPlatformVersion) && Objects.equals(this.mArchitecture, that.mArchitecture) && Objects.equals(this.mModel, that.mModel);
    }

    public int hashCode() {
        return Objects.hash(this.mBrandVersionList, this.mFullVersion, this.mPlatform, this.mPlatformVersion, this.mArchitecture, this.mModel, this.mMobile, this.mBitness, this.mWow64);
    }

    public static final class Builder {
        private List<BrandVersion> mBrandVersionList = new ArrayList<BrandVersion>();
        private String mFullVersion;
        private String mPlatform;
        private String mPlatformVersion;
        private String mArchitecture;
        private String mModel;
        private boolean mMobile = true;
        private int mBitness = 0;
        private boolean mWow64 = false;

        public Builder() {
        }

        public Builder(@NonNull UserAgentMetadata uaMetadata) {
            this.mBrandVersionList = uaMetadata.getBrandVersionList();
            this.mFullVersion = uaMetadata.getFullVersion();
            this.mPlatform = uaMetadata.getPlatform();
            this.mPlatformVersion = uaMetadata.getPlatformVersion();
            this.mArchitecture = uaMetadata.getArchitecture();
            this.mModel = uaMetadata.getModel();
            this.mMobile = uaMetadata.isMobile();
            this.mBitness = uaMetadata.getBitness();
            this.mWow64 = uaMetadata.isWow64();
        }

        @NonNull
        public UserAgentMetadata build() {
            return new UserAgentMetadata(this.mBrandVersionList, this.mFullVersion, this.mPlatform, this.mPlatformVersion, this.mArchitecture, this.mModel, this.mMobile, this.mBitness, this.mWow64);
        }

        @NonNull
        public Builder setBrandVersionList(@NonNull List<BrandVersion> brandVersions) {
            this.mBrandVersionList = brandVersions;
            return this;
        }

        @NonNull
        public Builder setFullVersion(@Nullable String fullVersion) {
            if (fullVersion == null) {
                this.mFullVersion = null;
                return this;
            }
            if (fullVersion.trim().isEmpty()) {
                throw new IllegalArgumentException("Full version should not be blank.");
            }
            this.mFullVersion = fullVersion;
            return this;
        }

        @NonNull
        public Builder setPlatform(@Nullable String platform) {
            if (platform == null) {
                this.mPlatform = null;
                return this;
            }
            if (platform.trim().isEmpty()) {
                throw new IllegalArgumentException("Platform should not be blank.");
            }
            this.mPlatform = platform;
            return this;
        }

        @NonNull
        public Builder setPlatformVersion(@Nullable String platformVersion) {
            this.mPlatformVersion = platformVersion;
            return this;
        }

        @NonNull
        public Builder setArchitecture(@Nullable String architecture) {
            this.mArchitecture = architecture;
            return this;
        }

        @NonNull
        public Builder setModel(@Nullable String model) {
            this.mModel = model;
            return this;
        }

        @NonNull
        public Builder setMobile(boolean mobile) {
            this.mMobile = mobile;
            return this;
        }

        @NonNull
        public Builder setBitness(int bitness) {
            this.mBitness = bitness;
            return this;
        }

        @NonNull
        public Builder setWow64(boolean wow64) {
            this.mWow64 = wow64;
            return this;
        }
    }

    public static final class BrandVersion {
        private final String mBrand;
        private final String mMajorVersion;
        private final String mFullVersion;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        private BrandVersion(@NonNull String brand, @NonNull String majorVersion, @NonNull String fullVersion) {
            this.mBrand = brand;
            this.mMajorVersion = majorVersion;
            this.mFullVersion = fullVersion;
        }

        @NonNull
        public String getBrand() {
            return this.mBrand;
        }

        @NonNull
        public String getMajorVersion() {
            return this.mMajorVersion;
        }

        @NonNull
        public String getFullVersion() {
            return this.mFullVersion;
        }

        @NonNull
        public String toString() {
            return this.mBrand + "," + this.mMajorVersion + "," + this.mFullVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BrandVersion)) {
                return false;
            }
            BrandVersion that = (BrandVersion)o;
            return Objects.equals(this.mBrand, that.mBrand) && Objects.equals(this.mMajorVersion, that.mMajorVersion) && Objects.equals(this.mFullVersion, that.mFullVersion);
        }

        public int hashCode() {
            return Objects.hash(this.mBrand, this.mMajorVersion, this.mFullVersion);
        }

        public static final class Builder {
            private String mBrand;
            private String mMajorVersion;
            private String mFullVersion;

            public Builder() {
            }

            public Builder(@NonNull BrandVersion brandVersion) {
                this.mBrand = brandVersion.getBrand();
                this.mMajorVersion = brandVersion.getMajorVersion();
                this.mFullVersion = brandVersion.getFullVersion();
            }

            @NonNull
            public BrandVersion build() {
                if (this.mBrand == null || this.mBrand.trim().isEmpty() || this.mMajorVersion == null || this.mMajorVersion.trim().isEmpty() || this.mFullVersion == null || this.mFullVersion.trim().isEmpty()) {
                    throw new IllegalStateException("Brand name, major version and full version should not be null or blank.");
                }
                return new BrandVersion(this.mBrand, this.mMajorVersion, this.mFullVersion);
            }

            @NonNull
            public Builder setBrand(@NonNull String brand) {
                if (brand.trim().isEmpty()) {
                    throw new IllegalArgumentException("Brand should not be blank.");
                }
                this.mBrand = brand;
                return this;
            }

            @NonNull
            public Builder setMajorVersion(@NonNull String majorVersion) {
                if (majorVersion.trim().isEmpty()) {
                    throw new IllegalArgumentException("MajorVersion should not be blank.");
                }
                this.mMajorVersion = majorVersion;
                return this;
            }

            @NonNull
            public Builder setFullVersion(@NonNull String fullVersion) {
                if (fullVersion.trim().isEmpty()) {
                    throw new IllegalArgumentException("FullVersion should not be blank.");
                }
                this.mFullVersion = fullVersion;
                return this;
            }
        }
    }
}

