/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.app.AppComponentFactory;
import android.app.Application;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;

@RequiresApi(api=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class CoreComponentFactory
extends AppComponentFactory {
    @NonNull
    public Activity instantiateActivity(@NonNull ClassLoader cl, @NonNull String className, @Nullable Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CoreComponentFactory.checkCompatWrapper(super.instantiateActivity(cl, className, intent));
    }

    @NonNull
    public Application instantiateApplication(@NonNull ClassLoader cl, @NonNull String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CoreComponentFactory.checkCompatWrapper(super.instantiateApplication(cl, className));
    }

    @NonNull
    public BroadcastReceiver instantiateReceiver(@NonNull ClassLoader cl, @NonNull String className, @Nullable Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CoreComponentFactory.checkCompatWrapper(super.instantiateReceiver(cl, className, intent));
    }

    @NonNull
    public ContentProvider instantiateProvider(@NonNull ClassLoader cl, @NonNull String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CoreComponentFactory.checkCompatWrapper(super.instantiateProvider(cl, className));
    }

    @NonNull
    public Service instantiateService(@NonNull ClassLoader cl, @NonNull String className, @Nullable Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CoreComponentFactory.checkCompatWrapper(super.instantiateService(cl, className, intent));
    }

    static <T> T checkCompatWrapper(T obj) {
        Object wrapper;
        if (obj instanceof CompatWrapped && (wrapper = ((CompatWrapped)obj).getWrapper()) != null) {
            return (T)wrapper;
        }
        return obj;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static interface CompatWrapped {
        public Object getWrapper();
    }
}

