/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class BundleCompat {
    private BundleCompat() {
    }

    @Nullable
    public static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelable(in, key, clazz);
        }
        Parcelable parcelable = in.getParcelable(key);
        return (T)(clazz.isInstance(parcelable) ? parcelable : null);
    }

    @Nullable
    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public static Parcelable[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends Parcelable> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArray(in, key, clazz);
        }
        return in.getParcelableArray(key);
    }

    @Nullable
    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArrayList(in, key, clazz);
        }
        return in.getParcelableArrayList(key);
    }

    @Nullable
    public static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getSparseParcelableArray(in, key, clazz);
        }
        return in.getSparseParcelableArray(key);
    }

    @Nullable
    public static IBinder getBinder(@NonNull Bundle bundle, @Nullable String key) {
        if (Build.VERSION.SDK_INT >= 18) {
            return Api18Impl.getBinder(bundle, key);
        }
        return BeforeApi18Impl.getBinder(bundle, key);
    }

    public static void putBinder(@NonNull Bundle bundle, @Nullable String key, @Nullable IBinder binder) {
        if (Build.VERSION.SDK_INT >= 18) {
            Api18Impl.putBinder(bundle, key, binder);
        } else {
            BeforeApi18Impl.putBinder(bundle, key, binder);
        }
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return (T)in.getParcelable(key, clazz);
        }

        @DoNotInline
        static <T> T[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return in.getParcelableArray(key, clazz);
        }

        @DoNotInline
        static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getParcelableArrayList(key, clazz);
        }

        @DoNotInline
        static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getSparseParcelableArray(key, clazz);
        }
    }

    @RequiresApi(value=18)
    static class Api18Impl {
        private Api18Impl() {
        }

        @DoNotInline
        static IBinder getBinder(Bundle bundle, String key) {
            return bundle.getBinder(key);
        }

        @DoNotInline
        static void putBinder(Bundle bundle, String key, IBinder value) {
            bundle.putBinder(key, value);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    static class BeforeApi18Impl {
        private static final String TAG = "BundleCompat";
        private static Method sGetIBinderMethod;
        private static boolean sGetIBinderMethodFetched;
        private static Method sPutIBinderMethod;
        private static boolean sPutIBinderMethodFetched;

        private BeforeApi18Impl() {
        }

        public static IBinder getBinder(Bundle bundle, String key) {
            if (!sGetIBinderMethodFetched) {
                try {
                    sGetIBinderMethod = Bundle.class.getMethod("getIBinder", String.class);
                    sGetIBinderMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    Log.i((String)TAG, (String)"Failed to retrieve getIBinder method", (Throwable)e);
                }
                sGetIBinderMethodFetched = true;
            }
            if (sGetIBinderMethod != null) {
                try {
                    return (IBinder)sGetIBinderMethod.invoke((Object)bundle, key);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Log.i((String)TAG, (String)"Failed to invoke getIBinder via reflection", (Throwable)e);
                    sGetIBinderMethod = null;
                }
            }
            return null;
        }

        public static void putBinder(Bundle bundle, String key, IBinder binder) {
            if (!sPutIBinderMethodFetched) {
                try {
                    sPutIBinderMethod = Bundle.class.getMethod("putIBinder", String.class, IBinder.class);
                    sPutIBinderMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    Log.i((String)TAG, (String)"Failed to retrieve putIBinder method", (Throwable)e);
                }
                sPutIBinderMethodFetched = true;
            }
            if (sPutIBinderMethod != null) {
                try {
                    sPutIBinderMethod.invoke((Object)bundle, key, binder);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Log.i((String)TAG, (String)"Failed to invoke putIBinder via reflection", (Throwable)e);
                    sPutIBinderMethod = null;
                }
            }
        }
    }
}

