/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class FontProvider {
    private static final Comparator<byte[]> sByteArrayComparator = (l, r) -> {
        if (((byte[])l).length != ((byte[])r).length) {
            return ((byte[])l).length - ((byte[])r).length;
        }
        for (int i = 0; i < ((byte[])l).length; ++i) {
            if (l[i] == r[i]) continue;
            return l[i] - r[i];
        }
        return 0;
    };

    private FontProvider() {
    }

    @NonNull
    static FontsContractCompat.FontFamilyResult getFontFamilyResult(@NonNull Context context, @NonNull FontRequest request, @Nullable CancellationSignal cancellationSignal) throws PackageManager.NameNotFoundException {
        ProviderInfo providerInfo = FontProvider.getProvider(context.getPackageManager(), request, context.getResources());
        if (providerInfo == null) {
            return FontsContractCompat.FontFamilyResult.create(1, null);
        }
        FontsContractCompat.FontInfo[] fonts = FontProvider.query(context, request, providerInfo.authority, cancellationSignal);
        return FontsContractCompat.FontFamilyResult.create(0, fonts);
    }

    @VisibleForTesting
    @Nullable
    static ProviderInfo getProvider(@NonNull PackageManager packageManager, @NonNull FontRequest request, @Nullable Resources resources) throws PackageManager.NameNotFoundException {
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
        }
        PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
        List<byte[]> signatures = FontProvider.convertToByteArrayList(packageInfo.signatures);
        Collections.sort(signatures, sByteArrayComparator);
        List<List<byte[]>> requestCertificatesList = FontProvider.getCertificates(request, resources);
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!FontProvider.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    static FontsContractCompat.FontInfo[] query(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        ArrayList<FontsContractCompat.FontInfo> result = new ArrayList<FontsContractCompat.FontInfo>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = null;){
            String[] projection = new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"};
            ContentResolver resolver = context.getContentResolver();
            cursor = Build.VERSION.SDK_INT > 16 ? Api16Impl.query(resolver, uri, projection, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal) : resolver.query(uri, projection, "query = ?", new String[]{request.getQuery()}, null);
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                result = new ArrayList();
                int idColumnIndex = cursor.getColumnIndex("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    Uri fileUri;
                    long id2;
                    int ttcIndex;
                    int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    int n = ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                    if (fileIdColumnIndex == -1) {
                        id2 = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)uri, (long)id2);
                    } else {
                        id2 = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)fileBaseUri, (long)id2);
                    }
                    int weight = weightColumnIndex != -1 ? cursor.getInt(weightColumnIndex) : 400;
                    boolean italic = italicColumnIndex != -1 && cursor.getInt(italicColumnIndex) == 1;
                    result.add(FontsContractCompat.FontInfo.create(fileUri, ttcIndex, weight, italic, resultCode));
                }
            }
        }
        return result.toArray(new FontsContractCompat.FontInfo[0]);
    }

    private static List<List<byte[]>> getCertificates(FontRequest request, Resources resources) {
        if (request.getCertificates() != null) {
            return request.getCertificates();
        }
        int resourceId = request.getCertificatesArrayResId();
        return FontResourcesParserCompat.readCerts(resources, resourceId);
    }

    private static boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shaList = new ArrayList<byte[]>();
        for (Signature signature : signatures) {
            shaList.add(signature.toByteArray());
        }
        return shaList;
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        static Cursor query(ContentResolver contentResolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, Object cancellationSignal) {
            return contentResolver.query(uri, projection, selection, selectionArgs, sortOrder, (CancellationSignal)cancellationSignal);
        }
    }
}

