/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TypedValueCompat {
    private static final float INCHES_PER_PT = 0.013888889f;
    private static final float INCHES_PER_MM = 0.03937008f;

    private TypedValueCompat() {
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getUnitFromComplexDimension(int complexDimension) {
        return 0xF & complexDimension >> 0;
    }

    public static float deriveDimension(int unitToConvertTo, float pixelValue, @NonNull DisplayMetrics metrics) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.deriveDimension(unitToConvertTo, pixelValue, metrics);
        }
        switch (unitToConvertTo) {
            case 0: {
                return pixelValue;
            }
            case 1: {
                if (metrics.density == 0.0f) {
                    return 0.0f;
                }
                return pixelValue / metrics.density;
            }
            case 2: {
                if (metrics.scaledDensity == 0.0f) {
                    return 0.0f;
                }
                return pixelValue / metrics.scaledDensity;
            }
            case 3: {
                if (metrics.xdpi == 0.0f) {
                    return 0.0f;
                }
                return pixelValue / metrics.xdpi / 0.013888889f;
            }
            case 4: {
                if (metrics.xdpi == 0.0f) {
                    return 0.0f;
                }
                return pixelValue / metrics.xdpi;
            }
            case 5: {
                if (metrics.xdpi == 0.0f) {
                    return 0.0f;
                }
                return pixelValue / metrics.xdpi / 0.03937008f;
            }
        }
        throw new IllegalArgumentException("Invalid unitToConvertTo " + unitToConvertTo);
    }

    public static float dpToPx(float dpValue, @NonNull DisplayMetrics metrics) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)metrics);
    }

    public static float pxToDp(float pixelValue, @NonNull DisplayMetrics metrics) {
        return TypedValueCompat.deriveDimension(1, pixelValue, metrics);
    }

    public static float spToPx(float spValue, @NonNull DisplayMetrics metrics) {
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)metrics);
    }

    public static float pxToSp(float pixelValue, @NonNull DisplayMetrics metrics) {
        return TypedValueCompat.deriveDimension(2, pixelValue, metrics);
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        public static float deriveDimension(int unitToConvertTo, float pixelValue, DisplayMetrics metrics) {
            return TypedValue.deriveDimension((int)unitToConvertTo, (float)pixelValue, (DisplayMetrics)metrics);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ComplexDimensionUnit {
    }
}

