/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorUpdateListener;
import java.lang.ref.WeakReference;

public final class ViewPropertyAnimatorCompat {
    private final WeakReference<View> mView;
    Runnable mStartAction = null;
    Runnable mEndAction = null;
    int mOldLayerType = -1;
    static final int LISTENER_TAG_ID = 0x7E000000;

    ViewPropertyAnimatorCompat(View view) {
        this.mView = new WeakReference<View>(view);
    }

    @NonNull
    public ViewPropertyAnimatorCompat setDuration(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setDuration(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat alpha(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().alpha(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat alphaBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().alphaBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat withEndAction(@NonNull Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                ViewPropertyAnimator animator = view.animate();
                Api16Impl.withEndAction(animator, runnable);
            } else {
                this.setListenerInternal(view, new ViewPropertyAnimatorListenerApi14(this));
                this.mEndAction = runnable;
            }
        }
        return this;
    }

    public long getDuration() {
        View view = (View)this.mView.get();
        if (view != null) {
            return view.animate().getDuration();
        }
        return 0L;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setInterpolator(@Nullable Interpolator value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setInterpolator((TimeInterpolator)value);
        }
        return this;
    }

    @Nullable
    public Interpolator getInterpolator() {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 18) {
            ViewPropertyAnimator animator = view.animate();
            return Api18Impl.getInterpolator(animator);
        }
        return null;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setStartDelay(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setStartDelay(value);
        }
        return this;
    }

    public long getStartDelay() {
        View view = (View)this.mView.get();
        if (view != null) {
            return view.animate().getStartDelay();
        }
        return 0L;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotation(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotation(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationYBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleYBy(value);
        }
        return this;
    }

    public void cancel() {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().cancel();
        }
    }

    @NonNull
    public ViewPropertyAnimatorCompat x(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().x(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat xBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().xBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat y(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().y(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat yBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().yBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationYBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationZBy(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.translationZBy(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationZ(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.translationZ(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat z(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.z(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat zBy(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.zBy(animator, value);
        }
        return this;
    }

    public void start() {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().start();
        }
    }

    @NonNull
    @SuppressLint(value={"WrongConstant"})
    public ViewPropertyAnimatorCompat withLayer() {
        View view = (View)this.mView.get();
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                ViewPropertyAnimator animator = view.animate();
                Api16Impl.withLayer(animator);
            } else {
                this.mOldLayerType = view.getLayerType();
                this.setListenerInternal(view, new ViewPropertyAnimatorListenerApi14(this));
            }
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat withStartAction(@NonNull Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                ViewPropertyAnimator animator = view.animate();
                Api16Impl.withStartAction(animator, runnable);
            } else {
                this.setListenerInternal(view, new ViewPropertyAnimatorListenerApi14(this));
                this.mStartAction = runnable;
            }
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setListener(@Nullable ViewPropertyAnimatorListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.setListenerInternal(view, listener);
            } else {
                view.setTag(0x7E000000, (Object)listener);
                this.setListenerInternal(view, new ViewPropertyAnimatorListenerApi14(this));
            }
        }
        return this;
    }

    private void setListenerInternal(final View view, final ViewPropertyAnimatorListener listener) {
        if (listener != null) {
            view.animate().setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    listener.onAnimationCancel(view);
                }

                public void onAnimationEnd(Animator animation) {
                    listener.onAnimationEnd(view);
                }

                public void onAnimationStart(Animator animation) {
                    listener.onAnimationStart(view);
                }
            });
        } else {
            view.animate().setListener(null);
        }
    }

    @NonNull
    public ViewPropertyAnimatorCompat setUpdateListener(@Nullable ViewPropertyAnimatorUpdateListener listener) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 19) {
            ValueAnimator.AnimatorUpdateListener wrapped = null;
            if (listener != null) {
                wrapped = valueAnimator -> listener.onAnimationUpdate(view);
            }
            ViewPropertyAnimator animator = view.animate();
            Api19Impl.setUpdateListener(animator, wrapped);
        }
        return this;
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        static ViewPropertyAnimator withEndAction(ViewPropertyAnimator viewPropertyAnimator, Runnable runnable) {
            return viewPropertyAnimator.withEndAction(runnable);
        }

        @DoNotInline
        static ViewPropertyAnimator withLayer(ViewPropertyAnimator viewPropertyAnimator) {
            return viewPropertyAnimator.withLayer();
        }

        @DoNotInline
        static ViewPropertyAnimator withStartAction(ViewPropertyAnimator viewPropertyAnimator, Runnable runnable) {
            return viewPropertyAnimator.withStartAction(runnable);
        }
    }

    static class ViewPropertyAnimatorListenerApi14
    implements ViewPropertyAnimatorListener {
        ViewPropertyAnimatorCompat mVpa;
        boolean mAnimEndCalled;

        ViewPropertyAnimatorListenerApi14(ViewPropertyAnimatorCompat vpa) {
            this.mVpa = vpa;
        }

        @Override
        public void onAnimationStart(@NonNull View view) {
            this.mAnimEndCalled = false;
            if (this.mVpa.mOldLayerType > -1) {
                view.setLayerType(2, null);
            }
            if (this.mVpa.mStartAction != null) {
                Runnable startAction = this.mVpa.mStartAction;
                this.mVpa.mStartAction = null;
                startAction.run();
            }
            Object listenerTag = view.getTag(0x7E000000);
            ViewPropertyAnimatorListener listener = null;
            if (listenerTag instanceof ViewPropertyAnimatorListener) {
                listener = (ViewPropertyAnimatorListener)listenerTag;
            }
            if (listener != null) {
                listener.onAnimationStart(view);
            }
        }

        @Override
        @SuppressLint(value={"WrongConstant"})
        public void onAnimationEnd(@NonNull View view) {
            if (this.mVpa.mOldLayerType > -1) {
                view.setLayerType(this.mVpa.mOldLayerType, null);
                this.mVpa.mOldLayerType = -1;
            }
            if (Build.VERSION.SDK_INT >= 16 || !this.mAnimEndCalled) {
                if (this.mVpa.mEndAction != null) {
                    Runnable endAction = this.mVpa.mEndAction;
                    this.mVpa.mEndAction = null;
                    endAction.run();
                }
                Object listenerTag = view.getTag(0x7E000000);
                ViewPropertyAnimatorListener listener = null;
                if (listenerTag instanceof ViewPropertyAnimatorListener) {
                    listener = (ViewPropertyAnimatorListener)listenerTag;
                }
                if (listener != null) {
                    listener.onAnimationEnd(view);
                }
                this.mAnimEndCalled = true;
            }
        }

        @Override
        public void onAnimationCancel(@NonNull View view) {
            Object listenerTag = view.getTag(0x7E000000);
            ViewPropertyAnimatorListener listener = null;
            if (listenerTag instanceof ViewPropertyAnimatorListener) {
                listener = (ViewPropertyAnimatorListener)listenerTag;
            }
            if (listener != null) {
                listener.onAnimationCancel(view);
            }
        }
    }

    @RequiresApi(value=18)
    static class Api18Impl {
        private Api18Impl() {
        }

        @DoNotInline
        static Interpolator getInterpolator(ViewPropertyAnimator viewPropertyAnimator) {
            return (Interpolator)viewPropertyAnimator.getInterpolator();
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static ViewPropertyAnimator translationZBy(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.translationZBy(value);
        }

        @DoNotInline
        static ViewPropertyAnimator translationZ(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.translationZ(value);
        }

        @DoNotInline
        static ViewPropertyAnimator z(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.z(value);
        }

        @DoNotInline
        static ViewPropertyAnimator zBy(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.zBy(value);
        }
    }

    @RequiresApi(value=19)
    static class Api19Impl {
        private Api19Impl() {
        }

        @DoNotInline
        static ViewPropertyAnimator setUpdateListener(ViewPropertyAnimator viewPropertyAnimator, ValueAnimator.AnimatorUpdateListener listener) {
            return viewPropertyAnimator.setUpdateListener(listener);
        }
    }
}

