/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.accessibility;

import android.os.Build;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityRecord;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.accessibility.AccessibilityRecordCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AccessibilityEventCompat {
    @Deprecated
    public static final int TYPE_VIEW_HOVER_ENTER = 128;
    @Deprecated
    public static final int TYPE_VIEW_HOVER_EXIT = 256;
    @Deprecated
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    @Deprecated
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    @Deprecated
    public static final int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    @Deprecated
    public static final int TYPE_VIEW_SCROLLED = 4096;
    @Deprecated
    public static final int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;
    public static final int TYPE_ANNOUNCEMENT = 16384;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUSED = 32768;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED = 65536;
    public static final int TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY = 131072;
    public static final int TYPE_GESTURE_DETECTION_START = 262144;
    public static final int TYPE_GESTURE_DETECTION_END = 524288;
    public static final int TYPE_TOUCH_INTERACTION_START = 0x100000;
    public static final int TYPE_TOUCH_INTERACTION_END = 0x200000;
    public static final int TYPE_WINDOWS_CHANGED = 0x400000;
    public static final int TYPE_VIEW_CONTEXT_CLICKED = 0x800000;
    public static final int TYPE_ASSIST_READING_CONTEXT = 0x1000000;
    public static final int TYPE_VIEW_TARGETED_BY_SCROLL = 0x4000000;
    public static final int CONTENT_CHANGE_TYPE_UNDEFINED = 0;
    public static final int CONTENT_CHANGE_TYPE_SUBTREE = 1;
    public static final int CONTENT_CHANGE_TYPE_TEXT = 2;
    public static final int CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION = 4;
    public static final int CONTENT_CHANGE_TYPE_PANE_TITLE = 8;
    public static final int CONTENT_CHANGE_TYPE_PANE_APPEARED = 16;
    public static final int CONTENT_CHANGE_TYPE_PANE_DISAPPEARED = 32;
    public static final int CONTENT_CHANGE_TYPE_STATE_DESCRIPTION = 64;
    public static final int CONTENT_CHANGE_TYPE_DRAG_STARTED = 128;
    public static final int CONTENT_CHANGE_TYPE_DRAG_DROPPED = 256;
    public static final int CONTENT_CHANGE_TYPE_DRAG_CANCELLED = 512;
    public static final int CONTENT_CHANGE_TYPE_CONTENT_INVALID = 1024;
    public static final int CONTENT_CHANGE_TYPE_ERROR = 2048;
    public static final int CONTENT_CHANGE_TYPE_ENABLED = 4096;
    public static final int TYPES_ALL_MASK = -1;

    private AccessibilityEventCompat() {
    }

    @Deprecated
    public static int getRecordCount(AccessibilityEvent event) {
        return event.getRecordCount();
    }

    @Deprecated
    public static void appendRecord(AccessibilityEvent event, AccessibilityRecordCompat record) {
        event.appendRecord((AccessibilityRecord)record.getImpl());
    }

    @Deprecated
    public static AccessibilityRecordCompat getRecord(AccessibilityEvent event, int index) {
        return new AccessibilityRecordCompat(event.getRecord(index));
    }

    @Deprecated
    public static AccessibilityRecordCompat asRecord(AccessibilityEvent event) {
        return new AccessibilityRecordCompat(event);
    }

    public static void setContentChangeTypes(@NonNull AccessibilityEvent event, int changeTypes) {
        if (Build.VERSION.SDK_INT >= 19) {
            Api19Impl.setContentChangeTypes(event, changeTypes);
        }
    }

    public static int getContentChangeTypes(@NonNull AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Api19Impl.getContentChangeTypes(event);
        }
        return 0;
    }

    public static void setMovementGranularity(@NonNull AccessibilityEvent event, int granularity) {
        if (Build.VERSION.SDK_INT >= 16) {
            Api16Impl.setMovementGranularity(event, granularity);
        }
    }

    public static int getMovementGranularity(@NonNull AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.getMovementGranularity(event);
        }
        return 0;
    }

    public static void setAction(@NonNull AccessibilityEvent event, int action) {
        if (Build.VERSION.SDK_INT >= 16) {
            Api16Impl.setAction(event, action);
        }
    }

    public static int getAction(@NonNull AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.getAction(event);
        }
        return 0;
    }

    public static boolean isAccessibilityDataSensitive(@NonNull AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api34Impl.isAccessibilityDataSensitive(event);
        }
        return false;
    }

    public static void setAccessibilityDataSensitive(@NonNull AccessibilityEvent event, boolean accessibilityDataSensitive) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api34Impl.setAccessibilityDataSensitive(event, accessibilityDataSensitive);
        }
    }

    @RequiresApi(value=19)
    static class Api19Impl {
        private Api19Impl() {
        }

        @DoNotInline
        static void setContentChangeTypes(AccessibilityEvent accessibilityEvent, int changeTypes) {
            accessibilityEvent.setContentChangeTypes(changeTypes);
        }

        @DoNotInline
        static int getContentChangeTypes(AccessibilityEvent accessibilityEvent) {
            return accessibilityEvent.getContentChangeTypes();
        }
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        static void setMovementGranularity(AccessibilityEvent accessibilityEvent, int granularity) {
            accessibilityEvent.setMovementGranularity(granularity);
        }

        @DoNotInline
        static int getMovementGranularity(AccessibilityEvent accessibilityEvent) {
            return accessibilityEvent.getMovementGranularity();
        }

        @DoNotInline
        static void setAction(AccessibilityEvent accessibilityEvent, int action) {
            accessibilityEvent.setAction(action);
        }

        @DoNotInline
        static int getAction(AccessibilityEvent accessibilityEvent) {
            return accessibilityEvent.getAction();
        }
    }

    @RequiresApi(value=34)
    static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static boolean isAccessibilityDataSensitive(AccessibilityEvent event) {
            return event.isAccessibilityDataSensitive();
        }

        @DoNotInline
        static void setAccessibilityDataSensitive(AccessibilityEvent event, boolean accessibilityDataSensitive) {
            event.setAccessibilityDataSensitive(accessibilityDataSensitive);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface ContentChangeType {
    }
}

